/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.text.lookup.UrlEncoderStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class UrlEncoderStringLookupTest {
    private static final String DATA = "Hello+World%21";

    @Test
    public void test() {
        Assertions.assertEquals((Object)DATA, (Object)UrlEncoderStringLookup.INSTANCE.lookup("Hello World!"));
    }

    @Test
    public void testExceptionGettingString() throws UnsupportedEncodingException {
        UrlEncoderStringLookup mockLookup = (UrlEncoderStringLookup)Mockito.spy(UrlEncoderStringLookup.class);
        Mockito.when((Object)mockLookup.encode(DATA, StandardCharsets.UTF_8.displayName())).thenThrow(UnsupportedEncodingException.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> mockLookup.lookup(DATA));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)UrlEncoderStringLookup.INSTANCE.lookup(null));
    }

    @Test
    public void testToString() {
        Assertions.assertFalse((boolean)UrlEncoderStringLookup.INSTANCE.toString().isEmpty());
    }
}

