/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import java.util.Vector;
import megamek.common.Entity;
import megamek.common.LosEffects;
import megamek.common.ToHitData;
import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class ShowValidTargetsCommand
extends ServerCommand {
    public ShowValidTargetsCommand(Server server) {
        super(server, "validTargets", "Shows a list of entity id's that are valid targets for the current entity. Usage: /validTargets # where # is the id number of the entity you are shooting from.");
    }

    public void run(int n, String[] stringArray) {
        try {
            int n2 = Integer.parseInt(stringArray[1]);
            Entity entity = this.server.getGame().getEntity(n2);
            if (entity != null) {
                String string = "No valid targets.";
                boolean bl = false;
                Vector<Entity> vector = this.server.getGame().getValidTargets(entity);
                for (int i = 0; i < vector.size(); ++i) {
                    Entity entity2 = vector.get(i);
                    ToHitData toHitData = LosEffects.calculateLos(this.server.getGame(), n2, entity2).losModifiers(this.server.getGame());
                    if (toHitData.getValue() == Integer.MAX_VALUE) continue;
                    toHitData.setSideTable(entity2.sideTable(entity.getPosition()));
                    if (!bl) {
                        string = "This entity(" + n2 + ") can shoot the following entities: \n";
                        bl = true;
                    }
                    string = string + vector.get(i).getId() + " at a to hit penalty of ";
                    string = string + toHitData.getValue() + ", at range " + entity.getPosition().distance(vector.get(i).getPosition()) + toHitData.getTableDesc() + ";\n";
                }
                this.server.sendServerChat(n, string);
            } else {
                this.server.sendServerChat(n, "No such entity.");
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

