/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.WeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAMGHandler
extends WeaponHandler {
    private static final long serialVersionUID = 4109377609879352900L;

    public BAMGHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.damageType = Server.DamageType.ANTI_INFANTRY;
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.weapon.isRapidfire() && !(this.target instanceof Infantry)) {
            this.nDamPerHit = Compute.d6();
        } else if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            switch (this.wtype.getDamage()) {
                case 1: {
                    this.nDamPerHit = (int)Math.ceil(Compute.d6() / 2);
                    break;
                }
                case 2: {
                    this.nDamPerHit = Compute.d6();
                    break;
                }
                case 3: {
                    this.nDamPerHit = Compute.d6(2);
                }
            }
            if (this.bDirect) {
                this.nDamPerHit += this.toHit.getMoS() / 3;
            }
        } else {
            this.nDamPerHit = super.calcDamagePerHit();
        }
        if (this.bGlancing) {
            this.nDamPerHit = (int)Math.floor((double)this.nDamPerHit / 2.0);
        }
        return this.nDamPerHit;
    }

    @Override
    protected void addHeat() {
        if (this.toHit.getValue() != Integer.MAX_VALUE) {
            this.ae.heatBuildup = this.weapon.isRapidfire() ? (this.ae.heatBuildup += this.nDamPerHit) : (this.ae.heatBuildup += this.wtype.getHeat());
        }
    }

    @Override
    protected void reportMiss(Vector<Report> vector) {
        this.r = new Report(3220);
        this.r.subject = this.subjectId;
        if (this.weapon.isRapidfire() && (!(this.target instanceof Infantry) || this.target instanceof BattleArmor)) {
            this.r.messageId = 3225;
            this.r.add(this.nDamPerHit * 3);
        }
        vector.add(this.r);
    }
}

