/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

public class ACIncendiaryHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = 3301631731286472616L;

    public ACIncendiaryHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.damageType = Server.DamageType.INCENDIARY;
    }

    protected int calcDamagePerHit() {
        double d = this.wtype.getDamage();
        if (this.ae instanceof BattleArmor && this.weapon.getLocation() == 0 && this.ae.getSwarmTargetId() == this.target.getTargetId()) {
            d *= (double)((BattleArmor)this.ae).getShootingStrength();
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            d = Compute.directBlowInfantryDamage(d, this.bDirect ? this.toHit.getMoS() : 0, 0, ((Infantry)this.target).isMechanized());
        } else if (this.bDirect) {
            d = Math.min(d + (double)(this.toHit.getMoS() / 3), d * 2.0);
        }
        if (this.bGlancing) {
            d = (int)Math.floor(d / 2.0);
        }
        if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > this.wtype.getRanges(this.weapon)[3]) {
            d = (int)Math.floor(d * 0.75);
        }
        return (int)d;
    }
}

