/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.Coords;

public class IdealHex {
    public static final int LEFT = 1;
    public static final int STRAIGHT = 0;
    public static final int RIGHT = -1;
    private static final double XCONST = Math.tan(0.5235987755982988);
    public double[] x = new double[6];
    public double[] y = new double[6];
    public double cx;
    public double cy;
    private static IdealHex[] cache = null;
    private static int cacheWidth = 0;
    private static int cacheHeight = 0;

    public IdealHex(Coords coords) {
        double d = (double)coords.x * XCONST * 3.0;
        double d2 = coords.y * 2 + (coords.isXOdd() ? 1 : 0);
        this.cx = d + XCONST * 2.0;
        this.cy = d2 + 1.0;
        this.x[0] = d + XCONST;
        this.x[1] = d + XCONST * 3.0;
        this.x[2] = d + XCONST * 4.0;
        this.x[3] = this.x[1];
        this.x[4] = this.x[0];
        this.x[5] = d;
        this.y[0] = d2;
        this.y[1] = d2;
        this.y[2] = this.cy;
        this.y[3] = d2 + 2.0;
        this.y[4] = this.y[3];
        this.y[5] = this.y[2];
    }

    public boolean isIntersectedBy(double d, double d2, double d3, double d4) {
        int n = IdealHex.turns(d, d2, d3, d4, this.x[0], this.y[0]);
        if (n == 0) {
            return true;
        }
        for (int i = 1; i < 6; ++i) {
            int n2 = IdealHex.turns(d, d2, d3, d4, this.x[i], this.y[i]);
            if (n2 != 0 && n2 == n) continue;
            return true;
        }
        return false;
    }

    public static int turns(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d3 - d) * (d6 - d2) - (d5 - d) * (d4 - d2);
        return d7 > 1.0E-6 ? 1 : (d7 < -1.0E-6 ? -1 : 0);
    }

    public static void ensureCacheSize(int n, int n2) {
        if (cacheWidth < n || cacheHeight < n2) {
            cache = new IdealHex[n * n2];
            cacheWidth = n;
            cacheHeight = n2;
        }
    }

    public static IdealHex get(Coords coords) {
        if (cache == null || coords.x >= cacheWidth || coords.y >= cacheHeight || coords.x < 0 || coords.y < 0) {
            return new IdealHex(coords);
        }
        int n = coords.y * cacheWidth + coords.x;
        IdealHex idealHex = cache[n];
        if (idealHex != null) {
            return idealHex;
        }
        IdealHex.cache[n] = idealHex = new IdealHex(coords);
        return idealHex;
    }
}

