/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;
import javax.swing.JComponent;
import megamek.client.ui.Messages;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.widget.BackGroundDrawer;
import megamek.client.ui.swing.widget.DisplayMapSet;
import megamek.client.ui.swing.widget.PMAreasGroup;
import megamek.client.ui.swing.widget.PMSimpleLabel;
import megamek.client.ui.swing.widget.PMSimplePolygonArea;
import megamek.client.ui.swing.widget.PMUtil;
import megamek.client.ui.swing.widget.PMValueLabel;
import megamek.client.ui.swing.widget.WidgetUtils;
import megamek.common.Entity;
import megamek.common.SupportTank;
import megamek.common.Tank;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TankMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private JComponent comp;
    private PMSimplePolygonArea[] areas = new PMSimplePolygonArea[12];
    private PMSimpleLabel[] labels = new PMSimpleLabel[13];
    private PMValueLabel[] vLabels = new PMValueLabel[13];
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private PMAreasGroup content = new PMAreasGroup();
    private static final int INT_STR_OFFSET = 6;
    private Polygon frontArmor = new Polygon(new int[]{0, 19, 109, 128, 105, 92, 37, 23}, new int[]{55, 27, 27, 55, 68, 49, 49, 68}, 8);
    private Polygon frontIS = new Polygon(new int[]{67, 67, 105, 92, 37, 23, 61, 61}, new int[]{40, 77, 39, 20, 20, 39, 77, 40}, 8);
    private Polygon leftArmor = new Polygon(new int[]{0, 0, 23, 23}, new int[]{26, 214, 200, 39}, 4);
    private Polygon leftIS = new Polygon(new int[]{61, 23, 23, 23, 40, 33, 33, 46, 54, 58, 61}, new int[]{77, 39, 200, 200, 183, 168, 120, 94, 94, 85, 85}, 11);
    private Polygon rightArmor = new Polygon(new int[]{128, 105, 105, 128}, new int[]{26, 39, 200, 214}, 4);
    private Polygon rightIS = new Polygon(new int[]{83, 96, 96, 88, 105, 105, 105, 67, 67, 71, 75}, new int[]{94, 120, 168, 183, 200, 200, 39, 77, 85, 85, 94}, 11);
    private Polygon rearArmor = new Polygon(new int[]{128, 105, 92, 35, 23, 0, 11, 116}, new int[]{214, 200, 220, 220, 200, 214, 239, 239}, 8);
    private Polygon rearIS = new Polygon(new int[]{105, 88, 79, 50, 40, 23, 35, 92}, new int[]{200, 183, 202, 202, 183, 200, 220, 220}, 8);
    private Polygon turretArmor = new Polygon(new int[]{64, 74, 89, 89, 39, 39, 54, 64, 64, 64, 64, 50, 33, 33, 46, 54, 58, 61, 61, 67, 67, 71, 75, 83, 96, 96, 88, 79, 64}, new int[]{187, 187, 160, 139, 139, 160, 187, 187, 202, 187, 202, 202, 168, 120, 94, 94, 85, 85, 40, 40, 85, 85, 94, 94, 120, 168, 183, 202, 202}, 29);
    private Polygon turretIS = new Polygon(new int[]{39, 39, 54, 74, 89, 89}, new int[]{139, 160, 187, 187, 160, 139}, 6);
    private static final Font FONT_LABEL = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorSmallFontSize"));
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));

    public TankMapSet(JComponent jComponent) {
        this.comp = jComponent;
        this.setAreas();
        this.setLabels();
        this.setBackGround();
        this.translateAreas();
        this.setContent();
    }

    public void setRest() {
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        int n;
        Tank tank = (Tank)entity;
        int n2 = 1;
        int n3 = 1;
        for (n = 1; n < 6; ++n) {
            n2 = tank.getArmor(n);
            n3 = tank.getOArmor(n);
            this.vLabels[n].setValue(tank.getArmorString(n));
            WidgetUtils.setAreaColor(this.areas[n], this.vLabels[n], (double)n2 / (double)n3);
        }
        for (n = 7; n < 12; ++n) {
            n2 = tank.getInternal(n - 6);
            n3 = tank.getOInternal(n - 6);
            this.vLabels[n].setValue(tank.getInternalString(n - 6));
            WidgetUtils.setAreaColor(this.areas[n], this.vLabels[n], (double)n2 / (double)n3);
        }
        if (tank.hasBARArmor()) {
            this.vLabels[12].setValue(String.valueOf(((SupportTank)tank).getBARRating()));
        } else {
            this.labels[12].setVisible(false);
            this.vLabels[12].setVisible(false);
        }
    }

    private void setContent() {
        int n;
        for (n = 1; n < 6; ++n) {
            this.content.addArea(this.areas[n]);
            this.content.addArea(this.labels[n]);
            this.content.addArea(this.vLabels[n]);
        }
        for (n = 1; n < 6; ++n) {
            this.content.addArea(this.areas[n + 6]);
            this.content.addArea(this.labels[n + 6]);
            this.content.addArea(this.vLabels[n + 6]);
        }
        this.content.addArea(this.labels[12]);
        this.content.addArea(this.vLabels[12]);
    }

    private void setAreas() {
        this.areas[1] = new PMSimplePolygonArea(this.frontArmor);
        this.areas[2] = new PMSimplePolygonArea(this.rightArmor);
        this.areas[3] = new PMSimplePolygonArea(this.leftArmor);
        this.areas[4] = new PMSimplePolygonArea(this.rearArmor);
        this.areas[5] = new PMSimplePolygonArea(this.turretArmor);
        this.areas[7] = new PMSimplePolygonArea(this.frontIS);
        this.areas[8] = new PMSimplePolygonArea(this.rightIS);
        this.areas[9] = new PMSimplePolygonArea(this.leftIS);
        this.areas[10] = new PMSimplePolygonArea(this.rearIS);
        this.areas[11] = new PMSimplePolygonArea(this.turretIS);
    }

    private void setLabels() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_LABEL);
        this.labels[1] = WidgetUtils.createLabel(Messages.getString("TankMapSet.FrontArmor"), fontMetrics, Color.black, 65, 35);
        this.labels[7] = WidgetUtils.createLabel(Messages.getString("TankMapSet.FrontIS"), fontMetrics, Color.black, 63, 57);
        this.labels[3] = WidgetUtils.createLabel(Messages.getString("TankMapSet.LS"), fontMetrics, Color.black, 19, 135);
        this.labels[9] = WidgetUtils.createLabel(Messages.getString("TankMapSet.LIS"), fontMetrics, Color.black, 49, 106);
        this.labels[2] = WidgetUtils.createLabel(Messages.getString("TankMapSet.RS"), fontMetrics, Color.black, 124, 135);
        this.labels[8] = WidgetUtils.createLabel(Messages.getString("TankMapSet.RIS"), fontMetrics, Color.black, 95, 106);
        this.labels[4] = WidgetUtils.createLabel(Messages.getString("TankMapSet.RearArmor"), fontMetrics, Color.black, 65, 257);
        this.labels[10] = WidgetUtils.createLabel(Messages.getString("TankMapSet.RearIS"), fontMetrics, Color.black, 63, 239);
        this.labels[5] = WidgetUtils.createLabel(Messages.getString("TankMapSet.TurretArmor"), fontMetrics, Color.black, 73, 145);
        this.labels[11] = WidgetUtils.createLabel(Messages.getString("TankMapSet.TurretIS"), fontMetrics, Color.black, 73, 173);
        this.labels[12] = WidgetUtils.createLabel(Messages.getString("TankMapSet.BARRating"), fontMetrics, Color.white, 65, 278);
        fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.vLabels[1] = WidgetUtils.createValueLabel(101, 37, "", fontMetrics);
        this.vLabels[7] = WidgetUtils.createValueLabel(91, 58, "", fontMetrics);
        this.vLabels[3] = WidgetUtils.createValueLabel(20, 150, "", fontMetrics);
        this.vLabels[9] = WidgetUtils.createValueLabel(44, 121, "", fontMetrics);
        this.vLabels[2] = WidgetUtils.createValueLabel(125, 150, "", fontMetrics);
        this.vLabels[8] = WidgetUtils.createValueLabel(102, 121, "", fontMetrics);
        this.vLabels[4] = WidgetUtils.createValueLabel(99, 258, "", fontMetrics);
        this.vLabels[10] = WidgetUtils.createValueLabel(91, 241, "", fontMetrics);
        this.vLabels[5] = WidgetUtils.createValueLabel(73, 159, "", fontMetrics);
        this.vLabels[11] = WidgetUtils.createValueLabel(73, 193, "", fontMetrics);
        this.vLabels[12] = WidgetUtils.createValueLabel(100, 280, "", fontMetrics);
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }

    private void translateAreas() {
        this.areas[1].translate(8, 0);
        this.areas[7].translate(8, 29);
        this.areas[3].translate(8, 29);
        this.areas[9].translate(8, 29);
        this.areas[2].translate(8, 29);
        this.areas[8].translate(8, 29);
        this.areas[4].translate(8, 29);
        this.areas[10].translate(8, 29);
        this.areas[5].translate(8, 29);
        this.areas[11].translate(8, 29);
    }
}

