/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import com.sun.j3d.utils.image.TextureLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import megamek.client.ui.AWT.TilesetManager;
import megamek.client.ui.AWT.boardview3d.C;
import megamek.client.ui.AWT.boardview3d.ImageAlpha;
import megamek.client.ui.AWT.boardview3d.ImageModel;
import megamek.client.ui.AWT.boardview3d.SignModel;
import megamek.client.ui.AWT.util.ImageCache;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.preference.IPreferenceChangeListener;
import megamek.common.preference.PreferenceChangeEvent;
import megamek.common.preference.PreferenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TileTextureManager
implements IPreferenceChangeListener {
    private TilesetManager tileManager;
    private Component comp;
    private IGame game;
    private static ImageCache<ImageAlpha, Texture2D> textureCache = new ImageCache();
    private static final int TEXSIZE = 256;
    static final float HEX_ALPHA = 0.6666667f;
    static final float HEX_ALPHA2 = 0.4f;

    public TileTextureManager(Component component, IGame iGame) throws IOException {
        this.comp = component;
        this.game = iGame;
        this.tileManager = new TilesetManager(this.comp);
        System.out.println("TileTextureManager: loading images for board");
        this.tileManager.loadNeededImages(this.game);
        PreferenceManager.getClientPreferences().addPreferenceChangeListener(this);
    }

    public TilesetManager getTilesetManager() {
        return this.tileManager;
    }

    public Shape3D getModel(Entity entity) {
        return this.getModel(this.tileManager.imageFor(entity, 0), 1.0f, true);
    }

    public Shape3D getModel(IHex iHex) {
        return this.getModel(this.tileManager.baseFor(iHex), 0.4f, false);
    }

    public List<Shape3D> getModels(IHex iHex) {
        List<Image> list = this.tileManager.supersFor(iHex);
        Vector<Shape3D> vector = new Vector<Shape3D>();
        if (list != null) {
            for (Image image : list) {
                vector.add(this.getModel(image, 0.6666667f, false));
            }
        }
        return vector;
    }

    public Shape3D getModel(Image image, float f, boolean bl) {
        MediaTracker mediaTracker = new MediaTracker(this.comp);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        mediaTracker.removeImage(image);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, null, null);
        graphics2D.dispose();
        graphics2D = null;
        mediaTracker.addImage(bufferedImage, 1);
        try {
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        mediaTracker.removeImage(bufferedImage);
        ImageModel imageModel = new ImageModel(bufferedImage, bl);
        Appearance appearance = new Appearance();
        appearance.setTexture((Texture)this.getTexture(image, false, null, f, true));
        if ((double)f != 1.0) {
            appearance.setTransparencyAttributes(C.alphaTexture);
        }
        imageModel.setAppearance(appearance);
        return imageModel;
    }

    public Texture2D getTexture(Entity entity) {
        return this.getTexture(this.tileManager.imageFor(entity, 0), false, Color.GRAY, 1.0f, true);
    }

    public Texture2D getTexture(IHex iHex, float f) {
        return this.getTexture(this.tileManager.baseFor(iHex), true, null, f, true);
    }

    public Node getMinefieldSign() {
        return new SignModel(this.getTexture(this.tileManager.getMinefieldSign(), false, null, 1.0f, false));
    }

    Shape3D getArtilleryTarget(int n) {
        return this.getModel(this.tileManager.getArtilleryTarget(n), 0.5f, false);
    }

    public Texture2D getTexture(String string) {
        TextureLoader textureLoader = new TextureLoader(string, 1, null);
        Texture2D texture2D = (Texture2D)textureLoader.getTexture();
        texture2D.setMagFilter(1);
        texture2D.setMinFilter(1);
        return texture2D;
    }

    private final Texture2D getTexture(Image image, boolean bl, Color color, float f, boolean bl2) {
        if (image == null) {
            return null;
        }
        Texture2D texture2D = textureCache.get(new ImageAlpha(image, f));
        if (texture2D == null) {
            Object object;
            MediaTracker mediaTracker = new MediaTracker(this.comp);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            mediaTracker.removeImage(image);
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(n * 2, n2 * 2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, n * 2, n2 * 2);
            }
            graphics2D.translate(n / 2, n2 / 2);
            graphics2D.drawImage(image, null, null);
            if (bl2) {
                graphics2D.translate(0, -n2);
                graphics2D.drawImage(image, null, null);
                graphics2D.translate(0, 2 * n2);
                graphics2D.drawImage(image, null, null);
                graphics2D.translate(-3 * n / 4, -n2 / 2);
                graphics2D.drawImage(image, null, null);
                graphics2D.translate(0, -n2);
                graphics2D.drawImage(image, null, null);
                graphics2D.translate(3 * n / 2, 0);
                graphics2D.drawImage(image, null, null);
                graphics2D.translate(0, n2);
                graphics2D.drawImage(image, null, null);
            }
            mediaTracker.addImage(bufferedImage, 1);
            try {
                mediaTracker.waitForID(1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            mediaTracker.removeImage(bufferedImage);
            int n3 = 1;
            int n4 = 3;
            if (!bl) {
                n3 = 0;
                n4 = 0;
            }
            BufferedImage bufferedImage2 = new BufferedImage(256, 256, 2);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(256.0 / (double)(n - n3 * 2), 256.0 / (double)(n2 - n3 * 2));
            affineTransform.translate(-n / 2 - n3, -n2 / 2 - n3);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 3);
            affineTransformOp.filter(bufferedImage, bufferedImage2);
            if (n4 > 0) {
                object = bufferedImage2.createGraphics();
                ((Graphics)object).setColor(Color.DARK_GRAY);
                ((Graphics2D)object).setStroke(new BasicStroke(n4));
                ((Graphics2D)object).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                int[] nArray = new int[]{64, 191, 255, 191, 64, 0, 64};
                int[] nArray2 = new int[]{0, 0, 128, 255, 255, 128, 0};
                ((Graphics)object).drawPolygon(nArray, nArray2, nArray.length);
            }
            if (f < 1.0f) {
                object = bufferedImage2.getAlphaRaster();
                for (int i = 0; i < bufferedImage2.getHeight(); ++i) {
                    for (int j = 0; j < bufferedImage2.getWidth(); ++j) {
                        ((WritableRaster)object).setSample(j, i, 0, f * ((Raster)object).getSampleFloat(j, i, 0));
                    }
                }
            }
            object = new TextureLoader(bufferedImage2, 1);
            texture2D = (Texture2D)object.getTexture();
            texture2D.setMagFilter(1);
            texture2D.setMinFilter(1);
            if (this.tileManager.isLoaded()) {
                textureCache.put(new ImageAlpha(image, f), texture2D);
            }
        }
        return texture2D;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getName().equals("MapTileset")) {
            System.out.println("BoardView3D: loading images for board");
            this.tileManager.loadNeededImages(this.game);
        }
    }

    void hexChanged(IHex iHex) {
        this.tileManager.clearHex(iHex);
        this.tileManager.waitForHex(iHex);
    }
}

