#include <iostream>
#include <stdlib.h>
#include "parser.h"
#include "printer.h"
#include "polynomial.h"
#include "division.h"
#include "buchberger.h"
#include "wallideal.h"
#include "lp.h"
#include "reversesearch.h"
#include "termorder.h"
#include "ep_standard.h"
#include "ep_xfig.h"
#include "polyhedralcone.h"
#include "gfanapplication.h"
#include "saturation.h"
#include "field_rationals.h"
#include "field_zmodpz.h"
#include "field_rationalfunctions.h"
#include "symmetry.h"
#include "linalg.h"
#include "fieldlp.h"
#include "integer.h"
#include "polynomialgcd.h"
#include "packedmonomial.h"
#include "gfanlib_zcone.h"
#include "gfanlib_tableau.h"
#include "gfanlib_circuittableint.h"
#include "lll.h"

using namespace gfan;

template class gfan::Vector<gfan::Integer>;
template class gfan::Vector<gfan::Rational>;
template class gfan::Matrix<gfan::Integer>;
template class gfan::Matrix<gfan::Rational>;

class TestApplication : public GFanApplication
{
  StringOption testSuiteFolderOption;
  StringOption executableOption;
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  const char *helpText()
  {
    return "This runs the test suite and checks against the stored result. If no result exists, it is generated.\n";
  }
  TestApplication():
	testSuiteFolderOption("--suite","Specify the folder which contains the test suite.","testsuite"),
	executableOption("--gfan","Specify name of gfan executable to test.","./gfan")
  {
    registerOptions();
  }

  const char *name()
  {
    return "_test";
  }
  int testGCD()
  {
	  PolynomialRing r=StringParser("Q[p126,p125,p124,p123,p027,p026,p025,p024,p023,p017,p016,p015,p014,p013,p012]").parsePolynomialRing();

	  // Crashes (when linked with Singular)
//	  Polynomial p=StringParser("-p126*p027*p026*p015^2+p125*p026*p025*p017*p016-p125*p026^2*p017*p015-p125*p027*p025*p016^2+p125*p027*p026*p016*p015-p126*p025^2*p017*p016+p126*p026*p025*p017*p015+p126*p027*p025*p016*p015").parsePolynomial(r);
//	  Polynomial q=StringParser("p126*p027*p026*p025*p016*p015*p014-p124*p026*p025^2*p017*p016^2+2*p124*p026^2*p025*p017*p016*p015-p124*p026^3*p017*p015^2+p124*p027*p025^2*p016^3-2*p124*p027*p026*p025*p016^2*p015+p124*p027*p026^2*p016*p015^2+p125*p026*p025*p024*p017*p016^2-p125*p026^2*p024*p017*p016*p015-p125*p026^2*p025*p017*p016*p014+p125*p026^3*p017*p015*p014-p125*p027*p025*p024*p016^3+p125*p027*p026*p024*p016^2*p015+p125*p027*p026*p025*p016^2*p014-p125*p027*p026^2*p016*p015*p014-p126*p026*p025*p024*p017*p016*p015+p126*p026*p025^2*p017*p016*p014+p126*p026^2*p024*p017*p015^2-p126*p026^2*p025*p017*p015*p014+p126*p027*p025*p024*p016^2*p015-p126*p027*p025^2*p016^2*p014-p126*p027*p026*p024*p016*p015^2").parsePolynomial(r);

	  // Crashes (even when not linked to Singular)
	  Polynomial p=StringParser("-p126*p027*p026*p015^2*p014+p124*p025^2*p017*p016^2-2*p124*p026*p025*p017*p016*p015+p124*p026^2*p017*p015^2+p125*p026*p025*p017*p016*p014-p125*p026^2*p017*p015*p014-p125*p027*p025*p016^2*p014+p125*p027*p026*p016*p015*p014-p126*p025^2*p017*p016*p014+p126*p026*p025*p017*p015*p014+p126*p027*p025*p016*p015*p014").parsePolynomial(r);
	  Polynomial q=StringParser("p126*p027*p026*p025*p016*p015*p014-p124*p026*p025^2*p017*p016^2+2*p124*p026^2*p025*p017*p016*p015-p124*p026^3*p017*p015^2+p124*p027*p025^2*p016^3-2*p124*p027*p026*p025*p016^2*p015+p124*p027*p026^2*p016*p015^2+p125*p026*p025*p024*p017*p016^2-p125*p026^2*p024*p017*p016*p015-p125*p026^2*p025*p017*p016*p014+p125*p026^3*p017*p015*p014-p125*p027*p025*p024*p016^3+p125*p027*p026*p024*p016^2*p015+p125*p027*p026*p025*p016^2*p014-p125*p027*p026^2*p016*p015*p014-p126*p026*p025*p024*p017*p016*p015+p126*p026*p025^2*p017*p016*p014+p126*p026^2*p024*p017*p015^2-p126*p026^2*p025*p017*p015*p014+p126*p027*p025*p024*p016^2*p015-p126*p027*p025^2*p016^2*p014-p126*p027*p026*p024*p016*p015^2").parsePolynomial(r);


	  // Finds factor
//	  Polynomial p=StringParser("-p027*p026*p016*p015-p026*p025*p017*p016+p026^2*p017*p015+p027*p025*p016^2").parsePolynomial(r);
//	  Polynomial q=StringParser("p126*p027*p025*p016*p014+p124*p026*p025*p017*p016-p124*p026^2*p017*p015-p124*p027*p025*p016^2+p124*p027*p026*p016*p015-p125*p026*p024*p017*p016+p125*p026^2*p017*p014+p125*p027*p024*p016^2-p125*p027*p026*p016*p014+p126*p026*p024*p017*p015-p126*p026*p025*p017*p014-p126*p027*p024*p016*p015").parsePolynomial(r);

	  // Finds only 1 as factor
	  //	  Polynomial p=StringParser("-p026*p015+p025*p016").parsePolynomial(r);
//	  Polynomial q=StringParser("p126*p027*p025*p016*p014+p124*p026*p025*p017*p016-p124*p026^2*p017*p015-p124*p027*p025*p016^2+p124*p027*p026*p016*p015-p125*p026*p024*p017*p016+p125*p026^2*p017*p014+p125*p027*p024*p016^2-p125*p027*p026*p016*p014+p126*p026*p024*p017*p015-p126*p026*p025*p017*p014-p126*p027*p024*p016*p015").parsePolynomial(r);

	  Polynomial g=polynomialGCD(p,q);
	  debug<<g;
	  assert(0);
	  return 0;
  }
int testIntegers()
{
/*	Integer a(1);
	Integer b=1;
	for(int i=0;i<300;i++)
	{


		Integer c=a;
	c+=b;
		b=a;
		a=c;
		cerr<<a<<endl;
	}
	return 0;*/
}
	int testGfanLib()
	{
//		CircuitTableInt32
		{
			gfan::Matrix<CircuitTableInt32> M(3,5);

			M[0][0]=0;M[0][1]=0;M[0][2]=2;M[0][3]=2;M[0][4]=1;
			M[1][0]=1;M[1][1]=0;M[1][2]=3;M[1][3]=2;M[1][4]=1;
			M[2][0]=2;M[2][1]=0;M[2][2]=2;M[2][3]=0;M[2][4]=0;
			gfan::TableauSolver<CircuitTableInt32> M2(M,true);

			M2.coneInfo();
			return 0;
		}


		{
			gfan::Matrix<CircuitTableInt32> M(2,2);
			M[0][0]=2;
			M[1][0]=1;
			M[1][1]=2;
			M[0][1]=2;
			gfan::Tableau<CircuitTableInt32> M2(M,true);
			debug<<M2.toString();
			M2.exchange(1,2);
			debug<<M2.toString();
		}
		gfan::Matrix<CircuitTableInt32> M(3,6);
		M[0][0]=1;
		M[1][0]=0;
		M[2][0]=1;
		M[0][1]=0;
		M[1][1]=1;
		M[2][1]=1;
		M[0][2]=2;
		M[1][2]=2;
		M[2][2]=1;
		M[0][3]=5;
		M[1][3]=1;
		M[2][3]=1;
		M[0][4]=4;
		M[1][4]=0;
		M[2][4]=1;
		M[0][5]=3;
		M[1][5]=3;
		M[2][5]=3;
		gfan::TableauSolver<CircuitTableInt32> M2(M,true);
		debug<<M2.toString();
		M2.exchange(0,3);
		debug<<M2.toString();
		M2.exchange(1,4);
		debug<<M2.toString();
		M2.exchange(2,5);
		debug<<M2.toString();

		M2.solve();

		return 0;

		debug<<"ETST3213312\n";
		ZMatrix A=ZMatrix(3,3);
		A[0][0]=1;
		A[1][0]=1;

		A[1][1]=1;
		ZMatrix B=ZMatrix(0,3);
		for(int i=0;i<4000;i++)
		{		ZCone C(A,B);}
		return 0;
	}

	int testLLL()
	{
		IntegerMatrix A=rowsToIntegerMatrix(StringParser(
				"{"
/*				"(1,0,1,1, 0,0, 0, 0,0),"
				"(1,1,0, 0,1,0, 0, 0,0),"
				"(1,0,0, 0, 0,1,1, 0,0),"
				"(0,1,0, 0, 0,1, 0,1,0),"
				"(0,1,0, 0, 0,0, 0, 0,1),"
				"(0,0,0, 0, 0,1, 0, 0,1)}"
*/
				"( 1, 0,1,1, 0, 0, 0, 0,0),"
				"( 1, 1,0,0, 1, 0, 0, 0,0),"
				"( 1, 0,0,0, 0, 1, 1, 0,0),"
				"(-1, 0,1,1,-1, 0,-1, 1,0),"
				"( 0, 0,0,0, 0,-1, 0,-1,1),"
				"( 1,-1,0,0, 1, 0, 0,-1,0)}"
				).parseIntegerVectorList());
		A=A.submatrixColumnSubsetBoolean(IntegerVector(StringParser("( 1,1,1, 1, 1,1, 1, 1,1)").parseIntegerVector()));

		{
			FieldMatrix B=integerMatrixToFieldMatrix(A,Q);
			debug <<B.getHeight()<<"x"<<B.getWidth()<<"rank"<<B.reduceAndComputeRank();
		}

		debug<<"Doing LLL....\n"<<A;
		mlll(A);
		debug<<"LLL done\n";
		return 0;
	}

	int testPolynomialGCD()
	{
		PolynomialSet A=FileParser(stdin).parsePolynomialSetWithRing();
		Polynomial g=NonMonomialPolynomialGCDForZ(A);
		pout<<g<<"\n";
//		debug<<"nterms:"<<(int)g.terms.size()<<"\n"<<g<<"\n";
		return 0;
		{
			FILE *f=fopen("gcdexamples","r");
			FileParser F(f);
//			while(!feof(f))
			for(int i=0;i<20;i++)
			{
				PolynomialSet A=F.parsePolynomialSetWithRing();
				int nterms=F.parseInt();
//				Polynomial g=NonMonomialPolynomialGCDForZModP(A);
				Polynomial g=NonMonomialPolynomialGCDForZ(A);
				debug<<"nterms:"<<(int)g.terms.size()<<"\n"<<g<<"\n";
			}
			assert(0);
		}
//		PolynomialRing r=StringParser("Z/9931Z[a,b]").parsePolynomialRing();
		PolynomialRing r=StringParser("Z/9851Z[a,b]").parsePolynomialRing();
#if 1
		if(1)
		{
			PolynomialSet A=StringParser(
//					"Z/9851Z[x0,x1,x2,x3,x4,x5]"
#if 0
					"Z/31081Z[x1,x3,x4]{"
					"10480*x3^4+23521*x3^4*x4+17445*x3^4*x4^2+14816*x3^4*x4^3+21952*x3^4*x4^4+15402*x3^5+30564*x3^5*x4+7415*x3^5*x4^2+16201*x3^5*x4^3+27099*x3^5*x4^4+19917*x3^5*x4^5+19612*x3^6+15302*x3^6*x4+3612*x3^6*x4^2+12310*x3^6*x4^3+16477*x3^6*x4^4+7051*x3^6*x4^5+20564*x3^7+19791*x3^7*x4+21991*x3^7*x4^2+12637*x3^7*x4^3+6057*x3^7*x4^4+23231*x3^7*x4^5+14535*x3^8+26782*x3^8*x4+20681*x3^8*x4^2+6649*x3^8*x4^3+23550*x3^8*x4^4+14190*x3^9+1471*x3^9*x4+2489*x3^9*x4^2+7531*x3^9*x4^3+22060*x3^10+8835*x3^10*x4+7850*x3^10*x4^2+30722*x1*x3^3+19791*x1*x3^3*x4+1353*x1*x3^3*x4^2+24071*x1*x3^3*x4^3+29424*x1*x3^3*x4^4+21613*x1*x3^3*x4^5+8339*x1*x3^4+7465*x1*x3^4*x4+13651*x1*x3^4*x4^2+5486*x1*x3^4*x4^3"
					"+17869*x1*x3^4*x4^4+4951*x1*x3^4*x4^5+23731*x1*x3^4*x4^6+15655*x1*x3^5+28546*x1*x3^5*x4+11909*x1*x3^5*x4^2+5517*x1*x3^5*x4^3+27556*x1*x3^5*x4^4+26370*x1*x3^5*x4^5+10806*x1*x3^5*x4^6+2870*x1*x3^6+9972*x1*x3^6*x4+18303*x1*x3^6*x4^2+5649*x1*x3^6*x4^3+23575*x1*x3^6*x4^4+29235*x1*x3^6*x4^5-x1*x3^6*x4^6+11084*x1*x3^7+26810*x1*x3^7*x4+13588*x1*x3^7*x4^2+21113*x1*x3^7*x4^3+17736*x1*x3^7*x4^4+3*x1*x3^7*x4^5+23398*x1*x3^8+14883*x1*x3^8*x4+13836*x1*x3^8*x4^2+20085*x1*x3^8*x4^3+31078*x1*x3^8*x4^4+5003*x1*x3^9+15699*x1*x3^9*x4+15381*x1*x3^9*x4^2+x1*x3^9*x4^3+359*x1^2*x3^2+17068*x1^2*x3^2*x4+15595*x1^2*x3^2*x4^2+25377*x1^2*x3^2*x4^3+28664*x1^2*x3^2*x4^4+28404*x1^2*x3^2*x4^5+6895*x1^2*x3^3+10231*x1^2*x3^3*x4+19516*x1^2*x3^3*x4^2+19906*x1^2*x3^3*x4^3+8900*x1^2*x3^3*x4^4+14974*x1^2*x3^3*x4^5+29400*x1^2*x3^3*x4^6+21849*x1^2*x3^4+8606*x1^2*x3^4*x4+22936*x1^2*x3^4*x4^2+22769*x1^2*x3^4*x4^3+15774*x1^2*x3^4*x4^4+15899*x1^2*x3^4*x4^5+18938*x1^2*x3^4*x4^6+23411*x1^2*x3^5"
					"+14860*x1^2*x3^5*x4+22744*x1^2*x3^5*x4^2+21410*x1^2*x3^5*x4^3+15407*x1^2*x3^5*x4^4+23722*x1^2*x3^5*x4^5+4*x1^2*x3^5*x4^6+3862*x1^2*x3^6+24483*x1^2*x3^6*x4+14308*x1^2*x3^6*x4^2+20672*x1^2*x3^6*x4^3+4366*x1^2*x3^6*x4^4+31069*x1^2*x3^6*x4^5+71*x1^2*x3^7+11950*x1^2*x3^7*x4+7606*x1^2*x3^7*x4^2+30836*x1^2*x3^7*x4^3+12*x1^2*x3^7*x4^4+8036*x1^2*x3^8+4259*x1^2*x3^8*x4+15381*x1^2*x3^8*x4^2+31077*x1^2*x3^8*x4^3+20601*x1^3*x3+29974*x1^3*x3*x4+19295*x1^3*x3*x4^2+4255*x1^3*x3*x4^3+15240*x1^3*x3*x4^4+2677*x1^3*x3*x4^5+23909*x1^3*x3^2+22930*x1^3*x3^2*x4+2963*x1^3*x3^2*x4^2+25085*x1^3*x3^2*x4^3+30230*x1^3*x3^2*x4^4+5931*x1^3*x3^2*x4^5+18062*x1^3*x3^2*x4^6+17375*x1^3*x3^3+22858*x1^3*x3^3*x4+10104*x1^3*x3^3*x4^2+24139*x1^3*x3^3*x4^3+26625*x1^3*x3^3*x4^4+3302*x1^3*x3^3*x4^5+2674*x1^3*x3^3*x4^6+17717*x1^3*x3^4+8488*x1^3*x3^4*x4+6093*x1^3*x3^4*x4^2+24154*x1^3*x3^4*x4^3+407*x1^3*x3^4*x4^4+18410*x1^3*x3^4*x4^5+31075*x1^3*x3^4*x4^6+25208*x1^3*x3^5+26248*x1^3*x3^5*x4"
					"+10629*x1^3*x3^5*x4^2+24545*x1^3*x3^5*x4^3+17958*x1^3*x3^5*x4^4+18*x1^3*x3^5*x4^5+28309*x1^3*x3^6+15547*x1^3*x3^6*x4+24681*x1^3*x3^6*x4^2+22482*x1^3*x3^6*x4^3+31063*x1^3*x3^6*x4^4+5003*x1^3*x3^7+22246*x1^3*x3^7*x4+638*x1^3*x3^7*x4^2+6*x1^3*x3^7*x4^3+2889*x1^4*x4+8474*x1^4*x4^2+24724*x1^4*x4^3+29044*x1^4*x4^4+9468*x1^4*x4^5+7617*x1^4*x3+20496*x1^4*x3*x4+30333*x1^4*x3*x4^2+4730*x1^4*x3*x4^3+16679*x1^4*x3*x4^4+10313*x1^4*x3*x4^5+29400*x1^4*x3*x4^6+18752*x1^4*x3^2+17501*x1^4*x3^2*x4+693*x1^4*x3^2*x4^2+17364*x1^4*x3^2*x4^3+17629*x1^4*x3^2*x4^4+22531*x1^4*x3^2*x4^5+18938*x1^4*x3^2*x4^6+28681*x1^4*x3^3+17168*x1^4*x3^3*x4+16144*x1^4*x3^3*x4^2+19248*x1^4*x3^3*x4^3+14866*x1^4*x3^3*x4^4+810*x1^4*x3^3*x4^5+4*x1^4*x3^3*x4^6+7473*x1^4*x3^4+5877*x1^4*x3^4*x4+26709*x1^4*x3^4*x4^2+19845*x1^4*x3^4*x4^3+10940*x1^4*x3^4*x4^4+31069*x1^4*x3^4*x4^5+27275*x1^4*x3^5+21574*x1^4*x3^5*x4"
					"+15436*x1^4*x3^5*x4^2+24262*x1^4*x3^5*x4^3+12*x1^4*x3^5*x4^4+22060*x1^4*x3^6+22246*x1^4*x3^6*x4+7212*x1^4*x3^6*x4^2+31077*x1^4*x3^6*x4^3+1557*x1^5*x4+19365*x1^5*x4^2+21835*x1^5*x4^3+23547*x1^5*x4^4+6076*x1^5*x4^5+23731*x1^5*x4^6+430*x1^5*x3*x4+12908*x1^5*x3*x4^2+11144*x1^5*x3*x4^3+20263*x1^5*x3*x4^4+18090*x1^5*x3*x4^5+10806*x1^5*x3*x4^6+22964*x1^5*x3^2*x4+7968*x1^5*x3^2*x4^2+10145*x1^5*x3^2*x4^3+1850*x1^5*x3^2*x4^4+28916*x1^5*x3^2*x4^5-x1^5*x3^2*x4^6+14124*x1^5*x3^3*x4+7328*x1^5*x3^3*x4^2+419*x1^5*x3^3*x4^3+18693*x1^5*x3^3*x4^4+3*x1^5*x3^3*x4^5+27818*x1^5*x3^4*x4+29195*x1^5*x3^4*x4^2+19128*x1^5*x3^4*x4^3+31078*x1^5*x3^4*x4^4+19958*x1^5*x3^5*x4+15700*x1^5*x3^5*x4^2+x1^5*x3^5*x4^3,"
					"2889*x3^5+13894*x3^5*x4+26401*x3^5*x4^2+9129*x3^5*x4^3+27088*x3^6+24707*x3^6*x4+15089*x3^6*x4^2+15002*x3^6*x4^3+11164*x3^6*x4^4+15051*x3^7+3809*x3^7*x4+15009*x3^7*x4^2+9693*x3^7*x4^3+24030*x3^7*x4^4+10070*x3^8+30804*x3^8*x4+2943*x3^8*x4^2+5066*x3^8*x4^3+7850*x3^8*x4^4+23299*x3^9+16033*x3^9*x4+22144*x3^9*x4^2+7531*x3^9*x4^3+22329*x3^10+30880*x3^10*x4+23550*x3^10*x4^2+11123*x3^11+23231*x3^11*x4+19525*x1*x3^4+1166*x1*x3^4*x4+17043*x1*x3^4*x4^2+14480*x1*x3^4*x4^3+9468*x1*x3^4*x4^4+17529*x1*x3^5+28033*x1*x3^5*x4+16621*x1*x3^5*x4^2+1290*x1*x3^5*x4^3+3802*x1*x3^5*x4^4+7350*x1*x3^5*x4^5+2388*x1*x3^6+7014*x1*x3^6*x4+23679*x1*x3^6*x4^2+3783*x1*x3^6*x4^3+18813*x1*x3^6*x4^4+20275*x1*x3^6*x4^5+13765*x1*x3^7+11545*x1*x3^7*x4+19388*x1*x3^7*x4^2+15044*x1*x3^7*x4^3+17227*x1*x3^7*x4^4+x1*x3^7*x4^5+14171*x1*x3^8+25057*x1*x3^8*x4+5913*x1*x3^8*x4^2+29364*x1*x3^8*x4^3+31078*x1*x3^8*x4^4+664*x1*x3^9+8495*x1*x3^9*x4+26058*x1*x3^9*x4^2+3*x1*x3^9*x4^3+6547*x1*x3^10+319*x1*x3^10*x4-x1*x3^10*x4^2+17334*x1^2*x3^3+11801*x1^2*x3^3*x4+9709*x1^2*x3^3*x4^2+6195*x1^2*x3^3*x4^3"
					"+24290*x1^2*x3^3*x4^4+895*x1^2*x3^4+8041*x1^2*x3^4*x4+26035*x1^2*x3^4*x4^2+16446*x1^2*x3^4*x4^3+14716*x1^2*x3^4*x4^4+25412*x1^2*x3^4*x4^5+26424*x1^2*x3^5+3816*x1^2*x3^5*x4+6147*x1^2*x3^5*x4^2+30203*x1^2*x3^5*x4^3+6297*x1^2*x3^5*x4^4+22949*x1^2*x3^5*x4^5+30726*x1^2*x3^6+16799*x1^2*x3^6*x4+4313*x1^2*x3^6*x4^2+20404*x1^2*x3^6*x4^3+13682*x1^2*x3^6*x4^4+31076*x1^2*x3^6*x4^5+21136*x1^2*x3^7+6487*x1^2*x3^7*x4+26119*x1^2*x3^7*x4^2+19944*x1^2*x3^7*x4^3+15*x1^2*x3^7*x4^4+22702*x1^2*x3^8+28105*x1^2*x3^8*x4+13756*x1^2*x3^8*x4^2+31066*x1^2*x3^8*x4^3+17987*x1^2*x3^9+22912*x1^2*x3^9*x4+5*x1^2*x3^9*x4^2+19525*x1^3*x3^2+5147*x1^3*x3^2*x4+8658*x1^3*x3^2*x4^2+20812*x1^3*x3^2*x4^3+25727*x1^3*x3^2*x4^4+25314*x1^3*x3^3+1472*x1^3*x3^3*x4+18409*x1^3*x3^3*x4^2+25329*x1^3*x3^3*x4^3+21727*x1^3*x3^3*x4^4+11338*x1^3*x3^3*x4^5+4538*x1^3*x3^4+24902*x1^3*x3^4*x4+28981*x1^3*x3^4*x4^2+20470*x1^3*x3^4*x4^3+20945*x1^3*x3^4*x4^4+16264*x1^3*x3^4*x4^5+4261*x1^3*x3^5+9380*x1^3*x3^5*x4+9737*x1^3*x3^5*x4^2+8515*x1^3*x3^5*x4^3+20055*x1^3*x3^5*x4^4+10*x1^3*x3^5*x4^5+22629*x1^3*x3^6+24442*x1^3*x3^6*x4+15134*x1^3*x3^6*x4^2+4341*x1^3*x3^6*x4^3"
					"+31051*x1^3*x3^6*x4^4+15430*x1^3*x3^7+24217*x1^3*x3^7*x4+21502*x1^3*x3^7*x4^2+30*x1^3*x3^7*x4^3+13094*x1^3*x3^8+31071*x1^3*x3^8*x4^2+2889*x1^4*x3+4493*x1^4*x3*x4+2028*x1^4*x3*x4^2+22712*x1^4*x3*x4^3+24290*x1^4*x3*x4^4+20860*x1^4*x3^2+11266*x1^4*x3^2*x4+17638*x1^4*x3^2*x4^2+22541*x1^4*x3^2*x4^3+14015*x1^4*x3^2*x4^4+19743*x1^4*x3^2*x4^5+13331*x1^4*x3^3+23771*x1^4*x3^3*x4+4789*x1^4*x3^3*x4^2+9281*x1^4*x3^3*x4^3+3504*x1^4*x3^3*x4^4+14817*x1^4*x3^3*x4^5+11457*x1^4*x3^4+8419*x1^4*x3^4*x4+17696*x1^4*x3^4*x4^2+29654*x1^4*x3^4*x4^3+2857*x1^4*x3^4*x4^4+31071*x1^4*x3^4*x4^5+28965*x1^4*x3^5+18307*x1^4*x3^5*x4+28214*x1^4*x3^5*x4^2+20166*x1^4*x3^5*x4^3+30*x1^4*x3^5*x4^4+4300*x1^4*x3^6+18675*x1^4*x3^6*x4+16153*x1^4*x3^6*x4^2+31051*x1^4*x3^6*x4^3+24534*x1^4*x3^7+8169*x1^4*x3^7*x4+10*x1^4*x3^7*x4^2+25661*x1^5*x4+29404*x1^5*x4^2+19915*x1^5*x4^3+9468*x1^5*x4^4+1557*x1^5*x3+25453*x1^5*x3*x4+4690*x1^5*x3*x4^2+27495*x1^5*x3*x4^3+10579*x1^5*x3*x4^4+5669*x1^5*x3*x4^5+430*x1^5*x3^2+22131*x1^5*x3^2*x4+12333*x1^5*x3^2*x4^2+1872*x1^5*x3^2*x4^3"
					"+8615*x1^5*x3^2*x4^4+8132*x1^5*x3^2*x4^5+22964*x1^5*x3^3+18249*x1^5*x3^3*x4+21114*x1^5*x3^3*x4^2+7644*x1^5*x3^3*x4^3+25887*x1^5*x3^3*x4^4+5*x1^5*x3^3*x4^5+14124*x1^5*x3^4+15601*x1^5*x3^4*x4+4237*x1^5*x3^4*x4^2+16754*x1^5*x3^4*x4^3+31066*x1^5*x3^4*x4^4+27818*x1^5*x3^5+16039*x1^5*x3^5*x4+11708*x1^5*x3^5*x4^2+15*x1^5*x3^5*x4^3+19958*x1^5*x3^6+30762*x1^5*x3^6*x4+31076*x1^5*x3^6*x4^2+25352*x1^6*x4+25842*x1^6*x4^2+16221*x1^6*x4^3+17240*x1^6*x4^4+23731*x1^6*x4^5+7800*x1^6*x3*x4+2305*x1^6*x3*x4^2+17941*x1^6*x3*x4^3+11039*x1^6*x3*x4^4+10806*x1^6*x3*x4^5+29128*x1^6*x3^2*x4+18052*x1^6*x3^2*x4^2+6916*x1^6*x3^2*x4^3+5685*x1^6*x3^2*x4^4-x1^6*x3^2*x4^5+18397*x1^6*x3^3*x4+22563*x1^6*x3^3*x4^2+26224*x1^6*x3^3*x4^3+3*x1^6*x3^3*x4^4+28994*x1^6*x3^4*x4+11597*x1^6*x3^4*x4^2+31078*x1^6*x3^4*x4^3+7850*x1^6*x3^5*x4+x1^6*x3^5*x4^2}"
#elif 1
					"Z/31081Z[x0,x1,x2,x3,x4]"
					"{x0*x1^3*x2*x4^2+x2^2*x3^3*x4^2-x2^2*x3^4*x4-x2^3*x3^3*x4+x2^3*x3^4-2*x1*x2*x3^2*x4^3+2*x1*x2*x3^3*x4^2+x1*x2^2*x3^2*x4^2-x1*x2^2*x3^3*x4+x1*x2^3*x3^2*x4-x1*x2^3*x3^3+x1^2*x3*x4^4-x1^2*x3^2*x4^3+x1^2*x2*x3*x4^3-x1^2*x2*x3^2*x4^2-2*x1^2*x2^2*x3*x4^2+2*x1^2*x2^2*x3^2*x4-x1^3*x4^4+x1^3*x3*x4^3+x1^3*x2*x4^3-x1^3*x2*x3*x4^2+x0*x2^2*x3^3*x4-x0*x2^3*x3^3-2*x0*x1*x2*x3^2*x4^2+x0*x1*x2^2*x3^2*x4+x0*x1*x2^3*x3^2+x0*x1^2*x3*x4^3+x0*x1^2*x2*x3*x4^2-2*x0*x1^2*x2^2*x3*x4-x0*x1^3*x4^3,"
					"x0*x1^6*x4^4+x2^4*x3^6*x4-x2^4*x3^7-4*x1*x2^3*x3^5*x4^2+4*x1*x2^3*x3^6*x4-2*x1*x2^4*x3^5*x4+2*x1*x2^4*x3^6+6*x1^2*x2^2*x3^4*x4^3-6*x1^2*x2^2*x3^5*x4^2+8*x1^2*x2^3*x3^4*x4^2-8*x1^2*x2^3*x3^5*x4+x1^2*x2^4*x3^4*x4-x1^2*x2^4*x3^5-4*x1^3*x2*x3^3*x4^4+4*x1^3*x2*x3^4*x4^3-12*x1^3*x2^2*x3^3*x4^3+12*x1^3*x2^2*x3^4*x4^2-4*x1^3*x2^3*x3^3*x4^2+4*x1^3*x2^3*x3^4*x4+x1^4*x3^2*x4^5-x1^4*x3^3*x4^4+8*x1^4*x2*x3^2*x4^4-8*x1^4*x2*x3^3*x4^3+6*x1^4*x2^2*x3^2*x4^3-6*x1^4*x2^2*x3^3*x4^2-2*x1^5*x3*x4^5+2*x1^5*x3^2*x4^4-4*x1^5*x2*x3*x4^4+4*x1^5*x2*x3^2*x4^3+x1^6*x4^5-x1^6*x3*x4^4+x0*x2^4*x3^6-4*x0*x1*x2^3*x3^5*x4-2*x0*x1*x2^4*x3^5+6*x0*x1^2*x2^2*x3^4*x4^2+8*x0*x1^2*x2^3*x3^4*x4+x0*x1^2*x2^4*x3^4-4*x0*x1^3*x2*x3^3*x4^3-12*x0*x1^3*x2^2*x3^3*x4^2-4*x0*x1^3*x2^3*x3^3*x4+x0*x1^4*x3^2*x4^4+8*x0*x1^4*x2*x3^2*x4^3+6*x0*x1^4*x2^2*x3^2*x4^2-2*x0*x1^5*x3*x4^4-4*x0*x1^5*x2*x3*x4^3}"
//					"-x2^2*x3^3*x4+x2^2*x3^4+2*x1*x2*x3^2*x4^2-2*x1*x2*x3^3*x4+x1*x2^2*x3^2*x4-x1*x2^2*x3^3-x1^2*x3*x4^3+x1^2*x3^2*x4^2-2*x1^2*x2*x3*x4^2+2*x1^2*x2*x3^2*x4+x1^3*x4^3-x1^3*x3*x4^2-x0*x2^2*x3^3+2*x0*x1*x2*x3^2*x4+x0*x1*x2^2*x3^2-x0*x1^2*x3*x4^2-2*x0*x1^2*x2*x3*x4+x0*x1^3*x4^2"

#elif 0
					"Z/31081Z[x0,x1,x2,x3,x4]"
					"{x2*x3^7*x4^5-3*x2*x3^8*x4^4+3*x2*x3^9*x4^3-x2*x3^10*x4^2-2*x2^2*x3^7*x4^4+6*x2^2*x3^8*x4^3-6*x2^2*x3^9*x4^2+2*x2^2*x3^10*x4+x2^3*x3^7*x4^3-3*x2^3*x3^8*x4^2+3*x2^3*x3^9*x4-x2^3*x3^10-x1*x3^6*x4^6+3*x1*x3^7*x4^5-3*x1*x3^8*x4^4+x1*x3^9*x4^3-2*x1*x2*x3^6*x4^5+6*x1*x2*x3^7*x4^4-6*x1*x2*x3^8*x4^3+2*x1*x2*x3^9*x4^2+7*x1*x2^2*x3^6*x4^4-21*x1*x2^2*x3^7*x4^3+21*x1*x2^2*x3^8*x4^2-7*x1*x2^2*x3^9*x4-4*x1*x2^3*x3^6*x4^3+12*x1*x2^3*x3^7*x4^2-12*x1*x2^3*x3^8*x4+4*x1*x2^3*x3^9+4*x1^2*x3^5*x4^6-12*x1^2*x3^6*x4^5+12*x1^2*x3^7*x4^4-4*x1^2*x3^8*x4^3-2*x1^2*x2*x3^5*x4^5+6*x1^2*x2*x3^6*x4^4-6*x1^2*x2*x3^7*x4^3+2*x1^2*x2*x3^8*x4^2-8*x1^2*x2^2*x3^5*x4^4+24*x1^2*x2^2*x3^6*x4^3-24*x1^2*x2^2*x3^7*x4^2+8*x1^2*x2^2*x3^8*x4+6*x1^2*x2^3*x3^5*x4^3-18*x1^2*x2^3*x3^6*x4^2+18*x1^2*x2^3*x3^7*x4-6*x1^2*x2^3*x3^8-6*x1^3*x3^4*x4^6+18*x1^3*x3^5*x4^5-18*x1^3*x3^6*x4^4+6*x1^3*x3^7*x4^3+8*x1^3*x2*x3^4*x4^5-24*x1^3*x2*x3^5*x4^4"
					"+24*x1^3*x2*x3^6*x4^3-8*x1^3*x2*x3^7*x4^2+2*x1^3*x2^2*x3^4*x4^4-6*x1^3*x2^2*x3^5*x4^3+6*x1^3*x2^2*x3^6*x4^2-2*x1^3*x2^2*x3^7*x4-4*x1^3*x2^3*x3^4*x4^3+12*x1^3*x2^3*x3^5*x4^2-12*x1^3*x2^3*x3^6*x4+4*x1^3*x2^3*x3^7+4*x1^4*x3^3*x4^6-12*x1^4*x3^4*x4^5+12*x1^4*x3^5*x4^4-4*x1^4*x3^6*x4^3-7*x1^4*x2*x3^3*x4^5+21*x1^4*x2*x3^4*x4^4-21*x1^4*x2*x3^5*x4^3+7*x1^4*x2*x3^6*x4^2+2*x1^4*x2^2*x3^3*x4^4-6*x1^4*x2^2*x3^4*x4^3+6*x1^4*x2^2*x3^5*x4^2-2*x1^4*x2^2*x3^6*x4+x1^4*x2^3*x3^3*x4^3-3*x1^4*x2^3*x3^4*x4^2+3*x1^4*x2^3*x3^5*x4-x1^4*x2^3*x3^6-x1^5*x3^2*x4^6+3*x1^5*x3^3*x4^5-3*x1^5*x3^4*x4^4+x1^5*x3^5*x4^3+2*x1^5*x2*x3^2*x4^5-6*x1^5*x2*x3^3*x4^4+6*x1^5*x2*x3^4*x4^3-2*x1^5*x2*x3^5*x4^2-x1^5*x2^2*x3^2*x4^4+3*x1^5*x2^2*x3^3*x4^3-3*x1^5*x2^2*x3^4*x4^2+x1^5*x2^2*x3^5*x4-x0*x2*x3^6*x4^4-2*x0*x2*x3^6*x4^5+3*x0*x2*x3^7*x4^3+9*x0*x2*x3^7*x4^4-3*x0*x2*x3^8*x4^2-12*x0*x2*x3^8*x4^3+x0*x2*x3^9*x4+5*x0*x2*x3^9*x4^2+x0*x2^2*x3^6*x4^3+4*x0*x2^2*x3^6*x4^4-3*x0*x2^2*x3^7*x4^2-18*x0*x2^2*x3^7*x4^3+3*x0*x2^2*x3^8*x4+24*x0*x2^2*x3^8*x4^2-x0*x2^2*x3^9-10*x0*x2^2*x3^9*x4-2*x0*x2^3*x3^6*x4^3+9*x0*x2^3*x3^7*x4^2-12*x0*x2^3*x3^8*x4+5*x0*x2^3*x3^9+x0*x1*x3^5*x4^5+2*x0*x1*x3^5*x4^6-3*x0*x1*x3^6*x4^4-9*x0*x1*x3^6*x4^5+3*x0*x1*x3^7*x4^3+12*x0*x1*x3^7*x4^4-x0*x1*x3^8*x4^2-5*x0*x1*x3^8*x4^3+2*x0*x1*x2*x3^5*x4^4+4*x0*x1*x2*x3^5*x4^5-6*x0*x1*x2*x3^6*x4^3-18*x0*x1*x2*x3^6*x4^4+6*x0*x1*x2*x3^7*x4^2+24*x0*x1*x2*x3^7*x4^3-2*x0*x1*x2*x3^8*x4-10*x0*x1*x2*x3^8*x4^2-3*x0*x1*x2^2*x3^5*x4^3-14*x0*x1*x2^2*x3^5*x4^4+9*x0*x1*x2^2*x3^6*x4^2+63*x0*x1*x2^2*x3^6*x4^3-9*x0*x1*x2^2*x3^7*x4-84*x0*x1*x2^2*x3^7*x4^2+3*x0*x1*x2^2*x3^8+35*x0*x1*x2^2*x3^8*x4"
					"+8*x0*x1*x2^3*x3^5*x4^3-36*x0*x1*x2^3*x3^6*x4^2+48*x0*x1*x2^3*x3^7*x4-20*x0*x1*x2^3*x3^8-3*x0*x1^2*x3^4*x4^5-8*x0*x1^2*x3^4*x4^6+9*x0*x1^2*x3^5*x4^4+36*x0*x1^2*x3^5*x4^5-9*x0*x1^2*x3^6*x4^3-48*x0*x1^2*x3^6*x4^4+3*x0*x1^2*x3^7*x4^2+20*x0*x1^2*x3^7*x4^3+4*x0*x1^2*x2*x3^4*x4^5-18*x0*x1^2*x2*x3^5*x4^4+24*x0*x1^2*x2*x3^6*x4^3-10*x0*x1^2*x2*x3^7*x4^2+3*x0*x1^2*x2^2*x3^4*x4^3+16*x0*x1^2*x2^2*x3^4*x4^4-9*x0*x1^2*x2^2*x3^5*x4^2-72*x0*x1^2*x2^2*x3^5*x4^3+9*x0*x1^2*x2^2*x3^6*x4+96*x0*x1^2*x2^2*x3^6*x4^2-3*x0*x1^2*x2^2*x3^7-40*x0*x1^2*x2^2*x3^7*x4-12*x0*x1^2*x2^3*x3^4*x4^3+54*x0*x1^2*x2^3*x3^5*x4^2-72*x0*x1^2*x2^3*x3^6*x4+30*x0*x1^2*x2^3*x3^7+3*x0*x1^3*x3^3*x4^5+12*x0*x1^3*x3^3*x4^6-9*x0*x1^3*x3^4*x4^4-54*x0*x1^3*x3^4*x4^5+9*x0*x1^3*x3^5*x4^3+72*x0*x1^3*x3^5*x4^4-3*x0*x1^3*x3^6*x4^2-30*x0*x1^3*x3^6*x4^3-2*x0*x1^3*x2*x3^3*x4^4-16*x0*x1^3*x2*x3^3*x4^5+6*x0*x1^3*x2*x3^4*x4^3+72*x0*x1^3*x2*x3^4*x4^4-6*x0*x1^3*x2*x3^5*x4^2-96*x0*x1^3*x2*x3^5*x4^3+2*x0*x1^3*x2*x3^6*x4+40*x0*x1^3*x2*x3^6*x4^2-x0*x1^3*x2^2*x3^3*x4^3-4*x0*x1^3*x2^2*x3^3*x4^4+3*x0*x1^3*x2^2*x3^4*x4^2+18*x0*x1^3*x2^2*x3^4*x4^3-3*x0*x1^3*x2^2*x3^5*x4-24*x0*x1^3*x2^2*x3^5*x4^2+x0*x1^3*x2^2*x3^6+10*x0*x1^3*x2^2*x3^6*x4+8*x0*x1^3*x2^3*x3^3*x4^3-36*x0*x1^3*x2^3*x3^4*x4^2+48*x0*x1^3*x2^3*x3^5*x4-20*x0*x1^3*x2^3*x3^6-x0*x1^4*x3^2*x4^5-8*x0*x1^4*x3^2*x4^6+3*x0*x1^4*x3^3*x4^4+36*x0*x1^4*x3^3*x4^5-3*x0*x1^4*x3^4*x4^3-48*x0*x1^4*x3^4*x4^4+x0*x1^4*x3^5*x4^2+20*x0*x1^4*x3^5*x4^3+x0*x1^4*x2*x3^2*x4^4+14*x0*x1^4*x2*x3^2*x4^5-3*x0*x1^4*x2*x3^3*x4^3-63*x0*x1^4*x2*x3^3*x4^4+3*x0*x1^4*x2*x3^4*x4^2+84*x0*x1^4*x2*x3^4*x4^3-x0*x1^4*x2*x3^5*x4-35*x0*x1^4*x2*x3^5*x4^2-4*x0*x1^4*x2^2*x3^2*x4^4+18*x0*x1^4*x2^2*x3^3*x4^3-24*x0*x1^4*x2^2*x3^4*x4^2+10*x0*x1^4*x2^2*x3^5*x4-2*x0*x1^4*x2^3*x3^2*x4^3+9*x0*x1^4*x2^3*x3^3*x4^2-12*x0*x1^4*x2^3*x3^4*x4+5*x0*x1^4*x2^3*x3^5+2*x0*x1^5*x3*x4^6-9*x0*x1^5*x3^2*x4^5+12*x0*x1^5*x3^3*x4^4-5*x0*x1^5*x3^4*x4^3-4*x0*x1^5*x2*x3*x4^5+18*x0*x1^5*x2*x3^2*x4^4-24*x0*x1^5*x2*x3^3*x4^3+10*x0*x1^5*x2*x3^4*x4^2+2*x0*x1^5*x2^2*x3*x4^4-9*x0*x1^5*x2^2*x3^2*x4^3+12*x0*x1^5*x2^2*x3^3*x4^2-5*x0*x1^5*x2^2*x3^4*x4+2*x0^2*x2*x3^5*x4^4+x0^2*x2*x3^5*x4^5-9*x0^2*x2*x3^6*x4^3-9*x0^2*x2*x3^6*x4^4+12*x0^2*x2*x3^7*x4^2+18*x0^2*x2*x3^7*x4^3-5*x0^2*x2*x3^8*x4-10*x0^2*x2*x3^8*x4^2-2*x0^2*x2^2*x3^5*x4^3-2*x0^2*x2^2*x3^5*x4^4+9*x0^2*x2^2*x3^6*x4^2+18*x0^2*x2^2*x3^6*x4^3-12*x0^2*x2^2*x3^7*x4-36*x0^2*x2^2*x3^7*x4^2+5*x0^2*x2^2*x3^8+20*x0^2*x2^2*x3^8*x4+x0^2*x2^3*x3^5*x4^3-9*x0^2*x2^3*x3^6*x4^2+18*x0^2*x2^3*x3^7*x4-10*x0^2*x2^3*x3^8-2*x0^2*x1*x3^4*x4^5-x0^2*x1*x3^4*x4^6+9*x0^2*x1*x3^5*x4^4+9*x0^2*x1*x3^5*x4^5-12*x0^2*x1*x3^6*x4^3-18*x0^2*x1*x3^6*x4^4+5*x0^2*x1*x3^7*x4^2+10*x0^2*x1*x3^7*x4^3-4*x0^2*x1*x2*x3^4*x4^4-2*x0^2*x1*x2*x3^4*x4^5+18*x0^2*x1*x2*x3^5*x4^3+18*x0^2*x1*x2*x3^5*x4^4-24*x0^2*x1*x2*x3^6*x4^2-36*x0^2*x1*x2*x3^6*x4^3+10*x0^2*x1*x2*x3^7*x4+20*x0^2*x1*x2*x3^7*x4^2+6*x0^2*x1*x2^2*x3^4*x4^3+7*x0^2*x1*x2^2*x3^4*x4^4-27*x0^2*x1*x2^2*x3^5*x4^2-63*x0^2*x1*x2^2*x3^5*x4^3+36*x0^2*x1*x2^2*x3^6*x4+126*x0^2*x1*x2^2*x3^6*x4^2-15*x0^2*x1*x2^2*x3^7-70*x0^2*x1*x2^2*x3^7*x4-4*x0^2*x1*x2^3*x3^4*x4^3+36*x0^2*x1*x2^3*x3^5*x4^2-72*x0^2*x1*x2^3*x3^6*x4+40*x0^2*x1*x2^3*x3^7+6*x0^2*x1^2*x3^3*x4^5+4*x0^2*x1^2*x3^3*x4^6-27*x0^2*x1^2*x3^4*x4^4-36*x0^2*x1^2*x3^4*x4^5+36*x0^2*x1^2*x3^5*x4^3+72*x0^2*x1^2*x3^5*x4^4-15*x0^2*x1^2*x3^6*x4^2-40*x0^2*x1^2*x3^6*x4^3-2*x0^2*x1^2*x2*x3^3*x4^5+18*x0^2*x1^2*x2*x3^4*x4^4-36*x0^2*x1^2*x2*x3^5*x4^3+20*x0^2*x1^2*x2*x3^6*x4^2-6*x0^2*x1^2*x2^2*x3^3*x4^3-8*x0^2*x1^2*x2^2*x3^3*x4^4+27*x0^2*x1^2*x2^2*x3^4*x4^2+72*x0^2*x1^2*x2^2*x3^4*x4^3-36*x0^2*x1^2*x2^2*x3^5*x4-144*x0^2*x1^2*x2^2*x3^5*x4^2+15*x0^2*x1^2*x2^2*x3^6+80*x0^2*x1^2*x2^2*x3^6*x4+6*x0^2*x1^2*x2^3*x3^3*x4^3-54*x0^2*x1^2*x2^3*x3^4*x4^2+108*x0^2*x1^2*x2^3*x3^5*x4-60*x0^2*x1^2*x2^3*x3^6-6*x0^2*x1^3*x3^2*x4^5-6*x0^2*x1^3*x3^2*x4^6+27*x0^2*x1^3*x3^3*x4^4+54*x0^2*x1^3*x3^3*x4^5-36*x0^2*x1^3*x3^4*x4^3-108*x0^2*x1^3*x3^4*x4^4+15*x0^2*x1^3*x3^5*x4^2+60*x0^2*x1^3*x3^5*x4^3+4*x0^2*x1^3*x2*x3^2*x4^4+8*x0^2*x1^3*x2*x3^2*x4^5-18*x0^2*x1^3*x2*x3^3*x4^3-72*x0^2*x1^3*x2*x3^3*x4^4+24*x0^2*x1^3*x2*x3^4*x4^2+144*x0^2*x1^3*x2*x3^4*x4^3-10*x0^2*x1^3*x2*x3^5*x4"
					"-80*x0^2*x1^3*x2*x3^5*x4^2+2*x0^2*x1^3*x2^2*x3^2*x4^3+2*x0^2*x1^3*x2^2*x3^2*x4^4-9*x0^2*x1^3*x2^2*x3^3*x4^2-18*x0^2*x1^3*x2^2*x3^3*x4^3+12*x0^2*x1^3*x2^2*x3^4*x4+36*x0^2*x1^3*x2^2*x3^4*x4^2-5*x0^2*x1^3*x2^2*x3^5-20*x0^2*x1^3*x2^2*x3^5*x4-4*x0^2*x1^3*x2^3*x3^2*x4^3+36*x0^2*x1^3*x2^3*x3^3*x4^2-72*x0^2*x1^3*x2^3*x3^4*x4+40*x0^2*x1^3*x2^3*x3^5+2*x0^2*x1^4*x3*x4^5+4*x0^2*x1^4*x3*x4^6-9*x0^2*x1^4*x3^2*x4^4-36*x0^2*x1^4*x3^2*x4^5+12*x0^2*x1^4*x3^3*x4^3+72*x0^2*x1^4*x3^3*x4^4-5*x0^2*x1^4*x3^4*x4^2-40*x0^2*x1^4*x3^4*x4^3-2*x0^2*x1^4*x2*x3*x4^4-7*x0^2*x1^4*x2*x3*x4^5+9*x0^2*x1^4*x2*x3^2*x4^3+63*x0^2*x1^4*x2*x3^2*x4^4-12*x0^2*x1^4*x2*x3^3*x4^2-126*x0^2*x1^4*x2*x3^3*x4^3+5*x0^2*x1^4*x2*x3^4*x4+70*x0^2*x1^4*x2*x3^4*x4^2+2*x0^2*x1^4*x2^2*x3*x4^4-18*x0^2*x1^4*x2^2*x3^2*x4^3+36*x0^2*x1^4*x2^2*x3^3*x4^2-20*x0^2*x1^4*x2^2*x3^4*x4+x0^2*x1^4*x2^3*x3*x4^3-9*x0^2*x1^4*x2^3*x3^2*x4^2+18*x0^2*x1^4*x2^3*x3^3*x4-10*x0^2*x1^4*x2^3*x3^4-x0^2*x1^5*x4^6+9*x0^2*x1^5*x3*x4^5-18*x0^2*x1^5*x3^2*x4^4+10*x0^2*x1^5*x3^3*x4^3+2*x0^2*x1^5*x2*x4^5-18*x0^2*x1^5*x2*x3*x4^4+36*x0^2*x1^5*x2*x3^2*x4^3-20*x0^2*x1^5*x2*x3^3*x4^2-x0^2*x1^5*x2^2*x4^4+9*x0^2*x1^5*x2^2*x3*x4^3-18*x0^2*x1^5*x2^2*x3^2*x4^2+10*x0^2*x1^5*x2^2*x3^3*x4-x0^3*x2*x3^4*x4^4+9*x0^3*x2*x3^5*x4^3+3*x0^3*x2*x3^5*x4^4-18*x0^3*x2*x3^6*x4^2-12*x0^3*x2*x3^6*x4^3+10*x0^3*x2*x3^7*x4+10*x0^3*x2*x3^7*x4^2+x0^3*x2^2*x3^4*x4^3-9*x0^3*x2^2*x3^5*x4^2-6*x0^3*x2^2*x3^5*x4^3+18*x0^3*x2^2*x3^6*x4+24*x0^3*x2^2*x3^6*x4^2-10*x0^3*x2^2*x3^7-20*x0^3*x2^2*x3^7*x4+3*x0^3*x2^3*x3^5*x4^2-12*x0^3*x2^3*x3^6*x4+10*x0^3*x2^3*x3^7+x0^3*x1*x3^3*x4^5-9*x0^3*x1*x3^4*x4^4-3*x0^3*x1*x3^4*x4^5+18*x0^3*x1*x3^5*x4^3+12*x0^3*x1*x3^5*x4^4-10*x0^3*x1*x3^6*x4^2-10*x0^3*x1*x3^6*x4^3+2*x0^3*x1*x2*x3^3*x4^4-18*x0^3*x1*x2*x3^4*x4^3-6*x0^3*x1*x2*x3^4*x4^4+36*x0^3*x1*x2*x3^5*x4^2+24*x0^3*x1*x2*x3^5*x4^3-20*x0^3*x1*x2*x3^6*x4-20*x0^3*x1*x2*x3^6*x4^2-3*x0^3*x1*x2^2*x3^3*x4^3+27*x0^3*x1*x2^2*x3^4*x4^2+21*x0^3*x1*x2^2*x3^4*x4^3-54*x0^3*x1*x2^2*x3^5*x4-84*x0^3*x1*x2^2*x3^5*x4^2+30*x0^3*x1*x2^2*x3^6+70*x0^3*x1*x2^2*x3^6*x4-12*x0^3*x1*x2^3*x3^4*x4^2+48*x0^3*x1*x2^3*x3^5*x4-40*x0^3*x1*x2^3*x3^6-3*x0^3*x1^2*x3^2*x4^5+27*x0^3*x1^2*x3^3*x4^4+12*x0^3*x1^2*x3^3*x4^5-54*x0^3*x1^2*x3^4*x4^3-48*x0^3*x1^2*x3^4*x4^4+30*x0^3*x1^2*x3^5*x4^2+40*x0^3*x1^2*x3^5*x4^3-6*x0^3*x1^2*x2*x3^3*x4^4+24*x0^3*x1^2*x2*x3^4*x4^3-20*x0^3*x1^2*x2*x3^5*x4^2+3*x0^3*x1^2*x2^2*x3^2*x4^3-27*x0^3*x1^2*x2^2*x3^3*x4^2-24*x0^3*x1^2*x2^2*x3^3*x4^3+54*x0^3*x1^2*x2^2*x3^4*x4+96*x0^3*x1^2*x2^2*x3^4*x4^2-30*x0^3*x1^2*x2^2*x3^5-80*x0^3*x1^2*x2^2*x3^5*x4+18*x0^3*x1^2*x2^3*x3^3*x4^2-72*x0^3*x1^2*x2^3*x3^4*x4+60*x0^3*x1^2*x2^3*x3^5+3*x0^3*x1^3*x3*x4^5-27*x0^3*x1^3*x3^2*x4^4-18*x0^3*x1^3*x3^2*x4^5+54*x0^3*x1^3*x3^3*x4^3+72*x0^3*x1^3*x3^3*x4^4-30*x0^3*x1^3*x3^4*x4^2-60*x0^3*x1^3*x3^4*x4^3-2*x0^3*x1^3*x2*x3*x4^4+18*x0^3*x1^3*x2*x3^2*x4^3+24*x0^3*x1^3*x2*x3^2*x4^4-36*x0^3*x1^3*x2*x3^3*x4^2-96*x0^3*x1^3*x2*x3^3*x4^3+20*x0^3*x1^3*x2*x3^4*x4+80*x0^3*x1^3*x2*x3^4*x4^2-x0^3*x1^3*x2^2*x3*x4^3+9*x0^3*x1^3*x2^2*x3^2*x4^2+6*x0^3*x1^3*x2^2*x3^2*x4^3-18*x0^3*x1^3*x2^2*x3^3*x4-24*x0^3*x1^3*x2^2*x3^3*x4^2+10*x0^3*x1^3*x2^2*x3^4+20*x0^3*x1^3*x2^2*x3^4*x4-12*x0^3*x1^3*x2^3*x3^2*x4^2+48*x0^3*x1^3*x2^3*x3^3*x4-40*x0^3*x1^3*x2^3*x3^4-x0^3*x1^4*x4^5+9*x0^3*x1^4*x3*x4^4+12*x0^3*x1^4*x3*x4^5-18*x0^3*x1^4*x3^2*x4^3-48*x0^3*x1^4*x3^2*x4^4+10*x0^3*x1^4*x3^3*x4^2+40*x0^3*x1^4*x3^3*x4^3+x0^3*x1^4*x2*x4^4-9*x0^3*x1^4*x2*x3*x4^3-21*x0^3*x1^4*x2*x3*x4^4+18*x0^3*x1^4*x2*x3^2*x4^2+84*x0^3*x1^4*x2*x3^2*x4^3-10*x0^3*x1^4*x2*x3^3*x4-70*x0^3*x1^4*x2*x3^3*x4^2+6*x0^3*x1^4*x2^2*x3*x4^3-24*x0^3*x1^4*x2^2*x3^2*x4^2+20*x0^3*x1^4*x2^2*x3^3*x4+3*x0^3*x1^4*x2^3*x3*x4^2-12*x0^3*x1^4*x2^3*x3^2*x4+10*x0^3*x1^4*x2^3*x3^3-3*x0^3*x1^5*x4^5+12*x0^3*x1^5*x3*x4^4-10*x0^3*x1^5*x3^2*x4^3+6*x0^3*x1^5*x2*x4^4-24*x0^3*x1^5*x2*x3*x4^3+20*x0^3*x1^5*x2*x3^2*x4^2-3*x0^3*x1^5*x2^2*x4^3+12*x0^3*x1^5*x2^2*x3*x4^2-10*x0^3*x1^5*x2^2*x3^2*x4-3*x0^4*x2*x3^4*x4^3+12*x0^4*x2*x3^5*x4^2+3*x0^4*x2*x3^5*x4^3-10*x0^4*x2*x3^6*x4"
					"-5*x0^4*x2*x3^6*x4^2+3*x0^4*x2^2*x3^4*x4^2-12*x0^4*x2^2*x3^5*x4-6*x0^4*x2^2*x3^5*x4^2+10*x0^4*x2^2*x3^6+10*x0^4*x2^2*x3^6*x4+3*x0^4*x2^3*x3^5*x4-5*x0^4*x2^3*x3^6+3*x0^4*x1*x3^3*x4^4-12*x0^4*x1*x3^4*x4^3-3*x0^4*x1*x3^4*x4^4+10*x0^4*x1*x3^5*x4^2+5*x0^4*x1*x3^5*x4^3+6*x0^4*x1*x2*x3^3*x4^3-24*x0^4*x1*x2*x3^4*x4^2-6*x0^4*x1*x2*x3^4*x4^3+20*x0^4*x1*x2*x3^5*x4+10*x0^4*x1*x2*x3^5*x4^2-9*x0^4*x1*x2^2*x3^3*x4^2+36*x0^4*x1*x2^2*x3^4*x4+21*x0^4*x1*x2^2*x3^4*x4^2-30*x0^4*x1*x2^2*x3^5-35*x0^4*x1*x2^2*x3^5*x4-12*x0^4*x1*x2^3*x3^4*x4+20*x0^4*x1*x2^3*x3^5-9*x0^4*x1^2*x3^2*x4^4+36*x0^4*x1^2*x3^3*x4^3+12*x0^4*x1^2*x3^3*x4^4-30*x0^4*x1^2*x3^4*x4^2-20*x0^4*x1^2*x3^4*x4^3-6*x0^4*x1^2*x2*x3^3*x4^3+10*x0^4*x1^2*x2*x3^4*x4^2+9*x0^4*x1^2*x2^2*x3^2*x4^2-36*x0^4*x1^2*x2^2*x3^3*x4-24*x0^4*x1^2*x2^2*x3^3*x4^2+30*x0^4*x1^2*x2^2*x3^4+40*x0^4*x1^2*x2^2*x3^4*x4+18*x0^4*x1^2*x2^3*x3^3*x4-30*x0^4*x1^2*x2^3*x3^4+9*x0^4*x1^3*x3*x4^4-36*x0^4*x1^3*x3^2*x4^3-18*x0^4*x1^3*x3^2*x4^4+30*x0^4*x1^3*x3^3*x4^2+30*x0^4*x1^3*x3^3*x4^3-6*x0^4*x1^3*x2*x3*x4^3+24*x0^4*x1^3*x2*x3^2*x4^2+24*x0^4*x1^3*x2*x3^2*x4^3-20*x0^4*x1^3*x2*x3^3*x4-40*x0^4*x1^3*x2*x3^3*x4^2-3*x0^4*x1^3*x2^2*x3*x4^2+12*x0^4*x1^3*x2^2*x3^2*x4+6*x0^4*x1^3*x2^2*x3^2*x4^2-10*x0^4*x1^3*x2^2*x3^3-10*x0^4*x1^3*x2^2*x3^3*x4-12*x0^4*x1^3*x2^3*x3^2*x4+20*x0^4*x1^3*x2^3*x3^3-3*x0^4*x1^4*x4^4+12*x0^4*x1^4*x3*x4^3+12*x0^4*x1^4*x3*x4^4-10*x0^4*x1^4*x3^2*x4^2-20*x0^4*x1^4*x3^2*x4^3+3*x0^4*x1^4*x2*x4^3-12*x0^4*x1^4*x2*x3*x4^2-21*x0^4*x1^4*x2*x3*x4^3+10*x0^4*x1^4*x2*x3^2*x4+35*x0^4*x1^4*x2*x3^2*x4^2+6*x0^4*x1^4*x2^2*x3*x4^2-10*x0^4*x1^4*x2^2*x3^2*x4+3*x0^4*x1^4*x2^3*x3*x4-5*x0^4*x1^4*x2^3*x3^2-3*x0^4*x1^5*x4^4+5*x0^4*x1^5*x3*x4^3+6*x0^4*x1^5*x2*x4^3-10*x0^4*x1^5*x2*x3*x4^2-3*x0^4*x1^5*x2^2*x4^2+5*x0^4*x1^5*x2^2*x3*x4-3*x0^5*x2*x3^4*x4^2+5*x0^5*x2*x3^5*x4+x0^5*x2*x3^5*x4^2+3*x0^5*x2^2*x3^4*x4-5*x0^5*x2^2*x3^5-2*x0^5*x2^2*x3^5*x4+x0^5*x2^3*x3^5+3*x0^5*x1*x3^3*x4^3-5*x0^5*x1*x3^4*x4^2-x0^5*x1*x3^4*x4^3+6*x0^5*x1*x2*x3^3*x4^2-10*x0^5*x1*x2*x3^4*x4-2*x0^5*x1*x2*x3^4*x4^2-9*x0^5*x1*x2^2*x3^3*x4+15*x0^5*x1*x2^2*x3^4+7*x0^5*x1*x2^2*x3^4*x4-4*x0^5*x1*x2^3*x3^4-9*x0^5*x1^2*x3^2*x4^3+15*x0^5*x1^2*x3^3*x4^2+4*x0^5*x1^2*x3^3*x4^3-2*x0^5*x1^2*x2*x3^3*x4^2+9*x0^5*x1^2*x2^2*x3^2*x4-15*x0^5*x1^2*x2^2*x3^3-8*x0^5*x1^2*x2^2*x3^3*x4+6*x0^5*x1^2*x2^3*x3^3+9*x0^5*x1^3*x3*x4^3-15*x0^5*x1^3*x3^2*x4^2-6*x0^5*x1^3*x3^2*x4^3-6*x0^5*x1^3*x2*x3*x4^2+10*x0^5*x1^3*x2*x3^2*x4+8*x0^5*x1^3*x2*x3^2*x4^2-3*x0^5*x1^3*x2^2*x3*x4+5*x0^5*x1^3*x2^2*x3^2+2*x0^5*x1^3*x2^2*x3^2*x4-4*x0^5*x1^3*x2^3*x3^2-3*x0^5*x1^4*x4^3+5*x0^5*x1^4*x3*x4^2+4*x0^5*x1^4*x3*x4^3+3*x0^5*x1^4*x2*x4^2-5*x0^5*x1^4*x2*x3*x4-7*x0^5*x1^4*x2*x3*x4^2+2*x0^5*x1^4*x2^2*x3*x4+x0^5*x1^4*x2^3*x3-x0^5*x1^5*x4^3+2*x0^5*x1^5*x2*x4^2-x0^5*x1^5*x2^2*x4-x0^6*x2*x3^4*x4+x0^6*x2^2*x3^4+x0^6*x1*x3^3*x4^2+2*x0^6*x1*x2*x3^3*x4-3*x0^6*x1*x2^2*x3^3-3*x0^6*x1^2*x3^2*x4^2+3*x0^6*x1^2*x2^2*x3^2+3*x0^6*x1^3*x3*x4^2-2*x0^6*x1^3*x2*x3*x4-x0^6*x1^3*x2^2*x3-x0^6*x1^4*x4^2+x0^6*x1^4*x2*x4,"
					"-x2*x3^8*x4^4+3*x2*x3^9*x4^3-3*x2*x3^10*x4^2+x2*x3^11*x4+x2^2*x3^8*x4^3-3*x2^2*x3^9*x4^2+3*x2^2*x3^10*x4-x2^2*x3^11+x1*x3^7*x4^5-3*x1*x3^8*x4^4+3*x1*x3^9*x4^3-x1*x3^10*x4^2+4*x1*x2*x3^7*x4^4-12*x1*x2*x3^8*x4^3+12*x1*x2*x3^9*x4^2-4*x1*x2*x3^10*x4-5*x1*x2^2*x3^7*x4^3+15*x1*x2^2*x3^8*x4^2-15*x1*x2^2*x3^9*x4+5*x1*x2^2*x3^10-5*x1^2*x3^6*x4^5+15*x1^2*x3^7*x4^4-15*x1^2*x3^8*x4^3+5*x1^2*x3^9*x4^2-5*x1^2*x2*x3^6*x4^4+15*x1^2*x2*x3^7*x4^3-15*x1^2*x2*x3^8*x4^2+5*x1^2*x2*x3^9*x4+10*x1^2*x2^2*x3^6*x4^3-30*x1^2*x2^2*x3^7*x4^2+30*x1^2*x2^2*x3^8*x4-10*x1^2*x2^2*x3^9+10*x1^3*x3^5*x4^5"
					"-30*x1^3*x3^6*x4^4+30*x1^3*x3^7*x4^3-10*x1^3*x3^8*x4^2-10*x1^3*x2^2*x3^5*x4^3+30*x1^3*x2^2*x3^6*x4^2-30*x1^3*x2^2*x3^7*x4+10*x1^3*x2^2*x3^8-10*x1^4*x3^4*x4^5+30*x1^4*x3^5*x4^4-30*x1^4*x3^6*x4^3+10*x1^4*x3^7*x4^2+5*x1^4*x2*x3^4*x4^4-15*x1^4*x2*x3^5*x4^3+15*x1^4*x2*x3^6*x4^2-5*x1^4*x2*x3^7*x4+5*x1^4*x2^2*x3^4*x4^3-15*x1^4*x2^2*x3^5*x4^2+15*x1^4*x2^2*x3^6*x4-5*x1^4*x2^2*x3^7+5*x1^5*x3^3*x4^5-15*x1^5*x3^4*x4^4+15*x1^5*x3^5*x4^3-5*x1^5*x3^6*x4^2-4*x1^5*x2*x3^3*x4^4+12*x1^5*x2*x3^4*x4^3-12*x1^5*x2*x3^5*x4^2+4*x1^5*x2*x3^6*x4-x1^5*x2^2*x3^3*x4^3+3*x1^5*x2^2*x3^4*x4^2-3*x1^5*x2^2*x3^5*x4+x1^5*x2^2*x3^6-x1^6*x3^2*x4^5+3*x1^6*x3^3*x4^4-3*x1^6*x3^4*x4^3+x1^6*x3^5*x4^2+x1^6*x2*x3^2*x4^4-3*x1^6*x2*x3^3*x4^3+3*x1^6*x2*x3^4*x4^2-x1^6*x2*x3^5*x4+x0*x2*x3^7*x4^3+2*x0*x2*x3^7*x4^4-3*x0*x2*x3^8*x4^2-9*x0*x2*x3^8*x4^3+3*x0*x2*x3^9*x4+12*x0*x2*x3^9*x4^2-x0*x2*x3^10-5*x0*x2*x3^10*x4-2*x0*x2^2*x3^7*x4^3+9*x0*x2^2*x3^8*x4^2-12*x0*x2^2*x3^9*x4+5*x0*x2^2*x3^10-x0*x1*x3^6*x4^4-2*x0*x1*x3^6*x4^5+3*x0*x1*x3^7*x4^3+9*x0*x1*x3^7*x4^4-3*x0*x1*x3^8*x4^2-12*x0*x1*x3^8*x4^3+x0*x1*x3^9*x4+5*x0*x1*x3^9*x4^2-4*x0*x1*x2*x3^6*x4^3-8*x0*x1*x2*x3^6*x4^4+12*x0*x1*x2*x3^7*x4^2+36*x0*x1*x2*x3^7*x4^3-12*x0*x1*x2*x3^8*x4-48*x0*x1*x2*x3^8*x4^2+4*x0*x1*x2*x3^9+20*x0*x1*x2*x3^9*x4+10*x0*x1*x2^2*x3^6*x4^3-45*x0*x1*x2^2*x3^7*x4^2+60*x0*x1*x2^2*x3^8*x4-25*x0*x1*x2^2*x3^9+4*x0*x1^2*x3^5*x4^4+10*x0*x1^2*x3^5*x4^5-12*x0*x1^2*x3^6*x4^3-45*x0*x1^2*x3^6*x4^4+12*x0*x1^2*x3^7*x4^2+60*x0*x1^2*x3^7*x4^3-4*x0*x1^2*x3^8*x4-25*x0*x1^2*x3^8*x4^2+6*x0*x1^2*x2*x3^5*x4^3+10*x0*x1^2*x2*x3^5*x4^4-18*x0*x1^2*x2*x3^6*x4^2-45*x0*x1^2*x2*x3^6*x4^3+18*x0*x1^2*x2*x3^7*x4+60*x0*x1^2*x2*x3^7*x4^2-6*x0*x1^2*x2*x3^8-25*x0*x1^2*x2*x3^8*x4-20*x0*x1^2*x2^2*x3^5*x4^3+90*x0*x1^2*x2^2*x3^6*x4^2-120*x0*x1^2*x2^2*x3^7*x4+50*x0*x1^2*x2^2*x3^8-6*x0*x1^3*x3^4*x4^4-20*x0*x1^3*x3^4*x4^5+18*x0*x1^3*x3^5*x4^3+90*x0*x1^3*x3^5*x4^4-18*x0*x1^3*x3^6*x4^2-120*x0*x1^3*x3^6*x4^3+6*x0*x1^3*x3^7*x4+50*x0*x1^3*x3^7*x4^2-4*x0*x1^3*x2*x3^4*x4^3+12*x0*x1^3*x2*x3^5*x4^2-12*x0*x1^3*x2*x3^6*x4+4*x0*x1^3*x2*x3^7+20*x0*x1^3*x2^2*x3^4*x4^3-90*x0*x1^3*x2^2*x3^5*x4^2+120*x0*x1^3*x2^2*x3^6*x4-50*x0*x1^3*x2^2*x3^7+4*x0*x1^4*x3^3*x4^4+20*x0*x1^4*x3^3*x4^5-12*x0*x1^4*x3^4*x4^3-90*x0*x1^4*x3^4*x4^4+12*x0*x1^4*x3^5*x4^2+120*x0*x1^4*x3^5*x4^3-4*x0*x1^4*x3^6*x4-50*x0*x1^4*x3^6*x4^2+x0*x1^4*x2*x3^3*x4^3-10*x0*x1^4*x2*x3^3*x4^4-3*x0*x1^4*x2*x3^4*x4^2+45*x0*x1^4*x2*x3^4*x4^3+3*x0*x1^4*x2*x3^5*x4-60*x0*x1^4*x2*x3^5*x4^2-x0*x1^4*x2*x3^6+25*x0*x1^4*x2*x3^6*x4-10*x0*x1^4*x2^2*x3^3*x4^3+45*x0*x1^4*x2^2*x3^4*x4^2-60*x0*x1^4*x2^2*x3^5*x4+25*x0*x1^4*x2^2*x3^6-x0*x1^5*x3^2*x4^4-10*x0*x1^5*x3^2*x4^5+3*x0*x1^5*x3^3*x4^3+45*x0*x1^5*x3^3*x4^4-3*x0*x1^5*x3^4*x4^2-60*x0*x1^5*x3^4*x4^3+x0*x1^5*x3^5*x4+25*x0*x1^5*x3^5*x4^2+8*x0*x1^5*x2*x3^2*x4^4-36*x0*x1^5*x2*x3^3*x4^3+48*x0*x1^5*x2*x3^4*x4^2-20*x0*x1^5*x2*x3^5*x4+2*x0*x1^5*x2^2*x3^2*x4^3-9*x0*x1^5*x2^2*x3^3*x4^2+12*x0*x1^5*x2^2*x3^4*x4-5*x0*x1^5*x2^2*x3^5+2*x0*x1^6*x3*x4^5-9*x0*x1^6*x3^2*x4^4+12*x0*x1^6*x3^3*x4^3-5*x0*x1^6*x3^4*x4^2-2*x0*x1^6*x2*x3*x4^4+9*x0*x1^6*x2*x3^2*x4^3-12*x0*x1^6*x2*x3^3*x4^2+5*x0*x1^6*x2*x3^4*x4-2*x0^2*x2*x3^6*x4^3-x0^2*x2*x3^6*x4^4+9*x0^2*x2*x3^7*x4^2+9*x0^2*x2*x3^7*x4^3-12*x0^2*x2*x3^8*x4-18*x0^2*x2*x3^8*x4^2+5*x0^2*x2*x3^9+10*x0^2*x2*x3^9*x4+x0^2*x2^2*x3^6*x4^3-9*x0^2*x2^2*x3^7*x4^2+18*x0^2*x2^2*x3^8*x4-10*x0^2*x2^2*x3^9+2*x0^2*x1*x3^5*x4^4+x0^2*x1*x3^5*x4^5-9*x0^2*x1*x3^6*x4^3-9*x0^2*x1*x3^6*x4^4+12*x0^2*x1*x3^7*x4^2+18*x0^2*x1*x3^7*x4^3-5*x0^2*x1*x3^8*x4-10*x0^2*x1*x3^8*x4^2+8*x0^2*x1*x2*x3^5*x4^3+4*x0^2*x1*x2*x3^5*x4^4-36*x0^2*x1*x2*x3^6*x4^2-36*x0^2*x1*x2*x3^6*x4^3+48*x0^2*x1*x2*x3^7*x4+72*x0^2*x1*x2*x3^7*x4^2-20*x0^2*x1*x2*x3^8-40*x0^2*x1*x2*x3^8*x4-5*x0^2*x1*x2^2*x3^5*x4^3+45*x0^2*x1*x2^2*x3^6*x4^2-90*x0^2*x1*x2^2*x3^7*x4+50*x0^2*x1*x2^2*x3^8-8*x0^2*x1^2*x3^4*x4^4-5*x0^2*x1^2*x3^4*x4^5+36*x0^2*x1^2*x3^5*x4^3+45*x0^2*x1^2*x3^5*x4^4-48*x0^2*x1^2*x3^6*x4^2-90*x0^2*x1^2*x3^6*x4^3+20*x0^2*x1^2*x3^7*x4+50*x0^2*x1^2*x3^7*x4^2-12*x0^2*x1^2*x2*x3^4*x4^3-5*x0^2*x1^2*x2*x3^4*x4^4+54*x0^2*x1^2*x2*x3^5*x4^2+45*x0^2*x1^2*x2*x3^5*x4^3-72*x0^2*x1^2*x2*x3^6*x4-90*x0^2*x1^2*x2*x3^6*x4^2+30*x0^2*x1^2*x2*x3^7+50*x0^2*x1^2*x2*x3^7*x4+10*x0^2*x1^2*x2^2*x3^4*x4^3-90*x0^2*x1^2*x2^2*x3^5*x4^2+180*x0^2*x1^2*x2^2*x3^6*x4-100*x0^2*x1^2*x2^2*x3^7+12*x0^2*x1^3*x3^3*x4^4+10*x0^2*x1^3*x3^3*x4^5-54*x0^2*x1^3*x3^4*x4^3-90*x0^2*x1^3*x3^4*x4^4+72*x0^2*x1^3*x3^5*x4^2+180*x0^2*x1^3*x3^5*x4^3-30*x0^2*x1^3*x3^6*x4-100*x0^2*x1^3*x3^6*x4^2+8*x0^2*x1^3*x2*x3^3*x4^3-36*x0^2*x1^3*x2*x3^4*x4^2+48*x0^2*x1^3*x2*x3^5*x4-20*x0^2*x1^3*x2*x3^6-10*x0^2*x1^3*x2^2*x3^3*x4^3+90*x0^2*x1^3*x2^2*x3^4*x4^2-180*x0^2*x1^3*x2^2*x3^5*x4+100*x0^2*x1^3*x2^2*x3^6-8*x0^2*x1^4*x3^2*x4^4-10*x0^2*x1^4*x3^2*x4^5+36*x0^2*x1^4*x3^3*x4^3+90*x0^2*x1^4*x3^3*x4^4-48*x0^2*x1^4*x3^4*x4^2"
					"-180*x0^2*x1^4*x3^4*x4^3+20*x0^2*x1^4*x3^5*x4+100*x0^2*x1^4*x3^5*x4^2-2*x0^2*x1^4*x2*x3^2*x4^3+5*x0^2*x1^4*x2*x3^2*x4^4+9*x0^2*x1^4*x2*x3^3*x4^2-45*x0^2*x1^4*x2*x3^3*x4^3-12*x0^2*x1^4*x2*x3^4*x4+90*x0^2*x1^4*x2*x3^4*x4^2+5*x0^2*x1^4*x2*x3^5-50*x0^2*x1^4*x2*x3^5*x4+5*x0^2*x1^4*x2^2*x3^2*x4^3-45*x0^2*x1^4*x2^2*x3^3*x4^2+90*x0^2*x1^4*x2^2*x3^4*x4-50*x0^2*x1^4*x2^2*x3^5+2*x0^2*x1^5*x3*x4^4+5*x0^2*x1^5*x3*x4^5-9*x0^2*x1^5*x3^2*x4^3-45*x0^2*x1^5*x3^2*x4^4+12*x0^2*x1^5*x3^3*x4^2+90*x0^2*x1^5*x3^3*x4^3-5*x0^2*x1^5*x3^4*x4-50*x0^2*x1^5*x3^4*x4^2-4*x0^2*x1^5*x2*x3*x4^4+36*x0^2*x1^5*x2*x3^2*x4^3-72*x0^2*x1^5*x2*x3^3*x4^2+40*x0^2*x1^5*x2*x3^4*x4-x0^2*x1^5*x2^2*x3*x4^3+9*x0^2*x1^5*x2^2*x3^2*x4^2-18*x0^2*x1^5*x2^2*x3^3*x4+10*x0^2*x1^5*x2^2*x3^4-x0^2*x1^6*x4^5+9*x0^2*x1^6*x3*x4^4-18*x0^2*x1^6*x3^2*x4^3+10*x0^2*x1^6*x3^3*x4^2+x0^2*x1^6*x2*x4^4-9*x0^2*x1^6*x2*x3*x4^3+18*x0^2*x1^6*x2*x3^2*x4^2-10*x0^2*x1^6*x2*x3^3*x4+x0^3*x2*x3^5*x4^3-9*x0^3*x2*x3^6*x4^2-3*x0^3*x2*x3^6*x4^3+18*x0^3*x2*x3^7*x4+12*x0^3*x2*x3^7*x4^2-10*x0^3*x2*x3^8-10*x0^3*x2*x3^8*x4+3*x0^3*x2^2*x3^6*x4^2-12*x0^3*x2^2*x3^7*x4+10*x0^3*x2^2*x3^8-x0^3*x1*x3^4*x4^4+9*x0^3*x1*x3^5*x4^3+3*x0^3*x1*x3^5*x4^4-18*x0^3*x1*x3^6*x4^2-12*x0^3*x1*x3^6*x4^3+10*x0^3*x1*x3^7*x4+10*x0^3*x1*x3^7*x4^2-4*x0^3*x1*x2*x3^4*x4^3+36*x0^3*x1*x2*x3^5*x4^2+12*x0^3*x1*x2*x3^5*x4^3-72*x0^3*x1*x2*x3^6*x4-48*x0^3*x1*x2*x3^6*x4^2+40*x0^3*x1*x2*x3^7+40*x0^3*x1*x2*x3^7*x4-15*x0^3*x1*x2^2*x3^5*x4^2+60*x0^3*x1*x2^2*x3^6*x4-50*x0^3*x1*x2^2*x3^7+4*x0^3*x1^2*x3^3*x4^4-36*x0^3*x1^2*x3^4*x4^3-15*x0^3*x1^2*x3^4*x4^4+72*x0^3*x1^2*x3^5*x4^2+60*x0^3*x1^2*x3^5*x4^3-40*x0^3*x1^2*x3^6*x4-50*x0^3*x1^2*x3^6*x4^2+6*x0^3*x1^2*x2*x3^3*x4^3-54*x0^3*x1^2*x2*x3^4*x4^2-15*x0^3*x1^2*x2*x3^4*x4^3+108*x0^3*x1^2*x2*x3^5*x4+60*x0^3*x1^2*x2*x3^5*x4^2-60*x0^3*x1^2*x2*x3^6-50*x0^3*x1^2*x2*x3^6*x4+30*x0^3*x1^2*x2^2*x3^4*x4^2-120*x0^3*x1^2*x2^2*x3^5*x4+100*x0^3*x1^2*x2^2*x3^6-6*x0^3*x1^3*x3^2*x4^4+54*x0^3*x1^3*x3^3*x4^3+30*x0^3*x1^3*x3^3*x4^4-108*x0^3*x1^3*x3^4*x4^2-120*x0^3*x1^3*x3^4*x4^3+60*x0^3*x1^3*x3^5*x4+100*x0^3*x1^3*x3^5*x4^2-4*x0^3*x1^3*x2*x3^2*x4^3"
					"+36*x0^3*x1^3*x2*x3^3*x4^2-72*x0^3*x1^3*x2*x3^4*x4+40*x0^3*x1^3*x2*x3^5-30*x0^3*x1^3*x2^2*x3^3*x4^2+120*x0^3*x1^3*x2^2*x3^4*x4-100*x0^3*x1^3*x2^2*x3^5+4*x0^3*x1^4*x3*x4^4-36*x0^3*x1^4*x3^2*x4^3-30*x0^3*x1^4*x3^2*x4^4+72*x0^3*x1^4*x3^3*x4^2+120*x0^3*x1^4*x3^3*x4^3-40*x0^3*x1^4*x3^4*x4-100*x0^3*x1^4*x3^4*x4^2+x0^3*x1^4*x2*x3*x4^3-9*x0^3*x1^4*x2*x3^2*x4^2+15*x0^3*x1^4*x2*x3^2*x4^3+18*x0^3*x1^4*x2*x3^3*x4-60*x0^3*x1^4*x2*x3^3*x4^2-10*x0^3*x1^4*x2*x3^4+50*x0^3*x1^4*x2*x3^4*x4+15*x0^3*x1^4*x2^2*x3^2*x4^2-60*x0^3*x1^4*x2^2*x3^3*x4+50*x0^3*x1^4*x2^2*x3^4-x0^3*x1^5*x4^4+9*x0^3*x1^5*x3*x4^3+15*x0^3*x1^5*x3*x4^4-18*x0^3*x1^5*x3^2*x4^2-60*x0^3*x1^5*x3^2*x4^3+10*x0^3*x1^5*x3^3*x4+50*x0^3*x1^5*x3^3*x4^2-12*x0^3*x1^5*x2*x3*x4^3+48*x0^3*x1^5*x2*x3^2*x4^2-40*x0^3*x1^5*x2*x3^3*x4-3*x0^3*x1^5*x2^2*x3*x4^2+12*x0^3*x1^5*x2^2*x3^2*x4-10*x0^3*x1^5*x2^2*x3^3-3*x0^3*x1^6*x4^4+12*x0^3*x1^6*x3*x4^3-10*x0^3*x1^6*x3^2*x4^2+3*x0^3*x1^6*x2*x4^3-12*x0^3*x1^6*x2*x3*x4^2+10*x0^3*x1^6*x2*x3^2*x4+3*x0^4*x2*x3^5*x4^2-12*x0^4*x2*x3^6*x4-3*x0^4*x2*x3^6*x4^2+10*x0^4*x2*x3^7+5*x0^4*x2*x3^7*x4+3*x0^4*x2^2*x3^6*x4-5*x0^4*x2^2*x3^7-3*x0^4*x1*x3^4*x4^3+12*x0^4*x1*x3^5*x4^2+3*x0^4*x1*x3^5*x4^3-10*x0^4*x1*x3^6*x4-5*x0^4*x1*x3^6*x4^2-12*x0^4*x1*x2*x3^4*x4^2+48*x0^4*x1*x2*x3^5*x4+12*x0^4*x1*x2*x3^5*x4^2-40*x0^4*x1*x2*x3^6-20*x0^4*x1*x2*x3^6*x4-15*x0^4*x1*x2^2*x3^5*x4+25*x0^4*x1*x2^2*x3^6+12*x0^4*x1^2*x3^3*x4^3-48*x0^4*x1^2*x3^4*x4^2-15*x0^4*x1^2*x3^4*x4^3+40*x0^4*x1^2*x3^5*x4+25*x0^4*x1^2*x3^5*x4^2+18*x0^4*x1^2*x2*x3^3*x4^2-72*x0^4*x1^2*x2*x3^4*x4-15*x0^4*x1^2*x2*x3^4*x4^2+60*x0^4*x1^2*x2*x3^5+25*x0^4*x1^2*x2*x3^5*x4+30*x0^4*x1^2*x2^2*x3^4*x4-50*x0^4*x1^2*x2^2*x3^5-18*x0^4*x1^3*x3^2*x4^3+72*x0^4*x1^3*x3^3*x4^2+30*x0^4*x1^3*x3^3*x4^3-60*x0^4*x1^3*x3^4*x4-50*x0^4*x1^3*x3^4*x4^2-12*x0^4*x1^3*x2*x3^2*x4^2+48*x0^4*x1^3*x2*x3^3*x4-40*x0^4*x1^3*x2*x3^4-30*x0^4*x1^3*x2^2*x3^3*x4+50*x0^4*x1^3*x2^2*x3^4+12*x0^4*x1^4*x3*x4^3-48*x0^4*x1^4*x3^2*x4^2-30*x0^4*x1^4*x3^2*x4^3+40*x0^4*x1^4*x3^3*x4+50*x0^4*x1^4*x3^3*x4^2+3*x0^4*x1^4*x2*x3*x4^2-12*x0^4*x1^4*x2*x3^2*x4+15*x0^4*x1^4*x2*x3^2*x4^2+10*x0^4*x1^4*x2*x3^3-25*x0^4*x1^4*x2*x3^3*x4+15*x0^4*x1^4*x2^2*x3^2*x4-25*x0^4*x1^4*x2^2*x3^3-3*x0^4*x1^5*x4^3+12*x0^4*x1^5*x3*x4^2+15*x0^4*x1^5*x3*x4^3-10*x0^4*x1^5*x3^2*x4-25*x0^4*x1^5*x3^2*x4^2-12*x0^4*x1^5*x2*x3*x4^2+20*x0^4*x1^5*x2*x3^2*x4-3*x0^4*x1^5*x2^2*x3*x4+5*x0^4*x1^5*x2^2*x3^2-3*x0^4*x1^6*x4^3+5*x0^4*x1^6*x3*x4^2+3*x0^4*x1^6*x2*x4^2-5*x0^4*x1^6*x2*x3*x4+3*x0^5*x2*x3^5*x4-5*x0^5*x2*x3^6-x0^5*x2*x3^6*x4+x0^5*x2^2*x3^6-3*x0^5*x1*x3^4*x4^2+5*x0^5*x1*x3^5*x4+x0^5*x1*x3^5*x4^2-12*x0^5*x1*x2*x3^4*x4+20*x0^5*x1*x2*x3^5+4*x0^5*x1*x2*x3^5*x4-5*x0^5*x1*x2^2*x3^5+12*x0^5*x1^2*x3^3*x4^2-20*x0^5*x1^2*x3^4*x4-5*x0^5*x1^2*x3^4*x4^2+18*x0^5*x1^2*x2*x3^3*x4-30*x0^5*x1^2*x2*x3^4-5*x0^5*x1^2*x2*x3^4*x4+10*x0^5*x1^2*x2^2*x3^4-18*x0^5*x1^3*x3^2*x4^2+30*x0^5*x1^3*x3^3*x4+10*x0^5*x1^3*x3^3*x4^2-12*x0^5*x1^3*x2*x3^2*x4+20*x0^5*x1^3*x2*x3^3-10*x0^5*x1^3*x2^2*x3^3+12*x0^5*x1^4*x3*x4^2-20*x0^5*x1^4*x3^2*x4-10*x0^5*x1^4*x3^2*x4^2+3*x0^5*x1^4*x2*x3*x4-5*x0^5*x1^4*x2*x3^2+5*x0^5*x1^4*x2*x3^2*x4+5*x0^5*x1^4*x2^2*x3^2-3*x0^5*x1^5*x4^2+5*x0^5*x1^5*x3*x4+5*x0^5*x1^5*x3*x4^2-4*x0^5*x1^5*x2*x3*x4-x0^5*x1^5*x2^2*x3-x0^5*x1^6*x4^2+x0^5*x1^6*x2*x4+x0^6*x2*x3^5-x0^6*x1*x3^4*x4-4*x0^6*x1*x2*x3^4+4*x0^6*x1^2*x3^3*x4+6*x0^6*x1^2*x2*x3^3-6*x0^6*x1^3*x3^2*x4-4*x0^6*x1^3*x2*x3^2+4*x0^6*x1^4*x3*x4+x0^6*x1^4*x2*x3-x0^6*x1^5*x4}"
#endif
//					"Z/9851Z[x0,x1,x2]"
//					"{-x2+2*x2^2-x2^3+x1+9848*x1*x2+2*x1*x2^2+x1^2-x1^2*x2-x0+3*x0*x2+9849*x0*x2^2+9849*x0*x1+2*x0*x1*x2+x0^2-x0^2*x2,"
//					"x2+9849*x2^2+x2^3+x1*x2-x1*x2^2+x0+9849*x0*x2+x0*x2^2}"

//					"Z/9851Z[x0,x2]"
//					"{8644+9315*x2+1200*x2^2+8445*x2^3+7996*x0+2194*x0*x2+1415*x0*x2^2-x0*x2^3+994*x0^2+7048*x0^2*x2+9848*x0^2*x2^2+4227*x0^3+9848*x0^3*x2-x0^4,"
//					"1319+206*x2+4218*x2^2+x2^3+206*x0+8436*x0*x2+3*x0*x2^2+4218*x0^2+3*x0^2*x2+x0^3}"
//					"{3700*x1+9598*x1^2-x1^3+6025*x0+505*x0*x1+3*x0*x1^2+9599*x0^2+9848*x0^2*x1+x0^3,"
//					"9228+1627*x1+9473*x1^2-x1^3+8224*x0+756*x0*x1+3*x0*x1^2+9473*x0^2+9848*x0^2*x1+x0^3}"
					).parsePolynomialSetWithRing();
			A.mark(LexicographicTermOrder());
			debug<<homogeneitySpace(A);
			debug<<NonMonomialPolynomialGCDForZModP(A);
			A.pop_front();
			debug<<homogeneitySpace(A);
		}
		else
		if(0)
		{
			PolynomialSet p=StringParser("{1+a+b+ab,1+a+bb+abb}").parsePolynomialSet(r);

			debug<<p<<"\n";

			debug<<NonMonomialPolynomialGCDForZModP(p);
		}
		else if(1)
		{
			debug<<"A1\n";
			PolynomialRing r=StringParser("Q[a,b]").parsePolynomialRing();
			Polynomial p=StringParser("1+a+3b+2abb").parsePolynomial(r);
			Polynomial q=StringParser("2a+b+2aab").parsePolynomial(r);
			Polynomial a=StringParser("1/2+2/2a+3/2b+4/2ab").parsePolynomial(r);
			PolynomialSet A(r);
			A.push_back(p*a);
			A.push_back(q*a);
			debug<<A<<"\n";

			debug<<NonMonomialPolynomialGCDForZ(A);

		}
		else
		{
			Polynomial p=StringParser("1+a+3b+2abb").parsePolynomial(r);
			Polynomial q=StringParser("2a+b+2aab").parsePolynomial(r);
			Polynomial a=StringParser("1+2a+3b+4ab").parsePolynomial(r);
//			Polynomial p=StringParser("1+3b").parsePolynomial(r);
//			Polynomial q=StringParser("3a+b").parsePolynomial(r);
//			Polynomial a=StringParser("1+a+b").parsePolynomial(r);
			PolynomialSet A(r);
			A.push_back(p*a);
			A.push_back(q*a);
			debug<<A<<"\n";

			debug<<NonMonomialPolynomialGCDForZModP(A);

		}
#endif
		return 0;
	}

  void lpRationalFunctionTest()
  {
    //int n=3;
	//     IntegerVectorList L=StringParser("{(1,0,2),(1,2,0)}").parseIntegerVectorList();
    //  IntegerVectorList L=StringParser("{(1,2,0)}").parseIntegerVectorList();

    //     int n=4;
    //  IntegerVectorList L=StringParser("{(1,0,2,3),(1,2,3,0)}").parseIntegerVectorList();

    /*     int n=16;
     IntegerVectorList L=StringParser("{(1,0,2,3,5,4,6,7,9,8,10,11,13,12,14,15),"
				      "(3,0,1,2,7,4,5,6,11,8,9,10,15,12,13,14),"
				      "(0,4,8,12,1,5,9,13,2,6,10,14,3,7,11,15)}").parseIntegerVectorList();
    */
    int n=9;
     IntegerVectorList L=StringParser("{(1,0,2,4,3,5,7,6,8),"
				      "(1,2,0,4,5,3,7,8,6),"
				      "(3,4,5,0,1,2,6,7,8),"
				      "(3,4,5,6,7,8,0,1,2)"
				      "}").parseIntegerVectorList();
     /*
    int n=9;
     IntegerVectorList L=StringParser("{(1,0,2,4,3,5,7,6,8),"
				      "(1,2,0,4,5,3,7,8,6),"
				      "(0,3,6,1,4,7,2,5,8)}").parseIntegerVectorList();
     */

    SymmetryGroup s(n);
    s.computeClosure(L);

    FieldRationalFunctions F(Q,"t");
    FieldMatrix M(F,s.elements.size(),n);
    int I=0;
    for(SymmetryGroup::ElementContainer::const_iterator i=s.elements.begin();i!=s.elements.end();i++,I++)
      {
	for(int j=0;j<n;j++)
	  {
	    M[I][j]=M[I][j]+F.exponent(j);
	    M[I][j]=M[I][j]-F.exponent(((SymmetryGroup::inverse(*i))[j]));
	  }
      }
    AsciiPrinter P(Stderr);
    //    M.printMatrix(P);


    FieldMatrix M2(Q,M.getHeight(),M.getWidth());
    for(int i=0;i<M.getHeight();i++)
      for(int j=0;j<M.getWidth();j++)
	M2[i][j]=F.substitute(M[i][j],Q.zHomomorphism(10000).inverse());

        Field &myField=F;
	{
      M=M2;
      myField=Q;//HERE
      }
    IntegerVectorList extreme;

    M.printMatrix(P);


    I=0;
    FieldElement minusOne=myField.zHomomorphism(-1);//HERE
    for(SymmetryGroup::ElementContainer::const_iterator i=s.elements.begin();i!=s.elements.end();i++,I++)
      //    for(int i=0;i<s.elements.size();i++)
      {
	fprintf(Stderr,"IIII:%i\n",I);
	M[I]=minusOne*M[I];
	FieldVector b(myField,s.elements.size());//HERE
	b[I]=minusOne;
	FieldLP lp(M,b);
	FieldLP lp2=lp.withNoLineality();

	AsciiPrinter P(Stderr);
	//lp2.print(P);

	//	cerr <<"Result" << lp2.findFeasibleBasis()<<endl;

	if(lp2.findFeasibleBasis())
	  extreme.push_back(*i);

	M[I]=minusOne*M[I];
      }
    fprintf(Stdout,"Extreme permutations (%i):\n",(int)extreme.size());
    P.printVectorList(extreme);
  }


  class TestCase
  {
  public:
	  string folder;
	  TestCase(string const &folder_):
		  folder(folder_)
		  {

		  }
	  void fail()
	  {
		  cerr<<"Test failed:"<<folder<<endl;
		  assert(0);
	  }
	  bool compare(string a, string b)
	  {
		  FILE *A=fopen(a.c_str(),"r");
		  FILE *B=fopen(b.c_str(),"r");
		  assert(A);
		  assert(B);
		  while((!feof(A))&&(!feof(B)))
		  {
			  if(fgetc(A)!=fgetc(B))return false;
		  }
		  if(feof(A)!=feof(B))return false;
		  return true;
	  }
	  bool fileExists(string name)
	  {
		  FILE *f=fopen(name.c_str(),"r");
		  if(f)fclose(f);
		  return f;
	  }
	  void replaceStrings(char *dest, char *s, const char* exe, const char *examplePath)
	  {
		  while(*s)
		  {
			  if(*s=='%')			  {
				  if(s[1]=='s')
				  {
					  strcpy(dest,exe);dest+=strlen(exe);
				  }
				  else if(s[1]=='p')
				  {
					  strcpy(dest,examplePath);dest+=strlen(examplePath);
				  }
				  else
					  assert(0);
				  s+=2;			  }
			  else
				  *(dest++)=*(s++);
		  }
		  dest[0]=0;
	  }
	  /*
	   * Returns true if test was successful.
	   * Returns false if test was performed for the first time.
	   * Returns false if test fails // old:Asserts if test fails
	   */
	  bool perform(const char *exe)
	  {
		  string fileName=folder+"/command";
		  FILE *f=fopen(fileName.c_str(),"r");
		  if(!f)
		  {
			  cerr<<"Could not open file:\""<<fileName<<"\""<<endl;
			  assert(f);
		  }
		  char command[4096];
		  char *temp=fgets(command,4095,f);
		  fclose(f);
		  assert(temp);
		  for(int i=0;i<4096 && command[i];i++)if(command[i]=='\n'){command[i]=0;}
		  char command2[4096];
		  string input=folder+"/input";
//		  sprintf(command2,command,exe,exe,exe,exe);
		  replaceStrings(command2,command,exe,folder.c_str());
		  bool outputExists=fileExists(folder+"/output");
		  string outputName=folder+"/output";
		  if(outputExists)
		  {
			  outputName=outputName+"New";
		  }
		  int err=0;
		  {
			  string t="rm "+outputName;
			  /*err|=*/system(t.c_str());
		  }
		  string command3="cat <"+input+"|"+string(command2)+">"+outputName;
		  cerr<<"Running command:\""<<command3<<"\""<<endl;
		  err|=system(command3.c_str());
		  //assert(err==0);
		  if(err)return false;
		  if(outputExists)
			  outputExists=compare(folder+"/output",folder+"/outputNew");
		  return outputExists;
	  }
  };

  list<string> subFolderNames()
  {
#define tempName "GfAnTeMpTeStS"
	  char command[256];
	  int err=system("rm " tempName);
	  err=0;//Having err!=0 above is probably not at mistake. Rather the file did not exist.
	  sprintf(command,"ls %s>" tempName ,testSuiteFolderOption.getValue());
	  err|=system(command);
	  assert(err==0);

	  list<string> ret;
	  FILE *f=fopen(tempName,"r");
	  assert(f);
	  char name[256];
	  while(fgets(name,255,f))
	  {
		  for(int i=0;i<255 && name[i];i++)if(name[i]=='\n'){name[i]=0;}
		  if(name[0]>='0' && name[0]<='9')ret.push_back(string(testSuiteFolderOption.getValue())+"/"+string(name));
	  }
	  fclose(f);
	  return ret;
  }

  int main()
  {
//    lpRationalFunctionTest();
//    testRationalFunctionField();
//	  packedTest();return 0;
//	  return testIntegers();
//	  return testGCD();
//	  return testGfanLib();
//	  return testPolynomialGCD();
//	  return testLLL();

	  list<string> testFolders=subFolderNames();
	  list<TestCase> testList;
	  for(list<string>::const_iterator i=testFolders.begin();i!=testFolders.end();i++)
	  {
		  testList.push_back(TestCase(*i));
	  }

	  cout<<"Number of tests to perform "<<testList.size()<<endl;

	  list<string> failed;

	  int good=0;
	  int bad=0;
	  for(list<TestCase>::iterator i=testList.begin();i!=testList.end();i++)
		  if(i->perform(executableOption.getValue()))
			  good++;
		  else
		  {
			  bad++;
			  failed.push_back(i->folder);
		  }
	  cout<<"\n";
	  if(!failed.empty())
	  {
		  cout<<"Failed tests:\n-------------\n";
		  for(list<string>::iterator i=failed.begin();i!=failed.end();i++)
		  {
			  cout<<*i<<" FAILED!\n";
		  }
	  }

	  cout<<"Number of succesful tests "<<good<<endl;
	  cout<<"Number of failed tests "<<bad<<endl;

	  return 0;
  }
};

static TestApplication theApplication;
