package aQute.lib.bundle.support;

import java.io.*;
import java.lang.reflect.*;
import java.util.*;

import org.osgi.framework.*;
import org.osgi.service.log.*;

public class Activator implements BundleActivator, Runnable {
	Dictionary				headers;
	ThreadGroup				root;
	Thread					thread;
	static BundleContext	context;

	public void start(BundleContext c) throws Exception {
		context = c;
		headers = context.getBundle().getHeaders();
		String pubs = (String) headers.get("j2b-published");
		if (pubs != null)
			new Publisher();

		String mainclass = (String) headers.get("J2B-Main-Class");
		if (mainclass != null && mainclass.length() > 2) {
			root = new ThreadGroup((String) headers.get(Constants.BUNDLE_NAME));
			thread = new Thread(root, this, headers.get(Constants.BUNDLE_NAME)
					+ "-main");
			thread.start();
		}
	}

	public void run() {
		try {
			String mainclass = (String) headers.get("J2B-Main-Class");
			String cmdline = (String) headers.get("J2B-Command-Line");
			String name = (String) headers.get("Bundle-Name");
			String std = (String) headers.get("J2B-Stdio");

			if (name == null)
				name = "Untitled";

			setConsole(std, name);

			Class clazz = Class.forName(mainclass);
			String cmd[];
			if (cmdline != null)
				cmd = parse(cmdline);
			else
				cmd = new String[0];

			Method m = clazz.getMethod("main", new Class[]{cmd.getClass()});
			m.invoke(null, new Object[]{cmd});
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void stop(BundleContext context) throws Exception {
		if (root != null)
			root.stop();
	}

	void setConsole(String std, String name) {
		if (std == null || std.equals("LOG")) {
			XSystem.out = new PrintStream(new LogStream(context,
					LogService.LOG_INFO), true);
			XSystem.in = System.in;
			XSystem.err = new PrintStream(new LogStream(context,
					LogService.LOG_ERROR), true);
			System.out.println("Using log");
		} else if (std.equals("CONSOLE")) {
			XSystem.out = System.out;
			XSystem.err = System.err;
			XSystem.in = System.in;
			System.out.println("Using console");
		}
	}

	String[] parse(String s) {
		StringTokenizer st = new StringTokenizer(s, " \r\n\t");
		Vector tokens = new Vector();

		while (st.hasMoreTokens()) {
			String token = st.nextToken();

			if (token.startsWith("$(") && token.endsWith(")")) {
				String replacement = variable(token.substring(2,
						token.length() - 3));
				if (replacement != null)
					tokens.addElement(replacement);
			} else
				tokens.addElement(token);
		}
		String result[] = new String[tokens.size()];
		tokens.copyInto(result);
		return result;
	}

	String variable(String name) {
		return null;
	}

}

