/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;

public class RemoteFileManager {
    private Wagon m_wagon;
    private WagonManager m_wagonManager;
    private ArtifactRepository m_artifactRepository;
    private Settings m_settings;
    private Log m_log;

    public RemoteFileManager(ArtifactRepository ar, WagonManager wm, Settings settings, Log log) {
        this.m_artifactRepository = ar;
        this.m_wagonManager = wm;
        this.m_settings = settings;
        this.m_log = log;
        this.m_wagon = null;
    }

    public void disconnect() {
        if (this.m_wagon == null) {
            this.m_log.error((CharSequence)"must be connected first!");
            return;
        }
        try {
            this.m_wagon.disconnect();
        }
        catch (ConnectionException e) {
            this.m_log.error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
        }
    }

    public void connect() throws MojoExecutionException {
        String url = this.m_artifactRepository.getUrl();
        String id = this.m_artifactRepository.getId();
        Repository repository = new Repository(id, url);
        try {
            this.m_wagon = this.m_wagonManager.getWagon(repository);
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoExecutionException("Unsupported protocol: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        catch (WagonConfigurationException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        try {
            Debug debug = new Debug();
            this.m_wagon.addTransferListener((TransferListener)debug);
            ProxyInfo proxyInfo = RemoteFileManager.getProxyInfo(this.m_settings);
            if (proxyInfo != null) {
                this.m_wagon.connect(repository, this.m_wagonManager.getAuthenticationInfo(id), proxyInfo);
            } else {
                this.m_wagon.connect(repository, this.m_wagonManager.getAuthenticationInfo(id));
            }
        }
        catch (ConnectionException e) {
            throw new MojoExecutionException("Error uploading file", (Exception)((Object)e));
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException("Error uploading file", (Exception)((Object)e));
        }
    }

    public File get(String url) throws IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (this.m_wagon == null) {
            this.m_log.error((CharSequence)"must be connected first!");
            return null;
        }
        File file = File.createTempFile(String.valueOf(System.currentTimeMillis()), "tmp");
        this.m_wagon.get(url, file);
        return file;
    }

    public void put(File file, String url) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (this.m_wagon == null) {
            this.m_log.error((CharSequence)"must be connected first!");
            return;
        }
        this.m_wagon.put(file, url);
    }

    public static ProxyInfo getProxyInfo(Settings settings) {
        ProxyInfo proxyInfo = null;
        if (settings != null && settings.getActiveProxy() != null) {
            Proxy settingsProxy = settings.getActiveProxy();
            proxyInfo = new ProxyInfo();
            proxyInfo.setHost(settingsProxy.getHost());
            proxyInfo.setType(settingsProxy.getProtocol());
            proxyInfo.setPort(settingsProxy.getPort());
            proxyInfo.setNonProxyHosts(settingsProxy.getNonProxyHosts());
            proxyInfo.setUserName(settingsProxy.getUsername());
            proxyInfo.setPassword(settingsProxy.getPassword());
        }
        return proxyInfo;
    }

    public boolean isLockedFile(RemoteFileManager remote, String fileName) throws MojoFailureException {
        File file = null;
        try {
            file = remote.get(fileName + ".lock");
        }
        catch (TransferFailedException e) {
            e.printStackTrace();
            throw new MojoFailureException("TransferFailedException");
        }
        catch (ResourceDoesNotExistException e) {
            return false;
        }
        catch (AuthorizationException e) {
            e.printStackTrace();
            throw new MojoFailureException("AuthorizationException");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoFailureException("IOException");
        }
        return file == null || file.length() != 0L;
    }
}

