/*
 * Decompiled with CFR 0.152.
 */
package nl.fuji.log;

import java.lang.reflect.Method;
import java.util.Vector;
import nl.fuji.log.LogEntry;
import nl.fuji.ni.outgoing.ApplicationSender;
import org.apache.commons.logging.Log;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.ThrowsAdvice;

public class Logger
implements Log,
MethodBeforeAdvice,
ThrowsAdvice,
AfterReturningAdvice {
    private String TRACE = "T";
    private String DEBUG = "D";
    private String INFO = "I";
    private String WARN = "W";
    private String ERROR = "E";
    private String FATAL = "F";
    private String ORDER = String.valueOf(this.TRACE) + this.DEBUG + this.INFO + this.WARN + this.ERROR + this.FATAL;
    private String threshold = this.WARN;
    private ApplicationSender sender;
    private Log delegate;
    private ThreadLocal<Vector<LogEntry>> messages = new ThreadLocal<Vector<LogEntry>>(){

        @Override
        protected Vector<LogEntry> initialValue() {
            return new Vector<LogEntry>();
        }
    };
    private String ident = "log";
    private String aroundMethod;

    private Vector<LogEntry> getMessages() {
        return this.messages.get();
    }

    private void init() {
        this.getMessages().clear();
    }

    private void add(String level, Object object, Throwable thr) {
        if (this.ORDER.indexOf(this.threshold) <= this.ORDER.indexOf(level)) {
            String reason = null;
            if (thr != null) {
                reason = thr.toString();
            }
            LogEntry entry = new LogEntry(object, level, reason);
            this.getMessages().add(entry);
        }
    }

    private void exit() {
        if (this.getMessages().size() > 0) {
            this.sender.send(this.ident, this.getMessages());
            this.messages.remove();
        }
    }

    private boolean check(Method method) {
        return this.aroundMethod == null || method.getName().equals(this.aroundMethod);
    }

    public void afterReturning(Object obj, Method method, Object[] parameters, Object target) throws Throwable {
        if (this.check(method)) {
            this.exit();
        }
    }

    public void before(Method method, Object[] parameters, Object target) throws Throwable {
        if (this.check(method)) {
            this.init();
        }
    }

    public void afterThrowing(Method method, Object[] args, Object target, Exception exc) {
        if (this.check(method)) {
            this.add(this.FATAL, "fatal error occurred", exc);
            this.exit();
        }
    }

    public void debug(Object obj, Throwable thr) {
        this.delegate.debug(obj, thr);
        this.add(this.DEBUG, obj, thr);
    }

    public void debug(Object obj) {
        this.delegate.debug(obj);
        this.add(this.DEBUG, obj, null);
    }

    public void error(Object obj, Throwable thr) {
        this.delegate.error(obj, thr);
        this.add(this.ERROR, obj, thr);
    }

    public void error(Object obj) {
        this.delegate.error(obj);
        this.add(this.ERROR, obj, null);
    }

    public void fatal(Object obj, Throwable thr) {
        this.delegate.fatal(obj, thr);
        this.add(this.FATAL, obj, thr);
    }

    public void fatal(Object obj) {
        this.delegate.fatal(obj);
        this.add(this.FATAL, obj, null);
    }

    public void info(Object obj, Throwable thr) {
        this.delegate.info(obj, thr);
        this.add(this.INFO, obj, thr);
    }

    public void info(Object obj) {
        this.delegate.info(obj);
        this.add(this.INFO, obj, null);
    }

    public void trace(Object obj, Throwable thr) {
        this.delegate.trace(obj, thr);
        this.add(this.TRACE, obj, thr);
    }

    public void trace(Object obj) {
        this.delegate.trace(obj);
        this.add(this.TRACE, obj, null);
    }

    public void warn(Object obj, Throwable thr) {
        this.delegate.warn(obj, thr);
        this.add(this.WARN, obj, thr);
    }

    public void warn(Object obj) {
        this.delegate.warn(obj);
        this.add(this.WARN, obj, null);
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.delegate.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public void setAroundMethod(String aroundMethod) {
        this.aroundMethod = aroundMethod;
    }

    public void setDelegate(Log delegate) {
        this.delegate = delegate;
    }

    public void setIdent(String ident) {
        this.ident = ident;
    }

    public void setSender(ApplicationSender sender) {
        this.sender = sender;
    }

    public void setThreshold(String threshold) {
        this.threshold = threshold;
    }
}

