/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.util.ArrayList;
import org.apache.felix.log.Log;
import org.apache.felix.log.LogEntryImpl;
import org.apache.felix.log.LoggerAdminImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerConsumer;

public class LoggerImpl
implements Logger {
    private static final String ESCAPE = "\\";
    private static final String MAX_CHAR = "\uffff";
    private static final String BRACE_CLOSE = "}";
    private static final String BRACE_OPEN = "{";
    protected final String m_name;
    protected final Bundle m_bundle;
    protected final Log m_log;
    protected final LoggerAdminImpl m_loggerAdmin;

    public LoggerImpl(String name, Bundle bundle, Log log, LoggerAdminImpl loggerAdmin) {
        this.m_name = name;
        this.m_bundle = bundle;
        this.m_log = log;
        this.m_loggerAdmin = loggerAdmin;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.m_loggerAdmin.getLoggerContext(this.m_bundle, this.m_name).getEffectiveLogLevel(this.m_name).implies(LogLevel.TRACE);
    }

    void trace(String message, ServiceReference<?> serviceReference, Throwable t) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.m_log.log(this.m_name, this.m_bundle, serviceReference, LogLevel.TRACE, message, t);
    }

    @Override
    public void trace(String message) {
        this.trace(message, null, null);
    }

    @Override
    public void trace(String format, Object arg) {
        LogParameters logParameters = this.getLogParameters(arg);
        this.trace(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        LogParameters logParameters = this.getLogParameters(arg1, arg2);
        this.trace(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        LogParameters logParameters = this.getLogParameters(arguments);
        this.trace(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
        if (this.isTraceEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.m_loggerAdmin.getLoggerContext(this.m_bundle, this.m_name).getEffectiveLogLevel(this.m_name).implies(LogLevel.DEBUG);
    }

    void debug(String message, ServiceReference<?> serviceReference, Throwable t) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.m_log.log(this.m_name, this.m_bundle, serviceReference, LogLevel.DEBUG, message, t);
    }

    @Override
    public void debug(String message) {
        this.debug(message, null, null);
    }

    @Override
    public void debug(String format, Object arg) {
        LogParameters logParameters = this.getLogParameters(arg);
        this.debug(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        LogParameters logParameters = this.getLogParameters(arg1, arg2);
        this.debug(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        LogParameters logParameters = this.getLogParameters(arguments);
        this.debug(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
        if (this.isDebugEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_loggerAdmin.getLoggerContext(this.m_bundle, this.m_name).getEffectiveLogLevel(this.m_name).implies(LogLevel.INFO);
    }

    void info(String message, ServiceReference<?> serviceReference, Throwable t) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.m_log.log(this.m_name, this.m_bundle, serviceReference, LogLevel.INFO, message, t);
    }

    @Override
    public void info(String message) {
        this.info(message, null, null);
    }

    @Override
    public void info(String format, Object arg) {
        LogParameters logParameters = this.getLogParameters(arg);
        this.info(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        LogParameters logParameters = this.getLogParameters(arg1, arg2);
        this.info(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void info(String format, Object ... arguments) {
        LogParameters logParameters = this.getLogParameters(arguments);
        this.info(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
        if (this.isInfoEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_loggerAdmin.getLoggerContext(this.m_bundle, this.m_name).getEffectiveLogLevel(this.m_name).implies(LogLevel.WARN);
    }

    void warn(String message, ServiceReference<?> serviceReference, Throwable t) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.m_log.log(this.m_name, this.m_bundle, serviceReference, LogLevel.WARN, message, t);
    }

    @Override
    public void warn(String message) {
        this.warn(message, null, null);
    }

    @Override
    public void warn(String format, Object arg) {
        LogParameters logParameters = this.getLogParameters(arg);
        this.warn(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        LogParameters logParameters = this.getLogParameters(arg1, arg2);
        this.warn(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        LogParameters logParameters = this.getLogParameters(arguments);
        this.warn(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
        if (this.isWarnEnabled()) {
            consumer.accept(this);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_loggerAdmin.getLoggerContext(this.m_bundle, this.m_name).getEffectiveLogLevel(this.m_name).implies(LogLevel.ERROR);
    }

    void error(String message, ServiceReference<?> serviceReference, Throwable t) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.m_log.log(this.m_name, this.m_bundle, serviceReference, LogLevel.ERROR, message, t);
    }

    @Override
    public void error(String message) {
        this.error(message, null, null);
    }

    @Override
    public void error(String format, Object arg) {
        LogParameters logParameters = this.getLogParameters(arg);
        this.error(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        LogParameters logParameters = this.getLogParameters(arg1, arg2);
        this.error(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void error(String format, Object ... arguments) {
        LogParameters logParameters = this.getLogParameters(arguments);
        this.error(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
        if (this.isErrorEnabled()) {
            consumer.accept(this);
        }
    }

    public void audit(String message, ServiceReference<?> serviceReference, Throwable t) {
        this.m_log.log(this.m_name, this.m_bundle, serviceReference, LogLevel.AUDIT, message, t);
    }

    @Override
    public void audit(String message) {
        this.audit(message, null, null);
    }

    @Override
    public void audit(String format, Object arg) {
        LogParameters logParameters = this.getLogParameters(arg);
        this.audit(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void audit(String format, Object arg1, Object arg2) {
        LogParameters logParameters = this.getLogParameters(arg1, arg2);
        this.audit(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    @Override
    public void audit(String format, Object ... arguments) {
        LogParameters logParameters = this.getLogParameters(arguments);
        this.audit(this.format(format, logParameters), logParameters.sr, logParameters.t);
    }

    public void log(int level, String message, ServiceReference<?> sr, Throwable exception) {
        this.m_log.addEntry(new LogEntryImpl(this.m_name, this.m_bundle, sr, level, message, exception, Log.getStackTraceElement()));
    }

    LogParameters getLogParameters(Object arg) {
        return this.getLogParameters0(arg);
    }

    LogParameters getLogParameters(Object arg1, Object arg2) {
        return this.getLogParameters0(arg1, arg2);
    }

    LogParameters getLogParameters(Object ... arguments) {
        return this.getLogParameters0(arguments);
    }

    LogParameters getLogParameters0(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return new LogParameters(null, null, null);
        }
        ServiceReference sr = null;
        Throwable t = null;
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object arg : arguments) {
            if (t == null && arg instanceof Throwable) {
                t = (Throwable)arg;
                continue;
            }
            if (sr == null && arg instanceof ServiceReference) {
                sr = (ServiceReference)arg;
                continue;
            }
            if (arg == null) continue;
            args.add(arg);
        }
        return new LogParameters(args.toArray(), sr, t);
    }

    String format(String format, LogParameters logParameters) {
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        int length = format.length();
        String previous = MAX_CHAR;
        boolean escape = false;
        int argIndex = 0;
        while (offset < length) {
            int curChar = format.codePointAt(offset);
            offset += Character.charCount(curChar);
            String cur = new String(Character.toChars(curChar));
            if (argIndex == logParameters.args.length) {
                sb.append(cur);
                continue;
            }
            if (escape) {
                escape = false;
                sb.append(cur);
                previous = MAX_CHAR;
                continue;
            }
            if (ESCAPE.equals(cur)) {
                escape = true;
                previous = ESCAPE;
                continue;
            }
            if (BRACE_OPEN.equals(cur)) {
                if (BRACE_OPEN.equals(previous)) {
                    sb.append(previous);
                }
                previous = BRACE_OPEN;
                continue;
            }
            if (BRACE_CLOSE.equals(cur) && BRACE_OPEN.equals(previous)) {
                sb.append(logParameters.args[argIndex++]);
                previous = MAX_CHAR;
                continue;
            }
            sb.append(cur);
            previous = MAX_CHAR;
        }
        return sb.toString();
    }

    static class LogParameters {
        final Object[] args;
        final ServiceReference<?> sr;
        final Throwable t;

        public LogParameters(Object[] args, ServiceReference<?> sr, Throwable t) {
            this.args = args;
            this.sr = sr;
            this.t = t;
        }
    }
}

