/*
 * Decompiled with CFR 0.152.
 */
package util.ui.customizableitems;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import tvbrowser.core.Settings;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;

public class SelectableItemRenderer<E>
implements ListCellRenderer<SelectableItem<E>> {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(SelectableItemRenderer.class);
    private int mSelectionWidth;
    private boolean mIsEnabled = true;
    private HashMap<Class<?>, SelectableItemRendererCenterComponentIf<E>> mCenterComponentMap = new HashMap();
    private JScrollPane mParentScrollPane;

    public JPanel getListCellComponent(JList<? extends SelectableItem<E>> list, SelectableItem<E> value, int index, boolean isSelected, boolean cellHasFocus) {
        SelectableItem<E> selectableItem = value;
        JCheckBox cb = new JCheckBox("", selectableItem.isSelected());
        JPanel p = new JPanel((LayoutManager)new FormLayout("default,1dlu,default:grow", "default"));
        try {
            p.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.mSelectionWidth = cb.getPreferredSize().width + 2 + p.getInsets().left;
            p.add((Component)cb, CC.xy((int)1, (int)1));
            SelectableItemRendererCenterComponentIf<E> renderIf = this.mCenterComponentMap.get(selectableItem.getItem().getClass());
            if (renderIf == null) {
                renderIf = this.mCenterComponentMap.get(selectableItem.getItem().getClass().getSuperclass());
            }
            if (renderIf != null) {
                cb.setVerticalAlignment(1);
                cb.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 0, 0), cb.getBorder()));
                p.add((Component)renderIf.createCenterPanel(list, selectableItem.getItem(), index, isSelected, this.mIsEnabled, this.mParentScrollPane, this.mSelectionWidth + 2), CC.xy((int)3, (int)1));
                renderIf.calculateSize(list, index, p);
            } else if (selectableItem.getItem() instanceof Channel) {
                JLabel l = new JLabel();
                if (Settings.IconAndNames.SHOW_NAMES_IN_CHANNEL_LIST.getBoolean()) {
                    l.setText(selectableItem.getItem().toString());
                }
                if (!this.mIsEnabled) {
                    l.setEnabled(false);
                }
                l.setOpaque(false);
                if (Settings.IconAndNames.SHOW_ICONS_IN_CHANNEL_LIST.getBoolean()) {
                    l.setIcon(UiUtilities.createChannelIcon(((Channel)selectableItem.getItem()).getIcon()));
                }
                p.add((Component)l, CC.xy((int)3, (int)1));
                if (isSelected && this.mIsEnabled) {
                    l.setForeground(list.getSelectionForeground());
                } else {
                    l.setForeground(list.getForeground());
                }
            } else if (selectableItem.getItem() instanceof String && selectableItem.getItem().equals("\n")) {
                cb.setText(LOCALIZER.msg("lineFeed", "Line feed"));
            } else {
                cb.setText(selectableItem.getItem().toString());
            }
            if (isSelected && this.mIsEnabled) {
                p.setOpaque(true);
                p.setBackground(list.getSelectionBackground());
                cb.setForeground(list.getSelectionForeground());
                cb.setBackground(list.getSelectionBackground());
            } else {
                p.setOpaque(false);
                p.setForeground(list.getForeground());
                cb.setForeground(list.getForeground());
                cb.setBackground(list.getBackground());
            }
            cb.setEnabled(list.isEnabled() && selectableItem.isSelectable());
            if (cb.isEnabled()) {
                cb.setSelected(value.isSelected());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return p;
    }

    public void setEnabled(boolean value) {
        this.mIsEnabled = value;
    }

    public int getSelectionWidth() {
        return this.mSelectionWidth;
    }

    public void setCenterRendererComponent(Class<?> clazz, SelectableItemRendererCenterComponentIf<E> component) {
        this.mCenterComponentMap.put(clazz, component);
        component.initialize();
    }

    protected void setScrollPane(JScrollPane parentScrollPane) {
        this.mParentScrollPane = parentScrollPane;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends SelectableItem<E>> list, SelectableItem<E> value, int index, boolean isSelected, boolean cellHasFocus) {
        return this.getListCellComponent(list, value, index, isSelected, cellHasFocus);
    }
}

