/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.layout.FormLayout;
import devplugin.Plugin;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.GlobalPluginProgramFormatingSettings;
import tvbrowser.ui.settings.SettingsDialog;
import util.i18n.Localizer;
import util.program.AbstractPluginProgramFormating;
import util.program.LocalPluginProgramFormating;
import util.ui.EnhancedPanelBuilder;
import util.ui.LocalPluginProgramFormatingSettingsDialog;
import util.ui.OrderChooser;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class PluginProgramConfigurationPanel
extends JPanel
implements ActionListener {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(PluginProgramConfigurationPanel.class);
    private OrderChooser<AbstractPluginProgramFormating> mOrder;
    private JButton mAdd;
    private JButton mEdit;
    private JButton mDelete;
    private LocalPluginProgramFormating mDefaultLocalFormating;
    private boolean mShowTitleSetting;
    private boolean mShowEncodingSetting;
    private JEditorPane mHelpLabel;

    public PluginProgramConfigurationPanel(AbstractPluginProgramFormating[] selectedValues, LocalPluginProgramFormating[] availableLocalFormatings, LocalPluginProgramFormating defaultLocalFormating, boolean showTitleSetting, boolean showEncodingSetting) {
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,default:grow,5dlu"), (JPanel)this);
        this.mDefaultLocalFormating = defaultLocalFormating == null ? new LocalPluginProgramFormating("Plugin - Default", "{title}", "{channel_name} - {title}\n{leadingZero(start_day,\"2\")}.{leadingZero(start_month,\"2\")}.{start_year} {leadingZero(start_hour,\"2\")}:{leadingZero(start_minute,\"2\")}-{leadingZero(end_hour,\"2\")}:{leadingZero(end_minute,\"2\")}\n\n{splitAt(short_info,\"78\")}\n\n", "UTF-8") : defaultLocalFormating;
        this.mShowTitleSetting = showTitleSetting;
        this.mShowEncodingSetting = showEncodingSetting;
        AbstractPluginProgramFormating[] availableGlobalFormatings = Plugin.getPluginManager().getAvailableGlobalPuginProgramFormatings();
        if (availableLocalFormatings == null) {
            availableLocalFormatings = new LocalPluginProgramFormating[]{this.mDefaultLocalFormating};
        }
        ArrayList<AbstractPluginProgramFormating> formatingsList = new ArrayList<AbstractPluginProgramFormating>();
        for (AbstractPluginProgramFormating abstractPluginProgramFormating : availableGlobalFormatings) {
            if (abstractPluginProgramFormating == null) continue;
            formatingsList.add(abstractPluginProgramFormating);
        }
        for (AbstractPluginProgramFormating abstractPluginProgramFormating : availableLocalFormatings) {
            if (abstractPluginProgramFormating == null) continue;
            formatingsList.add(abstractPluginProgramFormating);
        }
        AbstractPluginProgramFormating[] allArr = formatingsList.toArray(new AbstractPluginProgramFormating[formatingsList.size()]);
        EnhancedPanelBuilder buttonPanel = new EnhancedPanelBuilder(new FormLayout("default,5dlu,default,5dlu,default", "default"));
        buttonPanel.getLayout().setColumnGroups((int[][])new int[][]{{1, 3, 5}});
        this.mAdd = new JButton(Localizer.getLocalization("i18n_add"));
        this.mAdd.setIcon(TVBrowserIcons.newIcon(16));
        this.mAdd.addActionListener(this);
        this.mEdit = new JButton(Localizer.getLocalization("i18n_edit"));
        this.mEdit.setIcon(TVBrowserIcons.edit(16));
        this.mEdit.setEnabled(false);
        this.mEdit.addActionListener(this);
        this.mDelete = new JButton(Localizer.getLocalization("i18n_delete"));
        this.mDelete.setIcon(TVBrowserIcons.delete(16));
        this.mDelete.setEnabled(false);
        this.mDelete.addActionListener(this);
        buttonPanel.add(this.mAdd, 1);
        buttonPanel.add(this.mEdit, 3);
        buttonPanel.add(this.mDelete, 5);
        this.mOrder = new OrderChooser<AbstractPluginProgramFormating>(selectedValues == null ? allArr : selectedValues, allArr);
        this.mOrder.setSelectionMode(0);
        this.mOrder.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.mEdit.setEnabled(this.mOrder.getSelectedValue() instanceof LocalPluginProgramFormating);
                this.mDelete.setEnabled(this.mOrder.getSelectedValue() instanceof LocalPluginProgramFormating);
            }
        });
        this.mOrder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() >= 2 && PluginProgramConfigurationPanel.this.mOrder.getSelectedValue() instanceof LocalPluginProgramFormating) {
                    LocalPluginProgramFormatingSettingsDialog.createInstance(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), (LocalPluginProgramFormating)PluginProgramConfigurationPanel.this.mOrder.getSelectedValue(), PluginProgramConfigurationPanel.this.mDefaultLocalFormating, PluginProgramConfigurationPanel.this.mShowTitleSetting, PluginProgramConfigurationPanel.this.mShowEncodingSetting);
                    PluginProgramConfigurationPanel.this.mOrder.refreshList();
                }
            }
        });
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "This list contains formattings that are provided by the plugin itself and formating available for all plugins. You can configure formatings, that are provided by the plugin itself, direct here. The formatings that are available for all plugins can be configured in <a href=\"#link\">{0}</a>.", GlobalPluginProgramFormatingSettings.LOCALIZER.msg("title", "Plugin program formating")), e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                SettingsDialog.getInstance().showSettingsTab("#pluginprogramformat");
            }
        });
        pb.addLabelRow(false, LOCALIZER.msg("title", "Formatings that should be shown for selection in the context menu:"), 2);
        pb.addRow("fill:default:grow", false, this.mOrder, 2);
        pb.addRow(buttonPanel.getPanel(), 2);
        pb.addRow("10dlu,pref", (Component)this.mHelpLabel, 2);
    }

    public AbstractPluginProgramFormating[] getSelectedPluginProgramFormatings() {
        List<AbstractPluginProgramFormating> list = this.mOrder.getOrderList();
        AbstractPluginProgramFormating[] configs = new AbstractPluginProgramFormating[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            configs[i] = list.get(i);
        }
        return configs;
    }

    public LocalPluginProgramFormating[] getAvailableLocalPluginProgramFormatings() {
        List<AbstractPluginProgramFormating> listOrder = this.mOrder.getOrderList();
        ArrayList<LocalPluginProgramFormating> list = new ArrayList<LocalPluginProgramFormating>();
        for (AbstractPluginProgramFormating value : listOrder) {
            if (!(value instanceof LocalPluginProgramFormating)) continue;
            list.add((LocalPluginProgramFormating)value);
        }
        return list.toArray(new LocalPluginProgramFormating[list.size()]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mAdd) {
            LocalPluginProgramFormating newFormatting = new LocalPluginProgramFormating(LOCALIZER.msg("newName", "New formatting"), this.mDefaultLocalFormating.getTitleValue(), this.mDefaultLocalFormating.getContentValue(), this.mDefaultLocalFormating.getEncodingValue());
            this.mOrder.addElement(newFormatting);
            this.mOrder.setSelectedIndex(this.mOrder.getItemCount() - 1);
            LocalPluginProgramFormatingSettingsDialog.createInstance(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), (LocalPluginProgramFormating)this.mOrder.getSelectedValue(), this.mDefaultLocalFormating, this.mShowTitleSetting, this.mShowEncodingSetting);
            this.mOrder.refreshList();
        } else if (e.getSource() == this.mDelete) {
            int index = this.mOrder.getSelectedIndex();
            this.mOrder.removeElementAt(index);
            this.mOrder.setSelectedIndex(index);
        } else if (e.getSource() == this.mEdit) {
            LocalPluginProgramFormatingSettingsDialog.createInstance(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), (LocalPluginProgramFormating)this.mOrder.getSelectedValue(), this.mDefaultLocalFormating, this.mShowTitleSetting, this.mShowEncodingSetting);
            this.mOrder.refreshList();
        }
    }
}

