/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter
implements FilenameFilter {
    private String[] mExtensionList;
    private String mName;

    public ExtensionFileFilter(String extension, String name) {
        this(new String[]{extension}, name);
    }

    public ExtensionFileFilter(String[] extenstionList, String name) {
        for (int i = 0; i < extenstionList.length; ++i) {
            extenstionList[i] = extenstionList[i].toLowerCase();
        }
        this.mExtensionList = extenstionList;
        this.mName = name;
    }

    public String toString() {
        return this.mName;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName().toLowerCase();
        for (String element : this.mExtensionList) {
            if (!name.endsWith(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.mName;
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.accept(new File(dir.getPath() + File.separator + name));
    }

    public String getExtension() {
        return this.mExtensionList[0];
    }
}

