/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import java.util.HashSet;
import java.util.logging.Logger;
import util.settings.Property;
import util.settings.PropertyManager;

public class ChoiceProperty
extends Property {
    private static final Logger mLog = Logger.getLogger(ChoiceProperty.class.getName());
    private HashSet<String> mAllowedValueSet;
    private String mDefaultValue;
    private String mCachedValue;

    public ChoiceProperty(PropertyManager manager, String key, String defaultValue, String[] allowedValueArr) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mCachedValue = null;
        this.mAllowedValueSet = new HashSet(allowedValueArr.length);
        for (String element : allowedValueArr) {
            this.mAllowedValueSet.add(element);
        }
    }

    public String getDefault() {
        return this.mDefaultValue;
    }

    public String getString() {
        if (this.mCachedValue == null) {
            String asString = this.getProperty();
            if (asString == null) {
                this.mCachedValue = this.mDefaultValue;
            } else if (this.isAllowed(asString)) {
                this.mCachedValue = asString;
            } else {
                mLog.info("The setting '" + this.getKey() + "' is set to an illegal value (" + asString + "). Using the default instead (" + this.mDefaultValue + ")...");
                this.mCachedValue = this.mDefaultValue;
            }
        }
        return this.mCachedValue;
    }

    public void setString(String value) {
        if (value == null) {
            throw new IllegalArgumentException("You can't set a null value");
        }
        if (!this.isAllowed(value)) {
            throw new IllegalArgumentException("The value '" + value + "' is not allowed");
        }
        if (value.equals(this.mDefaultValue)) {
            this.setProperty(null);
        } else {
            this.setProperty(value);
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }

    public boolean isAllowed(String value) {
        return this.mAllowedValueSet.contains(value);
    }
}

