/*
 * Decompiled with CFR 0.152.
 */
package util.misc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.davidashen.text.Hyphenator;
import net.davidashen.util.ErrorHandler;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import util.io.stream.InputStreamProcessor;
import util.io.stream.StreamUtilities;

public class TextLineBreakerStringWidth {
    private static final String HYPHEN_DICT_FILENAME = "hyphen/dehyphx.tex";
    private static final Logger mLog = Logger.getLogger(TextLineBreakerStringWidth.class.getName());
    public static final String ELLIPSIS = "\u2026";
    private int mCurrChar;
    private StringBuilder mCurrLineBuffer = new StringBuilder();
    private StringBuilder mCurrWordBuffer = new StringBuilder();
    private String mNextWord;
    private int mNextWordWidth;
    private int mSpaceWidth = 1;
    private int mMinusWidth = 1;
    private static Hyphenator hyphenator;
    private static boolean useHyphenator;

    public TextLineBreakerStringWidth() {
        if (Settings.ProgramPanel.HYPHENATION.getBoolean()) {
            this.initializeHyphenator();
        }
    }

    private void initializeHyphenator() {
        if (hyphenator != null) {
            return;
        }
        hyphenator = new Hyphenator();
        hyphenator.setErrorHandler(new ErrorHandler(){

            public void debug(String arg0, String arg1) {
            }

            public void error(String arg0) {
                mLog.severe(arg0);
            }

            public void exception(String arg0, Exception arg1) {
                mLog.severe(arg0);
            }

            public void info(String arg0) {
                mLog.info(arg0);
            }

            public boolean isDebugged(String arg0) {
                return false;
            }

            public void warning(String arg0) {
                mLog.warning(arg0);
            }
        });
        try {
            File dictionary = new File(HYPHEN_DICT_FILENAME);
            if (dictionary.exists()) {
                StreamUtilities.inputStream(HYPHEN_DICT_FILENAME, new InputStreamProcessor(){

                    @Override
                    public void process(InputStream input) throws IOException {
                        if (input != null) {
                            try {
                                hyphenator.loadTable(input);
                                useHyphenator = true;
                            }
                            catch (NullPointerException npe) {
                                npe.printStackTrace();
                            }
                        } else {
                            mLog.warning("Hyphenation stream could not be opened for file hyphen/dehyphx.tex");
                        }
                    }
                });
            } else {
                mLog.warning("Hyphenation dictionary not found at hyphen/dehyphx.tex");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSpaceWidth(int spaceWidth) {
        this.mSpaceWidth = spaceWidth;
    }

    public void setMinusWidth(int minusWidth) {
        this.mMinusWidth = minusWidth;
    }

    public String[] breakLines(Reader textReader, int width) throws IOException {
        return this.breakLines(textReader, width, Integer.MAX_VALUE);
    }

    public String[] breakLines(Reader textReader, int width, int maxLines) throws IOException {
        boolean allProcessed;
        if (width <= 0) {
            width = Settings.ProgramTable.COLUMN_WIDTH.getInt();
        }
        this.mNextWordWidth = -1;
        if (maxLines == -1) {
            maxLines = Integer.MAX_VALUE;
        }
        ArrayList<String> lineList = new ArrayList<String>();
        do {
            Object line = this.readNextLine(textReader, width);
            boolean bl = allProcessed = this.mCurrChar == -1 && this.mNextWordWidth == -1;
            if (lineList.size() + 1 == maxLines && !allProcessed && ((String)line).length() != 0) {
                line = this.getStringWidth((String)line + ELLIPSIS) > width ? ((String)line).substring(0, ((String)line).length() - 2) + ELLIPSIS : (String)line + ELLIPSIS;
            }
            lineList.add((String)line);
        } while (lineList.size() < maxLines && !allProcessed);
        int lastInx = lineList.size() - 1;
        String lastLine = (String)lineList.get(lastInx);
        if (StringUtils.isBlank((CharSequence)lastLine) || lineList.size() > maxLines) {
            lineList.remove(lastInx);
        }
        String[] lineArr = new String[lineList.size()];
        lineList.toArray(lineArr);
        return lineArr;
    }

    private String readNextLine(Reader textReader, int maxWidth) throws IOException {
        this.mCurrLineBuffer.setLength(0);
        int lineWidth = 0;
        do {
            if (this.mNextWordWidth == -1) {
                do {
                    this.mCurrChar = textReader.read();
                    if (!this.isEndOfLine(this.mCurrChar)) continue;
                    return this.mCurrLineBuffer.toString();
                } while (Character.isSpaceChar((char)this.mCurrChar));
                this.mNextWord = this.readNextWord(textReader);
                this.mNextWordWidth = this.getStringWidth(this.mNextWord);
            }
            int newLineWidth = lineWidth + this.mNextWordWidth;
            if (lineWidth != 0) {
                newLineWidth += this.mSpaceWidth;
            }
            int lineLength = this.mCurrLineBuffer.length();
            if (newLineWidth - this.mSpaceWidth > maxWidth) {
                if (lineWidth == 0 || maxWidth - lineWidth > 20) {
                    int breakPos = this.findBreakPos(this.mNextWord, maxWidth - lineWidth, lineWidth == 0);
                    if (breakPos <= 0) {
                        if (this.mCurrLineBuffer.length() > 0) {
                            return this.mCurrLineBuffer.toString();
                        }
                        breakPos = Math.min(2, this.mNextWordWidth);
                    }
                    String firstPart = this.mNextWord.substring(0, breakPos);
                    if (lineLength > 0 && (this.mCurrLineBuffer.charAt(lineLength - 1) != '-' || lineLength > 1 && this.mCurrLineBuffer.charAt(lineLength - 2) == ' ')) {
                        this.mCurrLineBuffer.append(' ');
                    }
                    this.mCurrLineBuffer.append(firstPart);
                    char lastChar = firstPart.charAt(firstPart.length() - 1);
                    if (Character.isLetterOrDigit(lastChar)) {
                        this.mCurrLineBuffer.append('-');
                    }
                    this.mNextWord = this.mNextWord.substring(breakPos);
                    this.mNextWordWidth = this.getStringWidth(this.mNextWord);
                    return this.mCurrLineBuffer.toString();
                }
                return this.mCurrLineBuffer.toString();
            }
            if (lineWidth != 0) {
                char lastChar = this.mCurrLineBuffer.charAt(lineLength - 1);
                if (lastChar != '/' && (lastChar != '-' || lineLength >= 2 && this.mCurrLineBuffer.charAt(lineLength - 2) == ' ')) {
                    this.mCurrLineBuffer.append(' ');
                }
                lineWidth += this.mSpaceWidth;
            }
            this.mCurrLineBuffer.append(this.mNextWord);
            lineWidth += this.mNextWordWidth;
            this.mNextWordWidth = -1;
        } while (!this.isEndOfLine(this.mCurrChar));
        return this.mCurrLineBuffer.toString();
    }

    private String readNextWord(Reader textReader) throws IOException {
        this.mCurrWordBuffer.setLength(0);
        do {
            this.mCurrWordBuffer.append((char)this.mCurrChar);
            this.mCurrChar = textReader.read();
        } while (!Character.isWhitespace((char)this.mCurrChar) && !this.isEndOfLine(this.mCurrChar) && this.mCurrChar != 47 && (this.mCurrChar != 45 || this.mCurrWordBuffer.length() < 2));
        if (this.mCurrChar == 47 || this.mCurrChar == 45) {
            this.mCurrWordBuffer.append((char)this.mCurrChar);
        }
        return this.mCurrWordBuffer.toString();
    }

    private int findBreakPos(String word, int maxWidth, boolean mustBreak) {
        maxWidth -= this.mMinusWidth;
        int left = 0;
        int right = word.length() - 1;
        while (left < right) {
            int middle = (left + right + 1) / 2;
            String subWord = word.substring(0, middle);
            int subWordWidth = this.getStringWidth(subWord);
            if (subWordWidth < maxWidth) {
                left = middle;
                continue;
            }
            right = middle - 1;
        }
        int lastFittingPos = left;
        for (int i = lastFittingPos - 1; i >= lastFittingPos / 2; --i) {
            char ch = word.charAt(i);
            if (Character.isLetterOrDigit(ch)) continue;
            return i + 1;
        }
        if (useHyphenator) {
            String hyphenated;
            int endCharacters = Character.isLetter(word.charAt(word.length() - 1)) ? 2 : 3;
            int startCharacters = 2;
            if (word.length() >= startCharacters + endCharacters && (hyphenated = hyphenator.hyphenate(word, endCharacters, startCharacters)) != null && hyphenated.length() > word.length()) {
                int characters = 0;
                int lastHyphen = 0;
                for (int i = 0; i < hyphenated.length(); ++i) {
                    if (hyphenated.charAt(i) != '\u00ad') {
                        if (++characters <= lastFittingPos) continue;
                        return lastHyphen;
                    }
                    lastHyphen = characters;
                }
            }
        }
        if (mustBreak) {
            return lastFittingPos;
        }
        return 0;
    }

    public int getStringWidth(String str) {
        return str.length();
    }

    private boolean isEndOfLine(int ch) {
        return ch == 10 || ch == -1;
    }

    public static void resetHyphenator() {
        hyphenator = null;
        useHyphenator = false;
    }

    static {
        useHyphenator = false;
    }
}

