/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.pluginview;

import devplugin.ActionMenu;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramItem;
import devplugin.ProgramReceiveTarget;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.ui.pluginview.Node;
import tvbrowser.ui.pluginview.PluginTreeModel;
import util.i18n.Localizer;
import util.ui.OverlayListener;

public class PluginTree
extends JTree
implements DragGestureListener,
DropTargetListener,
DragSourceListener {
    private Rectangle2D mCueLine = new Rectangle2D.Float();
    private Object mPlugin = null;
    private Thread mDropThread = null;
    private String mDragNode = null;
    private Point mCurrentPoint = null;
    private Rectangle2D mGhostRect = new Rectangle2D.Float();
    private BufferedImage mGhostImage;
    private BufferedImage mTreeImage;
    private boolean rejected = false;
    private static PluginTree mInstance;

    public PluginTree(TreeModel model) {
        super(model);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandPath(new TreePath(model.getRoot()));
        mInstance = this;
        InputMap inputMap = this.getInputMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(113, 0);
        inputMap.put(keyStroke, "none");
        new OverlayListener(this);
        new DragSource().createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, this);
    }

    public static PluginTree getInstance() {
        return mInstance;
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof Node) {
            Node node = (Node)value;
            Object o = node.getUserObject();
            if (o instanceof ProgramItem) {
                ProgramItem programItem = (ProgramItem)o;
                return node.getNodeFormatter().format(programItem);
            }
            if (o != null) {
                if (!leaf) {
                    int leafs = this.getLeafCount(node);
                    node.setLeafCount(leafs);
                    if (node.isShowLeafCount()) {
                        StringBuilder buf = new StringBuilder(o.toString());
                        if (leafs > 0) {
                            buf.append(" [").append(leafs).append(']');
                        }
                        return buf.toString();
                    }
                    return o.toString();
                }
                return o.toString();
            }
            return "null";
        }
        return value.toString();
    }

    private int getLeafCount(TreeNode node) {
        int count = 0;
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            if (child.isLeaf()) {
                ++count;
                continue;
            }
            count += this.getLeafCount(child);
        }
        return count;
    }

    public void expandAll(TreePath path) {
        this.expandPath(path);
        TreeModel model = this.getModel();
        if (path != null && model != null) {
            Object comp = path.getLastPathComponent();
            int cnt = model.getChildCount(comp);
            for (int i = 0; i < cnt; ++i) {
                Object node = model.getChild(comp, i);
                this.expandAll(path.pathByAddingChild(node));
            }
        }
    }

    public void collapseAll(TreePath path) {
        TreeModel model = this.getModel();
        if (path != null && model != null) {
            Object comp = path.getLastPathComponent();
            int cnt = model.getChildCount(comp);
            for (int i = 0; i < cnt; ++i) {
                Object node = model.getChild(comp, i);
                this.collapseAll(path.pathByAddingChild(node));
            }
            if (!path.getLastPathComponent().equals(model.getRoot())) {
                this.collapsePath(path);
            }
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        try {
            if (this.mDropThread != null && this.mDropThread.isAlive()) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                return;
            }
            PluginTree tree = (PluginTree)e.getComponent();
            if (tree.getLastSelectedPathComponent() == null) {
                return;
            }
            Node node = (Node)tree.getSelectionPath().getLastPathComponent();
            if (node.getType() != 0 && (node.getLeafCount() > 0 || node.isLeaf())) {
                ((PluginTreeModel)this.getModel()).setDisableUpdate(true);
                Vector<Program> vec = this.getLeafElements(node, new Vector<Program>());
                this.mDragNode = vec.size() == 1 ? vec.firstElement().getTitle() : (node.isLeaf() ? ((ProgramItem)node.getUserObject()).getProgram().getTitle() : vec.size() + " " + Localizer.getLocalization("i18n_programs"));
                JLabel lbl2 = new JLabel(this.mDragNode);
                lbl2.setForeground(Color.white);
                lbl2.setVisible(true);
                lbl2.setFont(this.getFont());
                Point ptDragOrigin = e.getDragOrigin();
                Point ptOffset = new Point();
                TreePath path = this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
                Point raPath = this.getPathBounds(path).getLocation();
                ptOffset.setLocation(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
                this.mGhostRect.setRect(ptOffset.x, ptOffset.y, lbl2.getPreferredSize().width, lbl2.getPreferredSize().height);
                lbl2.setSize(lbl2.getPreferredSize());
                this.mGhostImage = new BufferedImage(lbl2.getWidth(), lbl2.getHeight(), 3);
                this.mTreeImage = new BufferedImage(this.getWidth(), this.getHeight(), 3);
                Graphics2D g2t = this.mTreeImage.createGraphics();
                this.paint(g2t);
                g2t.dispose();
                Graphics2D g2 = this.mGhostImage.createGraphics();
                lbl2.paint(g2);
                g2.setComposite(AlphaComposite.getInstance(4, 0.5f));
                Color c1 = new Color(UIManager.getDefaults().getColor("Tree.selectionBackground").getRGB());
                c1 = c1.darker();
                g2.setPaint(new GradientPaint(0.0f, 0.0f, c1, this.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
                g2.fillRect(0, 0, this.getWidth(), this.mGhostImage.getHeight());
                g2.dispose();
                this.mCurrentPoint = e.getDragOrigin();
                e.startDrag(null, this.mGhostImage, new Point(15, 5), new TransferNode(), this);
            }
        }
        catch (Exception ee) {
            ((PluginTreeModel)this.getModel()).setDisableUpdate(false);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this.checkAndPaintTarget(e);
    }

    private void checkAndPaintTarget(DropTargetDragEvent e) {
        block37: {
            boolean reject = true;
            boolean changed = false;
            Object temp = null;
            try {
                DataFlavor[] flavors;
                block39: {
                    flavors = e.getCurrentDataFlavors();
                    if (flavors == null || flavors.length != 1) break block37;
                    try {
                        TreePath targetPath = ((PluginTree)((DropTarget)e.getSource()).getComponent()).getPathForLocation(e.getLocation().x, e.getLocation().y);
                        if (targetPath != null) {
                            Node target = (Node)targetPath.getLastPathComponent();
                            if (target.getProgramReceiveTarget() == null && targetPath.getPathCount() <= 2) {
                                target = (Node)targetPath.getPathComponent(1);
                            }
                            if (flavors[0].getHumanPresentableName().equals("NodeExport")) {
                                TreePath sourcePath = ((PluginTree)((DropTarget)e.getSource()).getComponent()).getSelectionPath();
                                PluginProxy[] plugin = (PluginProxy[])sourcePath.getPathComponent(1);
                                if (!(target.equals(plugin) || targetPath.isDescendant(sourcePath) || sourcePath.isDescendant(targetPath))) {
                                    if (target.equals(ReminderPlugin.getRootNode().getMutableTreeNode())) {
                                        e.acceptDrag(e.getDropAction());
                                        reject = false;
                                        temp = ReminderPlugin.getInstance();
                                        this.rejected = false;
                                    } else if (target.getProgramReceiveTarget() == null) {
                                        PluginProxy[] pluginAccessArray;
                                        for (PluginProxy pluginAccess : pluginAccessArray = PluginProxyManager.getInstance().getActivatedPlugins()) {
                                            if (pluginAccess.getRootNode() == null || !pluginAccess.getRootNode().getMutableTreeNode().equals(target)) continue;
                                            if (pluginAccess.canReceiveProgramsWithTarget()) {
                                                e.acceptDrag(e.getDropAction());
                                                reject = false;
                                                temp = pluginAccess;
                                                this.rejected = false;
                                                continue;
                                            }
                                            this.mPlugin = null;
                                            break;
                                        }
                                    } else if (!target.equals(sourcePath.getLastPathComponent())) {
                                        e.acceptDrag(e.getDropAction());
                                        this.rejected = false;
                                        reject = false;
                                        temp = target.getProgramReceiveTarget();
                                    } else {
                                        this.mPlugin = null;
                                    }
                                }
                            } else if (flavors[0].getHumanPresentableName().equals("Program") && targetPath.getPathCount() <= 2) {
                                if (FavoritesPlugin.getInstance().getRootNode().getMutableTreeNode().equals(target)) {
                                    e.acceptDrag(e.getDropAction());
                                    this.rejected = false;
                                    reject = false;
                                    temp = FavoritesPlugin.getInstance();
                                } else if (ReminderPlugin.getRootNode().getMutableTreeNode().equals(target)) {
                                    e.acceptDrag(e.getDropAction());
                                    this.rejected = false;
                                    reject = false;
                                    temp = ReminderPlugin.getInstance();
                                } else {
                                    PluginProxy[] pa;
                                    for (PluginProxy pluginAccess : pa = PluginProxyManager.getInstance().getActivatedPlugins()) {
                                        if (pluginAccess.getRootNode() == null || !pluginAccess.getRootNode().getMutableTreeNode().equals(target)) continue;
                                        if (this.getAction(pluginAccess.getContextMenuActions(Plugin.getPluginManager().getExampleProgram())) == null) {
                                            this.mPlugin = null;
                                            break;
                                        }
                                        e.acceptDrag(e.getDropAction());
                                        reject = false;
                                        this.rejected = false;
                                        temp = pluginAccess;
                                    }
                                }
                            }
                            if (!(reject || this.mPlugin != null && temp == this.mPlugin)) {
                                changed = true;
                                this.paintImmediately(this.mCueLine.getBounds());
                                this.mCueLine.setRect(((PluginTree)((DropTarget)e.getSource()).getComponent()).getPathBounds(targetPath));
                                Graphics2D g2 = (Graphics2D)this.getGraphics();
                                Color c = new Color(255, 0, 0, 40);
                                g2.setColor(c);
                                g2.fill(this.mCueLine);
                                this.mPlugin = temp;
                            }
                            break block39;
                        }
                        e.rejectDrag();
                    }
                    catch (Exception e2) {
                        e.rejectDrag();
                    }
                }
                if (reject && !this.rejected) {
                    e.rejectDrag();
                    this.paintImmediately(this.mCueLine.getBounds());
                    this.mPlugin = null;
                    this.rejected = true;
                }
                Point location = (Point)e.getLocation().clone();
                if (flavors[0].getHumanPresentableName().equals("NodeExport") && (this.mCurrentPoint.x != location.x || this.mCurrentPoint.y != location.y)) {
                    if (!DragSource.isDragImageSupported()) {
                        int height;
                        Graphics2D g2 = (Graphics2D)this.getGraphics();
                        Rectangle2D old = (Rectangle2D)this.mGhostRect.clone();
                        this.mGhostRect.setRect(location.x + 20, location.y, this.mGhostImage.getWidth(), this.mGhostImage.getHeight());
                        Rectangle2D target = (Rectangle2D)old.clone();
                        target.add(this.mGhostRect);
                        BufferedImage bf = new BufferedImage((int)target.getWidth(), (int)target.getHeight(), 3);
                        Graphics2D g2b = bf.createGraphics();
                        int width = (int)((double)this.mTreeImage.getWidth() - (target.getX() + target.getWidth())) > 0 ? (int)target.getWidth() : (int)((double)this.mTreeImage.getWidth() - target.getX());
                        int n = height = (int)((double)this.mTreeImage.getHeight() - (target.getY() + target.getHeight())) > 0 ? (int)target.getHeight() : (int)((double)this.mTreeImage.getHeight() - target.getY());
                        if (width > 0 && height > 0) {
                            g2b.drawImage((Image)this.mTreeImage.getSubimage((int)target.getX(), (int)target.getY(), width, height), 0, 0, null);
                        }
                        if (this.mCueLine.contains(location) && !reject) {
                            Rectangle2D temp1 = this.mCueLine.createIntersection(target);
                            double y = 0.0;
                            if (changed) {
                                y = this.mCueLine.getY() - target.getY();
                                changed = false;
                            }
                            temp1.setRect(0.0, y, temp1.getWidth(), temp1.getHeight());
                            Color c = new Color(255, 0, 0, 40);
                            g2b.setColor(c);
                            if (this.mCueLine.contains(this.mCueLine.createIntersection(target))) {
                                g2b.fill(temp1);
                            }
                        }
                        g2b.drawImage(this.mGhostImage, AffineTransform.getTranslateInstance(this.mGhostRect.getX() - target.getX(), this.mGhostRect.getY() - target.getY()), null);
                        g2b.dispose();
                        g2.drawImage(bf, AffineTransform.getTranslateInstance(target.getX(), target.getY()), null);
                    }
                    this.mCurrentPoint = location;
                }
            }
            catch (Exception flavors) {
                // empty catch block
            }
        }
        if (this.getVisibleRect().width < this.getSize().width || this.getVisibleRect().height < this.getSize().height) {
            int scroll = 20;
            if (e.getLocation().y + scroll + 5 > this.getVisibleRect().height) {
                this.scrollRectToVisible(new Rectangle(e.getLocation().x, e.getLocation().y + scroll + 5, 1, 1));
            }
            if (e.getLocation().y - scroll < this.getVisibleRect().y) {
                this.scrollRectToVisible(new Rectangle(e.getLocation().x, e.getLocation().y - scroll, 1, 1));
            }
            if (e.getLocation().x - scroll < this.getVisibleRect().x) {
                this.scrollRectToVisible(new Rectangle(e.getLocation().x - scroll, e.getLocation().y, 1, 1));
            }
            if (e.getLocation().x + scroll + 5 > this.getVisibleRect().width) {
                this.scrollRectToVisible(new Rectangle(e.getLocation().x + scroll + 5, e.getLocation().y, 1, 1));
            }
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        this.checkAndPaintTarget(e);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.paintImmediately(this.mCueLine.getBounds());
        this.paintImmediately(this.mGhostRect.getBounds());
        this.mPlugin = null;
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(e.getDropAction());
        final Transferable tr = e.getTransferable();
        final Object src = e.getSource();
        final Point loc = e.getLocation();
        final PluginTree tree = this;
        e.dropComplete(true);
        this.mDropThread = new Thread("Plugin view drop"){

            @Override
            public void run() {
                block22: {
                    tree.setCursor(Cursor.getPredefinedCursor(3));
                    DataFlavor[] flavors = null;
                    try {
                        flavors = tr.getTransferDataFlavors();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (flavors != null && flavors.length == 1) {
                        try {
                            TreePath targetPath = ((PluginTree)((DropTarget)src).getComponent()).getPathForLocation(loc.x, loc.y);
                            Node target = (Node)targetPath.getLastPathComponent();
                            if (target.getProgramReceiveTarget() == null && targetPath.getPathCount() <= 2) {
                                target = (Node)targetPath.getPathComponent(1);
                            }
                            if (flavors[0].getHumanPresentableName().equals("NodeExport")) {
                                Program[] p;
                                Vector<Object> vec;
                                TreePath sourcePath = ((PluginTree)((DropTarget)src).getComponent()).getSelectionPath();
                                Node plugin = (Node)sourcePath.getPathComponent(1);
                                Node source = (Node)sourcePath.getLastPathComponent();
                                if (target.equals(plugin) || targetPath.isDescendant(sourcePath) || sourcePath.isDescendant(targetPath)) {
                                    return;
                                }
                                if (source.isLeaf()) {
                                    vec = new Vector();
                                    if (source.getUserObject() instanceof ProgramItem) {
                                        vec.addElement(((ProgramItem)source.getUserObject()).getProgram());
                                    }
                                } else {
                                    vec = PluginTree.this.getLeafElements(source, new Vector<Program>());
                                }
                                if ((p = vec.toArray(new Program[vec.size()])).length <= 0) break block22;
                                if (target.equals(ReminderPlugin.getRootNode().getMutableTreeNode())) {
                                    ReminderPlugin.getInstance().addPrograms(p);
                                    break block22;
                                }
                                if (target.getProgramReceiveTarget() == null) {
                                    PluginProxy[] pa;
                                    for (PluginProxy pluginAccess : pa = PluginProxyManager.getInstance().getActivatedPlugins()) {
                                        if (pluginAccess.getRootNode() == null || !pluginAccess.getRootNode().getMutableTreeNode().equals(target)) continue;
                                        if (pluginAccess.canReceiveProgramsWithTarget() && pluginAccess.getProgramReceiveTargets() != null && pluginAccess.getProgramReceiveTargets().length > 0) {
                                            ProgramReceiveTarget receiveTarget = pluginAccess.getProgramReceiveTargets()[0];
                                            receiveTarget.receivePrograms(ProgramReceiveTarget.getEventTypeForSendingAction(PluginTree.this, receiveTarget), p);
                                            continue;
                                        }
                                        break block22;
                                    }
                                    break block22;
                                }
                                ProgramReceiveTarget receiveTarget = target.getProgramReceiveTarget();
                                receiveTarget.receivePrograms(ProgramReceiveTarget.getEventTypeForSendingAction(PluginTree.this, receiveTarget), p);
                                break block22;
                            }
                            if (flavors[0].getHumanPresentableName().equals("Program")) {
                                PluginProxy[] pa = PluginProxyManager.getInstance().getActivatedPlugins();
                                boolean found = false;
                                Program program = (Program)tr.getTransferData(flavors[0]);
                                for (PluginProxy pluginAccess : pa) {
                                    Action action;
                                    if (!pluginAccess.getRootNode().getMutableTreeNode().equals(target) || (action = PluginTree.this.getAction(pluginAccess.getContextMenuActions(program))) == null) continue;
                                    found = true;
                                    ActionEvent evt = new ActionEvent(program, 0, (String)action.getValue("ActionCommandKey"));
                                    action.actionPerformed(evt);
                                }
                                if (!found) {
                                    Action action = null;
                                    if (FavoritesPlugin.getInstance().getRootNode().getMutableTreeNode().equals(target)) {
                                        action = PluginTree.this.getAction(FavoritesPluginProxy.getInstance().getContextMenuActions(program));
                                    } else if (ReminderPlugin.getRootNode().getMutableTreeNode().equals(target)) {
                                        action = PluginTree.this.getAction(ReminderPluginProxy.getInstance().getContextMenuActions(program));
                                    }
                                    if (action != null) {
                                        found = true;
                                        ActionEvent evt = new ActionEvent(program, 0, (String)action.getValue("ActionCommandKey"));
                                        action.actionPerformed(evt);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                SwingUtilities.invokeLater(() -> {
                    PluginTree.this.paintImmediately(PluginTree.this.mCueLine.getBounds());
                    PluginTree.this.paintImmediately(PluginTree.this.mGhostRect.getBounds());
                });
                PluginTree.this.mPlugin = null;
                tree.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        this.mDropThread.setPriority(1);
        this.mDropThread.start();
    }

    private Action getAction(ActionMenu menu) {
        while (menu != null && menu.hasSubItems()) {
            ActionMenu[] subItems = menu.getSubItems();
            if (subItems.length > 0) {
                menu = subItems[0];
                continue;
            }
            menu = null;
        }
        if (menu == null) {
            this.mPlugin = null;
            return null;
        }
        return menu.getAction();
    }

    private Vector<Program> getLeafElements(Node node, Vector<Program> entries) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChildAt(i).isLeaf()) {
                Node childnode = (Node)node.getChildAt(i);
                if (!(childnode.getUserObject() instanceof ProgramItem) || entries.contains(((ProgramItem)childnode.getUserObject()).getProgram())) continue;
                entries.addElement(((ProgramItem)childnode.getUserObject()).getProgram());
                continue;
            }
            entries = this.getLeafElements((Node)node.getChildAt(i), entries);
        }
        return entries;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        ((PluginTreeModel)this.getModel()).setDisableUpdate(false);
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    private static class TransferNode
    implements Transferable {
        private DataFlavor mDF = new DataFlavor(TreePath.class, "NodeExport");

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] f = new DataFlavor[]{this.mDF};
            return f;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor e) {
            return e.equals(this.mDF);
        }

        @Override
        public Object getTransferData(DataFlavor e) throws UnsupportedFlavorException, IOException {
            return null;
        }
    }
}

