/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.ChannelDayProgram;
import devplugin.ChannelFilter;
import devplugin.Date;
import devplugin.FilterChangeListenerV2;
import devplugin.Plugin;
import devplugin.PluginCenterPanel;
import devplugin.PluginCenterPanelWrapper;
import devplugin.Program;
import devplugin.ProgramFilter;
import devplugin.ProgressMonitor;
import devplugin.TabListener;
import devplugin.Version;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TooManyListenersException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.htmlparser.util.Translate;
import tvbrowser.TVBrowser;
import tvbrowser.core.ChannelList;
import tvbrowser.core.DateListener;
import tvbrowser.core.DummyChannel;
import tvbrowser.core.JREUpdater;
import tvbrowser.core.PluginLoader;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.filters.ShowAllFilter;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.PluginStateListener;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.ui.DontShowAgainOptionBox;
import tvbrowser.ui.aboutbox.AboutBox;
import tvbrowser.ui.configassistant.ConfigAssistant;
import tvbrowser.ui.filter.dlgs.FilterComponentsDlg;
import tvbrowser.ui.filter.dlgs.SelectFilterDlg;
import tvbrowser.ui.finder.DateSelector;
import tvbrowser.ui.finder.FinderPanel;
import tvbrowser.ui.finder.calendar.CalendarPanel;
import tvbrowser.ui.finder.calendar.CalendarTablePanel;
import tvbrowser.ui.licensebox.LicenseBox;
import tvbrowser.ui.mainframe.ChannelChooserPanel;
import tvbrowser.ui.mainframe.DateChooserPanel;
import tvbrowser.ui.mainframe.DefaultMenuBar;
import tvbrowser.ui.mainframe.FaytFilter;
import tvbrowser.ui.mainframe.FaytPanel;
import tvbrowser.ui.mainframe.MenuBar;
import tvbrowser.ui.mainframe.PluginInformationDialog;
import tvbrowser.ui.mainframe.SoftwareUpdater;
import tvbrowser.ui.mainframe.StatusBar;
import tvbrowser.ui.mainframe.TimeChooserPanel;
import tvbrowser.ui.mainframe.UpdateDlg;
import tvbrowser.ui.mainframe.UserAwayDetector;
import tvbrowser.ui.mainframe.actions.TVBrowserAction;
import tvbrowser.ui.mainframe.actions.TVBrowserActions;
import tvbrowser.ui.mainframe.searchfield.SearchField;
import tvbrowser.ui.mainframe.searchfield.SearchFilter;
import tvbrowser.ui.mainframe.toolbar.ContextMenu;
import tvbrowser.ui.mainframe.toolbar.DefaultToolBarModel;
import tvbrowser.ui.mainframe.toolbar.MoreButton;
import tvbrowser.ui.mainframe.toolbar.ToolBar;
import tvbrowser.ui.pluginview.PluginTree;
import tvbrowser.ui.pluginview.PluginView;
import tvbrowser.ui.pluginview.PluginViewWrapper;
import tvbrowser.ui.programtable.ChannelPanel;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import tvbrowser.ui.programtable.FilterPanel;
import tvbrowser.ui.programtable.KeyboardAction;
import tvbrowser.ui.programtable.ProgramTable;
import tvbrowser.ui.programtable.ProgramTableScrollPane;
import tvbrowser.ui.programtable.ProgramTableScrollPaneWrapper;
import tvbrowser.ui.settings.BlockedPlugin;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.update.PluginAutoUpdater;
import tvbrowser.ui.update.SoftwareUpdateDlg;
import tvbrowser.ui.update.SoftwareUpdateItem;
import tvbrowser.ui.update.TvbrowserSoftwareUpdateItem;
import util.browserlauncher.Launch;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.io.NetworkUtilities;
import util.misc.OperatingSystem;
import util.settings.ContextMenuMouseActionSetting;
import util.ui.LabelButtonPanel;
import util.ui.ProgramPanel;
import util.ui.TVBrowserIcons;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.html.HTMLTextHelper;
import util.ui.persona.Persona;
import util.ui.persona.PersonaListener;
import util.ui.progress.Progress;
import util.ui.progress.ProgressWindow;
import util.ui.view.Node;

public class MainFrame
extends JFrame
implements DateListener,
DropTargetListener,
PersonaListener,
PluginStateListener,
FilterChangeListenerV2 {
    private static final Logger LOG = Logger.getLogger(TVBrowser.class.getName());
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(MainFrame.class);
    private static final int DIRECTION_LEFT = 1;
    private static final int DIRECTION_RIGHT = 2;
    private static final int COUNTDOWN_DATA_UPDATE_CLOSING_SECONDS = 300;
    private Node mTimebuttonsNode;
    private Node mDateNode;
    private Node mRootNode;
    private Node mChannelNode;
    private Node mPluginsNode;
    private JDialog mConfigAssistantDialog;
    private SoftwareUpdateItem[] mSoftwareUpdateItems = null;
    private ProgramTableScrollPane mProgramTableScrollPane;
    private DefaultProgramTableModel mProgramTableModel;
    private Thread mDownloadingThread;
    private JPanel jcontentPane;
    private DefaultToolBarModel mToolBarModel;
    private ToolBar mToolBar;
    private JPanel mToolBarPanel;
    private SearchField mSearchField;
    private StatusBar mStatusBar;
    private JPanel mTopPanel;
    private JPanel mSouthPanel;
    private DateSelector mFinderPanel;
    private static MainFrame mSingleton;
    private ChannelChooserPanel mChannelChooser;
    private MenuBar mMenuBar;
    private Component mCenterComponent;
    private boolean mIsVisible;
    private static boolean mShuttingDown;
    private static boolean mStarting;
    private Node mMainframeNode;
    private Node mNavigationNode;
    private Node mDateChannelNode;
    private Date mCurrentDay;
    private PluginView mPluginView;
    private int mXPos;
    private int mYPos;
    private int mWidth;
    private int mHeight;
    private FilterPanel mFilterPanel;
    private JPanel mRestartPanel = SettingsDialog.getRestartPanel();
    private LabelButtonPanel mVersionOldPanel;
    private TimeChooserPanel mTimeChooserPanel;
    private Point mStoredViewPosition;
    private String mCurrentFilterName;
    private int mLastTimerMinutesAfterMidnight;
    private static Date[] mChannelDateArr;
    private static int[] mOnAirRowProgramsArr;
    private boolean mSettingsWillBeOpened;
    private long mLastAutoUpdateRun;
    private long mLastAutoUpdateRunBuffer;
    private int mAutoDownloadTimer;
    private boolean mIsAskingUpdate = false;
    private Timer mTimer;
    private UserAwayDetector mAwayDetector = new UserAwayDetector();
    private KeyListener mGlobalFindAsYouTypeKeyListener;
    private FaytPanel mFindAsYouType;
    private JTabbedPane mCenterTabPane;
    private JPanel mCenterPanel;
    private ArrayList<PluginCenterPanelWrapper> mCenterPanelWrapperList = new ArrayList(0);
    private ProgramTableScrollPaneWrapper mScrollPaneWrapper;
    private TabbedPaneUI mPersonaUI;
    private TabbedPaneUI mDefaultUI;
    private PluginView mCenterPluginView;
    private PluginViewWrapper mPluginViewWrapper;
    private Component mSelectedTab;
    private Thread mTabChangeEventThread;
    private int mTabChangeEventCounter;

    private MainFrame() {
        super(TVBrowser.MAINWINDOW_TITLE, IOUtilities.getGraphicsConfigurationForFrame());
        MainFrame.println("POS 1");
        this.setContentPane(new BackgroundPanel());
        Persona.getInstance().registerPersonaListener(this);
        this.mFindAsYouType = new FaytPanel();
        this.mGlobalFindAsYouTypeKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (Settings.ProgramTable.FIND_AS_YOU_TYPE.getBoolean() && MainFrame.this.mProgramTableScrollPane != null && !MainFrame.this.mProgramTableScrollPane.getProgramTable().isSelected() && (e.getModifiersEx() & 0x200) != 512 && (e.getModifiersEx() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()) != Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() && (e.getModifiersEx() & 0x80) != 128 && (e.getModifiersEx() & 0x100) != 256) {
                    if (Character.isLetterOrDigit(e.getKeyChar()) || e.getKeyCode() == 32) {
                        MainFrame.this.mFindAsYouType.setText(String.valueOf(e.getKeyChar()));
                    } else if (MainFrame.this.mFindAsYouType.isVisible()) {
                        if (e.getKeyCode() == 8) {
                            MainFrame.this.mFindAsYouType.deleteLastChar();
                        } else if (e.getKeyCode() == 27) {
                            MainFrame.this.mFindAsYouType.closeFayt();
                        }
                    }
                }
            }
        };
        this.mIsVisible = false;
        this.mSettingsWillBeOpened = false;
        this.mAutoDownloadTimer = -1;
        this.mLastTimerMinutesAfterMidnight = -1;
        this.mLastAutoUpdateRun = System.currentTimeMillis();
        mChannelDateArr = null;
        mOnAirRowProgramsArr = null;
        this.mStatusBar = new StatusBar(this.mGlobalFindAsYouTypeKeyListener);
        this.mStatusBar.setOpaque(false);
        this.mStatusBar.getProgressBar().setOpaque(false);
        if (OperatingSystem.isMacOs()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            try {
                Class<?> impl = Class.forName("tvbrowser.ui.mainframe.macosx.MacOSXMenuBar");
                Class<?> mainFrameClass = this.getClass();
                Class<?> jlabelClass = Class.forName("javax.swing.JLabel");
                Constructor<?> cons = impl.getConstructor(mainFrameClass, jlabelClass);
                this.mMenuBar = (MenuBar)cons.newInstance(this, this.mStatusBar.getLabel());
            }
            catch (Exception e2) {
                if (TVBrowser.isTransportable()) {
                    LOG.info("Using default menu bar (instead of MacOSXMenuBar) for transportable version.");
                }
                LOG.warning("Could not instantiate MacOSXMenuBar\n" + e2.toString());
                if (e2.getCause() != null) {
                    StringWriter sw = new StringWriter();
                    e2.getCause().printStackTrace(new PrintWriter(sw));
                    LOG.warning(sw.toString());
                }
                this.mMenuBar = new DefaultMenuBar(this, this.mStatusBar.getLabel());
                this.mMenuBar.setVisible(Settings.Window.MENU_BAR_VISIBLE.getBoolean());
                LOG.info("Using default menu bar");
            }
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().setDefaultMenuBar(this.mMenuBar);
                Desktop.getDesktop().setAboutHandler(e -> this.showAboutBox());
                Desktop.getDesktop().setPreferencesHandler(p -> this.showSettingsDialog());
                Desktop.getDesktop().setQuitHandler((e, response) -> this.quit());
            }
        } else {
            this.mMenuBar = new DefaultMenuBar(this, this.mStatusBar.getLabel());
            this.mMenuBar.setVisible(Settings.Window.MENU_BAR_VISIBLE.getBoolean());
        }
        this.jcontentPane = (JPanel)this.getContentPane();
        this.jcontentPane.setLayout(new BorderLayout());
        JPanel skinPanel = new JPanel();
        skinPanel.addKeyListener(this.mGlobalFindAsYouTypeKeyListener);
        skinPanel.setOpaque(false);
        skinPanel.setLayout(new BorderLayout());
        MainFrame.println("POS 2");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.addKeyListener(this.mGlobalFindAsYouTypeKeyListener);
        centerPanel.setOpaque(false);
        centerPanel.setBorder(BorderFactory.createEmptyBorder());
        this.mCenterPanel = new JPanel(new BorderLayout());
        this.mCenterPanel.setOpaque(false);
        this.mCenterPanel.setBorder(BorderFactory.createEmptyBorder());
        centerPanel.add((Component)this.mCenterPanel, "Center");
        this.mFilterPanel = new FilterPanel(this.mGlobalFindAsYouTypeKeyListener);
        this.mFilterPanel.setVisible(false);
        this.addKeyListener(this.mGlobalFindAsYouTypeKeyListener);
        this.mTimeChooserPanel = new TimeChooserPanel(this, this.mGlobalFindAsYouTypeKeyListener);
        this.mRestartPanel = SettingsDialog.getRestartPanel();
        this.mRestartPanel.setBorder(Borders.createEmptyBorder((String)"2dlu,2dlu,2dlu,2dlu"));
        this.mRestartPanel.setVisible(Settings.isRestartNeeded());
        Settings.addRestartInfoListener(e -> {
            this.mRestartPanel.setVisible(Settings.isRestartNeeded());
            this.updateTopPanelVisibility();
        });
        this.mVersionOldPanel = new LabelButtonPanel(LOCALIZER.msg("oldVersion", "This version of TV-Browser is outdated."), null, LOCALIZER.msg("downloadNewVersion", "Go to download of TV-Browser {0}", Settings.General.VERSION_AVAILABLE.getVersion().toString()), () -> Launch.openURL("https://www.tvbrowser.org/index.php?id=tv-browser"), true);
        this.mVersionOldPanel.setBorder(Borders.createEmptyBorder((String)"2dlu,2dlu,2dlu,2dlu"));
        this.mVersionOldPanel.setVisible(Settings.General.VERSION_AVAILABLE.getVersion().isNewerThan(TVBrowser.VERSION));
        this.mTopPanel = new JPanel((LayoutManager)new FormLayout("100dlu:grow", "default,default,default"));
        this.mTopPanel.add((Component)this.mVersionOldPanel, CC.xy((int)1, (int)1));
        this.mTopPanel.add((Component)this.mRestartPanel, CC.xy((int)1, (int)2));
        this.mTopPanel.add((Component)this.mFilterPanel, CC.xy((int)1, (int)3));
        this.updateTopPanelVisibility();
        centerPanel.add((Component)this.mTopPanel, "North");
        Channel[] channelArr = ChannelList.getSubscribedChannels();
        int startOfDay = Settings.ProgramTable.START_OF_DAY.getInt();
        int endOfDay = Settings.ProgramTable.END_OF_DAY.getInt();
        this.mProgramTableModel = new DefaultProgramTableModel(channelArr, startOfDay, endOfDay);
        this.mProgramTableScrollPane = new ProgramTableScrollPane(this.mProgramTableModel, this.mGlobalFindAsYouTypeKeyListener);
        this.mCenterPluginView = new PluginView();
        this.mScrollPaneWrapper = new ProgramTableScrollPaneWrapper(this.mProgramTableScrollPane);
        this.mScrollPaneWrapper.setSettingsId("#programtablelook");
        this.mPluginViewWrapper = new PluginViewWrapper(this.mCenterPluginView);
        if (channelArr.length == 0) {
            this.mScrollPaneWrapper.showInfoPanel(1, null);
        }
        MainFrame.println("POS 3");
        ChangeListener tabChangeListener = new ChangeListener(){

            @Override
            public synchronized void stateChanged(ChangeEvent e) {
                MainFrame.this.mTabChangeEventCounter = 0;
                if (MainFrame.this.mTabChangeEventThread == null || !MainFrame.this.mTabChangeEventThread.isAlive()) {
                    MainFrame.this.mTabChangeEventThread = new Thread("TAB CHANGE EVENT WAITING THREAD"){

                        @Override
                        public void run() {
                            while (MainFrame.this.mTabChangeEventCounter++ < 20) {
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            Component focusOwner = MainFrame.this.getMostRecentFocusOwner();
                            SwingUtilities.invokeLater(() -> {
                                if (MainFrame.this.mSelectedTab != null) {
                                    ((TabListener)((Object)MainFrame.this.mSelectedTab)).tabHidden(focusOwner);
                                }
                                if (MainFrame.this.mCenterTabPane.getSelectedIndex() != -1) {
                                    MainFrame.this.mSelectedTab = MainFrame.this.mCenterTabPane.getComponent(MainFrame.this.mCenterTabPane.getSelectedIndex());
                                    if (MainFrame.this.mSelectedTab instanceof JPanel && !(MainFrame.this.mSelectedTab instanceof TabListener) && ((JPanel)MainFrame.this.mSelectedTab).getComponentCount() == 1) {
                                        MainFrame.this.mSelectedTab = ((JPanel)MainFrame.this.mSelectedTab).getComponent(0);
                                    }
                                    if (MainFrame.this.mSelectedTab instanceof TabListener) {
                                        ((TabListener)((Object)MainFrame.this.mSelectedTab)).tabShown();
                                    } else {
                                        MainFrame.this.mSelectedTab = null;
                                    }
                                } else {
                                    MainFrame.this.mSelectedTab = null;
                                }
                            });
                        }
                    };
                    MainFrame.this.mTabChangeEventThread.start();
                }
            }
        };
        this.mCenterTabPane = new JTabbedPane();
        this.mCenterTabPane.addChangeListener(tabChangeListener);
        this.mCenterTabPane.addMouseWheelListener(e -> {
            if (e.getWheelRotation() > 0) {
                this.scrollThroughTabs(2);
            } else {
                this.scrollThroughTabs(1);
            }
        });
        MainFrame.println("POS 4");
        this.mDefaultUI = this.mCenterTabPane.getUI();
        this.mPersonaUI = new BasicTabbedPaneUI(){

            @Override
            protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
                if (Persona.getInstance().getHeaderImage() != null && !Persona.getInstance().getShadowColor().equals(Persona.getInstance().getTextColor())) {
                    g.setColor(Persona.getInstance().getShadowColor());
                    g.drawString(title, textRect.x + 1, textRect.y + 1 + metrics.getAscent());
                    g.drawString(title, textRect.x + 2, textRect.y + 2 + metrics.getAscent());
                }
                super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            }

            @Override
            protected Insets getContentBorderInsets(int tabPlacement) {
                return new Insets(0, 0, 0, 0);
            }

            @Override
            protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
            }

            @Override
            protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
                if (Persona.getInstance().getAccentColor() != null && Persona.getInstance().getHeaderImage() != null) {
                    Color c = Persona.testPersonaForegroundAgainst(Persona.getInstance().getAccentColor());
                    int alpha = c.getAlpha();
                    g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
                    if (isSelected) {
                        g.fillRect(x, y, w, h - 2);
                    } else {
                        g.fillRect(x, y, w, h);
                    }
                } else {
                    super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
                }
            }
        };
        MainFrame.println("POS 5");
        KeyStroke stroke = KeyStroke.getKeyStroke(38, 128);
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(this.mCenterTabPane.getFocusTraversalKeys(2));
        forwardKeys.remove(stroke);
        this.mCenterTabPane.setFocusTraversalKeys(2, forwardKeys);
        InputMap im = this.mCenterTabPane.getInputMap(1);
        im.put(stroke, "scrollUp");
        this.mCenterTabPane.getActionMap().put("scrollUp", new KeyboardAction(this.mProgramTableScrollPane, 0));
        this.mCenterTabPane.setBorder(BorderFactory.createEmptyBorder());
        this.mCenterTabPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showContextMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showContextMenu(e);
                }
            }

            private void showContextMenu(MouseEvent e) {
                JMenuItem settings = new JMenuItem(LOCALIZER.msg("configTabs", "Configure tabs..."), TVBrowserIcons.preferences(16));
                settings.addActionListener(evt -> MainFrame.this.showSettingsDialog("#centerpanelsetup"));
                JPopupMenu popup = new JPopupMenu();
                popup.add(settings);
                try {
                    int index = MainFrame.this.mCenterTabPane.indexAtLocation(e.getX(), e.getY());
                    if (index >= 0) {
                        String[] ids = ((JComponent)MainFrame.this.mCenterTabPane.getComponentAt(index)).getName().split("&&&&");
                        if (Settings.CenterPanels.PLUGIN_FUNCTIONS_IN_MENU_SHOW.getBoolean() && ids[0] != null && !ids[0].equals("null")) {
                            JMenuItem item;
                            ActionMenu buttonAction;
                            PluginProxy plugin = PluginProxyManager.getInstance().getActivatedPluginForId(ids[0]);
                            ButtonActionIf buttonActionIf = null;
                            if (plugin != null) {
                                buttonActionIf = plugin;
                            } else {
                                InternalPluginProxyIf internal = InternalPluginProxyList.getInstance().getProxyForId(ids[0]);
                                if (internal != null && internal instanceof ButtonActionIf) {
                                    buttonActionIf = (ButtonActionIf)((Object)internal);
                                }
                            }
                            if (buttonActionIf != null && (buttonAction = buttonActionIf.getButtonAction()) != null && (item = MenuBar.createMenuItem(buttonAction, buttonActionIf, MainFrame.this.getStatusBarLabel())) != null) {
                                popup.addSeparator();
                                popup.add(item);
                            }
                        }
                        if (ids[1] != null && !ids[1].equals("null")) {
                            String name = "#programtablelook".equals(ids[1]) ? LOCALIZER.msg("configProgramTable", "Configure program table...") : LOCALIZER.msg("configPlugins", "Configure plugin...");
                            JMenuItem settingsPlugin = new JMenuItem(name);
                            settingsPlugin.addActionListener(evt -> MainFrame.this.showSettingsDialog(ids[1]));
                            if (popup.getComponentCount() == 1) {
                                popup.addSeparator();
                            }
                            popup.add(settingsPlugin);
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                popup.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            }
        });
        this.mProgramTableScrollPane.setOpaque(false);
        MainFrame.println("POS 6");
        this.createDateSelector();
        skinPanel.add((Component)centerPanel, "Center");
        this.mChannelChooser = new ChannelChooserPanel(this, this.mGlobalFindAsYouTypeKeyListener);
        this.mChannelChooser.setOpaque(false);
        this.mRootNode = new Node(null);
        if (Settings.LookAndFeel.PLUGIN_VIEW_IS_LEFT.getBoolean()) {
            this.mPluginsNode = new Node(this.mRootNode);
        } else {
            this.mNavigationNode = new Node(this.mRootNode);
        }
        this.mMainframeNode = new Node(this.mRootNode);
        Node programtableNode = new Node(this.mMainframeNode);
        if (Settings.LookAndFeel.PLUGIN_VIEW_IS_LEFT.getBoolean()) {
            this.mNavigationNode = new Node(this.mMainframeNode);
        } else {
            this.mPluginsNode = new Node(this.mMainframeNode);
        }
        this.mTimebuttonsNode = new Node(this.mNavigationNode);
        this.mDateChannelNode = new Node(this.mNavigationNode);
        this.mDateNode = new Node(this.mDateChannelNode);
        this.mChannelNode = new Node(this.mDateChannelNode);
        this.mRootNode.setProperty(Settings.Window.VIEW_ROOT);
        this.mMainframeNode.setProperty(Settings.Window.VIEW_MAIN_FRAME);
        this.mNavigationNode.setProperty(Settings.Window.VIEW_NAVIGATION);
        this.mDateChannelNode.setProperty(Settings.Window.VIEW_DATE_CHANNEL);
        MainFrame.println("POS 7");
        programtableNode.setLeaf(skinPanel);
        this.setShowPluginOverview(Settings.Window.PLUGIN_VIEW_SHOW.getBoolean());
        this.setShowTimeButtons(Settings.Window.TIME_BUTTONS_SHOW.getBoolean());
        this.setShowDatelist(Settings.Window.DATE_SELECTION_SHOW.getBoolean());
        this.setShowChannellist(Settings.Window.CHANNEL_SELECTION_SHOW.getBoolean());
        this.updateToolbar();
        this.dateChanged(new Date(), null, null, false);
        this.mCenterComponent = this.mRootNode.getComponent();
        if (this.mCenterComponent != null) {
            this.jcontentPane.add(this.mCenterComponent, "Center");
        }
        this.mSouthPanel = new JPanel(new BorderLayout());
        this.mSouthPanel.setOpaque(false);
        this.mSouthPanel.add((Component)this.mFindAsYouType, "North");
        this.mFindAsYouType.setVisible(false);
        if (Settings.Window.STATUS_BAR_VISIBLE.getBoolean()) {
            this.mSouthPanel.add((Component)this.mStatusBar, "South");
        }
        this.jcontentPane.add((Component)this.mSouthPanel, "South");
        this.setJMenuBar(this.mMenuBar);
        this.addContextMenuMouseListener(this.mMenuBar);
        this.mTimer = new Timer(10000, e -> this.handleTimerEvent());
        this.mTimer.start();
        this.setDefaultCloseOperation(0);
        DropTarget target = new DropTarget();
        try {
            target.addDropTargetListener(this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        this.setDropTarget(target);
        MainFrame.println("POS 9");
        this.updateCenterPanels();
        FilterManagerImpl.getInstance().registerFilterChangeListener(this);
        MainFrame.println("POS 10");
    }

    public void createDateSelector() {
        switch (Settings.LookAndFeel.VIEW_DATE_LAYOUT.getInt()) {
            case 1: {
                this.mFinderPanel = new CalendarTablePanel(this.mGlobalFindAsYouTypeKeyListener);
                break;
            }
            case 2: {
                this.mFinderPanel = new CalendarPanel(this.mGlobalFindAsYouTypeKeyListener);
                break;
            }
            default: {
                this.mFinderPanel = new FinderPanel(this.mGlobalFindAsYouTypeKeyListener);
            }
        }
        this.mFinderPanel.setDateListener(this);
    }

    public void switchFullscreenMode() {
        this.dispose();
        SwingUtilities.invokeLater(() -> {
            GraphicsDevice device = this.getGraphicsConfiguration().getDevice();
            if (this.isFullScreenMode()) {
                device.setFullScreenWindow(null);
                this.setUndecorated(false);
                this.setBounds(this.mXPos, this.mYPos, this.mWidth, this.mHeight);
                if (this.mMenuBar != null) {
                    this.mMenuBar.setFullscreenItemChecked(false);
                    this.mMenuBar.setVisible(Settings.Window.MENU_BAR_VISIBLE.getBoolean());
                }
                if (this.mToolBarPanel != null) {
                    this.mToolBarPanel.setVisible(Settings.ToolBar.IS_VISIBLE.getBoolean());
                }
                if (this.mStatusBar != null) {
                    this.mStatusBar.setVisible(Settings.Window.STATUS_BAR_VISIBLE.getBoolean());
                }
                if (this.mChannelChooser != null) {
                    this.mChannelChooser.setVisible(Settings.Window.CHANNEL_SELECTION_SHOW.getBoolean());
                }
                if (this.mFinderPanel != null) {
                    this.mFinderPanel.getComponent().setVisible(Settings.Window.DATE_SELECTION_SHOW.getBoolean());
                }
                this.setVisible(true);
                this.setShowPluginOverview(Settings.Window.PLUGIN_VIEW_SHOW.getBoolean(), false);
                this.setShowTimeButtons(Settings.Window.TIME_BUTTONS_SHOW.getBoolean(), false);
                this.setShowDatelist(Settings.Window.DATE_SELECTION_SHOW.getBoolean(), false);
                this.setShowChannellist(Settings.Window.CHANNEL_SELECTION_SHOW.getBoolean(), false);
            } else {
                this.mXPos = this.getX();
                this.mYPos = this.getY();
                this.mWidth = this.getWidth();
                this.mHeight = this.getHeight();
                this.setShowPluginOverview(false, false);
                this.setShowTimeButtons(false, false);
                this.setShowDatelist(false, false);
                this.setShowChannellist(false, false);
                if (this.mStatusBar != null) {
                    this.mMenuBar.setFullscreenItemChecked(true);
                    this.mStatusBar.setVisible(false);
                }
                if (this.mChannelChooser != null) {
                    this.mChannelChooser.setVisible(false);
                }
                if (this.mMenuBar != null) {
                    this.mMenuBar.setVisible(false);
                }
                if (this.mToolBarPanel != null) {
                    this.mToolBarPanel.setVisible(false);
                }
                if (this.mFinderPanel != null) {
                    this.mFinderPanel.getComponent().setVisible(false);
                }
                this.setUndecorated(true);
                final Rectangle screen = this.getGraphicsConfiguration().getBounds();
                if (device.isFullScreenSupported() && OperatingSystem.isMacOs()) {
                    device.setFullScreenWindow(MainFrame.getInstance());
                } else {
                    this.setLocation(screen.x, screen.y);
                    this.setSize(new Dimension(screen.width, screen.height));
                }
                this.setVisible(true);
                this.mProgramTableScrollPane.requestFocusInWindow();
                new Thread("Fullscreen border detection"){

                    @Override
                    public void run() {
                        this.setPriority(1);
                        while (MainFrame.this.isFullScreenMode()) {
                            Point p = MouseInfo.getPointerInfo().getLocation();
                            SwingUtilities.convertPointFromScreen(p, MainFrame.this);
                            if (MainFrame.this.isActive()) {
                                if (p.y <= 10) {
                                    if (MainFrame.this.mToolBarPanel != null && MainFrame.this.mToolBar.getToolbarLocation().compareTo("North") == 0 && !MainFrame.this.mToolBarPanel.isVisible()) {
                                        UIThreadRunner.invokeLater(() -> MainFrame.this.mToolBarPanel.setVisible(Settings.ToolBar.IS_VISIBLE.getBoolean()));
                                    }
                                    if (p.y <= 0) {
                                        UIThreadRunner.invokeLater(() -> MainFrame.this.mMenuBar.setVisible(Settings.Window.MENU_BAR_VISIBLE.getBoolean()));
                                    }
                                } else if (p.y > (MainFrame.this.mMenuBar != null && MainFrame.this.mMenuBar.isVisible() ? MainFrame.this.mMenuBar.getHeight() : 0) + (Settings.ToolBar.IS_VISIBLE.getBoolean() ? MainFrame.this.mToolBarPanel.getHeight() : 0)) {
                                    if (MainFrame.this.mMenuBar.isVisible()) {
                                        UIThreadRunner.invokeLater(() -> MainFrame.this.mMenuBar.setVisible(!MainFrame.this.isFullScreenMode() && Settings.Window.MENU_BAR_VISIBLE.getBoolean()));
                                    }
                                    if (MainFrame.this.mToolBarPanel != null && MainFrame.this.mToolBarPanel.isVisible() && MainFrame.this.mToolBar.getToolbarLocation().compareTo("North") == 0) {
                                        UIThreadRunner.invokeLater(() -> MainFrame.this.mToolBarPanel.setVisible(!MainFrame.this.isFullScreenMode()));
                                    }
                                }
                                if (p.y >= screen.height - 1) {
                                    if (MainFrame.this.mStatusBar != null && !MainFrame.this.mStatusBar.isVisible()) {
                                        UIThreadRunner.invokeLater(() -> MainFrame.this.mStatusBar.setVisible(Settings.Window.STATUS_BAR_VISIBLE.getBoolean()));
                                    }
                                } else if (MainFrame.this.mStatusBar != null && MainFrame.this.mStatusBar.isVisible() && p.y < screen.height - MainFrame.this.mStatusBar.getHeight()) {
                                    UIThreadRunner.invokeLater(() -> MainFrame.this.mStatusBar.setVisible(!MainFrame.this.isFullScreenMode()));
                                }
                                if (p.x <= 5) {
                                    if (p.x == 0 && MainFrame.this.mToolBarPanel != null && MainFrame.this.mToolBar.getToolbarLocation().compareTo("West") == 0 && !MainFrame.this.mToolBarPanel.isVisible()) {
                                        UIThreadRunner.invokeLater(() -> MainFrame.this.mToolBarPanel.setVisible(Settings.ToolBar.IS_VISIBLE.getBoolean()));
                                    }
                                    if (Settings.LookAndFeel.PLUGIN_VIEW_IS_LEFT.getBoolean()) {
                                        if (Settings.Window.PLUGIN_VIEW_SHOW.getBoolean()) {
                                            SwingUtilities.invokeLater(() -> MainFrame.this.setShowPluginOverview(true, false));
                                        }
                                    } else {
                                        MainFrame.this.checkIfToShowTimeDateChannelList();
                                    }
                                } else {
                                    int toolBarWidth;
                                    int n = toolBarWidth = MainFrame.this.mToolBarPanel != null && MainFrame.this.mToolBarPanel.isVisible() && MainFrame.this.mToolBar.getToolbarLocation().compareTo("West") == 0 ? MainFrame.this.mToolBarPanel.getWidth() : 0;
                                    if (p.x > toolBarWidth && toolBarWidth != 0) {
                                        UIThreadRunner.invokeLater(() -> MainFrame.this.mToolBarPanel.setVisible(!MainFrame.this.isFullScreenMode()));
                                    }
                                    if (Settings.LookAndFeel.PLUGIN_VIEW_IS_LEFT.getBoolean()) {
                                        if (Settings.Window.PLUGIN_VIEW_SHOW.getBoolean() && MainFrame.this.mPluginView != null && MainFrame.this.mPluginView.isVisible() && p.x > MainFrame.this.mPluginView.getWidth() + toolBarWidth + 25) {
                                            SwingUtilities.invokeLater(() -> MainFrame.this.setShowPluginOverview(!MainFrame.this.isFullScreenMode(), false));
                                        }
                                    } else if (Settings.Window.CHANNEL_SELECTION_SHOW.getBoolean() || Settings.Window.DATE_SELECTION_SHOW.getBoolean() || Settings.Window.TIME_BUTTONS_SHOW.getBoolean()) {
                                        SwingUtilities.invokeLater(() -> {
                                            if (MainFrame.this.mChannelChooser != null && MainFrame.this.mChannelChooser.isVisible() && p.x > MainFrame.this.mChannelChooser.getWidth()) {
                                                MainFrame.this.setShowChannellist(!MainFrame.this.isFullScreenMode(), false);
                                            }
                                            if (MainFrame.this.mFinderPanel != null && MainFrame.this.mFinderPanel.getComponent().isVisible() && p.x > MainFrame.this.mFinderPanel.getComponent().getWidth()) {
                                                MainFrame.this.setShowDatelist(!MainFrame.this.isFullScreenMode(), false);
                                            }
                                            if (MainFrame.this.mTimeChooserPanel != null && MainFrame.this.mTimeChooserPanel.isVisible() && p.x > MainFrame.this.mTimeChooserPanel.getWidth()) {
                                                MainFrame.this.setShowTimeButtons(!MainFrame.this.isFullScreenMode(), false);
                                            }
                                        });
                                    }
                                }
                                if (p.x >= screen.width - 1) {
                                    if (!Settings.LookAndFeel.PLUGIN_VIEW_IS_LEFT.getBoolean()) {
                                        if (Settings.Window.PLUGIN_VIEW_SHOW.getBoolean()) {
                                            SwingUtilities.invokeLater(() -> MainFrame.this.setShowPluginOverview(true, false));
                                        }
                                    } else {
                                        MainFrame.this.checkIfToShowTimeDateChannelList();
                                    }
                                } else if (!Settings.LookAndFeel.PLUGIN_VIEW_IS_LEFT.getBoolean()) {
                                    if (Settings.Window.PLUGIN_VIEW_SHOW.getBoolean() && MainFrame.this.mPluginView != null && MainFrame.this.mPluginView.isVisible() && p.x < screen.width - MainFrame.this.mPluginView.getWidth()) {
                                        SwingUtilities.invokeLater(() -> MainFrame.this.setShowPluginOverview(!MainFrame.this.isFullScreenMode(), false));
                                    }
                                } else if (Settings.Window.CHANNEL_SELECTION_SHOW.getBoolean() || Settings.Window.DATE_SELECTION_SHOW.getBoolean() || Settings.Window.TIME_BUTTONS_SHOW.getBoolean()) {
                                    SwingUtilities.invokeLater(() -> {
                                        if (MainFrame.this.mChannelChooser != null && MainFrame.this.mChannelChooser.isVisible() && p.x < screen2.width - MainFrame.this.mChannelChooser.getWidth()) {
                                            MainFrame.this.setShowChannellist(!MainFrame.this.isFullScreenMode(), false);
                                        }
                                        if (MainFrame.this.mFinderPanel != null && MainFrame.this.mFinderPanel.getComponent().isVisible() && p.x < screen2.width - MainFrame.this.mFinderPanel.getComponent().getWidth()) {
                                            MainFrame.this.setShowDatelist(!MainFrame.this.isFullScreenMode(), false);
                                        }
                                        if (MainFrame.this.mTimeChooserPanel != null && MainFrame.this.mTimeChooserPanel.isVisible() && p.x < screen2.width - MainFrame.this.mTimeChooserPanel.getWidth()) {
                                            MainFrame.this.setShowTimeButtons(!MainFrame.this.isFullScreenMode(), false);
                                        }
                                    });
                                }
                            }
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }.start();
            }
        });
    }

    private void checkIfToShowTimeDateChannelList() {
        if (Settings.Window.TIME_BUTTONS_SHOW.getBoolean() || Settings.Window.DATE_SELECTION_SHOW.getBoolean() || Settings.Window.CHANNEL_SELECTION_SHOW.getBoolean()) {
            SwingUtilities.invokeLater(() -> {
                if (Settings.Window.TIME_BUTTONS_SHOW.getBoolean() && !this.mTimeChooserPanel.isVisible()) {
                    this.setShowTimeButtons(true, false);
                }
                if (Settings.Window.DATE_SELECTION_SHOW.getBoolean() && !this.mFinderPanel.getComponent().isVisible()) {
                    this.setShowDatelist(true, false);
                }
                if (Settings.Window.CHANNEL_SELECTION_SHOW.getBoolean() && !this.mChannelChooser.isVisible()) {
                    this.setShowChannellist(true, false);
                }
            });
        }
    }

    private void clearActionAndInputMap() {
        ActionMap actionMap = this.rootPane.getActionMap();
        InputMap inputMap = this.rootPane.getInputMap(2);
        if (inputMap.size() > 0) {
            for (KeyStroke keyStroke : inputMap.keys()) {
                actionMap.remove(inputMap.get(keyStroke));
            }
            inputMap.clear();
        }
    }

    private void addKeyAction(int keyCode, int modifiers, Action action) {
        KeyStroke stroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        StringBuilder key = new StringBuilder();
        key.append(String.valueOf(stroke.getKeyCode()));
        key.append("_");
        key.append(String.valueOf(stroke.getModifiers()));
        this.rootPane.getInputMap(2).put(stroke, key.toString());
        this.rootPane.getActionMap().put(key.toString(), action);
    }

    private void addKeyAction(KeyStroke keyStroke, Action action) {
        StringBuilder key = new StringBuilder();
        key.append(String.valueOf(keyStroke.getKeyCode()));
        key.append("_");
        key.append(String.valueOf(keyStroke.getModifiers()));
        this.rootPane.getInputMap(2).put(keyStroke, key.toString());
        this.rootPane.getActionMap().put(key.toString(), action);
    }

    private void addProgramMouseActionKeys(int keyCode, ContextMenuMouseActionSetting[] actionSettings) {
        for (final ContextMenuMouseActionSetting actionSetting : actionSettings) {
            this.addKeyAction(keyCode, actionSetting.getModifiersEx(), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.mProgramTableScrollPane.handleKeyboardAction(new ContextMenuManager.ContextMenuAction(actionSetting.getContextMenuIf(), actionSetting.getContextMenuActionId()));
                }
            });
        }
    }

    public void addKeyboardAction() {
        int key;
        this.mProgramTableScrollPane.deSelectItem(false);
        this.clearActionAndInputMap();
        for (final TVBrowserAction action : TVBrowserActions.getActions()) {
            KeyStroke keyStroke = action.getAccelerator();
            if (keyStroke == null) continue;
            this.addKeyAction(keyStroke, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (action.isEnabled()) {
                        action.actionPerformed(null);
                    }
                }
            });
        }
        this.addKeyAction(114, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.setShowTimeButtons(!MainFrame.this.mTimeChooserPanel.isVisible());
            }
        });
        this.addKeyAction(115, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.setShowDatelist(!MainFrame.this.mFinderPanel.getComponent().isVisible());
            }
        });
        this.addKeyAction(65, 128, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.getProgramFilter() != FilterManagerImpl.getInstance().getDefaultFilter()) {
                    MainFrame.this.setProgramFilter(FilterManagerImpl.getInstance().getDefaultFilter());
                }
            }
        });
        this.addKeyAction(117, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.setShowChannellist(!MainFrame.this.mChannelChooser.isVisible());
            }
        });
        this.addKeyAction(84, 128, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.showFilterDialog();
            }
        });
        this.addKeyAction(75, 128, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new FilterComponentsDlg(UiUtilities.getLastModalChildOf(MainFrame.this));
            }
        });
        if (!OperatingSystem.isMacOs() || TVBrowser.isTransportable()) {
            this.addKeyAction(118, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.toggleShowMenuBar();
                }
            });
        }
        this.addKeyAction(38, 128, new KeyboardAction(this.mProgramTableScrollPane, 0));
        this.addKeyAction(224, 128, new KeyboardAction(this.mProgramTableScrollPane, 0));
        this.addKeyAction(39, 128, new KeyboardAction(this.mProgramTableScrollPane, 2));
        this.addKeyAction(227, 128, new KeyboardAction(this.mProgramTableScrollPane, 2));
        this.addKeyAction(40, 128, new KeyboardAction(this.mProgramTableScrollPane, 1));
        this.addKeyAction(225, 128, new KeyboardAction(this.mProgramTableScrollPane, 1));
        this.addKeyAction(37, 128, new KeyboardAction(this.mProgramTableScrollPane, 3));
        this.addKeyAction(226, 128, new KeyboardAction(this.mProgramTableScrollPane, 3));
        this.addKeyAction(525, 0, new KeyboardAction(this.mProgramTableScrollPane, 4));
        this.addKeyAction(82, 0, new KeyboardAction(this.mProgramTableScrollPane, 4));
        this.addKeyAction(78, 128, TVBrowserActions.goToNextDay);
        this.addKeyAction(80, 128, TVBrowserActions.goToPreviousDay);
        this.addKeyAction(27, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean menuCanceled = false;
                for (int i = 0; i < MainFrame.this.mMenuBar.getMenuCount(); ++i) {
                    JMenu test = MainFrame.this.mMenuBar.getMenu(i);
                    if (test.isSelected()) {
                        test.setSelected(false);
                        menuCanceled = true;
                    }
                    if (test.getPopupMenu().isShowing()) {
                        test.getPopupMenu().setVisible(false);
                        menuCanceled = true;
                    }
                    if (!menuCanceled) continue;
                    return;
                }
                if (MainFrame.this.isFullScreenMode()) {
                    TVBrowserActions.fullScreen.actionPerformed(null);
                } else {
                    MainFrame.this.mProgramTableScrollPane.closePopupMenuIfVisible();
                    MainFrame.this.mProgramTableScrollPane.getProgramTable().stopAutoScroll();
                    MainFrame.this.mAutoDownloadTimer = -1;
                    MainFrame.this.mLastTimerMinutesAfterMidnight = IOUtilities.getMinutesAfterMidnight();
                    TVBrowser.stopAutomaticDownload();
                    if (TVBrowserActions.update.isUpdating()) {
                        TVBrowserActions.update.actionPerformed(null);
                    }
                }
            }
        });
        this.addKeyAction(36, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.goToLeftSide();
            }
        });
        this.addKeyAction(35, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.goToRightSide();
            }
        });
        this.addKeyAction(39, 64, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.mProgramTableScrollPane.scrollPageRight();
            }
        });
        this.addKeyAction(37, 64, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.mProgramTableScrollPane.scrollPageLeft();
            }
        });
        int i = 0;
        for (key = 49; key <= 57; ++key) {
            final int index = i++;
            this.addKeyAction(key, 128, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.showTabForIndex(index);
                }
            });
        }
        i = 0;
        for (key = 97; key <= 105; ++key) {
            final int index = i++;
            this.addKeyAction(key, 128, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.showTabForIndex(index);
                }
            });
        }
        this.addKeyAction(45, 64, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.scrollThroughTabs(1);
            }
        });
        this.addKeyAction(109, 64, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.scrollThroughTabs(1);
            }
        });
        this.addKeyAction(521, 64, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.scrollThroughTabs(2);
            }
        });
        this.addKeyAction(107, 64, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.scrollThroughTabs(2);
            }
        });
        this.addProgramMouseActionKeys(76, Settings.Mouse.LEFT_SINGLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray());
        this.addProgramMouseActionKeys(68, Settings.Mouse.LEFT_DOUBLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray());
        this.addProgramMouseActionKeys(77, Settings.Mouse.MIDDLE_SINGLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray());
        this.addProgramMouseActionKeys(85, Settings.Mouse.MIDDLE_DOUBLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray());
        this.addKeyboardActionForMenu(this.mMenuBar.mPluginsMenu);
    }

    private void addKeyboardActionForMenu(JMenu menu) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null) continue;
            if (item instanceof JMenu) {
                this.addKeyboardActionForMenu((JMenu)item);
                continue;
            }
            KeyStroke s = item.getAccelerator();
            if (s == null) continue;
            this.addKeyAction(s, menu.getItem(i).getAction());
        }
    }

    protected void goToRightSide() {
        Channel[] channels = MainFrame.getInstance().getProgramTableModel().getShownChannels();
        if (channels != null && channels.length > 0) {
            this.mProgramTableScrollPane.scrollToChannel(channels[channels.length - 1]);
        }
    }

    protected void goToLeftSide() {
        Channel[] channels = MainFrame.getInstance().getProgramTableModel().getShownChannels();
        if (channels != null && channels.length > 0) {
            this.mProgramTableScrollPane.scrollToChannel(channels[0]);
        }
    }

    public JLabel getStatusBarLabel() {
        return this.mStatusBar.getLabel();
    }

    public void updateToolbar() {
        try {
            JPanel contentPane = (JPanel)this.getContentPane();
            if (this.mToolBarPanel != null) {
                contentPane.remove(this.mToolBarPanel);
            }
            this.mToolBarModel = DefaultToolBarModel.getInstance();
            this.mToolBar = new ToolBar(this.mToolBarModel, this.mStatusBar.getLabel());
            String location = this.mToolBar.getToolbarLocation();
            if (Settings.ToolBar.IS_VISIBLE.getBoolean()) {
                if (this.mToolBarPanel == null) {
                    this.mToolBarPanel = new JPanel(new BorderLayout()){

                        @Override
                        public void updateUI() {
                            super.updateUI();
                            if (Persona.getInstance().getHeaderImage() == null) {
                                this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getBackground().darker()));
                            } else {
                                int topBorder;
                                int n = Settings.ToolBar.ADDITIONAL_TOP_SPACE.getBoolean() && Settings.ToolBar.ADDITIONAL_BOTTOM_SPACE.getBoolean() ? 25 : (topBorder = Settings.ToolBar.ADDITIONAL_TOP_SPACE.getBoolean() ? 50 : 0);
                                int bottomBorder = Settings.ToolBar.ADDITIONAL_TOP_SPACE.getBoolean() && Settings.ToolBar.ADDITIONAL_BOTTOM_SPACE.getBoolean() ? 25 : (Settings.ToolBar.ADDITIONAL_BOTTOM_SPACE.getBoolean() ? 50 : 0);
                                this.setBorder(BorderFactory.createEmptyBorder((Settings.Window.MENU_BAR_VISIBLE.getBoolean() ? 0 : 3) + topBorder, 0, bottomBorder, 0));
                            }
                        }
                    };
                    this.addContextMenuMouseListener(this.mToolBarPanel);
                    this.mSearchField = new SearchField();
                    if (Persona.getInstance().getHeaderImage() != null) {
                        this.mToolBarPanel.setOpaque(false);
                        this.mSearchField.setOpaque(false);
                    } else {
                        this.mToolBarPanel.setOpaque(true);
                        this.mSearchField.setOpaque(true);
                    }
                    this.mToolBarPanel.addKeyListener(this.mGlobalFindAsYouTypeKeyListener);
                } else {
                    this.mToolBarPanel.removeAll();
                }
                if (location.compareTo("North") == 0) {
                    this.mToolBarPanel.add(MoreButton.wrapToolBar(this.mToolBar, this, this.mStatusBar.getLabel()), "Center");
                    if (Settings.ToolBar.IS_SEARCH_FIELD_VISIBLE.getBoolean()) {
                        this.mToolBarPanel.add((Component)this.mSearchField, "East");
                    }
                } else {
                    this.mToolBarPanel.add(MoreButton.wrapToolBar(this.mToolBar, this, this.mStatusBar.getLabel()), "West");
                    if (Settings.ToolBar.IS_SEARCH_FIELD_VISIBLE.getBoolean()) {
                        this.mToolBarPanel.add((Component)this.mSearchField, "South");
                    }
                }
                contentPane.add((Component)this.mToolBarPanel, location);
            }
            contentPane.invalidate();
            contentPane.updateUI();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void addContextMenuMouseListener(final JComponent c) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ContextMenu menu = new ContextMenu(c);
                    menu.show(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ContextMenu menu = new ContextMenu(c);
                    menu.show(e.getX(), e.getY());
                }
            }
        });
    }

    public ProgramTableScrollPane getProgramTableScrollPane() {
        return this.mProgramTableScrollPane;
    }

    public ToolBar getToolbar() {
        return this.mToolBar;
    }

    public JPanel getToolBarPanel() {
        return this.mToolBarPanel;
    }

    public DefaultProgramTableModel getProgramTableModel() {
        return this.mProgramTableModel;
    }

    public static synchronized MainFrame getInstance() {
        if (mSingleton == null) {
            mSingleton = new MainFrame();
        }
        return mSingleton;
    }

    public void updateTimeButtons() {
        this.mToolBar.updateTimeButtons();
        this.mTimeChooserPanel.updateButtons();
        this.mMenuBar.updateTimeItems();
    }

    public boolean isShowAllFilterActivated() {
        return this.mProgramTableModel == null || this.mProgramTableModel.getProgramFilter() instanceof ShowAllFilter;
    }

    public boolean isDefaultFilterActivated() {
        if (this.mProgramTableModel == null) {
            return true;
        }
        ProgramFilter filter = this.mProgramTableModel.getProgramFilter();
        return filter == null || Settings.General.FILTER_DEFAULT.getString().equals(filter.getClass().getName() + "###" + filter.getName());
    }

    public synchronized void setProgramFilter(final ProgramFilter filter) {
        boolean isDefaultFilter = filter.equals(FilterManagerImpl.getInstance().getDefaultFilter());
        this.mScrollPaneWrapper.removeInfoPanel(0);
        if (!isDefaultFilter) {
            this.mStoredViewPosition = this.mProgramTableScrollPane.getViewport().getViewPosition();
        }
        if (this.mProgramTableModel.getProgramFilter() instanceof SearchFilter && !(filter instanceof SearchFilter)) {
            this.mSearchField.deactivateSearch();
        } else if (this.mProgramTableModel.getProgramFilter() instanceof FaytFilter && !(filter instanceof FaytFilter)) {
            this.mFindAsYouType.closeFayt();
        }
        this.mProgramTableScrollPane.deSelectItem(false);
        this.mProgramTableModel.setProgramFilter(filter);
        this.mMenuBar.updateFiltersMenu();
        this.mToolBarModel.setFilterButtonSelected(!isDefaultFilter);
        if (!filter.equals(FilterManagerImpl.getInstance().getAllFilter()) && this.mProgramTableModel.getColumnCount() == 0 && this.mProgramTableModel.getAvailableChannelCount() > 0) {
            this.mScrollPaneWrapper.showInfoPanel(0, filter.getName());
        } else {
            this.setChannelFilter(this.mProgramTableModel.getChannelFilter());
        }
        this.updateFilterPanel();
        this.mToolBar.update();
        this.addKeyboardAction();
        if (this.mPluginView != null) {
            this.mPluginView.repaint();
        }
        if (this.mCenterPluginView != null) {
            this.mCenterPluginView.repaint();
        }
        if (this.mCurrentFilterName == null || !this.mCurrentFilterName.equals(filter.getName())) {
            if (this.mStoredViewPosition != null && isDefaultFilter) {
                SwingUtilities.invokeLater(() -> {
                    if (this.mStoredViewPosition != null) {
                        this.mProgramTableScrollPane.getViewport().setViewPosition(this.mStoredViewPosition);
                    }
                });
            } else {
                SwingUtilities.invokeLater(() -> {
                    if (this.getCurrentSelectedDate().equals(Date.getCurrentDate()) && !MainFrame.isStarting()) {
                        this.scrollToNow();
                    }
                });
            }
        }
        this.mStatusBar.getLabel().setText("");
        this.mCurrentFilterName = filter.getName();
        this.mProgramTableScrollPane.requestFocusInWindow();
        new Thread("SEND FILTER TO CENTER PANELS"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<PluginCenterPanelWrapper> arrayList = MainFrame.this.mCenterPanelWrapperList;
                synchronized (arrayList) {
                    try {
                        for (PluginCenterPanelWrapper wrapper : MainFrame.this.mCenterPanelWrapperList) {
                            wrapper.filterSelected(filter);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }.start();
    }

    public void setChannelFilter(ChannelFilter channelFilter) {
        this.mProgramTableModel.setChannelFilter(channelFilter);
        if (channelFilter != null) {
            Settings.Channels.GROUP_LAST_USED.setString(channelFilter.getName());
        } else {
            Settings.Channels.GROUP_LAST_USED.setString(null);
        }
        this.mChannelChooser.setChannelFilter(channelFilter);
        this.mChannelChooser.repaint();
        this.mMenuBar.updateChannelGroupMenu();
        if (channelFilter == null) {
            this.mScrollPaneWrapper.removeInfoPanel(2);
        } else if (channelFilter.getChannels() == null || channelFilter.getChannels().length == 0 || this.mProgramTableModel.getAvailableChannelCount() >= 0 && this.mProgramTableModel.getShownChannels().length == 0) {
            this.mScrollPaneWrapper.showInfoPanel(2, channelFilter.getName());
        }
    }

    public void updateFilterPanel() {
        boolean filterVisible;
        ProgramFilter filter = this.mProgramTableModel.getProgramFilter();
        boolean bl = filterVisible = !filter.equals(FilterManagerImpl.getInstance().getDefaultFilter()) && this.mMenuBar.isShowFilterPanelEnabled();
        if (filterVisible) {
            this.mFilterPanel.setCurrentFilter(filter);
        }
        this.mFilterPanel.setVisible(filterVisible);
        Settings.Window.FILTER_BAR_SHOW.setBoolean(this.mMenuBar.isShowFilterPanelEnabled());
        this.updateTopPanelVisibility();
    }

    private void updateTopPanelVisibility() {
        this.mTopPanel.setVisible(this.mFilterPanel.isVisible() || this.mRestartPanel.isVisible() || this.mVersionOldPanel.isVisible());
    }

    public ProgramFilter getProgramFilter() {
        if (this.mProgramTableModel == null) {
            return null;
        }
        return this.mProgramTableModel.getProgramFilter();
    }

    public ChannelFilter getChannelFilter() {
        if (this.mProgramTableModel == null) {
            return null;
        }
        return this.mProgramTableModel.getChannelFilter();
    }

    public void quit() {
        Object[] options = new String[]{LOCALIZER.msg("exitConfirmTitle", "Exit TV-Browser"), Localizer.getLocalization("i18n_cancel")};
        if (DontShowAgainOptionBox.showOptionDialog(Settings.General.ASK_FOR_EXIT_CONFIRMATION.getMessageId(), (Component)(this.isActive() ? this : null), LOCALIZER.msg("exitConirmText", "Do you really want to quit TV-Browser?"), options[0], 3, 0, options, (Object)options[0], null) != 0) {
            return;
        }
        TVBrowser.removeTray();
        this.quit(true);
    }

    public void quit(boolean log) {
        this.quit(log, false);
    }

    private void quit(boolean log, boolean export) {
        this.mTimer.stop();
        if (log && this.mDownloadingThread != null && this.mDownloadingThread.isAlive()) {
            final AtomicInteger countdownValue = new AtomicInteger(300);
            TvDataUpdater.getInstance().stopDownload();
            final JDialog info = new JDialog(UiUtilities.getLastModalChildOf(this));
            info.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            info.setUndecorated(true);
            info.toFront();
            final JLabel countdown = new JLabel(countdownValue.get() / 60 + ":" + String.format("%02d", countdownValue.get() % 60));
            countdown.setFont(countdown.getFont().deriveFont((float)countdown.getFont().getSize() * 2.0f));
            JPanel main = new JPanel((LayoutManager)new FormLayout("5dlu,0dlu:grow,default,0dlu:grow,5dlu", "5dlu,default,2dlu,default,5dlu"));
            main.setBorder(BorderFactory.createLineBorder(Color.black));
            main.add((Component)new JLabel(LOCALIZER.msg("downloadinfo", "A data update is running. TV-Browser will be closed when the update is done or countdown is reached.")), CC.xyw((int)2, (int)2, (int)3));
            main.add((Component)countdown, CC.xy((int)3, (int)4));
            info.setContentPane(main);
            info.pack();
            info.setLocationRelativeTo(this);
            Thread wait = new Thread("WAIT FOR UPDATE COMPLETED"){

                @Override
                public void run() {
                    while (countdownValue.getAndDecrement() > 0 && MainFrame.this.mDownloadingThread != null && MainFrame.this.mDownloadingThread.isAlive()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        countdown.setText(countdownValue.get() / 60 + ":" + String.format("%02d", countdownValue.get() % 60));
                    }
                    info.setVisible(false);
                    info.dispose();
                }
            };
            wait.start();
            info.setVisible(true);
        }
        if (log && this.isUndecorated()) {
            this.switchFullscreenMode();
        }
        if (mShuttingDown) {
            return;
        }
        mShuttingDown = true;
        PluginProxyManager.getInstance().shutdownAllPlugins(log);
        if (log) {
            LOG.info("Storing dataservice settings");
        }
        TvDataServiceProxyManager.getInstance().shutDown();
        GraphicsDevice[] graphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsDevice device = this.getGraphicsConfiguration().getDevice();
        for (int i = 0; i < graphicDevices.length; ++i) {
            if (!graphicDevices[i].equals(device)) continue;
            Settings.Window.SCREEN_NUMBER.setInt(i);
            break;
        }
        TVBrowser.shutdown(log);
        TvDataBase.getInstance().close(log);
        if (export) {
            Settings.Directories.TV_DATA.resetToDefault();
            Settings.copyToSystem();
        }
        JREUpdater.doUpdateIfAvailable();
        if (log) {
            LOG.info("Quitting");
            System.exit(0);
        }
    }

    public static boolean isShuttingDown() {
        return mShuttingDown;
    }

    public static boolean isStarting() {
        return mStarting;
    }

    public void handleTvBrowserStartFinished() {
        this.mMenuBar.updateChannelGroupMenu();
        PluginProxyManager.getInstance().addPluginStateListener(this);
        SwingUtilities.invokeLater(() -> {
            MainFrame.println("POS 7a");
            FilterList filterList = FilterList.getInstance();
            MainFrame.println("POS 8");
            ProgramFilter filter = filterList.getFilterByName(Settings.Window.FILTER_LAST_USED.getString());
            MainFrame.println("POS 9a");
            if (filter == null) {
                filter = FilterManagerImpl.getInstance().getDefaultFilter();
            }
            MainFrame.println("POS 9b");
            this.setProgramFilter(filter);
            MainFrame.println("POS 9c");
            String channelFilterName = Settings.Channels.GROUP_LAST_USED.getString();
            if (channelFilterName != null) {
                try {
                    ChannelFilter channelFilter = ChannelFilter.createChannelFilterForName(channelFilterName);
                    this.setChannelFilter(channelFilter);
                }
                catch (ClassCastException classCastException) {
                }
                catch (TvBrowserException tvBrowserException) {
                    // empty catch block
                }
            }
            MainFrame.println("POS 9d");
            mStarting = false;
            this.mMenuBar.updateChannelItems();
            if (Persona.getInstance().getHeaderImage() != null) {
                this.updatePersona();
            }
            if (PluginLoader.getInstance().hasToShowMouseInfo() && JOptionPane.showConfirmDialog(this, LOCALIZER.msg("askOpenMouseSettings", "Plugins were installed that support mouse actions.\n\nDo you want to open the mouse settings now to configure those actions?"), Localizer.getLocalization("i18n_info"), 0) == 0) {
                this.showSettingsDialog("#mouse");
            }
            PluginTree.getInstance().updateUI();
            if (!Settings.General.IS_USING_FULLSCREEN.getBoolean()) {
                this.mRootNode.update();
            }
        });
        SwingUtilities.invokeLater(() -> {
            ChangeListener[] listeners;
            ChangeEvent che = new ChangeEvent(this.mCenterTabPane);
            for (ChangeListener l : listeners = this.mCenterTabPane.getChangeListeners()) {
                l.stateChanged(che);
            }
        });
    }

    private void runAutoUpdate() {
        Channel[] channels;
        ArrayList<TvDataServiceProxy> dataServices = new ArrayList<TvDataServiceProxy>();
        ArrayList<TvDataServiceProxy> checkedServices = new ArrayList<TvDataServiceProxy>(0);
        for (Channel channel : channels = Settings.Channels.SUBSCRIBED.getChannelArray()) {
            if (channel instanceof DummyChannel || channel.getDataServiceProxy() == null || checkedServices.contains(channel.getDataServiceProxy())) continue;
            checkedServices.add(channel.getDataServiceProxy());
            if (!channel.getDataServiceProxy().supportsAutoUpdate()) continue;
            dataServices.add(channel.getDataServiceProxy());
        }
        checkedServices.clear();
        if (!dataServices.isEmpty() && this.licenseForTvDataServicesWasAccepted(dataServices.toArray(new TvDataServiceProxy[dataServices.size()]))) {
            this.runUpdateThread(14, dataServices.toArray(new TvDataServiceProxy[dataServices.size()]), true);
        }
        this.mLastAutoUpdateRun = System.currentTimeMillis();
    }

    public static void resetOnAirArrays() {
        mChannelDateArr = null;
        mOnAirRowProgramsArr = null;
    }

    private void handleTimerEvent() {
        this.checkAutomaticGotoNow();
        Date date = Date.getCurrentDate();
        if (this.mLastTimerMinutesAfterMidnight == -1) {
            MainFrame.resetOnAirArrays();
            this.mAutoDownloadTimer = (int)(Math.random() * 1430.0);
        }
        try {
            int minutesAfterMidnight = IOUtilities.getMinutesAfterMidnight();
            boolean onAirChanged = false;
            if (!(minutesAfterMidnight == this.mLastTimerMinutesAfterMidnight || this.mDownloadingThread != null && this.mDownloadingThread.isAlive())) {
                this.mLastTimerMinutesAfterMidnight = minutesAfterMidnight;
                Channel[] ch = ChannelList.getSubscribedChannels();
                if (ch != null) {
                    if (mChannelDateArr == null) {
                        onAirChanged = true;
                        this.fillOnAirArrays(ch);
                    } else {
                        for (int i = 0; i < mChannelDateArr.length; ++i) {
                            if (mChannelDateArr[i] == null) continue;
                            ChannelDayProgram chProg = TvDataBase.getInstance().getDayProgram(mChannelDateArr[i], ch[i]);
                            if (chProg != null && chProg.getProgramCount() > 0 && mOnAirRowProgramsArr[i] != -1) {
                                Program p;
                                if (mOnAirRowProgramsArr[i] >= chProg.getProgramCount()) {
                                    this.fillOnAirArrays(ch);
                                    LOG.warning("Reset of on-air-arrays");
                                }
                                if ((p = chProg.getProgramAt(mOnAirRowProgramsArr[i])).isOnAir()) {
                                    p.validateMarking();
                                    continue;
                                }
                                if (!p.isExpired()) continue;
                                onAirChanged = true;
                                p.validateMarking();
                                int n = mOnAirRowProgramsArr[i] + 1;
                                if (n < chProg.getProgramCount()) {
                                    MainFrame.mOnAirRowProgramsArr[i] = n;
                                    chProg.getProgramAt(mOnAirRowProgramsArr[i]).validateMarking();
                                    continue;
                                }
                                MainFrame.mChannelDateArr[i] = mChannelDateArr[i].addDays(1);
                                chProg = TvDataBase.getInstance().getDayProgram(mChannelDateArr[i], ch[i]);
                                if (chProg == null || chProg.getProgramCount() < 1) {
                                    MainFrame.mOnAirRowProgramsArr[i] = -1;
                                    continue;
                                }
                                MainFrame.mOnAirRowProgramsArr[i] = 0;
                                chProg.getProgramAt(mOnAirRowProgramsArr[i]).validateMarking();
                                continue;
                            }
                            if (mChannelDateArr[i].compareTo(Date.getCurrentDate()) >= 0) continue;
                            MainFrame.mChannelDateArr[i] = Date.getCurrentDate();
                            onAirChanged = true;
                            chProg = TvDataBase.getInstance().getDayProgram(mChannelDateArr[i], ch[i]);
                            if (chProg == null || chProg.getProgramCount() <= 0) continue;
                            MainFrame.mOnAirRowProgramsArr[i] = 0;
                            chProg.getProgramAt(mOnAirRowProgramsArr[i]).validateMarking();
                        }
                    }
                }
                for (PluginCenterPanelWrapper wrapper : this.mCenterPanelWrapperList) {
                    wrapper.timeEvent();
                }
                if (this.mLastAutoUpdateRun + (long)Settings.Data.DATA_SERVICE_AUTO_UPDATE_TIME.getInt() * 60000L <= System.currentTimeMillis() && !TvDataUpdater.getInstance().isDownloading()) {
                    this.runAutoUpdate();
                }
                if (!(!Settings.General.AUTO_DATA_DOWNLOAD_ENABLED.getBoolean() && !Settings.General.AUTO_UPDATE_PRIME_TIME.getBoolean() || this.mAutoDownloadTimer >= IOUtilities.getMinutesAfterMidnight() && date.equals(this.mCurrentDay) && !Settings.General.AUTO_UPDATE_PRIME_TIME.getBoolean() || this.mDownloadingThread != null && this.mDownloadingThread.isAlive() || !TVBrowser.handleAutomaticDownload(this.mAutoDownloadTimer))) {
                    this.mAutoDownloadTimer = -1;
                }
            }
            if (onAirChanged) {
                if (Settings.ProgramTable.LAYOUT.getString().equals("optimizedCompactTimeBlock")) {
                    this.mProgramTableScrollPane.getProgramTable().updateLayout();
                    this.mProgramTableScrollPane.updateUI();
                }
                if (this.getProgramFilter() != null && !this.getProgramFilter().equals(FilterManagerImpl.getInstance().getDefaultFilter())) {
                    this.setProgramFilter(this.getProgramFilter());
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "ERROR HANDLING TIMER EVENT ", e);
        }
        if (this.mPluginView != null) {
            this.mPluginView.repaint();
        }
        if (this.mCenterPluginView != null) {
            this.mCenterPluginView.repaint();
        }
        if (date.equals(this.mCurrentDay)) {
            return;
        }
        if (this.mCurrentDay != null) {
            if (this.mProgramTableModel.getDate().compareTo(Date.getCurrentDate().addDays(-1)) < 0) {
                this.scrollToNow();
            }
            Thread deletionThread = new Thread("Deferring data deletion"){

                @Override
                public void run() {
                    try {
                        30.sleep((long)(Math.random() * 3600.0 * 1000.0));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    SwingUtilities.invokeLater(() -> {
                        LOG.info("Deleting expired TV listings...");
                        TvDataBase.getInstance().deleteExpiredFiles(1, true);
                    });
                }
            };
            deletionThread.start();
        }
        this.mLastTimerMinutesAfterMidnight = -1;
        this.mCurrentDay = date;
        if (this.mFinderPanel != null) {
            this.mFinderPanel.updateContent();
        }
        if (this.mPluginView != null) {
            this.mPluginView.update();
        }
        if (this.mCenterPluginView != null) {
            this.mCenterPluginView.update();
        }
    }

    private void checkAutomaticGotoNow() {
        if (this.mAwayDetector.isAway()) {
            this.scrollToNow();
        }
    }

    private void fillOnAirArrays(Channel[] ch) {
        mChannelDateArr = new Date[ch.length];
        mOnAirRowProgramsArr = new int[ch.length];
        Arrays.fill(mOnAirRowProgramsArr, -1);
        Date currentDate = Date.getCurrentDate();
        for (int i = 0; i < ch.length; ++i) {
            ChannelDayProgram chProg = TvDataBase.getInstance().getDayProgram(currentDate, ch[i]);
            if (chProg == null) {
                MainFrame.mChannelDateArr[i] = null;
                continue;
            }
            int n = chProg.getProgramCount();
            for (int j = 0; j < n; ++j) {
                Program p = chProg.getProgramAt(j);
                if (!p.isOnAir() && p.isExpired()) continue;
                p.validateMarking();
                MainFrame.mOnAirRowProgramsArr[i] = j;
                MainFrame.mChannelDateArr[i] = currentDate;
                break;
            }
            if (mOnAirRowProgramsArr[i] != -1) continue;
            chProg = TvDataBase.getInstance().getDayProgram(currentDate.addDays(1), ch[i]);
            if (chProg != null && chProg.getProgramCount() > 0 && chProg.getProgramAt(0).isOnAir()) {
                chProg.getProgramAt(0).validateMarking();
                MainFrame.mOnAirRowProgramsArr[i] = 0;
            }
            MainFrame.mChannelDateArr[i] = currentDate.addDays(1);
        }
    }

    public void updatePluginsMenu() {
        this.mMenuBar.updatePluginsMenu();
    }

    public void scrollToProgram(Program program) {
        this.scrollToProgram(program, null);
    }

    public void scrollToProgram(Program program, Runnable callback) {
        int result;
        if (!this.getProgramFilter().accept(program) && (result = JOptionPane.showOptionDialog(this, LOCALIZER.msg("programFiltered", "The program {0} is not visible with the filter {1} being active.\nDo you want to deactivate the filter?", program.getTitle(), this.getProgramFilter().getName()), LOCALIZER.msg("programNotVisible", "Program not visible"), 0, 3, null, null, null)) == 0) {
            this.mStoredViewPosition = null;
            this.setProgramFilter(FilterManagerImpl.getInstance().getAllFilter());
        }
        this.mProgramTableScrollPane.resetScrolledTime();
        SwingUtilities.invokeLater(() -> {
            this.mProgramTableScrollPane.scrollToChannel(program.getChannel());
            this.scrollTo(program.getDate(), program.getStartTime(), callback);
        });
        for (PluginCenterPanelWrapper wrapper : this.mCenterPanelWrapperList) {
            wrapper.programScrolled(program);
        }
    }

    private void selectProgramInternal(Program program) {
        ProgramTable table = MainFrame.getInstance().getProgramTableScrollPane().getProgramTable();
        table.deSelectItem(false);
        table.selectProgram(program);
    }

    public void selectProgram(Program program, boolean scroll) {
        if (program != null) {
            if (scroll) {
                this.scrollToProgram(program, () -> this.selectProgramInternal(program));
            } else {
                this.selectProgramInternal(program);
            }
        }
        for (PluginCenterPanelWrapper wrapper : this.mCenterPanelWrapperList) {
            wrapper.programSelected(program);
        }
    }

    public void scrollToTime(int time, boolean mark) {
        this.mProgramTableScrollPane.deSelectItem(false);
        this.mProgramTableScrollPane.scrollToTime(time);
        this.mProgramTableScrollPane.requestFocusInWindow();
        if (mark) {
            this.mProgramTableScrollPane.getProgramTable().markTime(time);
        }
        for (PluginCenterPanelWrapper wrapper : this.mCenterPanelWrapperList) {
            wrapper.scrolledToTime(time);
        }
    }

    public void scrollToNow() {
        this.scrollToNow(false);
    }

    private void scrollToNow(boolean selectDay) {
        int dayStart = Settings.ProgramTable.START_OF_DAY.getInt();
        int dayEnd = Settings.ProgramTable.END_OF_DAY.getInt();
        this.mProgramTableScrollPane.resetScrolledTime();
        Calendar cal = Calendar.getInstance();
        int minutes = cal.get(11) * 60 + cal.get(12);
        Date day = Date.getCurrentDate();
        if ((dayStart >= dayEnd && minutes < dayEnd || dayStart < dayEnd && minutes <= (dayEnd + dayStart) / 2) && !selectDay) {
            day = day.addDays(-1);
            minutes += 1440;
        }
        if (selectDay || this.mProgramTableModel.getDate().compareTo(day) != 0) {
            this.scrollTo(day, minutes);
        } else {
            this.scrollToTime(minutes, false);
        }
        this.mProgramTableScrollPane.requestFocusInWindow();
        this.mProgramTableScrollPane.getProgramTable().clearTimeMarkings();
        new Thread("SEND SCROLL TO NOW TO CENTER PANELS"){

            @Override
            public void run() {
                for (PluginCenterPanelWrapper wrapper : MainFrame.this.mCenterPanelWrapperList) {
                    wrapper.scrolledToNow();
                }
            }
        }.start();
    }

    public void scrollToNowFirst() {
        this.handleTimerEvent();
        SwingUtilities.invokeLater(() -> this.scrollToNow(true));
    }

    private void scrollTo(Date day, int minute) {
        this.scrollTo(day, minute, null);
    }

    private void scrollTo(Date day, int minute, Runnable callback) {
        this.mProgramTableScrollPane.deSelectItem(false);
        this.mProgramTableScrollPane.getProgramTable().clearTimeMarkings();
        int dayStart = Settings.ProgramTable.START_OF_DAY.getInt();
        int dayEnd = Settings.ProgramTable.END_OF_DAY.getInt();
        if (dayStart >= dayEnd && minute < dayEnd || dayStart < dayEnd && minute <= (dayEnd + dayStart) / 2) {
            day = day.addDays(-1);
            minute += 1440;
        }
        int scrollMinute = minute;
        this.mFinderPanel.markDate(day, () -> {
            this.mProgramTableScrollPane.scrollToTime(scrollMinute);
            if (callback != null) {
                callback.run();
            }
        }, false);
    }

    public void runSetupAssistant() {
        ProgressWindow progWin = new ProgressWindow(this, LOCALIZER.msg("loadingAssistant", ""));
        final MainFrame parent = this;
        progWin.run(new Progress(){

            @Override
            public void run() {
                try {
                    UIThreadRunner.invokeAndWait(() -> {
                        MainFrame.this.mConfigAssistantDialog = new ConfigAssistant(parent);
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
        UiUtilities.centerAndShow(this.mConfigAssistantDialog);
        this.mConfigAssistantDialog.setVisible(false);
        this.mConfigAssistantDialog.dispose();
        this.mConfigAssistantDialog = null;
        Settings.handleChangedSettings();
        this.mProgramTableScrollPane.updateChannelPanel();
        boolean dataAvailable = TvDataBase.getInstance().dataAvailable(new Date());
        if (!dataAvailable) {
            this.askForDataUpdateNoDataAvailable();
        }
    }

    public void copySettingsToSystem() {
        if (TVBrowser.isTransportable()) {
            Object[] options = new String[]{LOCALIZER.msg("copy", "Copy"), LOCALIZER.msg("dontCopy", "Don't copy")};
            String title = LOCALIZER.msg("copyToSystemTitle", "Copy settings and data to system");
            String msg = LOCALIZER.msg("copyToSystemMsg", "Should the settings and TV data be copied to the system?\nTV-Browser will therefor will be quit automatically.");
            if (JOptionPane.showOptionDialog(this, msg, title, 0, 3, null, options, options[1]) == 0) {
                this.quit(true, true);
            }
        }
    }

    public void storeSettings() {
        this.mToolBarModel.store();
        this.mToolBar.storeSettings();
        this.mRootNode.storeProperties();
        ProgramFilter filter = this.getProgramFilter();
        if (filter != null) {
            if (!(filter instanceof SearchFilter)) {
                Settings.Window.FILTER_LAST_USED.setString(this.mCurrentFilterName);
            } else {
                Settings.Window.FILTER_LAST_USED.setString(FilterManagerImpl.getInstance().getDefaultFilter().getName());
            }
        } else {
            Settings.Window.FILTER_LAST_USED.setString(FilterManagerImpl.getInstance().getDefaultFilter().getName());
        }
        ChannelFilter channelFilter = this.getChannelFilter();
        if (channelFilter != null) {
            Settings.Channels.GROUP_LAST_USED.setString(channelFilter.getName());
        } else {
            Settings.Channels.GROUP_LAST_USED.setString(null);
        }
    }

    protected void showPluginInfoDlg() {
        Window parent = UiUtilities.getLastModalChildOf(this);
        PluginInformationDialog dlg = new PluginInformationDialog(parent);
        Settings.layoutWindow("main.pluginInfoDlg", dlg, new Dimension(Sizes.dialogUnitXAsPixel((int)420, (Component)dlg), Sizes.dialogUnitYAsPixel((int)215, (Component)dlg)));
        dlg.setVisible(true);
    }

    private void onDownloadStart() {
        Date compareDate;
        this.mAutoDownloadTimer = -1;
        TVBrowserActions.update.setUpdating(true);
        if (!Settings.Plugins.INFO_DIALOG_WAS_SHOWN.getBoolean() && (compareDate = Settings.General.DATE_FIRST_START.getDate().addDays((int)(Math.random() * 4.0 + 3.0))).compareTo(Date.getCurrentDate()) <= 0) {
            this.showPluginInfoDlg();
            Settings.Plugins.INFO_DIALOG_WAS_SHOWN.setBoolean(true);
        }
        this.mLastAutoUpdateRunBuffer = this.mLastAutoUpdateRun;
        this.mLastAutoUpdateRun = System.currentTimeMillis() + 3600000L;
        this.mToolBar.updateUpdateButton(true);
        this.mMenuBar.showStopMenuItem();
        Settings.Data.DOWNLOAD_DATE_LAST.setDate(Date.getCurrentDate());
        Settings.Data.DOWNLOAD_TIME_LAST.setInt(IOUtilities.getMinutesAfterMidnight());
    }

    private void onDownloadDone() {
        TVBrowserActions.update.setUpdating(false);
        TvDataUpdater.getInstance().stopDownload();
        this.mStatusBar.getProgressBar().setValue(0);
        this.mStatusBar.getProgressBar().setVisible(false);
        this.mToolBar.updateUpdateButton(false);
        this.mMenuBar.showUpdateMenuItem();
        this.mLastAutoUpdateRun = this.mLastAutoUpdateRunBuffer;
        this.mFinderPanel.updateItems();
        MainFrame.resetOnAirArrays();
        this.mAutoDownloadTimer = -1;
        DontShowAgainOptionBox.showOptionDialog(Settings.General.DOWNLOAD_DONE.getMessageId(), MainFrame.getInstance(), LOCALIZER.msg("downloaddone.message", "The download is done."), LOCALIZER.msg("downloaddone.title", "Done"));
    }

    public void handleChangedTvDataDir() {
        this.mFinderPanel.updateItems();
        this.changeDate(Date.getCurrentDate(), null, () -> {
            this.scrollToNow();
            MainFrame.resetOnAirArrays();
        }, false);
    }

    public void showChannel(Channel ch) {
        this.mProgramTableScrollPane.scrollToChannel(ch);
        for (PluginCenterPanelWrapper wrapper : this.mCenterPanelWrapperList) {
            wrapper.scrolledToChannel(ch);
        }
    }

    private void newTvDataAvailable(boolean scroll) {
        if (scroll) {
            this.changeDate(this.mFinderPanel.getSelectedDate(), null, () -> this.scrollToNow(), false);
        } else {
            this.changeDate(this.mFinderPanel.getSelectedDate(), null, null, true);
        }
        this.mMenuBar.updateDateItems();
    }

    private void checkFilterInfoPanel() {
        ProgramFilter filter = this.mProgramTableModel.getProgramFilter();
        if (!TvDataBase.getInstance().dataAvailable(this.mProgramTableModel.getDate()) && this.mProgramTableModel.getAvailableChannelCount() > 0 && Settings.General.AUTO_DOWNLOAD_TYPE.getString().equals("never")) {
            this.mScrollPaneWrapper.showInfoPanel(3, null);
        } else if (filter != null && !filter.equals(FilterManagerImpl.getInstance().getAllFilter()) && this.mProgramTableModel.getColumnCount() == 0 && this.mProgramTableModel.getAvailableChannelCount() > 0) {
            this.mScrollPaneWrapper.showInfoPanel(0, filter.getName());
        } else {
            boolean hadInfoPanel = false;
            if (this.mScrollPaneWrapper.hasInfoPanel(3)) {
                hadInfoPanel = true;
                this.mScrollPaneWrapper.removeInfoPanel(3);
            }
            if (this.mScrollPaneWrapper.hasInfoPanel(0)) {
                hadInfoPanel = true;
                this.mScrollPaneWrapper.removeInfoPanel(0);
            }
            if (hadInfoPanel) {
                this.setChannelFilter(this.mProgramTableModel.getChannelFilter());
            }
        }
    }

    public void goTo(Date date) {
        this.mProgramTableScrollPane.deSelectItem(false);
        this.mFinderPanel.markDate(date, true);
    }

    public void goToNextDay() {
        this.goToNextDay(null);
    }

    public void goToNextDay(Runnable callback) {
        Program selected = this.mProgramTableScrollPane.deSelectItem(true);
        if (selected != null) {
            Iterator<Program> dayProgram = PluginManagerImpl.getInstance().getChannelDayProgram(selected.getDate().addDays(1), selected.getChannel());
            Program next = null;
            boolean found = false;
            while (dayProgram.hasNext()) {
                next = dayProgram.next();
                if (next.isExpired() || next.getStartTime() + next.getLength() <= selected.getStartTime() || !this.mProgramTableModel.getProgramFilter().accept(next)) continue;
                this.selectProgram(next, true);
                next = null;
                found = true;
                break;
            }
            if (!found && next != null && !next.isExpired() && this.mProgramTableModel.getProgramFilter().accept(next)) {
                this.selectProgram(next, true);
            } else if (!found) {
                this.mFinderPanel.markNextDate(callback);
            }
        } else {
            this.mFinderPanel.markNextDate(callback);
        }
    }

    public void goToPreviousDay() {
        this.goToPreviousDay(null);
    }

    public void goToPreviousDay(Runnable callback) {
        Program selected = this.mProgramTableScrollPane.deSelectItem(true);
        if (selected != null) {
            Iterator<Program> dayProgram = PluginManagerImpl.getInstance().getChannelDayProgram(selected.getDate().addDays(-1), selected.getChannel());
            Program next = null;
            boolean found = false;
            while (dayProgram.hasNext()) {
                next = dayProgram.next();
                if (next.isExpired() || next.getStartTime() + next.getLength() <= selected.getStartTime() || !this.mProgramTableModel.getProgramFilter().accept(next)) continue;
                this.selectProgram(next, true);
                next = null;
                found = true;
                break;
            }
            if (!found && next != null && !next.isExpired() && this.mProgramTableModel.getProgramFilter().accept(next)) {
                this.selectProgram(next, true);
            } else if (!found) {
                this.mFinderPanel.markPreviousDate(callback);
            }
        } else {
            this.mFinderPanel.markPreviousDate(callback);
        }
    }

    public void goToNextWeek() {
        this.mProgramTableScrollPane.deSelectItem(false);
        this.mFinderPanel.markNextWeek();
    }

    public void goToPreviousWeek() {
        this.mProgramTableScrollPane.deSelectItem(false);
        this.mFinderPanel.markPreviousWeek();
    }

    public void goToToday() {
        this.goTo(Date.getCurrentDate());
    }

    public Date getCurrentSelectedDate() {
        return this.mFinderPanel.getSelectedDate();
    }

    private void changeDate(Date date, ProgressMonitor monitor, Runnable callback, boolean informPluginPanels) {
        SwingUtilities.invokeLater(() -> {
            int currentTime = this.mProgramTableScrollPane.getScrolledTime();
            this.mProgramTableScrollPane.deSelectItem(false);
            this.mProgramTableModel.setDate(date, monitor, () -> {
                if (callback != null) {
                    callback.run();
                }
                if (currentTime >= 0) {
                    this.mProgramTableScrollPane.scrollToTime(currentTime);
                }
            });
            this.checkFilterInfoPanel();
        });
        if (informPluginPanels) {
            for (PluginCenterPanelWrapper wrapper : this.mCenterPanelWrapperList) {
                wrapper.scrolledToDate(date);
            }
        }
    }

    @Override
    public void dateChanged(Date date, ProgressMonitor monitor, Runnable callback, boolean informPluginPanels) {
        this.changeDate(date, monitor, callback, informPluginPanels);
        super.setTitle(TVBrowser.MAINWINDOW_TITLE + " - " + date.getLongDateString());
        if (this.mToolBar != null) {
            this.mToolBar.dateChanged(date, monitor, callback);
        }
    }

    public boolean isUpdatingData() {
        return this.mDownloadingThread != null && this.mDownloadingThread.isAlive();
    }

    public void runUpdateThread(final int daysToDownload, final TvDataServiceProxy[] services, final boolean autoUpdate) {
        if (!this.isUpdatingData()) {
            this.mDownloadingThread = new Thread("TV data update"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MainFrame.this.onDownloadStart();
                    boolean scroll = !autoUpdate && !TvDataBase.getInstance().dataAvailable(Date.getCurrentDate()) && MainFrame.this.getProgramTableModel().getDate() != null && MainFrame.this.getProgramTableModel().getDate().compareTo(Date.getCurrentDate()) == 0;
                    JProgressBar progressBar = MainFrame.this.mStatusBar.getProgressBar();
                    progressBar.setVisible(true);
                    try {
                        TvDataUpdater.getInstance().downloadTvData(daysToDownload, services, progressBar, MainFrame.this.mStatusBar.getLabel());
                    }
                    catch (Throwable t) {
                        try {
                            String msg = LOCALIZER.msg("error.3", "An unexpected error occurred during update.");
                            ErrorHandler.handle(msg, t);
                        }
                        catch (Throwable throwable) {
                            Thread t2 = new Thread("HANDLING UPDATIN DATA", scroll){
                                final /* synthetic */ boolean val$scroll;
                                {
                                    this.val$scroll = bl;
                                    super(arg0);
                                }

                                @Override
                                public void run() {
                                    SwingUtilities.invokeLater(() -> {
                                        MainFrame.this.onDownloadDone();
                                        MainFrame.this.newTvDataAvailable(this.val$scroll);
                                        if ((Settings.General.JRE_UPDATE_DATE_LAST.getDate() == null || Settings.General.JRE_UPDATE_DATE_LAST.getDate().addDays(13).compareTo(Date.getCurrentDate()) <= 0) && NetworkUtilities.checkConnection() && !JREUpdater.checkForUpdate(MainFrame.this.mStatusBar.getLabel())) {
                                            MainFrame.this.checkForPluginUpdate();
                                        } else if (!MainFrame.this.checkForPluginUpdate()) {
                                            JREUpdater.handlePossibleUpdate();
                                        }
                                    });
                                }
                            };
                            t2.start();
                            throw throwable;
                        }
                        Thread t3 = new /* invalid duplicate definition of identical inner class */;
                        t3.start();
                    }
                    Thread t = new /* invalid duplicate definition of identical inner class */;
                    t.start();
                }
            };
            this.mDownloadingThread.setPriority(1);
            this.mDownloadingThread.start();
        }
    }

    private boolean checkForPluginUpdate() {
        boolean result = false;
        if (Settings.Plugins.UPDATE_LAST.getDate() == null || Settings.Plugins.UPDATE_LAST.getDate().addDays(7).compareTo(Date.getCurrentDate()) <= 0) {
            PluginAutoUpdater.searchForPluginUpdates(this.mStatusBar.getLabel());
            result = true;
        }
        return result;
    }

    public void updateChannellist() {
        this.updateChannelChooser();
        this.mMenuBar.updateChannelItems();
        if (ChannelList.getSubscribedChannels().length > 0) {
            this.mScrollPaneWrapper.removeInfoPanel(1);
        } else {
            this.mScrollPaneWrapper.showInfoPanel(1, null);
        }
    }

    public void updateChannelChooser() {
        this.mChannelChooser.updateChannelChooser();
        this.mMenuBar.updateChannelItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateTvData(int numberOfDays, String reason) {
        if (this.mIsAskingUpdate || this.isUpdatingData() || TVBrowser.isWaitingForUpdateStart()) {
            return;
        }
        if (TvDataUpdater.getInstance().isDownloading()) {
            return;
        }
        if (this.mDownloadingThread != null && this.mDownloadingThread.isAlive()) {
            return;
        }
        this.mIsAskingUpdate = true;
        try {
            if (ChannelList.getNumberOfSubscribedChannels() == 0) {
                int result = JOptionPane.showOptionDialog(this, LOCALIZER.msg("subscribeBeforeUpdate.msg", "You have not defined any channels.\n\nDo you want to subscribe to some channels before starting the data update?"), LOCALIZER.msg("subscribeBeforeUpdate.title", "No subscribed channels"), 0, 3, null, null, null);
                if (result == 0) {
                    this.showSettingsDialog("#channels");
                }
            } else if (TvDataUpdater.getInstance().isDownloading()) {
                TvDataUpdater.getInstance().stopDownload();
            } else if (UpdateDlg.isToShow()) {
                int daysToDownload;
                UpdateDlg dlg = new UpdateDlg(this, true, reason);
                if (numberOfDays > 0) {
                    dlg.setNumberOfDays(numberOfDays);
                }
                dlg.pack();
                if (!UpdateDlg.isToKeepHidden()) {
                    UiUtilities.centerAndShow(dlg);
                }
                if ((daysToDownload = dlg.getResult()) != -1 && this.licenseForTvDataServicesWasAccepted(dlg.getSelectedTvDataServices())) {
                    this.runUpdateThread(daysToDownload, dlg.getSelectedTvDataServices(), false);
                }
            }
        }
        finally {
            this.mIsAskingUpdate = false;
        }
    }

    public void updateTvData() {
        this.updateTvData(0, null);
    }

    public boolean licenseForTvDataServicesWasAccepted(TvDataServiceProxy[] updateServices) {
        boolean accept = true;
        String[] acceptedFor = Settings.Data.ACCEPTED_LICENSES.getStringArray();
        for (TvDataServiceProxy serviceProxy : updateServices) {
            boolean found = false;
            for (String acceptedService : acceptedFor) {
                if (serviceProxy.getId().compareTo(acceptedService) != 0) continue;
                found = true;
                break;
            }
            if (found || serviceProxy.getInfo().getLicense() == null) continue;
            LicenseBox box = new LicenseBox(this, serviceProxy.getInfo().getLicense(), true);
            UiUtilities.centerAndShow(box);
            boolean bl = accept = accept && box.agreed();
            if (!box.agreed()) continue;
            String[] oldIds = Settings.Data.ACCEPTED_LICENSES.getStringArray();
            String[] newIds = new String[oldIds.length + 1];
            System.arraycopy(oldIds, 0, newIds, 0, oldIds.length);
            newIds[newIds.length - 1] = serviceProxy.getId();
            Settings.Data.ACCEPTED_LICENSES.setStringArray(newIds);
        }
        return accept;
    }

    public void showSettingsDialog() {
        this.showSettingsDialog(Settings.Other.SETTINGS_LAST_USED_PATH.getString());
    }

    public void showSettingsDialog(String visibleTabId) {
        if (this.mSettingsWillBeOpened) {
            return;
        }
        try {
            UIThreadRunner.invokeAndWait(() -> {
                this.mSettingsWillBeOpened = true;
                Window comp = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
                ProgramTable programTable = MainFrame.getInstance().getProgramTableScrollPane().getProgramTable();
                Cursor oldWindowCursor = comp.getCursor();
                Cursor oldTableCursor = programTable.getCursor();
                comp.setCursor(Cursor.getPredefinedCursor(3));
                programTable.setCursor(Cursor.getPredefinedCursor(3));
                SettingsDialog dlg = new SettingsDialog(this, visibleTabId);
                dlg.centerAndShow();
                programTable.setCursor(oldTableCursor);
                comp.setCursor(oldWindowCursor);
                SwingUtilities.invokeLater(() -> {
                    Settings.handleChangedSettings();
                    if (this.mPluginView != null) {
                        this.mPluginView.refreshTree();
                    }
                    if (this.mCenterPluginView != null) {
                        this.mCenterPluginView.refreshTree();
                    }
                });
                this.mSettingsWillBeOpened = false;
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void showSettingsDialog(Plugin plugin) {
        this.showSettingsDialog(plugin.getId());
    }

    public void showAboutBox() {
        AboutBox box = new AboutBox(this);
        box.setSize(500, 580);
        UiUtilities.centerAndShow(box);
        box.dispose();
    }

    public void showUpdatePluginsDlg(boolean noQuestion) {
        this.showUpdatePluginsDlg(noQuestion, null, false);
    }

    public void showUpdatePluginsDlg(boolean noQuestion, String search, boolean select) {
        int answer = 0;
        if (!noQuestion) {
            Object[] options = new Object[]{LOCALIZER.msg("checknow", "Check now"), Localizer.getLocalization("i18n_cancel")};
            String msg = LOCALIZER.msg("question.1", "do you want to check for new plugins");
            answer = JOptionPane.showOptionDialog(this, msg, LOCALIZER.msg("title.1", "update plugins"), 0, 3, null, options, options[0]);
        }
        if (answer == 0) {
            this.updatePlugins("http://download.tvbrowser.org/plugins", 0, this.mStatusBar.getLabel(), false, search, select);
        }
    }

    public void updatePlugins(final String baseUrl, final int dialogType, final JLabel infoLabel, final boolean dontShowUpdateDlg, final String search, final boolean select) {
        new Thread("Plugin Update Thread"){

            @Override
            public void run() {
                BlockedPlugin[] newlyBlocked;
                SoftwareUpdateItem testVersion = null;
                try {
                    infoLabel.setText(LOCALIZER.msg("searchForPluginUpdates", "Search for plugin updates..."));
                    URL url = new URL(HTMLTextHelper.getPathWithClosingSlash(baseUrl) + "plugins.gz");
                    SoftwareUpdater softwareUpdater = new SoftwareUpdater(url, dialogType, false);
                    MainFrame.this.mSoftwareUpdateItems = softwareUpdater.getAvailableSoftwareUpdateItems();
                    testVersion = softwareUpdater.getTVBrowserTestItem();
                    infoLabel.setText("");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (!dontShowUpdateDlg) {
                    boolean goOn = true;
                    if (MainFrame.this.mSoftwareUpdateItems == null && dialogType != 1) {
                        JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("error.1", "software check failed."));
                        goOn = false;
                    } else if (testVersion != null && !Settings.General.INFORM_TEST_VERSIONS.isHidden() && Settings.General.TEST_VERSION_AVAILABLE.getVersion().isOlderThan(testVersion.getVersion())) {
                        MainFrame.this.showTestVersionAvailable((TvbrowserSoftwareUpdateItem)testVersion);
                    }
                    if (goOn) {
                        if (MainFrame.this.mSoftwareUpdateItems != null && MainFrame.this.mSoftwareUpdateItems.length == 0 && dialogType != 1) {
                            JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("error.2", "No new items available"));
                        } else if (MainFrame.this.mSoftwareUpdateItems != null && MainFrame.this.mSoftwareUpdateItems.length > 0) {
                            Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
                            try {
                                UIThreadRunner.invokeAndWait(() -> {
                                    SoftwareUpdateDlg dlg = new SoftwareUpdateDlg(parent, baseUrl, dialogType, MainFrame.this.mSoftwareUpdateItems, false, null, search, select);
                                    dlg.setVisible(true);
                                });
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else if (testVersion != null && !Settings.General.INFORM_TEST_VERSIONS.isHidden() && Settings.General.TEST_VERSION_AVAILABLE.getVersion().isOlderThan(testVersion.getVersion())) {
                    MainFrame.this.showTestVersionAvailable((TvbrowserSoftwareUpdateItem)testVersion);
                }
                if ((newlyBlocked = Settings.Plugins.BLOCKED_ARRAY.getNewBlockedPlugins()) != null && newlyBlocked.length > 0) {
                    StringBuilder message = new StringBuilder();
                    for (BlockedPlugin blockedPlugin : newlyBlocked) {
                        PluginProxy plugin = PluginProxyManager.getInstance().getPluginForId(blockedPlugin.getPluginId());
                        if (plugin == null) {
                            TvDataServiceProxy dataService = TvDataServiceProxyManager.getInstance().findDataServiceById(blockedPlugin.getPluginId());
                            if (dataService == null || !blockedPlugin.isBlockedVersion(dataService.getId(), dataService.getInfo().getVersion())) continue;
                            message.append("\n").append(dataService.getInfo().getName()).append(" (").append(blockedPlugin.getBlockStart()).append(" - ").append(blockedPlugin.getBlockEnd()).append(")");
                            continue;
                        }
                        if (!blockedPlugin.isBlockedVersion(plugin)) continue;
                        message.append("\n").append(plugin.getInfo().getName()).append(" (").append(blockedPlugin.getBlockStart()).append(" - ").append(blockedPlugin.getBlockEnd()).append(")");
                    }
                    if (message.length() > 0) {
                        message.insert(0, LOCALIZER.msg("update.blockedInfo", "The following Plugins were blocked and cannot be used in their current version:\n"));
                        MainFrame.this.showInfoTextMessage(LOCALIZER.msg("update.blockedPlugins", "Plugins blocked!"), message.toString(), 450);
                    }
                }
                Settings.Plugins.UPDATE_LAST.setDate(Date.getCurrentDate());
                infoLabel.setText("");
                MainFrame.this.mSoftwareUpdateItems = null;
                MainFrame.this.mVersionOldPanel.setButtonText(LOCALIZER.msg("downloadNewVersion", "Go to download of TV-Browser {0}", Settings.General.VERSION_AVAILABLE.getVersion().toString()));
                MainFrame.this.mVersionOldPanel.setVisible(Settings.General.VERSION_AVAILABLE.getVersion().isNewerThan(TVBrowser.VERSION));
                MainFrame.this.updateTopPanelVisibility();
            }
        }.start();
    }

    private void showTestVersionAvailable(TvbrowserSoftwareUpdateItem testVersion) {
        JLabel info = new JLabel("<html>" + LOCALIZER.msg("testVersionFound.msg", "A new test version of TV-Browser ({0}) is available:", testVersion.getVersion().toString()) + "<br><br>" + Translate.decode((String)testVersion.getDescription()) + "<html>");
        Object[] options = new String[]{LOCALIZER.msg("testVersionFound.btn", "Open TV-Browser website for download"), Localizer.getLocalization("i18n_cancel")};
        if (DontShowAgainOptionBox.showOptionDialog(Settings.General.INFORM_TEST_VERSIONS.getMessageId(), (Component)UiUtilities.getBestDialogParent(this), info, LOCALIZER.msg("testVersionFound.title", "New test version available"), 1, 0, options, (Object)options[0], null) == 0) {
            Launch.openURL("https://www.tvbrowser.org/index.php?id=tv-browser-beta");
        }
        Settings.General.TEST_VERSION_AVAILABLE.setVersion(testVersion.getVersion());
    }

    public void showFromTray(int state) {
        super.setVisible(true);
        this.toFront();
        this.setExtendedState(state);
        this.mIsVisible = true;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.mIsVisible = visible;
    }

    @Override
    public void repaint() {
        super.repaint();
        this.mRootNode.update();
    }

    public void askForDataUpdate(String message, int numberOfDays) {
        this.updateTvData(numberOfDays, message);
    }

    private void askForDataUpdate(String reason) {
        this.askForDataUpdate(reason, 0);
    }

    public void askForDataUpdateNoDataAvailable() {
        if (this.mProgramTableModel.getAvailableChannelCount() > 0 && Settings.General.AUTO_DOWNLOAD_TYPE.equals("never")) {
            this.askForDataUpdate(LOCALIZER.msg("askforupdatedlg.noData", "No TV data for todays program available."));
        }
    }

    public void askForDataUpdateChannelsAdded() {
        this.askForDataUpdate(LOCALIZER.msg("askforupdatedlg.addedChannels", "You have added channels."));
    }

    public void showFilterDialog() {
        SelectFilterDlg dlg = SelectFilterDlg.create(this);
        UiUtilities.centerAndShow(dlg);
        this.mMenuBar.updateFiltersMenu();
    }

    public void updateFilterMenu() {
        this.mMenuBar.updateFiltersMenu();
    }

    public void showHelpDialog() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        File indexFile = new File("help/" + language + "/index.html");
        if (!indexFile.exists()) {
            indexFile = new File("help/default/index.html");
        }
        Launch.openURL(indexFile.getAbsolutePath());
    }

    public void updateButtons() {
        this.mMenuBar.updateTimeItems();
        if (this.mTimebuttonsNode.getLeaf() != null) {
            ((TimeChooserPanel)this.mTimebuttonsNode.getLeaf()).updateButtons();
        }
    }

    public void setIsToolbarAdditonalTopSpace(boolean value) {
        Settings.ToolBar.ADDITIONAL_TOP_SPACE.setBoolean(value);
        if (this.mToolBarPanel != null) {
            this.mToolBarPanel.updateUI();
        }
    }

    public void setIsToolbarAdditonalBottomSpace(boolean value) {
        Settings.ToolBar.ADDITIONAL_BOTTOM_SPACE.setBoolean(value);
        if (this.mToolBarPanel != null) {
            this.mToolBarPanel.updateUI();
        }
    }

    public void toggleShowMenuBar() {
        this.setShowMenubar(!this.mMenuBar.isVisible());
    }

    public void setShowMenubar(boolean visible) {
        if (!visible) {
            DontShowAgainOptionBox.showOptionDialog("mainFrame.menuBarDisabled", this, LOCALIZER.msg("menuBarDisabled", "You have disabled the menu bar.\nTo show it again press F7 on your keyboard."));
        }
        Settings.Window.MENU_BAR_VISIBLE.setBoolean(visible);
        this.mMenuBar.setVisible(visible);
        this.mMenuBar.updateViewToolbarItem();
        if (this.mToolBarPanel != null) {
            this.mToolBarPanel.updateUI();
        }
    }

    public void setShowToolbar(boolean visible) {
        Settings.ToolBar.IS_VISIBLE.setBoolean(visible);
        this.mMenuBar.updateViewToolbarItem();
        this.updateToolbar();
    }

    public void setShowSearchField(boolean visible) {
        Settings.ToolBar.IS_SEARCH_FIELD_VISIBLE.setBoolean(visible);
        this.updateToolbar();
    }

    private void updateViews() {
        if (this.mIsVisible) {
            this.jcontentPane = (JPanel)this.getContentPane();
            this.jcontentPane.remove(this.mCenterComponent);
            this.mCenterComponent = this.mRootNode.getComponent();
            this.jcontentPane.add(this.mCenterComponent, "Center");
            this.jcontentPane.validate();
            this.jcontentPane.requestFocus();
            this.mRootNode.update();
        }
    }

    public void setShowTimeButtons(boolean visible) {
        this.setShowTimeButtons(visible, true);
    }

    public void setShowTimeButtons(boolean visible, boolean save) {
        if (visible) {
            this.mTimebuttonsNode.setLeaf(this.mTimeChooserPanel);
        } else {
            this.mTimebuttonsNode.setLeaf(null);
        }
        this.mTimeChooserPanel.setVisible(visible);
        this.mMenuBar.setTimeCooserItemChecked(visible);
        if (save) {
            Settings.Window.TIME_BUTTONS_SHOW.setBoolean(visible);
        }
        this.updateViews();
    }

    public void setShowDatelist(boolean visible) {
        this.setShowDatelist(visible, true);
    }

    public void setShowDatelist(boolean visible, boolean save) {
        if (visible) {
            this.mDateNode.setLeaf(new DateChooserPanel(this, this.mFinderPanel.getComponent()));
        } else {
            this.mDateNode.setLeaf(null);
        }
        this.mFinderPanel.getComponent().setVisible(visible);
        this.mMenuBar.setDateListItemChecked(visible);
        if (save) {
            Settings.Window.DATE_SELECTION_SHOW.setBoolean(visible);
        }
        this.updateViews();
    }

    public void setShowChannellist(boolean visible) {
        this.setShowChannellist(visible, true);
    }

    public void setShowChannellist(boolean visible, boolean save) {
        if (visible) {
            this.mChannelNode.setLeaf(this.mChannelChooser);
        } else {
            this.mChannelNode.setLeaf(null);
        }
        this.mChannelChooser.setVisible(visible);
        this.mMenuBar.setChannelListItemChecked(visible);
        if (save) {
            Settings.Window.CHANNEL_SELECTION_SHOW.setBoolean(visible);
        }
        this.updateViews();
    }

    public void setPluginViewButton(boolean selected) {
        if (this.mToolBarModel != null) {
            this.mToolBar.update();
        }
    }

    public void setShowPluginOverview(boolean visible) {
        this.setShowPluginOverview(visible, true);
    }

    public boolean isShowingPluginOverview() {
        return this.mPluginView != null;
    }

    public void setShowPluginOverview(boolean visible, boolean save) {
        this.mPluginView = visible ? new PluginView() : null;
        this.mPluginsNode.setLeaf(this.mPluginView);
        TVBrowserActions.pluginView.putValue("ActionIsSelected", visible);
        this.mMenuBar.setPluginViewItemChecked(visible);
        if (save) {
            Settings.Window.PLUGIN_VIEW_SHOW.setBoolean(visible);
        }
        this.updateViews();
    }

    public void setShowStatusbar(boolean visible) {
        JPanel contentPane = (JPanel)this.getContentPane();
        Settings.Window.STATUS_BAR_VISIBLE.setBoolean(visible);
        if (visible && !contentPane.isAncestorOf(this.mStatusBar)) {
            this.mSouthPanel.add((Component)this.mStatusBar, "South");
        } else if (contentPane.isAncestorOf(this.mStatusBar)) {
            this.mSouthPanel.remove(this.mStatusBar);
        }
        contentPane.invalidate();
        contentPane.repaint();
    }

    public ProgressMonitor createProgressMonitor() {
        return this.mStatusBar.createProgressMonitor();
    }

    public void selectChannel(Channel channel) {
        this.mChannelChooser.selectChannel(channel);
    }

    public void changeFontSize(int offset) {
        if (ProgramPanel.updateFonts(offset)) {
            ChannelPanel.fontChanged();
            ProgramTableScrollPane scrollPane = this.getProgramTableScrollPane();
            scrollPane.forceRepaintAll();
        }
    }

    public void changeColumnWidth(int offset) {
        int columnWidth = ProgramPanel.updateColumnWidth(offset);
        ProgramTableScrollPane scrollPane = this.getProgramTableScrollPane();
        scrollPane.setColumnWidth(columnWidth);
        scrollPane.forceRepaintAll();
    }

    public StatusBar getStatusBar() {
        return this.mStatusBar;
    }

    public boolean isFullScreenMode() {
        return this.isUndecorated();
    }

    public void updatePluginTree() {
        if (this.mPluginView != null) {
            this.mPluginView.refreshTree();
        }
        if (this.mCenterPluginView != null) {
            this.mCenterPluginView.refreshTree();
        }
    }

    private File[] getDragDropPlugins(DataFlavor[] dataFlavors, Transferable transferable) {
        HashSet<File> files = new HashSet<File>();
        for (DataFlavor flavor : dataFlavors) {
            try {
                String name;
                Object data = transferable.getTransferData(flavor);
                if (data instanceof List) {
                    for (Object o : (List)data) {
                        if (!(o instanceof File)) continue;
                        this.addPluginFile((File)o, files);
                    }
                    if (files.isEmpty()) continue;
                    break;
                }
                if (!(data instanceof String) || !(name = ((String)data).trim()).toLowerCase().endsWith("jar")) continue;
                File pluginFile = new File(name);
                if (pluginFile.canRead()) {
                    this.addPluginFile(pluginFile, files);
                    if (files.isEmpty()) continue;
                    break;
                }
                try {
                    URI uri = new URI(name);
                    this.addPluginFile(new File(uri), files);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                if (files.isEmpty()) continue;
                break;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return files.toArray(new File[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPluginFile(File file, HashSet<File> files) {
        if (file.isFile() && file.canRead()) {
            if (file.getName().toLowerCase().endsWith(".jar")) {
                files.add(file);
            } else if (file.getName().toLowerCase().endsWith(".zip")) {
                ZipFile test = null;
                try {
                    test = new ZipFile(file);
                    Enumeration<? extends ZipEntry> entries = test.entries();
                    File tempDir = new File(System.getProperty("java.io.tmpdir"), "tvbinstplugin");
                    tempDir.mkdirs();
                    while (entries.hasMoreElements()) {
                        int size;
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().toLowerCase().endsWith(".jar")) continue;
                        BufferedInputStream bis = new BufferedInputStream(test.getInputStream(entry));
                        byte[] buffer = new byte[2048];
                        File out = new File(tempDir.getAbsolutePath(), entry.getName());
                        if (out.isFile()) {
                            out.delete();
                        }
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out), buffer.length);
                        while ((size = bis.read(buffer, 0, buffer.length)) != -1) {
                            bos.write(buffer, 0, size);
                        }
                        bos.flush();
                        bos.close();
                        bis.close();
                        if (!out.isFile() || !out.canRead()) continue;
                        files.add(out);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (test != null) {
                        try {
                            test.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        File[] files = this.getDragDropPlugins(dtde.getCurrentDataFlavors(), dtde.getTransferable());
        if (files.length > 0) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(dtde.getDropAction());
        File[] files = this.getDragDropPlugins(dtde.getCurrentDataFlavors(), dtde.getTransferable());
        try {
            File tmpFile = File.createTempFile("plugins", ".txt");
            StringBuilder alreadyInstalled = new StringBuilder();
            StringBuilder notCompatiblePlugins = new StringBuilder();
            for (File jarFile : files) {
                URLClassLoader classLoader = null;
                try {
                    URL[] urls = new URL[]{jarFile.toURI().toURL()};
                    classLoader = URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader());
                }
                catch (MalformedURLException urls) {
                    // empty catch block
                }
                if (classLoader == null) continue;
                String pluginName = jarFile.getName();
                pluginName = pluginName.substring(0, pluginName.length() - 4);
                try {
                    String pluginId = "java." + pluginName.toLowerCase() + "." + pluginName;
                    PluginProxy installedPlugin = PluginProxyManager.getInstance().getPluginForId(pluginId);
                    TvDataServiceProxy service = TvDataServiceProxyManager.getInstance().findDataServiceById(pluginName.toLowerCase() + "." + pluginName);
                    Class<?> pluginClass = classLoader.loadClass(pluginName.toLowerCase() + "." + pluginName);
                    Method getVersion = pluginClass.getMethod("getVersion", new Class[0]);
                    Version version1 = null;
                    try {
                        version1 = (Version)getVersion.invoke(pluginClass, new Object[0]);
                    }
                    catch (Throwable t1) {
                        t1.printStackTrace();
                    }
                    if (installedPlugin != null && (installedPlugin.getInfo().getVersion().compareTo(version1) > 0 || installedPlugin.getInfo().getVersion().compareTo(version1) == 0 && version1.isStable())) {
                        alreadyInstalled.append(installedPlugin.getInfo().getName()).append('\n');
                        continue;
                    }
                    if (service != null && (service.getInfo().getVersion().compareTo(version1) > 0 || service.getInfo().getVersion().compareTo(version1) == 0 && version1.isStable())) {
                        alreadyInstalled.append(service.getInfo().getName()).append('\n');
                        continue;
                    }
                    RandomAccessFile write = new RandomAccessFile(tmpFile, "rw");
                    String versionString = Integer.toString(version1.getMajor()) + "." + version1.getMinor() / 10 + version1.getMinor() % 10 + "." + version1.getSubMinor();
                    write.seek(write.length());
                    write.writeBytes("[plugin:" + pluginName + "]\n");
                    write.writeBytes("name_en=" + pluginName + "\n");
                    write.writeBytes("filename=" + jarFile.getName() + "\n");
                    write.writeBytes("version=" + versionString + "\n");
                    write.writeBytes("stable=" + version1.isStable() + "\n");
                    write.writeBytes("download=" + jarFile.toURI().toURL() + "\n");
                    write.writeBytes("category=unknown\n");
                    write.close();
                }
                catch (Exception e) {
                    notCompatiblePlugins.append(jarFile.getName()).append("\n");
                }
            }
            if (alreadyInstalled.length() > 0) {
                this.showInfoTextMessage(LOCALIZER.msg("update.alreadyInstalled", "The following Plugin in current version are already installed:"), alreadyInstalled.toString(), 400);
            }
            if (notCompatiblePlugins.length() > 0) {
                this.showInfoTextMessage(LOCALIZER.msg("update.noTVBPlugin", "This following files are not TV-Browser Plugins:"), notCompatiblePlugins.toString(), 400);
            }
            if (tmpFile.length() > 0L) {
                URL url = tmpFile.toURI().toURL();
                SoftwareUpdater softwareUpdater = new SoftwareUpdater(url, 0, true);
                this.mSoftwareUpdateItems = softwareUpdater.getAvailableSoftwareUpdateItems();
                dtde.dropComplete(true);
                SoftwareUpdateDlg updateDlg = new SoftwareUpdateDlg((Window)this, 3, this.mSoftwareUpdateItems);
                updateDlg.setVisible(true);
            } else {
                dtde.rejectDrop();
                dtde.dropComplete(false);
            }
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private void showInfoTextMessage(String header, String infoText, int width) {
        JTextArea textArea = new JTextArea(infoText);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(width, 150));
        Object[] msg = new Object[]{header, scrollPane};
        JOptionPane.showMessageDialog(this, msg, Localizer.getLocalization("i18n_info"), 1);
    }

    public void updateChannelGroupMenu(JMenu channelGroupMenu) {
        this.mMenuBar.updateChannelGroupMenu(channelGroupMenu);
    }

    public boolean getUserRequestCopyToSystem() {
        return this.mMenuBar.getUserRequestedCopyToSystem();
    }

    @Override
    public void updatePersona() {
        SwingUtilities.invokeLater(() -> {
            this.repaint();
            if (Persona.getInstance().getHeaderImage() != null) {
                this.mCenterTabPane.setUI(this.mPersonaUI);
                if (this.mToolBarPanel != null) {
                    this.mToolBarPanel.setOpaque(false);
                }
                if (this.mSearchField != null) {
                    this.mSearchField.setOpaque(false);
                }
                this.mCenterTabPane.setOpaque(false);
                this.mCenterTabPane.setBackground(new Color(0, 0, 0, 0));
                this.mCenterTabPane.setForeground(Persona.getInstance().getTextColor());
            } else {
                this.mCenterTabPane.setUI(this.mDefaultUI);
                if (this.mToolBarPanel != null) {
                    this.mToolBarPanel.setOpaque(true);
                }
                if (this.mSearchField != null) {
                    this.mSearchField.setOpaque(true);
                }
                this.mCenterTabPane.setOpaque(true);
                this.mCenterTabPane.setBackground(UIManager.getColor("Panel.background"));
                this.mCenterTabPane.setForeground(UIManager.getColor("List.foreground"));
            }
            if (this.mToolBarPanel != null) {
                this.mToolBarPanel.updateUI();
            }
            this.mMenuBar.updatePersona();
            this.mToolBar.updatePersona();
            if (this.mSearchField != null) {
                this.mSearchField.updatePersona();
            }
            this.mTimeChooserPanel.updatePersona();
            this.mStatusBar.updatePersona();
            this.mProgramTableScrollPane.updatePersona();
            this.mFilterPanel.updatePersona();
        });
    }

    public void updateCenterPanels() {
        try {
            PluginCenterPanel[] panels;
            PluginCenterPanelWrapper wrapper;
            this.mCenterPanelWrapperList.clear();
            PluginProxy[] plugins = PluginProxyManager.getInstance().getActivatedPlugins();
            InternalPluginProxyIf[] internalPlugins = InternalPluginProxyList.getInstance().getAvailableProxys();
            ArrayList<PluginCenterPanel> centerPanelList = new ArrayList<PluginCenterPanel>(1);
            centerPanelList.add(this.mScrollPaneWrapper);
            centerPanelList.add(this.mPluginViewWrapper);
            for (PluginProxy plugin : plugins) {
                wrapper = plugin.getPluginCenterPanelWrapper();
                if (wrapper == null) continue;
                this.mCenterPanelWrapperList.add(wrapper);
                try {
                    for (PluginCenterPanel panel : panels = wrapper.getCenterPanels()) {
                        if (panel == null || panel.getPanel() == null || panel.getName() == null || panel.getId() == null) continue;
                        panel.setSettingsId(plugin.getId());
                        panel.setPluginId(plugin.getId());
                        if (panel.getIcon() == null) {
                            panel.setIcon(plugin.getPluginIcon());
                        }
                        centerPanelList.add(panel);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            for (InternalPluginProxyIf internalPlugin : internalPlugins) {
                wrapper = internalPlugin.getPluginCenterPanelWrapper();
                if (wrapper == null) continue;
                this.mCenterPanelWrapperList.add(wrapper);
                try {
                    for (PluginCenterPanel panel : panels = wrapper.getCenterPanels()) {
                        if (panel == null || panel.getPanel() == null || panel.getName() == null || panel.getId() == null) continue;
                        panel.setSettingsId(internalPlugin.getSettingsId());
                        panel.setPluginId(internalPlugin.getId());
                        if (panel.getIcon() == null) {
                            panel.setIcon(internalPlugin.getIcon());
                        }
                        centerPanelList.add(panel);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            ArrayList<PluginCenterPanel> usedCenterPanelList = new ArrayList<PluginCenterPanel>();
            ArrayList<String> enabledCenterPanels = new ArrayList<String>(Arrays.asList(Settings.CenterPanels.CENTER_PANEL_ARR.getStringArray()));
            block10: for (String enabledPanel : enabledCenterPanels) {
                for (int i = 0; i < centerPanelList.size(); ++i) {
                    if (!enabledPanel.equals(((PluginCenterPanel)centerPanelList.get(i)).getId())) continue;
                    usedCenterPanelList.add((PluginCenterPanel)centerPanelList.remove(i));
                    continue block10;
                }
            }
            block12: for (String disabledPanel : Settings.CenterPanels.DISABLED_CENTER_PANEL_ARR.getStringArray()) {
                for (int i = 0; i < centerPanelList.size(); ++i) {
                    if (!disabledPanel.equals(((PluginCenterPanel)centerPanelList.get(i)).getId())) continue;
                    centerPanelList.remove(i);
                    continue block12;
                }
            }
            boolean addNew = false;
            if (!centerPanelList.isEmpty()) {
                for (PluginCenterPanel centerPanel : centerPanelList) {
                    usedCenterPanelList.add(centerPanel);
                }
                addNew = true;
            }
            this.mCenterPanel.removeAll();
            this.mCenterTabPane.removeAll();
            if (usedCenterPanelList.isEmpty()) {
                this.mCenterPanel.add((Component)this.mProgramTableScrollPane, "Center");
            } else if (usedCenterPanelList.size() == 1 && !Settings.CenterPanels.ALWAYS_SHOW_TAB_BAR_FOR_CENTER_PANEL.getBoolean()) {
                this.mCenterPanel.add((Component)((PluginCenterPanel)usedCenterPanelList.get(0)).getPanel(), "Center");
            } else {
                this.mCenterPanel.add((Component)this.mCenterTabPane, "Center");
                ArrayList<String> usedIdList = null;
                if (addNew) {
                    usedIdList = new ArrayList<String>(usedCenterPanelList.size());
                }
                for (PluginCenterPanel panel : usedCenterPanelList) {
                    JPanel jPanel = panel.getPanel();
                    jPanel.setName(panel.getPluginId() + "&&&&" + panel.getSettingsId());
                    Object name = panel.getName();
                    Icon icon = panel.getIcon();
                    String tooltip = null;
                    if (Settings.CenterPanels.TAB_BAR_CENTER_PANEL_NAME_ICON_CONFIG.getInt() == 0) {
                        icon = null;
                    } else if (Settings.CenterPanels.TAB_BAR_CENTER_PANEL_NAME_ICON_CONFIG.getInt() == 1 && icon != null) {
                        tooltip = name;
                        name = null;
                    }
                    if (name != null && icon != null) {
                        name = (String)name + " ";
                    }
                    this.mCenterTabPane.addTab((String)name, icon, jPanel);
                    this.mCenterTabPane.setToolTipTextAt(this.mCenterTabPane.getTabCount() - 1, tooltip);
                    if (!addNew) continue;
                    usedIdList.add(panel.getId());
                }
                if (usedIdList != null && !usedIdList.isEmpty()) {
                    Settings.CenterPanels.CENTER_PANEL_ARR.setStringArray(usedIdList.toArray(new String[usedIdList.size()]));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.mCenterPanel.add((Component)this.mScrollPaneWrapper.getPanel(), "Center");
        }
    }

    public ProgramTableScrollPaneWrapper getProgramTableScrollPaneWrapper() {
        return this.mScrollPaneWrapper;
    }

    public PluginViewWrapper getPluginViewWrapper() {
        return this.mPluginViewWrapper;
    }

    @Override
    public void pluginActivated(PluginProxy plugin) {
        SwingUtilities.invokeLater(() -> this.updateCenterPanels());
    }

    @Override
    public void pluginDeactivated(PluginProxy plugin) {
        if (!MainFrame.isShuttingDown()) {
            SwingUtilities.invokeLater(() -> this.updateCenterPanels());
        }
    }

    @Override
    public void pluginLoaded(PluginProxy plugin) {
    }

    @Override
    public void pluginUnloaded(PluginProxy plugin) {
    }

    public void showProgramTableTabIfAvailable() {
        if (this.mCenterTabPane != null && this.mScrollPaneWrapper != null) {
            int index = this.mCenterTabPane.indexOfComponent(this.mScrollPaneWrapper.getPanel());
            if (index >= 0) {
                this.mCenterTabPane.setSelectedIndex(index);
            } else if (this.mCenterTabPane.getTabCount() > 0) {
                this.mCenterTabPane.setSelectedIndex(0);
            }
        }
    }

    private void scrollThroughTabs(int direction) {
        if (this.mCenterTabPane != null && this.mScrollPaneWrapper != null) {
            int index = this.mCenterTabPane.getSelectedIndex();
            if (direction == 1) {
                if (--index < 0) {
                    index = this.mCenterTabPane.getTabCount() - 1;
                }
            } else if (direction == 2 && ++index >= this.mCenterTabPane.getTabCount()) {
                index = 0;
            }
            if (index != this.mCenterTabPane.getSelectedIndex()) {
                this.mCenterTabPane.setSelectedIndex(index);
            }
        }
    }

    private void showTabForIndex(int index) {
        if (this.mCenterTabPane != null && this.mScrollPaneWrapper != null && index >= 0 && index < this.mCenterTabPane.getTabCount()) {
            this.mCenterTabPane.setSelectedIndex(index);
        }
    }

    @Override
    public void filterAdded(ProgramFilter filter) {
    }

    @Override
    public void filterRemoved(ProgramFilter filter) {
        ProgramFilter current = this.getProgramFilter();
        if (current != null && filter != null && current.equals(filter)) {
            ProgramFilter defaultFilter = FilterManagerImpl.getInstance().getDefaultFilter();
            if (filter.equals(defaultFilter)) {
                defaultFilter = FilterManagerImpl.getInstance().getAllFilter();
            }
            this.setProgramFilter(defaultFilter);
        }
    }

    @Override
    public void filterTouched(ProgramFilter filter) {
        ProgramFilter current = this.getProgramFilter();
        if (current != null && filter != null && current.equals(filter)) {
            this.setProgramFilter(filter);
        }
    }

    @Override
    public void filterTouched(ProgramFilter[] filters) {
        SwingUtilities.invokeLater(() -> {
            ProgramFilter current = this.getProgramFilter();
            if (current != null && filters != null) {
                for (ProgramFilter filter : filters) {
                    if (filter == null || !current.equals(filter)) continue;
                    this.setProgramFilter(filter);
                    break;
                }
            }
        });
    }

    @Override
    public void filterDefaultChanged(ProgramFilter filter) {
        this.updateFilterPanel();
        this.mToolBarModel.setFilterButtonSelected(!this.getProgramFilter().equals(filter));
    }

    public static void updateFilterPanelLabel() {
        if (mSingleton != null) {
            if (MainFrame.mSingleton.mFilterPanel.isVisible() && mSingleton.getProgramFilter() != null) {
                MainFrame.mSingleton.mFilterPanel.updateLabel(mSingleton.getProgramFilter());
            }
            MainFrame.mSingleton.mMenuBar.updateChannelGroupMenu();
        }
    }

    private static void println(String text) {
    }

    static {
        mShuttingDown = false;
        mStarting = true;
    }

    private class BackgroundPanel
    extends JPanel {
        private BackgroundPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (Persona.getInstance().getAccentColor() != null) {
                g.setColor(Persona.getInstance().getAccentColor());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                super.paintComponent(g);
            }
            BufferedImage headerImage = Persona.getInstance().getHeaderImage();
            BufferedImage footerImage = Persona.getInstance().getFooterImage();
            if (headerImage != null) {
                g.drawImage(headerImage, 0, 0, MainFrame.this.jcontentPane.getWidth(), headerImage.getHeight() - (MainFrame.this.mMenuBar.isVisible() ? MainFrame.this.mMenuBar.getHeight() : 0), headerImage.getWidth() - MainFrame.this.jcontentPane.getWidth(), MainFrame.this.mMenuBar.isVisible() ? MainFrame.this.mMenuBar.getHeight() : 0, headerImage.getWidth(), headerImage.getHeight(), null);
            }
            if (footerImage != null) {
                g.drawImage(footerImage, 0, MainFrame.this.jcontentPane.getHeight() - footerImage.getHeight(), footerImage.getWidth(), MainFrame.this.jcontentPane.getHeight(), 0, 0, footerImage.getWidth(), footerImage.getHeight(), null);
            }
        }
    }
}

