/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.finder;

import devplugin.Date;
import devplugin.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import tvbrowser.core.DateListener;
import util.i18n.Localizer;

class FinderItem
extends JComponent
implements ProgressMonitor {
    private Date mDate;
    private JProgressBar mProgressBar;
    private JLabel mLabel;
    private JList<FinderItem> mList;
    private static Color mColorSelected = new Color(236, 236, 212);

    public FinderItem(JList<FinderItem> list, Date date, Date today) {
        this.mDate = date;
        this.mList = list;
        this.mProgressBar = new JProgressBar();
        this.mProgressBar.setForeground(UIManager.getColor("List.selectionBackground"));
        this.mProgressBar.setBorder(null);
        this.mLabel = new JLabel();
        if (date.equals(today.addDays(-1))) {
            this.mLabel.setText(Localizer.getLocalization("i18n_yesterday"));
        } else if (date.equals(today)) {
            this.mLabel.setText(Localizer.getLocalization("i18n_today"));
        } else if (date.equals(today.addDays(1))) {
            this.mLabel.setText(Localizer.getLocalization("i18n_tomorrow"));
        } else {
            this.mLabel.setText(date.getShortDayLongMonthString());
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.mLabel, "Center");
    }

    public Date getDate() {
        return this.mDate;
    }

    public void setChoosen() {
        this.mLabel.setOpaque(true);
        this.mLabel.setBackground(UIManager.getColor("List.selectionBackground"));
        this.mLabel.setForeground(UIManager.getColor("List.selectionForeground"));
    }

    public void setSelected() {
        this.mLabel.setOpaque(true);
        this.mLabel.setBackground(mColorSelected);
    }

    @Override
    public void setOpaque(boolean b) {
        super.setOpaque(b);
        this.mLabel.setOpaque(b);
        this.mLabel.setForeground(UIManager.getColor("List.foreground"));
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.mLabel.setEnabled(b);
    }

    public void startProgress(final DateListener listener, final Runnable callback, final boolean informPluginPanels) {
        if (listener == null) {
            return;
        }
        this.remove(this.mLabel);
        this.add((Component)this.mProgressBar, "Center");
        final FinderItem monitor = this;
        Thread thread = new Thread("Finder"){

            @Override
            public void run() {
                listener.dateChanged(FinderItem.this.mDate, monitor, callback, informPluginPanels);
                FinderItem.this.stopProgress();
            }
        };
        thread.start();
    }

    public void stopProgress() {
        this.remove(this.mProgressBar);
        this.add((Component)this.mLabel, "Center");
        this.mList.repaint();
    }

    @Override
    public void setMaximum(int maximum) {
        this.mProgressBar.setMaximum(maximum);
    }

    @Override
    public void setValue(int value) {
        this.mProgressBar.setValue(value);
        this.mList.repaint();
    }

    @Override
    public void setMessage(String msg) {
    }
}

