/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.settings;

import java.awt.Font;
import util.settings.FontProperty;
import util.settings.PropertyManager;

public class DeferredFontProperty
extends FontProperty {
    private static final String[] KNOWN_GOOD_FONTS = new String[]{"Tahoma", "Trebuchet MS", "Arial Narrow"};
    private Font mDefFont;
    private Font mCachedValue;

    public DeferredFontProperty(PropertyManager manager, String key, Font defaultFont) {
        super(manager, key, defaultFont);
        this.mDefFont = defaultFont;
    }

    public void resetDefault() {
        this.mCachedValue = null;
    }

    @Override
    public Font getDefault() {
        if (this.mCachedValue == null) {
            for (String knownFont : KNOWN_GOOD_FONTS) {
                Font font = new Font(knownFont, this.mDefFont.getStyle(), this.mDefFont.getSize());
                if (font == null || font.getName().startsWith("Dialog")) continue;
                this.mCachedValue = font;
                break;
            }
        }
        if (this.mCachedValue == null) {
            this.mCachedValue = this.mDefFont;
        }
        return this.mCachedValue;
    }
}

