/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.plugin.programformating;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.programformating.GlobalPluginProgramFormating;
import util.i18n.Localizer;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;

public class GlobalPluginProgramFormatingManager {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(GlobalPluginProgramFormatingManager.class);
    private static GlobalPluginProgramFormatingManager mInstance;
    private GlobalPluginProgramFormating[] mAvailableProgramConfigurations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlobalPluginProgramFormatingManager() {
        mInstance = this;
        ObjectInputStream in = null;
        try {
            File programConfigFile = new File(Settings.getUserSettingsDirName(), "programConfigurations.dat");
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(programConfigFile), 4096));
            in.readInt();
            this.mAvailableProgramConfigurations = new GlobalPluginProgramFormating[in.readInt()];
            for (int i = 0; i < this.mAvailableProgramConfigurations.length; ++i) {
                this.mAvailableProgramConfigurations[i] = GlobalPluginProgramFormating.load(in);
            }
        }
        catch (Exception e) {
            this.mAvailableProgramConfigurations = new GlobalPluginProgramFormating[2];
            this.mAvailableProgramConfigurations[0] = GlobalPluginProgramFormatingManager.getDefaultConfiguration();
            new Thread("Plugin formating creation"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    GlobalPluginProgramFormatingManager.this.mAvailableProgramConfigurations[1] = GlobalPluginProgramFormatingManager.getTvPearlFormating();
                    GlobalPluginProgramFormatingManager.this.store();
                }
            }.start();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static GlobalPluginProgramFormatingManager getInstance() {
        if (mInstance == null) {
            new GlobalPluginProgramFormatingManager();
        }
        return mInstance;
    }

    public GlobalPluginProgramFormating[] getAvailableGlobalPluginProgramFormatings() {
        return this.mAvailableProgramConfigurations;
    }

    public void setAvailableProgramConfigurations(GlobalPluginProgramFormating[] configs) {
        this.mAvailableProgramConfigurations = configs;
    }

    public void store() {
        File programConfigFile = new File(Settings.getUserSettingsDirName(), "programConfigurations.dat");
        StreamUtilities.objectOutputStreamIgnoringExceptions(programConfigFile, new ObjectOutputStreamProcessor(){

            @Override
            public void process(ObjectOutputStream out) throws IOException {
                out.writeInt(1);
                out.writeInt(GlobalPluginProgramFormatingManager.this.mAvailableProgramConfigurations.length);
                for (GlobalPluginProgramFormating config : GlobalPluginProgramFormatingManager.this.mAvailableProgramConfigurations) {
                    config.store(out);
                }
                out.close();
            }
        });
    }

    public static GlobalPluginProgramFormating getDefaultConfiguration() {
        return new GlobalPluginProgramFormating(mLocalizer.msg("default", "Default"), "{title}", "{channel_name} - {title}\n{leadingZero(start_day,\"2\")}.{leadingZero(start_month,\"2\")}.{start_year} {leadingZero(start_hour,\"2\")}:{leadingZero(start_minute,\"2\")}-{leadingZero(end_hour,\"2\")}:{leadingZero(end_minute,\"2\")}\n\n{splitAt(short_info,\"78\")}\n\n", "UTF-8");
    }

    public static GlobalPluginProgramFormating getTvPearlFormating() {
        return new GlobalPluginProgramFormating(mLocalizer.msg("tvPearl", "TV Pearl"), "{title}", "{start_day_of_week}, {start_day}. {start_month_name}, {leadingZero(start_hour,\"2\")}:{leadingZero(start_minute,\"2\")}, {channel_name}\n{title}\n\n{genre}", "UTF-8");
    }

    protected GlobalPluginProgramFormating getConfigurationForId(String id) {
        for (GlobalPluginProgramFormating config : this.mAvailableProgramConfigurations) {
            if (!config.hasId(id)) continue;
            return config;
        }
        return null;
    }

    public GlobalPluginProgramFormating getFormatingInstanceForInstance(GlobalPluginProgramFormating formating) {
        for (GlobalPluginProgramFormating config : this.mAvailableProgramConfigurations) {
            if (!config.equals(formating)) continue;
            return config;
        }
        return null;
    }
}

