/*
 * Decompiled with CFR 0.152.
 */
package util.programkeyevent;

import compat.VersionCompat;
import devplugin.ContextMenuIf;
import devplugin.Program;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import tvbrowser.core.Settings;
import util.programkeyevent.ProgramKeyAndContextMenuListener;
import util.programmouseevent.ProgramMouseEventHandler;
import util.settings.ContextMenuMouseActionSetting;

public class ProgramKeyEventHandler
extends KeyAdapter {
    public static final int LEFT_SINGLE_KEY = 76;
    public static final int LEFT_DOUBLE_KEY = 68;
    public static final int MIDDLE_SINGLE_KEY = 77;
    public static final int MIDDLE_DOUBLE_KEY = 85;
    private ProgramKeyAndContextMenuListener mContextMenuListener;
    private ContextMenuIf mOwner;

    public ProgramKeyEventHandler(ProgramKeyAndContextMenuListener listener, ContextMenuIf owner) {
        this.mContextMenuListener = listener;
        this.mOwner = owner;
    }

    private void handleKeyEventFor(ContextMenuMouseActionSetting[] mouseActionSettings, KeyEvent e, Program program) {
        ContextMenuMouseActionSetting[] contextMenuMouseActionSettingArray = mouseActionSettings;
        int n = mouseActionSettings.length;
        int n2 = 0;
        while (n2 < n) {
            ContextMenuMouseActionSetting setting = contextMenuMouseActionSettingArray[n2];
            if (setting.getModifiersEx() == e.getModifiersEx()) {
                if (setting.getContextMenuIf() == this.mOwner) break;
                ProgramMouseEventHandler.handleAction(program, setting.getContextMenuIf().getContextMenuActions(program), setting.getContextMenuActionId());
                break;
            }
            ++n2;
        }
    }

    private static ContextMenuMouseActionSetting[] getSettingFor(String property) {
        ContextMenuMouseActionSetting[] result = new ContextMenuMouseActionSetting[]{};
        try {
            Class<Settings> clazz = Settings.class;
            Field prop = clazz.getDeclaredField(property);
            Object propObj = prop.get(clazz);
            Method m = propObj.getClass().getDeclaredMethod("getContextMenuMouseActionArray", new Class[0]);
            result = (ContextMenuMouseActionSetting[])m.invoke(propObj, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 76 || e.getKeyCode() == 77 || e.getKeyCode() == 68 || e.getKeyCode() == 85 || e.getKeyCode() == 525 || e.getKeyCode() == 82) {
            Program program = this.mContextMenuListener.getProgramForKeyEvent(e);
            if (program != null) {
                if (e.getKeyCode() == 525 || e.getKeyCode() == 82) {
                    this.mContextMenuListener.showContextMenu(program);
                } else if (e.getKeyCode() == 76) {
                    ContextMenuMouseActionSetting[] actionSetting = null;
                    actionSetting = VersionCompat.isExtendedMouseActionSupported() ? ProgramKeyEventHandler.getSettingFor("propLeftSingleClickIfArray") : ((e.getModifiersEx() & 0x80) == 128 ? new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(128, Settings.propLeftSingleCtrlClickIf.getString(), -1)} : new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, Settings.propLeftSingleClickIf.getString(), -1)});
                    this.handleKeyEventFor(actionSetting, e, program);
                } else if (e.getKeyCode() == 77) {
                    ContextMenuMouseActionSetting[] actionSetting = null;
                    actionSetting = VersionCompat.isExtendedMouseActionSupported() ? ProgramKeyEventHandler.getSettingFor("propMiddleSingleClickIfArray") : new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, Settings.propMiddleClickIf.getString(), -1)};
                    this.handleKeyEventFor(actionSetting, e, program);
                } else if (e.getKeyCode() == 68) {
                    ContextMenuMouseActionSetting[] actionSetting = null;
                    actionSetting = VersionCompat.isExtendedMouseActionSupported() ? ProgramKeyEventHandler.getSettingFor("propLeftDoubleClickIfArray") : new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, Settings.propDoubleClickIf.getString(), -1)};
                    this.handleKeyEventFor(actionSetting, e, program);
                } else if (e.getKeyCode() == 85) {
                    ContextMenuMouseActionSetting[] actionSetting = null;
                    actionSetting = VersionCompat.isExtendedMouseActionSupported() ? ProgramKeyEventHandler.getSettingFor("propMiddleDoubleClickIfArray") : new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, Settings.propMiddleDoubleClickIf.getString(), -1)};
                    this.handleKeyEventFor(actionSetting, e, program);
                }
            }
            this.mContextMenuListener.keyEventActionFinished();
            e.consume();
        }
    }
}

