#!/bin/sh
# the next line restarts using the interpreter \
exec wish "$0" "$@"

array set source {
    notebook notebood.src
    arrowButton arrowbud.src
    comboButton combobud.src
    comboEntry comboend.src
    scrollList scrolisd.src
    scroll scrolld.src
    scroller scrolled.src
    widgetTip widgetid.src
    spinEntry spinentd.src
    labelledFrame labelfrd.src
    panner pannerd.src
    optionMenu optimend.src
}

proc launch {class} {                                                    ;# launch configuration and test script for specified class
    global source

    .$class configure -state disabled                      ;# disable corresponding button so that same window does not appear twice
    set interpreter [interp create]
    load {} Tk $interpreter                                                                              ;# obviously Tk is required
    $interpreter alias exit eval "interp delete $interpreter; .$class configure -state normal"               ;# self destroy on exit
    $interpreter eval wm title . $class
    $interpreter eval wm protocol . WM_DELETE_WINDOW exit                       ;# exit when window is closed through window manager
    $interpreter eval source $source($class)                                                                   ;# source test script
}

wm protocol . WM_DELETE_WINDOW exit                                 ;# so that all interpreters are deleted when closing main window

message .message -aspect 500 -font {Helvetica 12 normal} -text {click on any button below to launch sample configuration window for specified class}
pack .message -fill x

foreach class {
    arrowButton comboButton comboEntry labelledFrame notebook optionMenu panner scroll scroller scrollList spinEntry widgetTip
} {
    set button [button .$class -text $class -command "launch $class"]
    pack $button -fill x
}
