/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CallBlock
extends BlockBody {
    private final Arity arity;
    private final BlockCallback callback;
    private final StaticScope dummyScope;

    public static Block newCallClosure(IRubyObject self2, RubyModule imClass, Arity arity2, BlockCallback callback, ThreadContext context) {
        Binding binding2 = context.currentBinding(self2, Visibility.PUBLIC);
        CallBlock body = new CallBlock(arity2, callback, context);
        return new Block(body, binding2);
    }

    private CallBlock(Arity arity2, BlockCallback callback, ThreadContext context) {
        super(3);
        this.arity = arity2;
        this.callback = callback;
        this.dummyScope = context.runtime.getStaticScopeFactory().getDummyScope();
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.callback.call(context, args2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        return this.callback.call(context, args2, block);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.callback.call(context, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.callback.call(context, new IRubyObject[]{arg0}, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yield(context, new IRubyObject[]{arg0, arg1}, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yield(context, new IRubyObject[]{arg0, arg1, arg2}, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.callback.call(context, new IRubyObject[]{value2}, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self2, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        IRubyObject[] iRubyObjectArray;
        if (value2.respondsTo("to_a")) {
            iRubyObjectArray = value2.convertToArray().toJavaArray();
        } else {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = value2;
        }
        IRubyObject[] args2 = iRubyObjectArray;
        return this.yield(context, args2, Block.NULL_BLOCK);
    }

    private IRubyObject yield(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject[] preppedArgs = RubyProc.prepareProcArgs(context, this.arity(), args2);
        return this.callback.call(context, preppedArgs, Block.NULL_BLOCK);
    }

    @Override
    public StaticScope getStaticScope() {
        return this.dummyScope;
    }

    @Override
    public void setStaticScope(StaticScope newScope) {
    }

    @Override
    public Block cloneBlock(Binding binding2) {
        return new Block(this, binding2.clone());
    }

    @Override
    public Arity arity() {
        return this.arity;
    }

    @Override
    public String getFile() {
        return "(internal)";
    }

    @Override
    public int getLine() {
        return -1;
    }
}

