/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pantsbuild.jarjar.ExcludeProcessor;
import org.pantsbuild.jarjar.Keep;
import org.pantsbuild.jarjar.KeepProcessor;
import org.pantsbuild.jarjar.ManifestProcessor;
import org.pantsbuild.jarjar.PackageRemapper;
import org.pantsbuild.jarjar.PatternElement;
import org.pantsbuild.jarjar.ResourceProcessor;
import org.pantsbuild.jarjar.Rule;
import org.pantsbuild.jarjar.Zap;
import org.pantsbuild.jarjar.ZapProcessor;
import org.pantsbuild.jarjar.misplaced.MisplacedClassProcessor;
import org.pantsbuild.jarjar.misplaced.MisplacedClassProcessorFactory;
import org.pantsbuild.jarjar.util.EntryStruct;
import org.pantsbuild.jarjar.util.JarProcessor;
import org.pantsbuild.jarjar.util.JarProcessorChain;
import org.pantsbuild.jarjar.util.JarTransformerChain;
import org.pantsbuild.jarjar.util.RemappingClassTransformer;
import org.pantsbuild.jarjar.util.StandaloneJarProcessor;

class MainProcessor
implements JarProcessor {
    private final boolean verbose;
    private final JarProcessorChain chain;
    private final KeepProcessor kp;
    private final Map<String, String> renames = new HashMap<String, String>();

    public MainProcessor(List<PatternElement> patterns, boolean verbose, boolean skipManifest) {
        this(patterns, verbose, skipManifest, null);
    }

    public MainProcessor(List<PatternElement> patterns, boolean verbose, boolean skipManifest, String misplacedClassStrategy) {
        this.verbose = verbose;
        ArrayList<Zap> zapList = new ArrayList<Zap>();
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        ArrayList<Keep> keepList = new ArrayList<Keep>();
        for (PatternElement pattern : patterns) {
            if (pattern instanceof Zap) {
                zapList.add((Zap)pattern);
                continue;
            }
            if (pattern instanceof Rule) {
                ruleList.add((Rule)pattern);
                continue;
            }
            if (!(pattern instanceof Keep)) continue;
            keepList.add((Keep)pattern);
        }
        PackageRemapper pr = new PackageRemapper(ruleList, verbose);
        this.kp = keepList.isEmpty() ? null : new KeepProcessor(keepList);
        ArrayList<JarProcessor> processors = new ArrayList<JarProcessor>();
        if (skipManifest) {
            processors.add(ManifestProcessor.getInstance());
        }
        if (this.kp != null) {
            processors.add(this.kp);
        }
        MisplacedClassProcessor misplacedClassProcessor = MisplacedClassProcessorFactory.getInstance().getProcessorForName(misplacedClassStrategy);
        processors.add(new ZapProcessor(zapList));
        processors.add(misplacedClassProcessor);
        processors.add(new JarTransformerChain(new RemappingClassTransformer[]{new RemappingClassTransformer(pr)}));
        processors.add(new ResourceProcessor(pr));
        this.chain = new JarProcessorChain(processors.toArray(new JarProcessor[processors.size()]));
    }

    public void strip(File file) throws IOException {
        if (this.kp == null) {
            return;
        }
        Set<String> excludes = this.getExcludes();
        if (!excludes.isEmpty()) {
            StandaloneJarProcessor.run(file, file, new ExcludeProcessor(excludes, this.verbose));
        }
    }

    private Set<String> getExcludes() {
        HashSet<String> result = new HashSet<String>();
        for (String exclude : this.kp.getExcludes()) {
            String name = exclude + ".class";
            String renamed = this.renames.get(name);
            result.add(renamed != null ? renamed : name);
        }
        return result;
    }

    @Override
    public boolean process(EntryStruct struct) throws IOException {
        String name = struct.name;
        boolean keepIt = this.chain.process(struct);
        if (keepIt) {
            if (!name.equals(struct.name)) {
                if (this.kp != null) {
                    this.renames.put(name, struct.name);
                }
                if (this.verbose) {
                    System.err.println("Renamed " + name + " -> " + struct.name);
                }
            }
        } else if (this.verbose) {
            System.err.println("Removed " + name);
        }
        return keepIt;
    }
}

