/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.IOException;
import java.util.Map;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.pantsbuild.jarjar.DepHandler;
import org.pantsbuild.jarjar.PathClass;
import org.pantsbuild.jarjar.util.RuntimeIOException;

class DepFindVisitor
extends RemappingClassAdapter {
    public DepFindVisitor(Map<String, String> classes, String source, DepHandler handler) throws IOException {
        super(null, (Remapper)new DepFindRemapper(classes, source, handler));
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        ((DepFindRemapper)this.remapper).setClassName(name);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    private static class DepFindRemapper
    extends Remapper {
        private final Map<String, String> classes;
        private final String source;
        private final DepHandler handler;
        private PathClass curPathClass;

        public DepFindRemapper(Map<String, String> classes, String source, DepHandler handler) throws IOException {
            this.classes = classes;
            this.source = source;
            this.handler = handler;
        }

        public void setClassName(String name) {
            this.curPathClass = new PathClass(this.source, name);
        }

        public String map(String key) {
            try {
                String otherSource;
                if (this.classes.containsKey(key) && !this.source.equals(otherSource = this.classes.get(key))) {
                    this.handler.handle(this.curPathClass, new PathClass(otherSource, key));
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            return null;
        }
    }
}

