/******************************************************************************
 * The MIT License (MIT)
 *
 * Copyright (c) 2019-2024 Baldur Karlsson
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

#include "d3d12_common.h"
#include "d3d12_resources.h"

template <>
rdcstr DoStringise(const D3D12Chunk &el)
{
  RDCCOMPILE_ASSERT((uint32_t)D3D12Chunk::Max == 1137, "Chunks changed without updating names");

  BEGIN_ENUM_STRINGISE(D3D12Chunk)
  {
    STRINGISE_ENUM_CLASS_NAMED(SetName, "ID3D12Resource::SetName");
    STRINGISE_ENUM_CLASS_NAMED(PushMarker, "ID3D12GraphicsCommandList::BeginEvent");
    STRINGISE_ENUM_CLASS_NAMED(SetMarker, "ID3D12GraphicsCommandList::SetMarker");
    STRINGISE_ENUM_CLASS_NAMED(PopMarker, "ID3D12GraphicsCommandList::EndEvent");
    STRINGISE_ENUM_CLASS_NAMED(SetShaderDebugPath, "Internal::SetShaderDebugPath");
    STRINGISE_ENUM_CLASS_NAMED(CreateSwapBuffer, "IDXGISwapChain::GetBuffer");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateCommandQueue, "ID3D12Device::CreateCommandQueue");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateCommandAllocator,
                               "ID3D12Device::CreateCommandAllocator");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateCommandList, "ID3D12Device::CreateCommandList");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateGraphicsPipeline,
                               "ID3D12Device::CreateGraphicsPipeline");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateComputePipeline, "ID3D12Device::CreateComputePipeline");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateDescriptorHeap, "ID3D12Device::CreateDescriptorHeap");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateRootSignature, "ID3D12Device::CreateRootSignature");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateCommandSignature,
                               "ID3D12Device::CreateCommandSignature");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateHeap, "ID3D12Device::CreateHeap");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateCommittedResource,
                               "ID3D12Device::CreateCommittedResource");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreatePlacedResource, "ID3D12Device::CreatePlacedResource");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateQueryHeap, "ID3D12Device::CreateQueryHeap");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateFence, "ID3D12Device::CreateFence");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateReservedResource,
                               "ID3D12Device::CreateReservedResource");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateConstantBufferView,
                               "ID3D12Device::CreateConstantBufferView");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateShaderResourceView,
                               "ID3D12Device::CreateShaderResourceView");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateUnorderedAccessView,
                               "ID3D12Device::CreateUnorderedAccessView");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateRenderTargetView,
                               "ID3D12Device::CreateRenderTargetView");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateDepthStencilView,
                               "ID3D12Device::CreateDepthStencilView");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateSampler, "ID3D12Device::CreateSampler");
    STRINGISE_ENUM_CLASS_NAMED(Device_CopyDescriptors, "ID3D12Device::CopyDescriptors");
    STRINGISE_ENUM_CLASS_NAMED(Device_CopyDescriptorsSimple, "ID3D12Device::CopyDescriptorsSimple");
    STRINGISE_ENUM_CLASS_NAMED(Device_OpenSharedHandle, "ID3D12Device::OpenSharedHandle");
    STRINGISE_ENUM_CLASS_NAMED(Queue_ExecuteCommandLists,
                               "ID3D12CommandQueue::ExecuteCommandLists");
    STRINGISE_ENUM_CLASS_NAMED(Queue_Signal, "ID3D12CommandQueue::Signal");
    STRINGISE_ENUM_CLASS_NAMED(Queue_Wait, "ID3D12CommandQueue::Wait");
    STRINGISE_ENUM_CLASS_NAMED(Queue_UpdateTileMappings, "ID3D12CommandQueue::UpdateTileMappings");
    STRINGISE_ENUM_CLASS_NAMED(Queue_CopyTileMappings, "ID3D12CommandQueue::CopyTileMappings");
    STRINGISE_ENUM_CLASS_NAMED(List_Close, "ID3D12GraphicsCommandList::Close");
    STRINGISE_ENUM_CLASS_NAMED(List_Reset, "ID3D12GraphicsCommandList::Reset");
    STRINGISE_ENUM_CLASS_NAMED(List_ResourceBarrier, "ID3D12GraphicsCommandList::ResourceBarrier");
    STRINGISE_ENUM_CLASS_NAMED(List_BeginQuery, "ID3D12GraphicsCommandList::BeginQuery");
    STRINGISE_ENUM_CLASS_NAMED(List_EndQuery, "ID3D12GraphicsCommandList::EndQuery");
    STRINGISE_ENUM_CLASS_NAMED(List_ResolveQueryData,
                               "ID3D12GraphicsCommandList::ResolveQueryData");
    STRINGISE_ENUM_CLASS_NAMED(List_SetPredication, "ID3D12GraphicsCommandList::SetPredication");
    STRINGISE_ENUM_CLASS_NAMED(List_DrawIndexedInstanced,
                               "ID3D12GraphicsCommandList::DrawIndexedInstanced");
    STRINGISE_ENUM_CLASS_NAMED(List_DrawInstanced, "ID3D12GraphicsCommandList::DrawInstanced");
    STRINGISE_ENUM_CLASS_NAMED(List_Dispatch, "ID3D12GraphicsCommandList::Dispatch");
    STRINGISE_ENUM_CLASS_NAMED(List_ExecuteIndirect, "ID3D12GraphicsCommandList::ExecuteIndirect");
    STRINGISE_ENUM_CLASS_NAMED(List_ExecuteBundle, "ID3D12GraphicsCommandList::ExecuteBundle");
    STRINGISE_ENUM_CLASS_NAMED(List_CopyBufferRegion,
                               "ID3D12GraphicsCommandList::CopyBufferRegion");
    STRINGISE_ENUM_CLASS_NAMED(List_CopyTextureRegion,
                               "ID3D12GraphicsCommandList::CopyTextureRegion");
    STRINGISE_ENUM_CLASS_NAMED(List_CopyResource, "ID3D12GraphicsCommandList::CopyResource");
    STRINGISE_ENUM_CLASS_NAMED(List_ResolveSubresource,
                               "ID3D12GraphicsCommandList::ResolveSubresource");
    STRINGISE_ENUM_CLASS_NAMED(List_ClearRenderTargetView,
                               "ID3D12GraphicsCommandList::ClearRenderTargetView");
    STRINGISE_ENUM_CLASS_NAMED(List_ClearDepthStencilView,
                               "ID3D12GraphicsCommandList::ClearDepthStencilView");
    STRINGISE_ENUM_CLASS_NAMED(List_ClearUnorderedAccessViewUint,
                               "ID3D12GraphicsCommandList::ClearUnorderedAccessViewUint");
    STRINGISE_ENUM_CLASS_NAMED(List_ClearUnorderedAccessViewFloat,
                               "ID3D12GraphicsCommandList::ClearUnorderedAccessViewFloat");
    STRINGISE_ENUM_CLASS_NAMED(List_DiscardResource, "ID3D12GraphicsCommandList::DiscardResource");
    STRINGISE_ENUM_CLASS_NAMED(List_IASetPrimitiveTopology,
                               "ID3D12GraphicsCommandList::IASetPrimitiveTopology");
    STRINGISE_ENUM_CLASS_NAMED(List_IASetIndexBuffer,
                               "ID3D12GraphicsCommandList::IASetIndexBuffer");
    STRINGISE_ENUM_CLASS_NAMED(List_IASetVertexBuffers,
                               "ID3D12GraphicsCommandList::IASetVertexBuffers");
    STRINGISE_ENUM_CLASS_NAMED(List_SOSetTargets, "ID3D12GraphicsCommandList::SOSetTargets");
    STRINGISE_ENUM_CLASS_NAMED(List_RSSetViewports, "ID3D12GraphicsCommandList::RSSetViewports");
    STRINGISE_ENUM_CLASS_NAMED(List_RSSetScissorRects,
                               "ID3D12GraphicsCommandList::RSSetScissorRects");
    STRINGISE_ENUM_CLASS_NAMED(List_SetPipelineState,
                               "ID3D12GraphicsCommandList::SetPipelineState");
    STRINGISE_ENUM_CLASS_NAMED(List_SetDescriptorHeaps,
                               "ID3D12GraphicsCommandList::SetDescriptorHeaps");
    STRINGISE_ENUM_CLASS_NAMED(List_OMSetRenderTargets,
                               "ID3D12GraphicsCommandList::OMSetRenderTargets");
    STRINGISE_ENUM_CLASS_NAMED(List_OMSetStencilRef, "ID3D12GraphicsCommandList::OMSetStencilRef");
    STRINGISE_ENUM_CLASS_NAMED(List_OMSetBlendFactor,
                               "ID3D12GraphicsCommandList::OMSetBlendFactor");
    STRINGISE_ENUM_CLASS_NAMED(List_SetGraphicsRootDescriptorTable,
                               "ID3D12GraphicsCommandList::SetGraphicsRootDescriptorTable");
    STRINGISE_ENUM_CLASS_NAMED(List_SetGraphicsRootSignature,
                               "ID3D12GraphicsCommandList::SetGraphicsRootSignature");
    STRINGISE_ENUM_CLASS_NAMED(List_SetGraphicsRoot32BitConstant,
                               "ID3D12GraphicsCommandList::SetGraphicsRoot32BitConstant");
    STRINGISE_ENUM_CLASS_NAMED(List_SetGraphicsRoot32BitConstants,
                               "ID3D12GraphicsCommandList::SetGraphicsRoot32BitConstants");
    STRINGISE_ENUM_CLASS_NAMED(List_SetGraphicsRootConstantBufferView,
                               "ID3D12GraphicsCommandList::SetGraphicsRootConstantBufferView");
    STRINGISE_ENUM_CLASS_NAMED(List_SetGraphicsRootShaderResourceView,
                               "ID3D12GraphicsCommandList::SetGraphicsRootShaderResourceView");
    STRINGISE_ENUM_CLASS_NAMED(List_SetGraphicsRootUnorderedAccessView,
                               "ID3D12GraphicsCommandList::SetGraphicsRootUnorderedAccessView");
    STRINGISE_ENUM_CLASS_NAMED(List_SetComputeRootDescriptorTable,
                               "ID3D12GraphicsCommandList::SetComputeRootDescriptorTable");
    STRINGISE_ENUM_CLASS_NAMED(List_SetComputeRootSignature,
                               "ID3D12GraphicsCommandList::SetComputeRootSignature");
    STRINGISE_ENUM_CLASS_NAMED(List_SetComputeRoot32BitConstant,
                               "ID3D12GraphicsCommandList::SetComputeRoot32BitConstant");
    STRINGISE_ENUM_CLASS_NAMED(List_SetComputeRoot32BitConstants,
                               "ID3D12GraphicsCommandList::SetComputeRoot32BitConstants");
    STRINGISE_ENUM_CLASS_NAMED(List_SetComputeRootConstantBufferView,
                               "ID3D12GraphicsCommandList::SetComputeRootConstantBufferView");
    STRINGISE_ENUM_CLASS_NAMED(List_SetComputeRootShaderResourceView,
                               "ID3D12GraphicsCommandList::SetComputeRootShaderResourceView");
    STRINGISE_ENUM_CLASS_NAMED(List_SetComputeRootUnorderedAccessView,
                               "ID3D12GraphicsCommandList::SetComputeRootUnorderedAccessView");
    STRINGISE_ENUM_CLASS_NAMED(List_CopyTiles, "ID3D12GraphicsCommandList::CopyTiles");
    STRINGISE_ENUM_CLASS_NAMED(Resource_Unmap, "ID3D12Resource::Unmap");
    STRINGISE_ENUM_CLASS_NAMED(Resource_WriteToSubresource, "ID3D12Resource::WriteToSubresource");
    STRINGISE_ENUM_CLASS_NAMED(List_IndirectSubCommand, "Indirect Sub-command");
    STRINGISE_ENUM_CLASS_NAMED(Queue_BeginEvent, "ID3D12CommandQueue::BeginEvent");
    STRINGISE_ENUM_CLASS_NAMED(Queue_SetMarker, "ID3D12CommandQueue::SetMarker");
    STRINGISE_ENUM_CLASS_NAMED(Queue_EndEvent, "ID3D12CommandQueue::EndEvent");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreatePipelineState, "ID3D12Device2::CreatePipelineState");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateHeapFromAddress,
                               "ID3D12Device3::OpenExistingHeapFromAddress");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateHeapFromFileMapping,
                               "ID3D12Device3::OpenExistingHeapFromFileMapping");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateCommandList1, "ID3D12Device4::CreateCommandList1");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateCommittedResource1,
                               "ID3D12Device4::CreateCommittedResource1");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateHeap1, "ID3D12Device4::CreateHeap1");
    STRINGISE_ENUM_CLASS_NAMED(List_AtomicCopyBufferUINT,
                               "ID3D12GraphicsCommandList1::AtomicCopyBufferUINT");
    STRINGISE_ENUM_CLASS_NAMED(List_AtomicCopyBufferUINT64,
                               "ID3D12GraphicsCommandList1::AtomicCopyBufferUINT64");
    STRINGISE_ENUM_CLASS_NAMED(List_OMSetDepthBounds,
                               "ID3D12GraphicsCommandList1::OMSetDepthBounds");
    STRINGISE_ENUM_CLASS_NAMED(List_ResolveSubresourceRegion,
                               "ID3D12GraphicsCommandList1::ResolveSubresourceRegion");
    STRINGISE_ENUM_CLASS_NAMED(List_SetSamplePositions,
                               "ID3D12GraphicsCommandList1::SetSamplePositions");
    STRINGISE_ENUM_CLASS_NAMED(List_SetViewInstanceMask,
                               "ID3D12GraphicsCommandList1::SetViewInstanceMask");
    STRINGISE_ENUM_CLASS_NAMED(List_WriteBufferImmediate,
                               "ID3D12GraphicsCommandList2::WriteBufferImmediate");
    STRINGISE_ENUM_CLASS_NAMED(List_BeginRenderPass, "ID3D12GraphicsCommandList4::BeginRenderPass");
    STRINGISE_ENUM_CLASS_NAMED(List_EndRenderPass, "ID3D12GraphicsCommandList4::EndRenderPass");
    STRINGISE_ENUM_CLASS_NAMED(List_RSSetShadingRate,
                               "ID3D12GraphicsCommandList5::RSSetShadingRate");
    STRINGISE_ENUM_CLASS_NAMED(List_RSSetShadingRateImage,
                               "ID3D12GraphicsCommandList5::RSSetShadingRateImage");
    STRINGISE_ENUM_CLASS_NAMED(Device_ExternalDXGIResource, "External DXGI Resource import");
    STRINGISE_ENUM_CLASS_NAMED(Swapchain_Present, "IDXGISwapChain::Present");
    STRINGISE_ENUM_CLASS_NAMED(List_ClearState, "ID3D12GraphicsCommandList::ClearState");
    STRINGISE_ENUM_CLASS_NAMED(CompatDevice_CreateSharedResource,
                               "ID3D12CompatibilityDevice::CreateSharedResource");
    STRINGISE_ENUM_CLASS_NAMED(CompatDevice_CreateSharedHeap,
                               "ID3D12CompatibilityDevice::CreateSharedHeap");
    STRINGISE_ENUM_CLASS_NAMED(SetShaderExtUAV, "Vendor Extension: Set magic shader UAV slot");

    STRINGISE_ENUM_CLASS_NAMED(Device_CreateCommittedResource2,
                               "ID3D12Device8::CreateCommittedResource2");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreatePlacedResource1,
                               "ID3D12Device8::CreatePlacedResource1");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateCommandQueue1, "ID3D12Device9::CreateCommandQueue1");
    STRINGISE_ENUM_CLASS_NAMED(CoherentMapWrite, "Internal::Coherent Mapped Memory Write");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateSampler2, "ID3D12Device11::CreateSampler2");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateCommittedResource3,
                               "ID3D12Device10::Device_CreateCommittedResource3");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreatePlacedResource2,
                               "ID3D12Device10::Device_CreatePlacedResource2");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateReservedResource1,
                               "ID3D12Device4::Device_CreateReservedResource1");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateReservedResource2,
                               "ID3D12Device10::Device_CreateReservedResource2");
    STRINGISE_ENUM_CLASS_NAMED(List_OMSetFrontAndBackStencilRef,
                               "ID3D12GraphicsCommandList8::OMSetFrontAndBackStencilRef");
    STRINGISE_ENUM_CLASS_NAMED(List_RSSetDepthBias, "ID3D12GraphicsCommandList9::RSSetDepthBias");
    STRINGISE_ENUM_CLASS_NAMED(List_IASetIndexBufferStripCutValue,
                               "ID3D12GraphicsCommandList9::IASetIndexBufferStripCutValue");
    STRINGISE_ENUM_CLASS_NAMED(List_Barrier, "ID3D12GraphicsCommandList7::Barrier");
    STRINGISE_ENUM_CLASS_NAMED(List_DispatchMesh, "ID3D12GraphicsCommandList6::DispatchMesh");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateStateObject, "ID3D12Device5::CreateStateObject");
    STRINGISE_ENUM_CLASS_NAMED(Device_AddToStateObject, "ID3D12Device7::AddToStateObject");
    STRINGISE_ENUM_CLASS_NAMED(List_BuildRaytracingAccelerationStructure,
                               "ID3D12GraphicsCommandList4::BuildRaytracingAccelerationStructure");
    STRINGISE_ENUM_CLASS_NAMED(List_CopyRaytracingAccelerationStructure,
                               "ID3D12GraphicsCommandList4::CopyRaytracingAccelerationStructure");
    STRINGISE_ENUM_CLASS_NAMED(
        List_EmitRaytracingAccelerationStructurePostbuildInfo,
        "ID3D12GraphicsCommandList4::EmitRaytracingAccelerationStructurePostbuildInfo");
    STRINGISE_ENUM_CLASS_NAMED(List_DispatchRays, "ID3D12GraphicsCommandList4::DispatchRays");
    STRINGISE_ENUM_CLASS_NAMED(List_SetPipelineState1,
                               "ID3D12GraphicsCommandList4::SetPipelineState1");
    STRINGISE_ENUM_CLASS_NAMED(CreateAS, "Internal::Acceleration Structure Create");
    STRINGISE_ENUM_CLASS_NAMED(StateObject_SetPipelineStackSize,
                               "ID3D12StateObjectProperties::SetPipelineStackSize");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateHeapFromAddress1,
                               "ID3D12Device13::OpenExistingHeapFromAddress1");
    STRINGISE_ENUM_CLASS_NAMED(Device_CreateRootSignatureFromSubobjectInLibrary,
                               "ID3D12Device14::CreateRootSignatureFromSubobjectInLibrary");
    STRINGISE_ENUM_CLASS_NAMED(List_SetProgram, "ID3D12GraphicsCommandList10::SetProgram");
    STRINGISE_ENUM_CLASS_NAMED(List_DispatchGraph, "ID3D12GraphicsCommandList10::DispatchGraph");
    STRINGISE_ENUM_CLASS_NAMED(Max, "Max Chunk");
  }
  END_ENUM_STRINGISE()
}

template <>
rdcstr DoStringise(const D3D12DescriptorType &el)
{
  if((uint32_t)el < (uint32_t)D3D12DescriptorType::CBV)
    return "Sampler";

  BEGIN_ENUM_STRINGISE(D3D12DescriptorType);
  {
    STRINGISE_ENUM_CLASS_NAMED(CBV, "CBV");
    STRINGISE_ENUM_CLASS_NAMED(SRV, "SRV");
    STRINGISE_ENUM_CLASS_NAMED(UAV, "UAV");
    STRINGISE_ENUM_CLASS_NAMED(RTV, "RTV");
    STRINGISE_ENUM_CLASS_NAMED(DSV, "DSV");
    STRINGISE_ENUM_CLASS_NAMED(Undefined, "Undefined");
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12ResourceType &el)
{
  BEGIN_ENUM_STRINGISE(D3D12ResourceType);
  {
    STRINGISE_ENUM_NAMED(Resource_Device, "Device");
    STRINGISE_ENUM_NAMED(Resource_Unknown, "Unknown");
    STRINGISE_ENUM_NAMED(Resource_CommandAllocator, "Command Allocator");
    STRINGISE_ENUM_NAMED(Resource_CommandQueue, "Command Queue");
    STRINGISE_ENUM_NAMED(Resource_CommandSignature, "Command Signature");
    STRINGISE_ENUM_NAMED(Resource_DescriptorHeap, "Descriptor Heap");
    STRINGISE_ENUM_NAMED(Resource_Fence, "Fence");
    STRINGISE_ENUM_NAMED(Resource_Heap, "Heap");
    STRINGISE_ENUM_NAMED(Resource_PipelineState, "Pipeline State");
    STRINGISE_ENUM_NAMED(Resource_QueryHeap, "Query Heap");
    STRINGISE_ENUM_NAMED(Resource_Resource, "Resource");
    STRINGISE_ENUM_NAMED(Resource_GraphicsCommandList, "Graphics CommandList");
    STRINGISE_ENUM_NAMED(Resource_RootSignature, "Root Signature");
    STRINGISE_ENUM_NAMED(Resource_PipelineLibrary, "Pipeline Library");
    STRINGISE_ENUM_NAMED(Resource_ProtectedResourceSession, "Protected Resource Session");
    STRINGISE_ENUM_NAMED(Resource_AccelerationStructure, "Acceleration Structure");
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_HEAP_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_HEAP_TYPE);
  {
    STRINGISE_ENUM(D3D12_HEAP_TYPE_DEFAULT)
    STRINGISE_ENUM(D3D12_HEAP_TYPE_UPLOAD)
    STRINGISE_ENUM(D3D12_HEAP_TYPE_READBACK)
    STRINGISE_ENUM(D3D12_HEAP_TYPE_CUSTOM)
    STRINGISE_ENUM(D3D12_HEAP_TYPE_GPU_UPLOAD)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_CPU_PAGE_PROPERTY &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_CPU_PAGE_PROPERTY);
  {
    STRINGISE_ENUM(D3D12_CPU_PAGE_PROPERTY_UNKNOWN)
    STRINGISE_ENUM(D3D12_CPU_PAGE_PROPERTY_NOT_AVAILABLE)
    STRINGISE_ENUM(D3D12_CPU_PAGE_PROPERTY_WRITE_COMBINE)
    STRINGISE_ENUM(D3D12_CPU_PAGE_PROPERTY_WRITE_BACK)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_MEMORY_POOL &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_MEMORY_POOL);
  {
    STRINGISE_ENUM(D3D12_MEMORY_POOL_UNKNOWN)
    STRINGISE_ENUM(D3D12_MEMORY_POOL_L0)
    STRINGISE_ENUM(D3D12_MEMORY_POOL_L1)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_QUERY_HEAP_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_QUERY_HEAP_TYPE);
  {
    STRINGISE_ENUM(D3D12_QUERY_HEAP_TYPE_OCCLUSION)
    STRINGISE_ENUM(D3D12_QUERY_HEAP_TYPE_TIMESTAMP)
    STRINGISE_ENUM(D3D12_QUERY_HEAP_TYPE_PIPELINE_STATISTICS)
    STRINGISE_ENUM(D3D12_QUERY_HEAP_TYPE_SO_STATISTICS)
    STRINGISE_ENUM(D3D12_QUERY_HEAP_TYPE_VIDEO_DECODE_STATISTICS)
    STRINGISE_ENUM(D3D12_QUERY_HEAP_TYPE_COPY_QUEUE_TIMESTAMP)
    STRINGISE_ENUM(D3D12_QUERY_HEAP_TYPE_PIPELINE_STATISTICS1)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_QUERY_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_QUERY_TYPE);
  {
    STRINGISE_ENUM(D3D12_QUERY_TYPE_OCCLUSION)
    STRINGISE_ENUM(D3D12_QUERY_TYPE_BINARY_OCCLUSION)
    STRINGISE_ENUM(D3D12_QUERY_TYPE_TIMESTAMP)
    STRINGISE_ENUM(D3D12_QUERY_TYPE_PIPELINE_STATISTICS)
    STRINGISE_ENUM(D3D12_QUERY_TYPE_SO_STATISTICS_STREAM0)
    STRINGISE_ENUM(D3D12_QUERY_TYPE_SO_STATISTICS_STREAM1)
    STRINGISE_ENUM(D3D12_QUERY_TYPE_SO_STATISTICS_STREAM2)
    STRINGISE_ENUM(D3D12_QUERY_TYPE_SO_STATISTICS_STREAM3)
    STRINGISE_ENUM(D3D12_QUERY_TYPE_VIDEO_DECODE_STATISTICS)
    STRINGISE_ENUM(D3D12_QUERY_TYPE_PIPELINE_STATISTICS1)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_PREDICATION_OP &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_PREDICATION_OP);
  {
    STRINGISE_ENUM(D3D12_PREDICATION_OP_EQUAL_ZERO)
    STRINGISE_ENUM(D3D12_PREDICATION_OP_NOT_EQUAL_ZERO)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_DESCRIPTOR_HEAP_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_DESCRIPTOR_HEAP_TYPE);
  {
    STRINGISE_ENUM(D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV)
    STRINGISE_ENUM(D3D12_DESCRIPTOR_HEAP_TYPE_SAMPLER)
    STRINGISE_ENUM(D3D12_DESCRIPTOR_HEAP_TYPE_RTV)
    STRINGISE_ENUM(D3D12_DESCRIPTOR_HEAP_TYPE_DSV)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RESOURCE_BARRIER_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_RESOURCE_BARRIER_TYPE);
  {
    STRINGISE_ENUM(D3D12_RESOURCE_BARRIER_TYPE_TRANSITION)
    STRINGISE_ENUM(D3D12_RESOURCE_BARRIER_TYPE_ALIASING)
    STRINGISE_ENUM(D3D12_RESOURCE_BARRIER_TYPE_UAV)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_SRV_DIMENSION &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_SRV_DIMENSION);
  {
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_UNKNOWN)
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_BUFFER)
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_TEXTURE1D)
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_TEXTURE1DARRAY)
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_TEXTURE2D)
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_TEXTURE2DARRAY)
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_TEXTURE2DMS)
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_TEXTURE2DMSARRAY)
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_TEXTURE3D)
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_TEXTURECUBE)
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_TEXTURECUBEARRAY)
    STRINGISE_ENUM(D3D12_SRV_DIMENSION_RAYTRACING_ACCELERATION_STRUCTURE)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RTV_DIMENSION &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_RTV_DIMENSION);
  {
    STRINGISE_ENUM(D3D12_RTV_DIMENSION_UNKNOWN)
    STRINGISE_ENUM(D3D12_RTV_DIMENSION_BUFFER)
    STRINGISE_ENUM(D3D12_RTV_DIMENSION_TEXTURE1D)
    STRINGISE_ENUM(D3D12_RTV_DIMENSION_TEXTURE1DARRAY)
    STRINGISE_ENUM(D3D12_RTV_DIMENSION_TEXTURE2D)
    STRINGISE_ENUM(D3D12_RTV_DIMENSION_TEXTURE2DARRAY)
    STRINGISE_ENUM(D3D12_RTV_DIMENSION_TEXTURE2DMS)
    STRINGISE_ENUM(D3D12_RTV_DIMENSION_TEXTURE2DMSARRAY)
    STRINGISE_ENUM(D3D12_RTV_DIMENSION_TEXTURE3D)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_UAV_DIMENSION &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_UAV_DIMENSION);
  {
    STRINGISE_ENUM(D3D12_UAV_DIMENSION_BUFFER)
    STRINGISE_ENUM(D3D12_UAV_DIMENSION_TEXTURE1D)
    STRINGISE_ENUM(D3D12_UAV_DIMENSION_TEXTURE1DARRAY)
    STRINGISE_ENUM(D3D12_UAV_DIMENSION_TEXTURE2D)
    STRINGISE_ENUM(D3D12_UAV_DIMENSION_TEXTURE2DARRAY)
    STRINGISE_ENUM(D3D12_UAV_DIMENSION_TEXTURE2DMS)
    STRINGISE_ENUM(D3D12_UAV_DIMENSION_TEXTURE2DMSARRAY)
    STRINGISE_ENUM(D3D12_UAV_DIMENSION_TEXTURE3D)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_DSV_DIMENSION &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_DSV_DIMENSION);
  {
    STRINGISE_ENUM(D3D12_DSV_DIMENSION_UNKNOWN)
    STRINGISE_ENUM(D3D12_DSV_DIMENSION_TEXTURE1D)
    STRINGISE_ENUM(D3D12_DSV_DIMENSION_TEXTURE1DARRAY)
    STRINGISE_ENUM(D3D12_DSV_DIMENSION_TEXTURE2D)
    STRINGISE_ENUM(D3D12_DSV_DIMENSION_TEXTURE2DARRAY)
    STRINGISE_ENUM(D3D12_DSV_DIMENSION_TEXTURE2DMS)
    STRINGISE_ENUM(D3D12_DSV_DIMENSION_TEXTURE2DMSARRAY)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_FILTER &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_FILTER);
  {
    STRINGISE_ENUM(D3D12_FILTER_MIN_MAG_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MIN_MAG_POINT_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MIN_POINT_MAG_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MIN_LINEAR_MAG_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MIN_MAG_LINEAR_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MIN_MAG_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MIN_MAG_ANISOTROPIC_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_ANISOTROPIC);
    STRINGISE_ENUM(D3D12_FILTER_COMPARISON_MIN_MAG_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_COMPARISON_MIN_MAG_ANISOTROPIC_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_COMPARISON_ANISOTROPIC);
    STRINGISE_ENUM(D3D12_FILTER_MINIMUM_MIN_MAG_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MINIMUM_MIN_MAG_ANISOTROPIC_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MINIMUM_ANISOTROPIC);
    STRINGISE_ENUM(D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR);
    STRINGISE_ENUM(D3D12_FILTER_MAXIMUM_MIN_MAG_ANISOTROPIC_MIP_POINT);
    STRINGISE_ENUM(D3D12_FILTER_MAXIMUM_ANISOTROPIC);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_TEXTURE_ADDRESS_MODE &el)
{
  // possible for unused fields via 0-initialisation
  if((int)el == 0)
    return "--";

  BEGIN_ENUM_STRINGISE(D3D12_TEXTURE_ADDRESS_MODE);
  {
    STRINGISE_ENUM(D3D12_TEXTURE_ADDRESS_MODE_WRAP);
    STRINGISE_ENUM(D3D12_TEXTURE_ADDRESS_MODE_MIRROR);
    STRINGISE_ENUM(D3D12_TEXTURE_ADDRESS_MODE_CLAMP);
    STRINGISE_ENUM(D3D12_TEXTURE_ADDRESS_MODE_BORDER);
    STRINGISE_ENUM(D3D12_TEXTURE_ADDRESS_MODE_MIRROR_ONCE);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_BLEND &el)
{
  // possible for unused fields via 0-initialisation
  if((int)el == 0)
    return "--";

  BEGIN_ENUM_STRINGISE(D3D12_BLEND);
  {
    STRINGISE_ENUM(D3D12_BLEND_ZERO);
    STRINGISE_ENUM(D3D12_BLEND_ONE);
    STRINGISE_ENUM(D3D12_BLEND_SRC_COLOR);
    STRINGISE_ENUM(D3D12_BLEND_INV_SRC_COLOR);
    STRINGISE_ENUM(D3D12_BLEND_SRC_ALPHA);
    STRINGISE_ENUM(D3D12_BLEND_INV_SRC_ALPHA);
    STRINGISE_ENUM(D3D12_BLEND_DEST_ALPHA);
    STRINGISE_ENUM(D3D12_BLEND_INV_DEST_ALPHA);
    STRINGISE_ENUM(D3D12_BLEND_DEST_COLOR);
    STRINGISE_ENUM(D3D12_BLEND_INV_DEST_COLOR);
    STRINGISE_ENUM(D3D12_BLEND_SRC_ALPHA_SAT);
    STRINGISE_ENUM(D3D12_BLEND_BLEND_FACTOR);
    STRINGISE_ENUM(D3D12_BLEND_INV_BLEND_FACTOR);
    STRINGISE_ENUM(D3D12_BLEND_SRC1_COLOR);
    STRINGISE_ENUM(D3D12_BLEND_INV_SRC1_COLOR);
    STRINGISE_ENUM(D3D12_BLEND_SRC1_ALPHA);
    STRINGISE_ENUM(D3D12_BLEND_INV_SRC1_ALPHA);
    STRINGISE_ENUM(D3D12_BLEND_ALPHA_FACTOR);
    STRINGISE_ENUM(D3D12_BLEND_INV_ALPHA_FACTOR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_BLEND_OP &el)
{
  // possible for unused fields via 0-initialisation
  if((int)el == 0)
    return "--";

  BEGIN_ENUM_STRINGISE(D3D12_BLEND_OP);
  {
    STRINGISE_ENUM(D3D12_BLEND_OP_ADD);
    STRINGISE_ENUM(D3D12_BLEND_OP_SUBTRACT);
    STRINGISE_ENUM(D3D12_BLEND_OP_REV_SUBTRACT);
    STRINGISE_ENUM(D3D12_BLEND_OP_MIN);
    STRINGISE_ENUM(D3D12_BLEND_OP_MAX);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_LOGIC_OP &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_LOGIC_OP);
  {
    STRINGISE_ENUM(D3D12_LOGIC_OP_CLEAR);
    STRINGISE_ENUM(D3D12_LOGIC_OP_SET);
    STRINGISE_ENUM(D3D12_LOGIC_OP_COPY);
    STRINGISE_ENUM(D3D12_LOGIC_OP_COPY_INVERTED);
    STRINGISE_ENUM(D3D12_LOGIC_OP_NOOP);
    STRINGISE_ENUM(D3D12_LOGIC_OP_INVERT);
    STRINGISE_ENUM(D3D12_LOGIC_OP_AND);
    STRINGISE_ENUM(D3D12_LOGIC_OP_NAND);
    STRINGISE_ENUM(D3D12_LOGIC_OP_OR);
    STRINGISE_ENUM(D3D12_LOGIC_OP_NOR);
    STRINGISE_ENUM(D3D12_LOGIC_OP_XOR);
    STRINGISE_ENUM(D3D12_LOGIC_OP_EQUIV);
    STRINGISE_ENUM(D3D12_LOGIC_OP_AND_REVERSE);
    STRINGISE_ENUM(D3D12_LOGIC_OP_AND_INVERTED);
    STRINGISE_ENUM(D3D12_LOGIC_OP_OR_REVERSE);
    STRINGISE_ENUM(D3D12_LOGIC_OP_OR_INVERTED);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_FILL_MODE &el)
{
  // possible for unused fields via 0-initialisation
  if((int)el == 0)
    return "--";

  BEGIN_ENUM_STRINGISE(D3D12_FILL_MODE);
  {
    STRINGISE_ENUM(D3D12_FILL_MODE_WIREFRAME);
    STRINGISE_ENUM(D3D12_FILL_MODE_SOLID);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_CULL_MODE &el)
{
  // possible for unused fields via 0-initialisation
  if((int)el == 0)
    return "--";

  BEGIN_ENUM_STRINGISE(D3D12_CULL_MODE);
  {
    STRINGISE_ENUM(D3D12_CULL_MODE_NONE);
    STRINGISE_ENUM(D3D12_CULL_MODE_FRONT);
    STRINGISE_ENUM(D3D12_CULL_MODE_BACK);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_CONSERVATIVE_RASTERIZATION_MODE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_CONSERVATIVE_RASTERIZATION_MODE);
  {
    STRINGISE_ENUM(D3D12_CONSERVATIVE_RASTERIZATION_MODE_OFF)
    STRINGISE_ENUM(D3D12_CONSERVATIVE_RASTERIZATION_MODE_ON)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_COMPARISON_FUNC &el)
{
  // possible for unused fields via 0-initialisation
  if((int)el == 0)
    return "--";

  BEGIN_ENUM_STRINGISE(D3D12_COMPARISON_FUNC);
  {
    STRINGISE_ENUM(D3D12_COMPARISON_FUNC_NONE);
    STRINGISE_ENUM(D3D12_COMPARISON_FUNC_NEVER);
    STRINGISE_ENUM(D3D12_COMPARISON_FUNC_LESS);
    STRINGISE_ENUM(D3D12_COMPARISON_FUNC_EQUAL);
    STRINGISE_ENUM(D3D12_COMPARISON_FUNC_LESS_EQUAL);
    STRINGISE_ENUM(D3D12_COMPARISON_FUNC_GREATER);
    STRINGISE_ENUM(D3D12_COMPARISON_FUNC_NOT_EQUAL);
    STRINGISE_ENUM(D3D12_COMPARISON_FUNC_GREATER_EQUAL);
    STRINGISE_ENUM(D3D12_COMPARISON_FUNC_ALWAYS);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_DEPTH_WRITE_MASK &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_DEPTH_WRITE_MASK);
  {
    STRINGISE_ENUM(D3D12_DEPTH_WRITE_MASK_ZERO)
    STRINGISE_ENUM(D3D12_DEPTH_WRITE_MASK_ALL)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_STENCIL_OP &el)
{
  // possible for unused fields via 0-initialisation
  if((int)el == 0)
    return "--";

  BEGIN_ENUM_STRINGISE(D3D12_STENCIL_OP);
  {
    STRINGISE_ENUM(D3D12_STENCIL_OP_KEEP);
    STRINGISE_ENUM(D3D12_STENCIL_OP_ZERO);
    STRINGISE_ENUM(D3D12_STENCIL_OP_REPLACE);
    STRINGISE_ENUM(D3D12_STENCIL_OP_INCR_SAT);
    STRINGISE_ENUM(D3D12_STENCIL_OP_DECR_SAT);
    STRINGISE_ENUM(D3D12_STENCIL_OP_INVERT);
    STRINGISE_ENUM(D3D12_STENCIL_OP_INCR);
    STRINGISE_ENUM(D3D12_STENCIL_OP_DECR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_INPUT_CLASSIFICATION &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_INPUT_CLASSIFICATION);
  {
    STRINGISE_ENUM(D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA)
    STRINGISE_ENUM(D3D12_INPUT_CLASSIFICATION_PER_INSTANCE_DATA)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_INDEX_BUFFER_STRIP_CUT_VALUE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_INDEX_BUFFER_STRIP_CUT_VALUE);
  {
    STRINGISE_ENUM(D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_DISABLED)
    STRINGISE_ENUM(D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_0xFFFF)
    STRINGISE_ENUM(D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_0xFFFFFFFF)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_PRIMITIVE_TOPOLOGY_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_PRIMITIVE_TOPOLOGY_TYPE);
  {
    STRINGISE_ENUM(D3D12_PRIMITIVE_TOPOLOGY_TYPE_UNDEFINED)
    STRINGISE_ENUM(D3D12_PRIMITIVE_TOPOLOGY_TYPE_POINT)
    STRINGISE_ENUM(D3D12_PRIMITIVE_TOPOLOGY_TYPE_LINE)
    STRINGISE_ENUM(D3D12_PRIMITIVE_TOPOLOGY_TYPE_TRIANGLE)
    STRINGISE_ENUM(D3D12_PRIMITIVE_TOPOLOGY_TYPE_PATCH)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_INDIRECT_ARGUMENT_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_INDIRECT_ARGUMENT_TYPE);
  {
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_DRAW)
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_DRAW_INDEXED)
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_DISPATCH)
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_VERTEX_BUFFER_VIEW)
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_INDEX_BUFFER_VIEW)
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_CONSTANT)
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_CONSTANT_BUFFER_VIEW)
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_SHADER_RESOURCE_VIEW)
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_UNORDERED_ACCESS_VIEW)
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_DISPATCH_RAYS)
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_DISPATCH_MESH)
    STRINGISE_ENUM(D3D12_INDIRECT_ARGUMENT_TYPE_INCREMENTING_CONSTANT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_COMMAND_LIST_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_COMMAND_LIST_TYPE);
  {
    STRINGISE_ENUM(D3D12_COMMAND_LIST_TYPE_DIRECT)
    STRINGISE_ENUM(D3D12_COMMAND_LIST_TYPE_BUNDLE)
    STRINGISE_ENUM(D3D12_COMMAND_LIST_TYPE_COMPUTE)
    STRINGISE_ENUM(D3D12_COMMAND_LIST_TYPE_COPY)
    STRINGISE_ENUM(D3D12_COMMAND_LIST_TYPE_VIDEO_DECODE)
    STRINGISE_ENUM(D3D12_COMMAND_LIST_TYPE_VIDEO_PROCESS)
    STRINGISE_ENUM(D3D12_COMMAND_LIST_TYPE_VIDEO_ENCODE)
    STRINGISE_ENUM(D3D12_COMMAND_LIST_TYPE_NONE)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_TEXTURE_COPY_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_TEXTURE_COPY_TYPE);
  {
    STRINGISE_ENUM(D3D12_TEXTURE_COPY_TYPE_SUBRESOURCE_INDEX)
    STRINGISE_ENUM(D3D12_TEXTURE_COPY_TYPE_PLACED_FOOTPRINT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RESOURCE_DIMENSION &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_RESOURCE_DIMENSION);
  {
    STRINGISE_ENUM(D3D12_RESOURCE_DIMENSION_UNKNOWN)
    STRINGISE_ENUM(D3D12_RESOURCE_DIMENSION_BUFFER)
    STRINGISE_ENUM(D3D12_RESOURCE_DIMENSION_TEXTURE1D)
    STRINGISE_ENUM(D3D12_RESOURCE_DIMENSION_TEXTURE2D)
    STRINGISE_ENUM(D3D12_RESOURCE_DIMENSION_TEXTURE3D)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_TEXTURE_LAYOUT &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_TEXTURE_LAYOUT);
  {
    STRINGISE_ENUM(D3D12_TEXTURE_LAYOUT_UNKNOWN)
    STRINGISE_ENUM(D3D12_TEXTURE_LAYOUT_ROW_MAJOR)
    STRINGISE_ENUM(D3D12_TEXTURE_LAYOUT_64KB_UNDEFINED_SWIZZLE)
    STRINGISE_ENUM(D3D12_TEXTURE_LAYOUT_64KB_STANDARD_SWIZZLE)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_TILED_RESOURCES_TIER &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_TILED_RESOURCES_TIER);
  {
    STRINGISE_ENUM(D3D12_TILED_RESOURCES_TIER_NOT_SUPPORTED)
    STRINGISE_ENUM(D3D12_TILED_RESOURCES_TIER_1)
    STRINGISE_ENUM(D3D12_TILED_RESOURCES_TIER_2)
    STRINGISE_ENUM(D3D12_TILED_RESOURCES_TIER_3)
    STRINGISE_ENUM(D3D12_TILED_RESOURCES_TIER_4)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RESOLVE_MODE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_RESOLVE_MODE);
  {
    STRINGISE_ENUM(D3D12_RESOLVE_MODE_AVERAGE)
    STRINGISE_ENUM(D3D12_RESOLVE_MODE_DECOMPRESS)
    STRINGISE_ENUM(D3D12_RESOLVE_MODE_MAX)
    STRINGISE_ENUM(D3D12_RESOLVE_MODE_MIN)
    STRINGISE_ENUM(D3D12_RESOLVE_MODE_ENCODE_SAMPLER_FEEDBACK)
    STRINGISE_ENUM(D3D12_RESOLVE_MODE_DECODE_SAMPLER_FEEDBACK)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_WRITEBUFFERIMMEDIATE_MODE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_WRITEBUFFERIMMEDIATE_MODE);
  {
    STRINGISE_ENUM(D3D12_WRITEBUFFERIMMEDIATE_MODE_DEFAULT)
    STRINGISE_ENUM(D3D12_WRITEBUFFERIMMEDIATE_MODE_MARKER_IN)
    STRINGISE_ENUM(D3D12_WRITEBUFFERIMMEDIATE_MODE_MARKER_OUT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE);
  {
    STRINGISE_ENUM(D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_DISCARD)
    STRINGISE_ENUM(D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_PRESERVE)
    STRINGISE_ENUM(D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_CLEAR)
    STRINGISE_ENUM(D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_NO_ACCESS)
    STRINGISE_ENUM(D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_PRESERVE_LOCAL_RENDER)
    STRINGISE_ENUM(D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_PRESERVE_LOCAL_SRV)
    STRINGISE_ENUM(D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_PRESERVE_LOCAL_UAV)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RENDER_PASS_ENDING_ACCESS_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_RENDER_PASS_ENDING_ACCESS_TYPE);
  {
    STRINGISE_ENUM(D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_DISCARD)
    STRINGISE_ENUM(D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_PRESERVE)
    STRINGISE_ENUM(D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_RESOLVE)
    STRINGISE_ENUM(D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_NO_ACCESS)
    STRINGISE_ENUM(D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_PRESERVE_LOCAL_RENDER)
    STRINGISE_ENUM(D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_PRESERVE_LOCAL_SRV)
    STRINGISE_ENUM(D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_PRESERVE_LOCAL_UAV)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_SHADING_RATE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_SHADING_RATE);
  {
    STRINGISE_ENUM(D3D12_SHADING_RATE_1X1)
    STRINGISE_ENUM(D3D12_SHADING_RATE_1X2)
    STRINGISE_ENUM(D3D12_SHADING_RATE_2X1)
    STRINGISE_ENUM(D3D12_SHADING_RATE_2X2)
    STRINGISE_ENUM(D3D12_SHADING_RATE_2X4)
    STRINGISE_ENUM(D3D12_SHADING_RATE_4X2)
    STRINGISE_ENUM(D3D12_SHADING_RATE_4X4)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_SHADING_RATE_COMBINER &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_SHADING_RATE_COMBINER);
  {
    STRINGISE_ENUM(D3D12_SHADING_RATE_COMBINER_PASSTHROUGH)
    STRINGISE_ENUM(D3D12_SHADING_RATE_COMBINER_OVERRIDE)
    STRINGISE_ENUM(D3D12_SHADING_RATE_COMBINER_MIN)
    STRINGISE_ENUM(D3D12_SHADING_RATE_COMBINER_MAX)
    STRINGISE_ENUM(D3D12_SHADING_RATE_COMBINER_SUM)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_ROOT_PARAMETER_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_ROOT_PARAMETER_TYPE);
  {
    STRINGISE_ENUM(D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE)
    STRINGISE_ENUM(D3D12_ROOT_PARAMETER_TYPE_32BIT_CONSTANTS)
    STRINGISE_ENUM(D3D12_ROOT_PARAMETER_TYPE_CBV)
    STRINGISE_ENUM(D3D12_ROOT_PARAMETER_TYPE_SRV)
    STRINGISE_ENUM(D3D12_ROOT_PARAMETER_TYPE_UAV)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_SHADER_VISIBILITY &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_SHADER_VISIBILITY);
  {
    STRINGISE_ENUM(D3D12_SHADER_VISIBILITY_ALL)
    STRINGISE_ENUM(D3D12_SHADER_VISIBILITY_VERTEX)
    STRINGISE_ENUM(D3D12_SHADER_VISIBILITY_HULL)
    STRINGISE_ENUM(D3D12_SHADER_VISIBILITY_DOMAIN)
    STRINGISE_ENUM(D3D12_SHADER_VISIBILITY_GEOMETRY)
    STRINGISE_ENUM(D3D12_SHADER_VISIBILITY_PIXEL)
    STRINGISE_ENUM(D3D12_SHADER_VISIBILITY_AMPLIFICATION)
    STRINGISE_ENUM(D3D12_SHADER_VISIBILITY_MESH)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_STATIC_BORDER_COLOR &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_STATIC_BORDER_COLOR);
  {
    STRINGISE_ENUM(D3D12_STATIC_BORDER_COLOR_TRANSPARENT_BLACK)
    STRINGISE_ENUM(D3D12_STATIC_BORDER_COLOR_OPAQUE_BLACK)
    STRINGISE_ENUM(D3D12_STATIC_BORDER_COLOR_OPAQUE_WHITE)
    STRINGISE_ENUM(D3D12_STATIC_BORDER_COLOR_OPAQUE_BLACK_UINT)
    STRINGISE_ENUM(D3D12_STATIC_BORDER_COLOR_OPAQUE_WHITE_UINT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_DESCRIPTOR_RANGE_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_DESCRIPTOR_RANGE_TYPE);
  {
    STRINGISE_ENUM(D3D12_DESCRIPTOR_RANGE_TYPE_SRV)
    STRINGISE_ENUM(D3D12_DESCRIPTOR_RANGE_TYPE_UAV)
    STRINGISE_ENUM(D3D12_DESCRIPTOR_RANGE_TYPE_CBV)
    STRINGISE_ENUM(D3D12_DESCRIPTOR_RANGE_TYPE_SAMPLER)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_LINE_RASTERIZATION_MODE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_LINE_RASTERIZATION_MODE);
  {
    STRINGISE_ENUM(D3D12_LINE_RASTERIZATION_MODE_ALIASED)
    STRINGISE_ENUM(D3D12_LINE_RASTERIZATION_MODE_ALPHA_ANTIALIASED)
    STRINGISE_ENUM(D3D12_LINE_RASTERIZATION_MODE_QUADRILATERAL_WIDE)
    STRINGISE_ENUM(D3D12_LINE_RASTERIZATION_MODE_QUADRILATERAL_NARROW)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_BARRIER_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_BARRIER_TYPE);
  {
    STRINGISE_ENUM(D3D12_BARRIER_TYPE_GLOBAL)
    STRINGISE_ENUM(D3D12_BARRIER_TYPE_TEXTURE)
    STRINGISE_ENUM(D3D12_BARRIER_TYPE_BUFFER)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_BARRIER_LAYOUT &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_BARRIER_LAYOUT);
  {
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_UNDEFINED)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_COMMON)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_GENERIC_READ)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_RENDER_TARGET)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_UNORDERED_ACCESS)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_DEPTH_STENCIL_WRITE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_DEPTH_STENCIL_READ)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_SHADER_RESOURCE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_COPY_SOURCE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_COPY_DEST)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_RESOLVE_SOURCE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_RESOLVE_DEST)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_SHADING_RATE_SOURCE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_VIDEO_DECODE_READ)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_VIDEO_DECODE_WRITE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_VIDEO_PROCESS_READ)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_VIDEO_PROCESS_WRITE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_VIDEO_ENCODE_READ)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_VIDEO_ENCODE_WRITE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_COMMON)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_GENERIC_READ)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_UNORDERED_ACCESS)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_SHADER_RESOURCE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_COPY_SOURCE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_DIRECT_QUEUE_COPY_DEST)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_COMMON)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_GENERIC_READ)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_UNORDERED_ACCESS)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_SHADER_RESOURCE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_COPY_SOURCE)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_COMPUTE_QUEUE_COPY_DEST)
    STRINGISE_ENUM(D3D12_BARRIER_LAYOUT_VIDEO_QUEUE_COMMON)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_CLEAR_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_CLEAR_FLAGS);
  {
    STRINGISE_BITFIELD_BIT(D3D12_CLEAR_FLAG_DEPTH);
    STRINGISE_BITFIELD_BIT(D3D12_CLEAR_FLAG_STENCIL);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_BUFFER_SRV_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_BUFFER_SRV_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_BUFFER_SRV_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_BUFFER_SRV_FLAG_RAW);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_DSV_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_DSV_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_DSV_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_DSV_FLAG_READ_ONLY_DEPTH);
    STRINGISE_BITFIELD_BIT(D3D12_DSV_FLAG_READ_ONLY_STENCIL);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_BUFFER_UAV_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_BUFFER_UAV_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_BUFFER_UAV_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_BUFFER_UAV_FLAG_RAW);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_HEAP_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_HEAP_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_HEAP_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_SHARED);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_DENY_BUFFERS);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_ALLOW_DISPLAY);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_SHARED_CROSS_ADAPTER);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_DENY_RT_DS_TEXTURES);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_DENY_NON_RT_DS_TEXTURES);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_HARDWARE_PROTECTED);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_ALLOW_WRITE_WATCH);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_ALLOW_SHADER_ATOMICS);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_CREATE_NOT_RESIDENT);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_CREATE_NOT_ZEROED);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_TOOLS_USE_MANUAL_WRITE_TRACKING);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_ALLOW_ALL_BUFFERS_AND_TEXTURES);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_ALLOW_ONLY_BUFFERS);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_ALLOW_ONLY_NON_RT_DS_TEXTURES);
    STRINGISE_BITFIELD_BIT(D3D12_HEAP_FLAG_ALLOW_ONLY_RT_DS_TEXTURES);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_FENCE_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_FENCE_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_FENCE_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_FENCE_FLAG_SHARED);
    STRINGISE_BITFIELD_BIT(D3D12_FENCE_FLAG_SHARED_CROSS_ADAPTER);
    STRINGISE_BITFIELD_BIT(D3D12_FENCE_FLAG_NON_MONITORED);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_DESCRIPTOR_HEAP_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_DESCRIPTOR_HEAP_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_DESCRIPTOR_HEAP_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_DESCRIPTOR_HEAP_FLAG_SHADER_VISIBLE);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RESOURCE_BARRIER_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_RESOURCE_BARRIER_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_RESOURCE_BARRIER_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_BARRIER_FLAG_BEGIN_ONLY);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_BARRIER_FLAG_END_ONLY);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RESOURCE_STATES &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_RESOURCE_STATES);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_RESOURCE_STATE_COMMON);
    STRINGISE_BITFIELD_VALUE(D3D12_RESOURCE_STATE_GENERIC_READ);
    STRINGISE_BITFIELD_VALUE(D3D12_RESOURCE_STATE_ALL_SHADER_RESOURCE);

    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_VERTEX_AND_CONSTANT_BUFFER);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_INDEX_BUFFER);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_RENDER_TARGET);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_UNORDERED_ACCESS);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_DEPTH_WRITE);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_DEPTH_READ);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_NON_PIXEL_SHADER_RESOURCE);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_PIXEL_SHADER_RESOURCE);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_STREAM_OUT);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_INDIRECT_ARGUMENT);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_COPY_DEST);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_COPY_SOURCE);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_RESOLVE_DEST);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_RESOLVE_SOURCE);

    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_RAYTRACING_ACCELERATION_STRUCTURE);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_SHADING_RATE_SOURCE);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_VIDEO_DECODE_READ);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_VIDEO_DECODE_WRITE);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_VIDEO_PROCESS_READ);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_VIDEO_PROCESS_WRITE);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_VIDEO_ENCODE_READ);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_STATE_VIDEO_ENCODE_WRITE);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_PIPELINE_STATE_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_PIPELINE_STATE_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_PIPELINE_STATE_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_PIPELINE_STATE_FLAG_TOOL_DEBUG);
    STRINGISE_BITFIELD_BIT(D3D12_PIPELINE_STATE_FLAG_DYNAMIC_DEPTH_BIAS);
    STRINGISE_BITFIELD_BIT(D3D12_PIPELINE_STATE_FLAG_DYNAMIC_INDEX_BUFFER_STRIP_CUT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RESOURCE_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_RESOURCE_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_RESOURCE_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_FLAG_ALLOW_RENDER_TARGET);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_FLAG_ALLOW_DEPTH_STENCIL);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_FLAG_ALLOW_UNORDERED_ACCESS);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_FLAG_DENY_SHADER_RESOURCE);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_FLAG_ALLOW_CROSS_ADAPTER);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_FLAG_ALLOW_SIMULTANEOUS_ACCESS);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_FLAG_VIDEO_DECODE_REFERENCE_ONLY);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_FLAG_VIDEO_ENCODE_REFERENCE_ONLY);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_FLAG_RAYTRACING_ACCELERATION_STRUCTURE);
    STRINGISE_BITFIELD_BIT(D3D12_RESOURCE_FLAG_USE_TIGHT_ALIGNMENT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_COMMAND_QUEUE_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_COMMAND_QUEUE_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_COMMAND_QUEUE_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_COMMAND_QUEUE_FLAG_DISABLE_GPU_TIMEOUT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_TILE_COPY_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_TILE_COPY_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_TILE_COPY_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_TILE_COPY_FLAG_NO_HAZARD);
    STRINGISE_BITFIELD_BIT(D3D12_TILE_COPY_FLAG_LINEAR_BUFFER_TO_SWIZZLED_TILED_RESOURCE);
    STRINGISE_BITFIELD_BIT(D3D12_TILE_COPY_FLAG_SWIZZLED_TILED_RESOURCE_TO_LINEAR_BUFFER);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_TILE_MAPPING_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_TILE_MAPPING_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_TILE_MAPPING_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_TILE_MAPPING_FLAG_NO_HAZARD);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_TILE_RANGE_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_TILE_RANGE_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_TILE_RANGE_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_TILE_RANGE_FLAG_NULL);
    STRINGISE_BITFIELD_BIT(D3D12_TILE_RANGE_FLAG_SKIP);
    STRINGISE_BITFIELD_BIT(D3D12_TILE_RANGE_FLAG_REUSE_SINGLE_TILE);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_COLOR_WRITE_ENABLE &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_COLOR_WRITE_ENABLE);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_COLOR_WRITE_ENABLE_ALL);

    STRINGISE_BITFIELD_BIT(D3D12_COLOR_WRITE_ENABLE_RED);
    STRINGISE_BITFIELD_BIT(D3D12_COLOR_WRITE_ENABLE_GREEN);
    STRINGISE_BITFIELD_BIT(D3D12_COLOR_WRITE_ENABLE_BLUE);
    STRINGISE_BITFIELD_BIT(D3D12_COLOR_WRITE_ENABLE_ALPHA);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_VIEW_INSTANCING_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_VIEW_INSTANCING_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_VIEW_INSTANCING_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_VIEW_INSTANCING_FLAG_ENABLE_VIEW_INSTANCE_MASKING);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_COMMAND_LIST_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_COMMAND_LIST_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_COMMAND_LIST_FLAG_NONE);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RENDER_PASS_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_RENDER_PASS_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_RENDER_PASS_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_RENDER_PASS_FLAG_ALLOW_UAV_WRITES);
    STRINGISE_BITFIELD_BIT(D3D12_RENDER_PASS_FLAG_SUSPENDING_PASS);
    STRINGISE_BITFIELD_BIT(D3D12_RENDER_PASS_FLAG_RESUMING_PASS);
    STRINGISE_BITFIELD_BIT(D3D12_RENDER_PASS_FLAG_BIND_READ_ONLY_DEPTH);
    STRINGISE_BITFIELD_BIT(D3D12_RENDER_PASS_FLAG_BIND_READ_ONLY_STENCIL);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_ROOT_SIGNATURE_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_ROOT_SIGNATURE_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_ROOT_SIGNATURE_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_ALLOW_INPUT_ASSEMBLER_INPUT_LAYOUT);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_DENY_VERTEX_SHADER_ROOT_ACCESS);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_DENY_HULL_SHADER_ROOT_ACCESS);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_DENY_DOMAIN_SHADER_ROOT_ACCESS);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_DENY_GEOMETRY_SHADER_ROOT_ACCESS);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_DENY_PIXEL_SHADER_ROOT_ACCESS);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_ALLOW_STREAM_OUTPUT);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_LOCAL_ROOT_SIGNATURE);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_DENY_AMPLIFICATION_SHADER_ROOT_ACCESS);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_DENY_MESH_SHADER_ROOT_ACCESS);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_CBV_SRV_UAV_HEAP_DIRECTLY_INDEXED);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_SIGNATURE_FLAG_SAMPLER_HEAP_DIRECTLY_INDEXED);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_ROOT_DESCRIPTOR_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_ROOT_DESCRIPTOR_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_ROOT_DESCRIPTOR_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_ROOT_DESCRIPTOR_FLAG_DATA_VOLATILE);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_DESCRIPTOR_FLAG_DATA_STATIC_WHILE_SET_AT_EXECUTE);
    STRINGISE_BITFIELD_BIT(D3D12_ROOT_DESCRIPTOR_FLAG_DATA_STATIC);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_DESCRIPTOR_RANGE_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_DESCRIPTOR_RANGE_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_DESCRIPTOR_RANGE_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_DESCRIPTOR_RANGE_FLAG_DESCRIPTORS_VOLATILE);
    STRINGISE_BITFIELD_BIT(D3D12_DESCRIPTOR_RANGE_FLAG_DATA_VOLATILE);
    STRINGISE_BITFIELD_BIT(D3D12_DESCRIPTOR_RANGE_FLAG_DATA_STATIC_WHILE_SET_AT_EXECUTE);
    STRINGISE_BITFIELD_BIT(D3D12_DESCRIPTOR_RANGE_FLAG_DATA_STATIC);
    STRINGISE_BITFIELD_BIT(
        D3D12_DESCRIPTOR_RANGE_FLAG_DESCRIPTORS_STATIC_KEEPING_BUFFER_BOUNDS_CHECKS);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_SAMPLER_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_SAMPLER_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_SAMPLER_FLAG_NONE)

    STRINGISE_BITFIELD_BIT(D3D12_SAMPLER_FLAG_UINT_BORDER_COLOR)
    STRINGISE_BITFIELD_BIT(D3D12_SAMPLER_FLAG_NON_NORMALIZED_COORDINATES)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_TEXTURE_BARRIER_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_TEXTURE_BARRIER_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_TEXTURE_BARRIER_FLAG_NONE)

    STRINGISE_BITFIELD_BIT(D3D12_TEXTURE_BARRIER_FLAG_DISCARD)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_BARRIER_SYNC &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_BARRIER_SYNC);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_BARRIER_SYNC_NONE)

    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_ALL)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_DRAW)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_INDEX_INPUT)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_VERTEX_SHADING)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_PIXEL_SHADING)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_DEPTH_STENCIL)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_RENDER_TARGET)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_COMPUTE_SHADING)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_RAYTRACING)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_COPY)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_RESOLVE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_EXECUTE_INDIRECT)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_PREDICATION)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_ALL_SHADING)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_NON_PIXEL_SHADING)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_EMIT_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_CLEAR_UNORDERED_ACCESS_VIEW)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_VIDEO_DECODE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_VIDEO_PROCESS)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_VIDEO_ENCODE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_BUILD_RAYTRACING_ACCELERATION_STRUCTURE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_COPY_RAYTRACING_ACCELERATION_STRUCTURE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_SYNC_SPLIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_BARRIER_ACCESS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_BARRIER_ACCESS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_BARRIER_ACCESS_COMMON)
    STRINGISE_BITFIELD_VALUE(D3D12_BARRIER_ACCESS_NO_ACCESS)

    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_COMMON)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_VERTEX_BUFFER)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_CONSTANT_BUFFER)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_INDEX_BUFFER)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_RENDER_TARGET)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_UNORDERED_ACCESS)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_DEPTH_STENCIL_WRITE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_DEPTH_STENCIL_READ)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_SHADER_RESOURCE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_STREAM_OUTPUT)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_INDIRECT_ARGUMENT)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_PREDICATION)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_COPY_DEST)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_COPY_SOURCE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_RESOLVE_DEST)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_RESOLVE_SOURCE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_RAYTRACING_ACCELERATION_STRUCTURE_READ)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_RAYTRACING_ACCELERATION_STRUCTURE_WRITE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_SHADING_RATE_SOURCE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_VIDEO_DECODE_READ)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_VIDEO_DECODE_WRITE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_VIDEO_PROCESS_READ)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_VIDEO_PROCESS_WRITE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_VIDEO_ENCODE_READ)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_VIDEO_ENCODE_WRITE)
    STRINGISE_BITFIELD_BIT(D3D12_BARRIER_ACCESS_NO_ACCESS)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12ResourceLayout &el)
{
  if(el.IsLayout())
    return DoStringise(el.ToLayout());
  else
    return DoStringise(el.ToStates());
}

template <>
rdcstr DoStringise(const D3D12_ELEMENTS_LAYOUT &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_ELEMENTS_LAYOUT);
  {
    STRINGISE_ENUM(D3D12_ELEMENTS_LAYOUT_ARRAY);
    STRINGISE_ENUM(D3D12_ELEMENTS_LAYOUT_ARRAY_OF_POINTERS);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RAYTRACING_GEOMETRY_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_RAYTRACING_GEOMETRY_TYPE);
  {
    STRINGISE_ENUM(D3D12_RAYTRACING_GEOMETRY_TYPE_TRIANGLES);
    STRINGISE_ENUM(D3D12_RAYTRACING_GEOMETRY_TYPE_PROCEDURAL_PRIMITIVE_AABBS);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RAYTRACING_GEOMETRY_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_RAYTRACING_GEOMETRY_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_RAYTRACING_GEOMETRY_FLAG_NONE);
    STRINGISE_BITFIELD_BIT(D3D12_RAYTRACING_GEOMETRY_FLAG_OPAQUE);
    STRINGISE_BITFIELD_BIT(D3D12_RAYTRACING_GEOMETRY_FLAG_NO_DUPLICATE_ANYHIT_INVOCATION);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE);
  {
    STRINGISE_ENUM(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL);
    STRINGISE_ENUM(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS &el)
{
  BEGIN_BITFIELD_STRINGISE(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS);
  {
    STRINGISE_BITFIELD_VALUE(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_NONE);

    STRINGISE_BITFIELD_BIT(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_ALLOW_UPDATE);
    STRINGISE_BITFIELD_BIT(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_ALLOW_COMPACTION);
    STRINGISE_BITFIELD_BIT(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_PREFER_FAST_TRACE);
    STRINGISE_BITFIELD_BIT(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_PREFER_FAST_BUILD);
    STRINGISE_BITFIELD_BIT(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_MINIMIZE_MEMORY);
    STRINGISE_BITFIELD_BIT(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_PERFORM_UPDATE);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE);
  {
    STRINGISE_ENUM(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE);
    STRINGISE_ENUM(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION);
    STRINGISE_ENUM(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION);
    STRINGISE_ENUM(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE);
  {
    STRINGISE_ENUM(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_CLONE);
    STRINGISE_ENUM(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_COMPACT);
    STRINGISE_ENUM(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_VISUALIZATION_DECODE_FOR_TOOLS);
    STRINGISE_ENUM(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_SERIALIZE);
    STRINGISE_ENUM(D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_DESERIALIZE);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_STATE_SUBOBJECT_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_STATE_SUBOBJECT_TYPE);
  {
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_STATE_OBJECT_CONFIG);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_GLOBAL_ROOT_SIGNATURE);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_LOCAL_ROOT_SIGNATURE);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_NODE_MASK);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_DXIL_LIBRARY);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_EXISTING_COLLECTION);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_SUBOBJECT_TO_EXPORTS_ASSOCIATION);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_RAYTRACING_SHADER_CONFIG);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_RAYTRACING_PIPELINE_CONFIG);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_HIT_GROUP);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_RAYTRACING_PIPELINE_CONFIG1);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_WORK_GRAPH);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_STREAM_OUTPUT);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_BLEND);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_SAMPLE_MASK);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_RASTERIZER);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_INPUT_LAYOUT);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_IB_STRIP_CUT_VALUE);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_PRIMITIVE_TOPOLOGY);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_RENDER_TARGET_FORMATS);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL_FORMAT);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_SAMPLE_DESC);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_FLAGS);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL1);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_VIEW_INSTANCING);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_GENERIC_PROGRAM);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL2);
    STRINGISE_ENUM(D3D12_STATE_SUBOBJECT_TYPE_MAX_VALID);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_STATE_OBJECT_FLAGS &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_STATE_OBJECT_FLAGS);
  {
    STRINGISE_ENUM(D3D12_STATE_OBJECT_FLAG_NONE);
    STRINGISE_ENUM(D3D12_STATE_OBJECT_FLAG_ALLOW_LOCAL_DEPENDENCIES_ON_EXTERNAL_DEFINITIONS);
    STRINGISE_ENUM(D3D12_STATE_OBJECT_FLAG_ALLOW_EXTERNAL_DEPENDENCIES_ON_LOCAL_DEFINITIONS);
    STRINGISE_ENUM(D3D12_STATE_OBJECT_FLAG_ALLOW_STATE_OBJECT_ADDITIONS);
    STRINGISE_ENUM(D3D12_STATE_OBJECT_FLAG_WORK_GRAPHS_USE_GRAPHICS_STATE_FOR_GLOBAL_ROOT_SIGNATURE);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_EXPORT_FLAGS &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_EXPORT_FLAGS);
  {
    STRINGISE_ENUM(D3D12_EXPORT_FLAG_NONE);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_HIT_GROUP_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_HIT_GROUP_TYPE);
  {
    STRINGISE_ENUM(D3D12_HIT_GROUP_TYPE_TRIANGLES);
    STRINGISE_ENUM(D3D12_HIT_GROUP_TYPE_PROCEDURAL_PRIMITIVE);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_RAYTRACING_PIPELINE_FLAGS &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_RAYTRACING_PIPELINE_FLAGS);
  {
    STRINGISE_ENUM(D3D12_RAYTRACING_PIPELINE_FLAG_NONE);
    STRINGISE_ENUM(D3D12_RAYTRACING_PIPELINE_FLAG_SKIP_TRIANGLES);
    STRINGISE_ENUM(D3D12_RAYTRACING_PIPELINE_FLAG_SKIP_PROCEDURAL_PRIMITIVES);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_STATE_OBJECT_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_STATE_OBJECT_TYPE);
  {
    STRINGISE_ENUM(D3D12_STATE_OBJECT_TYPE_COLLECTION);
    STRINGISE_ENUM(D3D12_STATE_OBJECT_TYPE_RAYTRACING_PIPELINE);
    STRINGISE_ENUM(D3D12_STATE_OBJECT_TYPE_EXECUTABLE);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_DRED_ALLOCATION_TYPE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_DRED_ALLOCATION_TYPE);
  {
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_COMMAND_QUEUE);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_COMMAND_ALLOCATOR);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_PIPELINE_STATE);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_COMMAND_LIST);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_FENCE);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_DESCRIPTOR_HEAP);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_HEAP);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_QUERY_HEAP);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_COMMAND_SIGNATURE);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_PIPELINE_LIBRARY);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_VIDEO_DECODER);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_VIDEO_PROCESSOR);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_RESOURCE);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_PASS);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_CRYPTOSESSION);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_CRYPTOSESSIONPOLICY);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_PROTECTEDRESOURCESESSION);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_VIDEO_DECODER_HEAP);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_COMMAND_POOL);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_COMMAND_RECORDER);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_STATE_OBJECT);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_METACOMMAND);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_SCHEDULINGGROUP);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_VIDEO_MOTION_ESTIMATOR);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_VIDEO_MOTION_VECTOR_HEAP);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_VIDEO_EXTENSION_COMMAND);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_VIDEO_ENCODER);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_VIDEO_ENCODER_HEAP);
    STRINGISE_ENUM(D3D12_DRED_ALLOCATION_TYPE_INVALID);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_AUTO_BREADCRUMB_OP &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_AUTO_BREADCRUMB_OP);
  {
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_SETMARKER);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_BEGINEVENT);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_ENDEVENT);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_DRAWINSTANCED);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_DRAWINDEXEDINSTANCED);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_EXECUTEINDIRECT);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_DISPATCH);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_COPYBUFFERREGION);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_COPYTEXTUREREGION);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_COPYRESOURCE);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_COPYTILES);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_RESOLVESUBRESOURCE);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_CLEARRENDERTARGETVIEW);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_CLEARUNORDEREDACCESSVIEW);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_CLEARDEPTHSTENCILVIEW);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_RESOURCEBARRIER);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_EXECUTEBUNDLE);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_PRESENT);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_RESOLVEQUERYDATA);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_BEGINSUBMISSION);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_ENDSUBMISSION);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_DECODEFRAME);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_PROCESSFRAMES);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_ATOMICCOPYBUFFERUINT);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_ATOMICCOPYBUFFERUINT64);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_RESOLVESUBRESOURCEREGION);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_WRITEBUFFERIMMEDIATE);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_DECODEFRAME1);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_SETPROTECTEDRESOURCESESSION);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_DECODEFRAME2);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_PROCESSFRAMES1);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_BUILDRAYTRACINGACCELERATIONSTRUCTURE);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_EMITRAYTRACINGACCELERATIONSTRUCTUREPOSTBUILDINFO);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_COPYRAYTRACINGACCELERATIONSTRUCTURE);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_DISPATCHRAYS);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_INITIALIZEMETACOMMAND);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_EXECUTEMETACOMMAND);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_ESTIMATEMOTION);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_RESOLVEMOTIONVECTORHEAP);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_SETPIPELINESTATE1);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_INITIALIZEEXTENSIONCOMMAND);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_EXECUTEEXTENSIONCOMMAND);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_DISPATCHMESH);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_ENCODEFRAME);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_RESOLVEENCODEROUTPUTMETADATA);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_BARRIER);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_BEGIN_COMMAND_LIST);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_DISPATCHGRAPH);
    STRINGISE_ENUM(D3D12_AUTO_BREADCRUMB_OP_SETPROGRAM);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const D3D12_FEATURE &el)
{
  BEGIN_ENUM_STRINGISE(D3D12_FEATURE);
  {
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS);
    STRINGISE_ENUM(D3D12_FEATURE_ARCHITECTURE);
    STRINGISE_ENUM(D3D12_FEATURE_FEATURE_LEVELS);
    STRINGISE_ENUM(D3D12_FEATURE_FORMAT_SUPPORT);
    STRINGISE_ENUM(D3D12_FEATURE_MULTISAMPLE_QUALITY_LEVELS);
    STRINGISE_ENUM(D3D12_FEATURE_FORMAT_INFO);
    STRINGISE_ENUM(D3D12_FEATURE_GPU_VIRTUAL_ADDRESS_SUPPORT);
    STRINGISE_ENUM(D3D12_FEATURE_SHADER_MODEL);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS1);
    STRINGISE_ENUM(D3D12_FEATURE_PROTECTED_RESOURCE_SESSION_SUPPORT);
    STRINGISE_ENUM(D3D12_FEATURE_ROOT_SIGNATURE);
    STRINGISE_ENUM(D3D12_FEATURE_ARCHITECTURE1);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS2);
    STRINGISE_ENUM(D3D12_FEATURE_SHADER_CACHE);
    STRINGISE_ENUM(D3D12_FEATURE_COMMAND_QUEUE_PRIORITY);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS3);
    STRINGISE_ENUM(D3D12_FEATURE_EXISTING_HEAPS);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS4);
    STRINGISE_ENUM(D3D12_FEATURE_SERIALIZATION);
    STRINGISE_ENUM(D3D12_FEATURE_CROSS_NODE);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS5);
    STRINGISE_ENUM(D3D12_FEATURE_DISPLAYABLE);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS6);
    STRINGISE_ENUM(D3D12_FEATURE_QUERY_META_COMMAND);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS7);
    STRINGISE_ENUM(D3D12_FEATURE_PROTECTED_RESOURCE_SESSION_TYPE_COUNT);
    STRINGISE_ENUM(D3D12_FEATURE_PROTECTED_RESOURCE_SESSION_TYPES);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS8);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS9);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS10);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS11);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS12);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS13);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS14);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS15);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS16);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS17);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS18);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS19);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS20);
    STRINGISE_ENUM(D3D12_FEATURE_PREDICATION);
    STRINGISE_ENUM(D3D12_FEATURE_PLACED_RESOURCE_SUPPORT_INFO);
    STRINGISE_ENUM(D3D12_FEATURE_HARDWARE_COPY);
    STRINGISE_ENUM(D3D12_FEATURE_D3D12_OPTIONS21);
  }
  END_ENUM_STRINGISE();
}
