/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6.views.searchtypes;

import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.events.EventList;
import org.graylog.plugins.views.search.searchtypes.events.EventSummary;
import org.graylog.storage.elasticsearch6.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch6.views.searchtypes.ESSearchTypeHandler;

public class ESEventList
implements ESSearchTypeHandler<EventList> {
    public void doGenerateQueryPart(SearchJob job, Query query, EventList eventList, ESGeneratedQueryContext queryContext) {
        queryContext.searchSourceBuilder((SearchType)eventList).size(10000);
    }

    protected List<Map<String, Object>> extractResult(SearchResult result) {
        return result.getHits(Map.class, false).stream().map(hit -> (Map)hit.source).collect(Collectors.toList());
    }

    @Override
    public SearchType.Result doExtractResult(SearchJob job, Query query, EventList searchType, SearchResult result, MetricAggregation aggregations, ESGeneratedQueryContext queryContext) {
        Set effectiveStreams = searchType.streams().isEmpty() ? query.usedStreamIds() : searchType.streams();
        List eventSummaries = this.extractResult(result).stream().map(EventSummary::parse).filter(eventSummary -> effectiveStreams.containsAll(eventSummary.streams())).collect(Collectors.toList());
        EventList.Result.Builder resultBuilder = EventList.Result.builder().events(eventSummaries).id(searchType.id());
        searchType.name().ifPresent(arg_0 -> ((EventList.Result.Builder)resultBuilder).name(arg_0));
        return resultBuilder.build();
    }
}

