/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.ClearScroll;
import io.searchbox.core.SearchResult;
import io.searchbox.core.SearchScroll;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.jackson.TypeReferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrollResultES6
extends IndexQueryResult
implements ScrollResult {
    private static final Logger LOG = LoggerFactory.getLogger(ScrollResult.class);
    private static final String DEFAULT_SCROLL = "1m";
    private static final String SCROLL_ID_FIELD = "_scroll_id";
    private final JestClient jestClient;
    private final ObjectMapper objectMapper;
    private SearchResult initialResult;
    private final String scroll;
    private final List<String> fields;
    private final String queryHash;
    private final long totalHits;
    private String scrollId;
    private final int limit;
    private int chunkId = 0;
    private int resultCount = 0;

    @AssistedInject
    public ScrollResultES6(JestClient jestClient, ObjectMapper objectMapper, @Assisted SearchResult initialResult, @Assisted(value="query") String query, @Assisted List<String> fields, @Assisted int limit) {
        this(jestClient, objectMapper, initialResult, query, DEFAULT_SCROLL, fields, limit);
    }

    @AssistedInject
    public ScrollResultES6(JestClient jestClient, ObjectMapper objectMapper, @Assisted SearchResult initialResult, @Assisted(value="query") String query, @Assisted(value="scroll") String scroll, @Assisted List<String> fields, @Assisted int limit) {
        super(query, null, initialResult.getJsonObject().path("took").asLong());
        this.jestClient = jestClient;
        this.objectMapper = objectMapper;
        this.initialResult = initialResult;
        this.scroll = scroll;
        this.fields = fields;
        this.totalHits = initialResult.getTotal();
        this.scrollId = this.getScrollIdFromResult(initialResult);
        this.limit = limit;
        Md5Hash md5Hash = new Md5Hash((Object)this.getOriginalQuery());
        this.queryHash = md5Hash.toHex();
        LOG.debug("[{}] Starting scroll request for query {}", (Object)this.queryHash, (Object)this.getOriginalQuery());
    }

    public ScrollResult.ScrollChunk nextChunk() throws IOException {
        List<ResultMessage> resultMessages;
        JestResult search;
        if (this.limit != -1 && this.resultCount >= this.limit) {
            LOG.debug("[{}] Reached limit for query {}", (Object)this.queryHash, (Object)this.getOriginalQuery());
            return null;
        }
        if (this.initialResult == null) {
            search = this.getNextScrollResult();
            resultMessages = StreamSupport.stream(search.getJsonObject().path("hits").path("hits").spliterator(), false).map(hit -> ResultMessage.parseFromSource((String)hit.path("_id").asText(), (String)hit.path("_index").asText(), (Map)((Map)this.objectMapper.convertValue((Object)hit.get("_source"), TypeReferences.MAP_STRING_OBJECT)))).collect(Collectors.toList());
        } else {
            search = this.initialResult;
            resultMessages = this.initialResult.getHits(Map.class, false).stream().map(hit -> ResultMessage.parseFromSource((String)hit.id, (String)hit.index, (Map)((Map)hit.source))).collect(Collectors.toList());
            this.initialResult = null;
        }
        if (resultMessages.size() == 0) {
            LOG.debug("[{}] Reached end of scroll results for query {}", (Object)this.queryHash, (Object)this.getOriginalQuery());
            return null;
        }
        int remainingResultsForLimit = this.limit - this.resultCount;
        List<ResultMessage> resultMessagesSlice = this.limit != -1 && remainingResultsForLimit < resultMessages.size() ? resultMessages.subList(0, remainingResultsForLimit) : resultMessages;
        this.resultCount += resultMessagesSlice.size();
        LOG.debug("[{}][{}] New scroll id {}, number of resultMessages in chunk: {}", new Object[]{this.queryHash, this.chunkId, this.getScrollIdFromResult(search), resultMessagesSlice.size()});
        this.scrollId = this.getScrollIdFromResult(search);
        return new ScrollChunkES6(resultMessagesSlice, this.fields, this.chunkId++);
    }

    private String getScrollIdFromResult(JestResult result) {
        if (!result.getJsonObject().hasNonNull(SCROLL_ID_FIELD)) {
            throw new IllegalStateException("Unable to extract scroll id from search result!");
        }
        return result.getJsonObject().path(SCROLL_ID_FIELD).asText();
    }

    private JestResult getNextScrollResult() throws IOException {
        SearchScroll.Builder searchBuilder = new SearchScroll.Builder(this.scrollId, this.scroll);
        return this.jestClient.execute(searchBuilder.build());
    }

    public String getQueryHash() {
        return this.queryHash;
    }

    public long totalHits() {
        return this.totalHits;
    }

    public void cancel() throws IOException {
        ClearScroll.Builder clearScrollBuilder = new ClearScroll.Builder().addScrollId(this.scrollId);
        JestResult result = this.jestClient.execute(clearScrollBuilder.build());
        LOG.debug("[{}] clearScroll for query successful: {}", (Object)this.queryHash, (Object)result.isSucceeded());
    }

    static class ScrollChunkES6
    implements ScrollResult.ScrollChunk {
        private final List<ResultMessage> resultMessages;
        private final List<String> fields;
        private final int chunkNumber;

        public ScrollChunkES6(List<ResultMessage> hits, List<String> fields, int chunkId) {
            this.resultMessages = hits;
            this.fields = fields;
            this.chunkNumber = chunkId;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public int getChunkNumber() {
            return this.chunkNumber;
        }

        public List<ResultMessage> getMessages() {
            return this.resultMessages;
        }
    }

    public static interface Factory {
        public ScrollResultES6 create(SearchResult var1, @Assisted(value="query") String var2, @Assisted(value="scroll") String var3, List<String> var4, int var5);
    }
}

