/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.transport;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.RequestHandlerRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportResponseHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public final class TransportActionProxy {
    private static final String PROXY_ACTION_PREFIX = "internal:transport/proxy/";

    private TransportActionProxy() {
    }

    public static void registerProxyAction(TransportService service, String action, Function<TransportRequest, Supplier<TransportResponse>> responseFunction) {
        RequestHandlerRegistry requestHandler = service.getRequestHandler(action);
        service.registerRequestHandler(TransportActionProxy.getProxyAction(action), () -> new ProxyRequest<Object>(requestHandler::newRequest), "same", true, false, new ProxyRequestHandler(service, action, responseFunction));
    }

    public static void registerProxyAction(TransportService service, String action, Supplier<TransportResponse> responseSupplier) {
        RequestHandlerRegistry requestHandler = service.getRequestHandler(action);
        service.registerRequestHandler(TransportActionProxy.getProxyAction(action), () -> new ProxyRequest<Object>(requestHandler::newRequest), "same", true, false, new ProxyRequestHandler(service, action, request -> responseSupplier));
    }

    public static String getProxyAction(String action) {
        return PROXY_ACTION_PREFIX + action;
    }

    public static TransportRequest wrapRequest(DiscoveryNode node, TransportRequest request) {
        return new ProxyRequest<TransportRequest>(request, node);
    }

    public static TransportRequest unwrapRequest(TransportRequest request) {
        if (request instanceof ProxyRequest) {
            return ((ProxyRequest)request).wrapped;
        }
        return request;
    }

    public static boolean isProxyAction(String action) {
        return action.startsWith(PROXY_ACTION_PREFIX);
    }

    public static boolean isProxyRequest(TransportRequest request) {
        return request instanceof ProxyRequest;
    }

    static class ProxyRequest<T extends TransportRequest>
    extends TransportRequest {
        T wrapped;
        Supplier<T> supplier;
        DiscoveryNode targetNode;

        ProxyRequest(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        ProxyRequest(T wrapped, DiscoveryNode targetNode) {
            this.wrapped = wrapped;
            this.targetNode = targetNode;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.targetNode = new DiscoveryNode(in);
            this.wrapped = (TransportRequest)this.supplier.get();
            ((TransportRequest)this.wrapped).readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.targetNode.writeTo(out);
            ((TransportRequest)this.wrapped).writeTo(out);
        }
    }

    private static class ProxyResponseHandler<T extends TransportResponse>
    implements TransportResponseHandler<T> {
        private final Supplier<T> responseFactory;
        private final TransportChannel channel;

        ProxyResponseHandler(TransportChannel channel, Supplier<T> responseFactory) {
            this.responseFactory = responseFactory;
            this.channel = channel;
        }

        @Override
        public T newInstance() {
            return (T)((TransportResponse)this.responseFactory.get());
        }

        @Override
        public void handleResponse(T response) {
            try {
                this.channel.sendResponse((TransportResponse)response);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void handleException(TransportException exp) {
            try {
                this.channel.sendResponse(exp);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    private static class ProxyRequestHandler<T extends ProxyRequest>
    implements TransportRequestHandler<T> {
        private final TransportService service;
        private final String action;
        private final Function<TransportRequest, Supplier<TransportResponse>> responseFunction;

        ProxyRequestHandler(TransportService service, String action, Function<TransportRequest, Supplier<TransportResponse>> responseFunction) {
            this.service = service;
            this.action = action;
            this.responseFunction = responseFunction;
        }

        @Override
        public void messageReceived(T request, TransportChannel channel) throws Exception {
            DiscoveryNode targetNode = ((ProxyRequest)request).targetNode;
            Object wrappedRequest = ((ProxyRequest)request).wrapped;
            this.service.sendRequest(targetNode, this.action, (TransportRequest)wrappedRequest, new ProxyResponseHandler<TransportResponse>(channel, this.responseFunction.apply((TransportRequest)wrappedRequest)));
        }
    }
}

