/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Streamable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregation;

public final class InternalAggregations
extends Aggregations
implements ToXContent,
Streamable {
    public static final InternalAggregations EMPTY = new InternalAggregations();

    private InternalAggregations() {
    }

    public InternalAggregations(List<InternalAggregation> aggregations) {
        super(aggregations);
    }

    public static InternalAggregations reduce(List<InternalAggregations> aggregationsList, InternalAggregation.ReduceContext context) {
        if (aggregationsList.isEmpty()) {
            return null;
        }
        HashMap<String, List> aggByName = new HashMap<String, List>();
        for (InternalAggregations aggregations : aggregationsList) {
            for (Aggregation aggregation : aggregations.aggregations) {
                List aggs = aggByName.computeIfAbsent(aggregation.getName(), k -> new ArrayList(aggregationsList.size()));
                aggs.add((InternalAggregation)aggregation);
            }
        }
        ArrayList<InternalAggregation> reducedAggregations = new ArrayList<InternalAggregation>();
        for (Map.Entry entry : aggByName.entrySet()) {
            List aggregations = (List)entry.getValue();
            InternalAggregation first = (InternalAggregation)aggregations.get(0);
            reducedAggregations.add(first.reduce(aggregations, context));
        }
        return new InternalAggregations((List<InternalAggregation>)reducedAggregations);
    }

    public static InternalAggregations readAggregations(StreamInput in) throws IOException {
        InternalAggregations result = new InternalAggregations();
        result.readFrom(in);
        return result;
    }

    public static InternalAggregations readOptionalAggregations(StreamInput in) throws IOException {
        return in.readOptionalStreamable(InternalAggregations::new);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.aggregations = in.readList(stream -> in.readNamedWriteable(InternalAggregation.class));
        if (this.aggregations.isEmpty()) {
            this.aggregationsAsMap = Collections.emptyMap();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableList(this.aggregations);
    }
}

