/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BytesRestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestBuilderListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.StoredScriptSource;

public class RestGetStoredScriptAction
extends BaseRestHandler {
    public static final ParseField _ID_PARSE_FIELD = new ParseField("_id", new String[0]);
    public static final ParseField FOUND_PARSE_FIELD = new ParseField("found", new String[0]);

    public RestGetStoredScriptAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_scripts/{lang}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_scripts/{lang}/{id}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String lang;
        String id;
        if (request.param("id") == null) {
            id = request.param("lang");
            lang = null;
        } else {
            id = request.param("id");
            lang = request.param("lang");
        }
        if (lang != null) {
            this.deprecationLogger.deprecated("specifying lang [" + lang + "] as part of the url path is deprecated", new Object[0]);
        }
        GetStoredScriptRequest getRequest = new GetStoredScriptRequest(id, lang);
        return channel -> client.admin().cluster().getStoredScript(getRequest, (ActionListener<GetStoredScriptResponse>)new RestBuilderListener<GetStoredScriptResponse>(channel){

            @Override
            public RestResponse buildResponse(GetStoredScriptResponse response, XContentBuilder builder) throws Exception {
                StoredScriptSource source;
                builder.startObject();
                builder.field(_ID_PARSE_FIELD.getPreferredName(), id);
                if (lang != null) {
                    builder.field(StoredScriptSource.LANG_PARSE_FIELD.getPreferredName(), lang);
                }
                boolean found = (source = response.getSource()) != null;
                builder.field(FOUND_PARSE_FIELD.getPreferredName(), found);
                if (found) {
                    if (lang == null) {
                        builder.startObject(StoredScriptSource.SCRIPT_PARSE_FIELD.getPreferredName());
                        builder.field(StoredScriptSource.LANG_PARSE_FIELD.getPreferredName(), source.getLang());
                        builder.field(StoredScriptSource.SOURCE_PARSE_FIELD.getPreferredName(), source.getSource());
                        if (!source.getOptions().isEmpty()) {
                            builder.field(StoredScriptSource.OPTIONS_PARSE_FIELD.getPreferredName(), source.getOptions());
                        }
                        builder.endObject();
                    } else {
                        builder.field(StoredScriptSource.SCRIPT_PARSE_FIELD.getPreferredName(), source.getSource());
                    }
                }
                builder.endObject();
                return new BytesRestResponse(found ? RestStatus.OK : RestStatus.NOT_FOUND, builder);
            }
        });
    }
}

