/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.CollectionUtil;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.CommitPoint;

public class CommitPoints
implements Iterable<CommitPoint> {
    private final List<CommitPoint> commitPoints;

    public CommitPoints(List<CommitPoint> commitPoints) {
        CollectionUtil.introSort(commitPoints, new Comparator<CommitPoint>(){

            @Override
            public int compare(CommitPoint o1, CommitPoint o2) {
                return o2.version() < o1.version() ? -1 : (o2.version() == o1.version() ? 0 : 1);
            }
        });
        this.commitPoints = Collections.unmodifiableList(new ArrayList<CommitPoint>(commitPoints));
    }

    public List<CommitPoint> commits() {
        return this.commitPoints;
    }

    public boolean hasVersion(long version) {
        for (CommitPoint commitPoint : this.commitPoints) {
            if (commitPoint.version() != version) continue;
            return true;
        }
        return false;
    }

    public CommitPoint.FileInfo findPhysicalIndexFile(String physicalName) {
        for (CommitPoint commitPoint : this.commitPoints) {
            CommitPoint.FileInfo fileInfo = commitPoint.findPhysicalIndexFile(physicalName);
            if (fileInfo == null) continue;
            return fileInfo;
        }
        return null;
    }

    public CommitPoint.FileInfo findNameFile(String name) {
        for (CommitPoint commitPoint : this.commitPoints) {
            CommitPoint.FileInfo fileInfo = commitPoint.findNameFile(name);
            if (fileInfo == null) continue;
            return fileInfo;
        }
        return null;
    }

    @Override
    public Iterator<CommitPoint> iterator() {
        return this.commitPoints.iterator();
    }

    public static byte[] toXContent(CommitPoint commitPoint) throws Exception {
        XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON).prettyPrint();
        builder.startObject();
        builder.field("version", commitPoint.version());
        builder.field("name", commitPoint.name());
        builder.field("type", commitPoint.type().toString());
        builder.startObject("index_files");
        for (CommitPoint.FileInfo fileInfo : commitPoint.indexFiles()) {
            builder.startObject(fileInfo.name());
            builder.field("physical_name", fileInfo.physicalName());
            builder.field("length", fileInfo.length());
            if (fileInfo.checksum() != null) {
                builder.field("checksum", fileInfo.checksum());
            }
            builder.endObject();
        }
        builder.endObject();
        builder.startObject("translog_files");
        for (CommitPoint.FileInfo fileInfo : commitPoint.translogFiles()) {
            builder.startObject(fileInfo.name());
            builder.field("physical_name", fileInfo.physicalName());
            builder.field("length", fileInfo.length());
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return BytesReference.toBytes(builder.bytes());
    }

    public static CommitPoint fromXContent(byte[] data) throws Exception {
        try (XContentParser parser = XContentFactory.xContent(XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, data);){
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                throw new IOException("No commit point data");
            }
            long version = -1L;
            String name = null;
            CommitPoint.Type type = null;
            ArrayList<CommitPoint.FileInfo> indexFiles = new ArrayList<CommitPoint.FileInfo>();
            ArrayList<CommitPoint.FileInfo> translogFiles = new ArrayList<CommitPoint.FileInfo>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    ArrayList<CommitPoint.FileInfo> files = null;
                    if ("index_files".equals(currentFieldName) || "indexFiles".equals(currentFieldName)) {
                        files = indexFiles;
                    } else if ("translog_files".equals(currentFieldName) || "translogFiles".equals(currentFieldName)) {
                        files = translogFiles;
                    } else {
                        throw new IOException("Can't handle object with name [" + currentFieldName + "]");
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token != XContentParser.Token.START_OBJECT) continue;
                        String fileName = currentFieldName;
                        String physicalName = null;
                        long size = -1L;
                        String checksum = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if ("physical_name".equals(currentFieldName) || "physicalName".equals(currentFieldName)) {
                                physicalName = parser.text();
                                continue;
                            }
                            if ("length".equals(currentFieldName)) {
                                size = parser.longValue();
                                continue;
                            }
                            if (!"checksum".equals(currentFieldName)) continue;
                            checksum = parser.text();
                        }
                        if (physicalName == null) {
                            throw new IOException("Malformed commit, missing physical_name for [" + fileName + "]");
                        }
                        if (size == -1L) {
                            throw new IOException("Malformed commit, missing length for [" + fileName + "]");
                        }
                        files.add(new CommitPoint.FileInfo(fileName, physicalName, size, checksum));
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("version".equals(currentFieldName)) {
                    version = parser.longValue();
                    continue;
                }
                if ("name".equals(currentFieldName)) {
                    name = parser.text();
                    continue;
                }
                if (!"type".equals(currentFieldName)) continue;
                type = CommitPoint.Type.valueOf(parser.text());
            }
            if (version == -1L) {
                throw new IOException("Malformed commit, missing version");
            }
            if (name == null) {
                throw new IOException("Malformed commit, missing name");
            }
            if (type == null) {
                throw new IOException("Malformed commit, missing type");
            }
            CommitPoint commitPoint = new CommitPoint(version, name, type, indexFiles, translogFiles);
            return commitPoint;
        }
    }
}

