/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.InnerHitBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.ParsedQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.SearchScript;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.sort.SortAndFormats;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.sort.SortBuilder;

public abstract class InnerHitContextBuilder {
    protected final QueryBuilder query;
    protected final InnerHitBuilder innerHitBuilder;
    protected final Map<String, InnerHitContextBuilder> children;

    protected InnerHitContextBuilder(QueryBuilder query, InnerHitBuilder innerHitBuilder, Map<String, InnerHitContextBuilder> children) {
        this.innerHitBuilder = innerHitBuilder;
        this.children = children;
        this.query = query;
    }

    public abstract void build(SearchContext var1, InnerHitsContext var2) throws IOException;

    public static void extractInnerHits(QueryBuilder query, Map<String, InnerHitContextBuilder> innerHitBuilders) {
        if (!(query instanceof AbstractQueryBuilder)) {
            throw new IllegalStateException("provided query builder [" + query.getClass() + "] class should inherit from AbstractQueryBuilder, but it doesn't");
        }
        ((AbstractQueryBuilder)query).extractInnerHitBuilders(innerHitBuilders);
    }

    protected void setupInnerHitsContext(QueryShardContext queryShardContext, InnerHitsContext.InnerHitSubContext innerHitsContext) throws IOException {
        Optional<SortAndFormats> optionalSort;
        innerHitsContext.from(this.innerHitBuilder.getFrom());
        innerHitsContext.size(this.innerHitBuilder.getSize());
        innerHitsContext.explain(this.innerHitBuilder.isExplain());
        innerHitsContext.version(this.innerHitBuilder.isVersion());
        innerHitsContext.trackScores(this.innerHitBuilder.isTrackScores());
        if (this.innerHitBuilder.getStoredFieldsContext() != null) {
            innerHitsContext.storedFieldsContext(this.innerHitBuilder.getStoredFieldsContext());
        }
        if (this.innerHitBuilder.getDocValueFields() != null) {
            innerHitsContext.docValueFieldsContext(new DocValueFieldsContext(this.innerHitBuilder.getDocValueFields()));
        }
        if (this.innerHitBuilder.getScriptFields() != null) {
            for (SearchSourceBuilder.ScriptField field : this.innerHitBuilder.getScriptFields()) {
                SearchScript searchScript = innerHitsContext.getQueryShardContext().getSearchScript(field.script(), ScriptContext.Standard.SEARCH);
                innerHitsContext.scriptFields().add(new ScriptFieldsContext.ScriptField(field.fieldName(), searchScript, field.ignoreFailure()));
            }
        }
        if (this.innerHitBuilder.getFetchSourceContext() != null) {
            innerHitsContext.fetchSourceContext(this.innerHitBuilder.getFetchSourceContext());
        }
        if (this.innerHitBuilder.getSorts() != null && (optionalSort = SortBuilder.buildSort(this.innerHitBuilder.getSorts(), queryShardContext)).isPresent()) {
            innerHitsContext.sort(optionalSort.get());
        }
        if (this.innerHitBuilder.getHighlightBuilder() != null) {
            innerHitsContext.highlight(this.innerHitBuilder.getHighlightBuilder().build(queryShardContext));
        }
        ParsedQuery parsedQuery = new ParsedQuery(this.query.toQuery(queryShardContext), queryShardContext.copyNamedQueries());
        innerHitsContext.parsedQuery(parsedQuery);
        Map<String, InnerHitsContext.InnerHitSubContext> baseChildren = InnerHitContextBuilder.buildChildInnerHits(innerHitsContext.parentSearchContext(), this.children);
        innerHitsContext.setChildInnerHits(baseChildren);
    }

    private static Map<String, InnerHitsContext.InnerHitSubContext> buildChildInnerHits(SearchContext parentSearchContext, Map<String, InnerHitContextBuilder> children) throws IOException {
        HashMap<String, InnerHitsContext.InnerHitSubContext> childrenInnerHits = new HashMap<String, InnerHitsContext.InnerHitSubContext>();
        for (Map.Entry<String, InnerHitContextBuilder> entry : children.entrySet()) {
            InnerHitsContext childInnerHitsContext = new InnerHitsContext();
            entry.getValue().build(parentSearchContext, childInnerHitsContext);
            if (childInnerHitsContext.getInnerHits() == null) continue;
            childrenInnerHits.putAll(childInnerHitsContext.getInnerHits());
        }
        return childrenInnerHits;
    }
}

