/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.DoubleRange;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.FloatRange;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.InetAddressPoint;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.InetAddressRange;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.IntRange;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.LongRange;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.StoredField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BoostQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Explicit;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.ShapeRelation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.joda.DateMathParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.network.InetAddresses;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.LocaleUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.DateFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.NumberFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.TypeParsers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.RangeQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.joda.time.DateTimeZone;

public class RangeFieldMapper
extends FieldMapper {
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private Boolean includeInAll;
    private Explicit<Boolean> coerce;

    private RangeFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> coerce, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.coerce = coerce;
        this.includeInAll = includeInAll;
    }

    @Override
    public RangeFieldType fieldType() {
        return (RangeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType.typeName();
    }

    @Override
    protected RangeFieldMapper clone() {
        return (RangeFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        Range range;
        boolean includeInAll = context.includeInAll(this.includeInAll, this);
        if (context.externalValueSet()) {
            range = context.parseExternalValue(Range.class);
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                RangeFieldType fieldType = this.fieldType();
                RangeType rangeType = fieldType.rangeType;
                String fieldName = null;
                Object from = rangeType.minValue();
                Object to = rangeType.maxValue();
                boolean includeFrom = true;
                boolean includeTo = true;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.GT_FIELD.getPreferredName())) {
                        includeFrom = false;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        from = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.GTE_FIELD.getPreferredName())) {
                        includeFrom = true;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        from = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.LT_FIELD.getPreferredName())) {
                        includeTo = false;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        to = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.LTE_FIELD.getPreferredName())) {
                        includeTo = true;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        to = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                        continue;
                    }
                    throw new MapperParsingException("error parsing field [" + this.name() + "], with unknown parameter [" + fieldName + "]");
                }
                range = new Range(rangeType, from, to, includeFrom, includeTo);
            } else {
                throw new MapperParsingException("error parsing field [" + this.name() + "], expected an object but got " + parser.currentName());
            }
        }
        if (includeInAll) {
            context.allEntries().addText(this.fieldType.name(), range.toString(), this.fieldType.boost());
        }
        boolean indexed = this.fieldType.indexOptions() != IndexOptions.NONE;
        boolean docValued = this.fieldType.hasDocValues();
        boolean stored = this.fieldType.stored();
        fields.addAll(this.fieldType().rangeType.createFields(this.name(), range, indexed, docValued, stored));
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        RangeFieldMapper other = (RangeFieldMapper)mergeWith;
        this.includeInAll = other.includeInAll;
        if (other.coerce.explicit()) {
            this.coerce = other.coerce;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.fieldType().rangeType == RangeType.DATE && (includeDefaults || this.fieldType().dateTimeFormatter() != null && !this.fieldType().dateTimeFormatter().format().equals(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format()))) {
            builder.field("format", this.fieldType().dateTimeFormatter().format());
        }
        if (this.fieldType().rangeType == RangeType.DATE && (includeDefaults || this.fieldType().dateTimeFormatter() != null && this.fieldType().dateTimeFormatter().locale() != Locale.ROOT)) {
            builder.field("locale", this.fieldType().dateTimeFormatter().locale());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", this.coerce.value());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static class Range {
        RangeType type;
        private Object from;
        private Object to;
        private boolean includeFrom;
        private boolean includeTo;

        public Range(RangeType type, Object from, Object to, boolean includeFrom, boolean includeTo) {
            this.type = type;
            this.from = from;
            this.to = to;
            this.includeFrom = includeFrom;
            this.includeTo = includeTo;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.includeFrom ? (char)'[' : '(');
            Object f = this.includeFrom || this.from.equals(this.type.minValue()) ? this.from : this.type.nextDown(this.from);
            Object t = this.includeTo || this.to.equals(this.type.maxValue()) ? this.to : this.type.nextUp(this.to);
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)f) : f.toString());
            sb.append(" : ");
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)t) : t.toString());
            sb.append(this.includeTo ? (char)']' : ')');
            return sb.toString();
        }
    }

    public static abstract class RangeType
    extends Enum<RangeType> {
        public static final /* enum */ RangeType IP = new RangeType("ip_range"){

            @Override
            public Field getRangeField(String name, Range r) {
                return new InetAddressRange(name, (InetAddress)r.from, (InetAddress)r.to);
            }

            @Override
            public InetAddress parseFrom(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
                InetAddress address = InetAddresses.forString(parser.text());
                return included ? address : this.nextUp(address);
            }

            @Override
            public InetAddress parseTo(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
                InetAddress address = InetAddresses.forString(parser.text());
                return included ? address : this.nextDown(address);
            }

            @Override
            public InetAddress parse(Object value, boolean coerce) {
                if (value instanceof InetAddress) {
                    return (InetAddress)value;
                }
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                return InetAddresses.forString(value.toString());
            }

            @Override
            public InetAddress minValue() {
                return InetAddressPoint.MIN_VALUE;
            }

            @Override
            public InetAddress maxValue() {
                return InetAddressPoint.MAX_VALUE;
            }

            @Override
            public InetAddress nextUp(Object value) {
                return InetAddressPoint.nextUp((InetAddress)value);
            }

            @Override
            public InetAddress nextDown(Object value) {
                return InetAddressPoint.nextDown((InetAddress)value);
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                InetAddress lower = (InetAddress)from;
                InetAddress upper = (InetAddress)to;
                return InetAddressRange.newWithinQuery(field, includeLower ? lower : this.nextUp(lower), includeUpper ? upper : this.nextDown(upper));
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                InetAddress lower = (InetAddress)from;
                InetAddress upper = (InetAddress)to;
                return InetAddressRange.newContainsQuery(field, includeLower ? lower : this.nextUp(lower), includeUpper ? upper : this.nextDown(upper));
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                InetAddress lower = (InetAddress)from;
                InetAddress upper = (InetAddress)to;
                return InetAddressRange.newIntersectsQuery(field, includeLower ? lower : this.nextUp(lower), includeUpper ? upper : this.nextDown(upper));
            }

            public String toString(InetAddress address) {
                return InetAddresses.toAddrString(address);
            }
        };
        public static final /* enum */ RangeType DATE = new RangeType("date_range", NumberFieldMapper.NumberType.LONG){

            @Override
            public Field getRangeField(String name, Range r) {
                return new LongRange(name, new long[]{((Number)r.from).longValue()}, new long[]{((Number)r.to).longValue()});
            }

            private Number parse(DateMathParser dateMathParser, String dateStr) {
                return dateMathParser.parse(dateStr, () -> {
                    throw new IllegalArgumentException("now is not used at indexing time");
                });
            }

            @Override
            public Number parseFrom(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
                Number value = this.parse(fieldType.dateMathParser, parser.text());
                return included ? (Number)value : (Number)this.nextUp(value);
            }

            @Override
            public Number parseTo(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
                Number value = this.parse(fieldType.dateMathParser, parser.text());
                return included ? (Number)value : (Number)this.nextDown(value);
            }

            @Override
            public Long minValue() {
                return Long.MIN_VALUE;
            }

            @Override
            public Long maxValue() {
                return Long.MAX_VALUE;
            }

            @Override
            public Long nextUp(Object value) {
                return (long)((Long)LONG.nextUp(value));
            }

            @Override
            public Long nextDown(Object value) {
                return (long)((Long)LONG.nextDown(value));
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, @Nullable DateTimeZone timeZone, @Nullable DateMathParser parser, QueryShardContext context) {
                DateMathParser dateMathParser;
                DateTimeZone zone = timeZone == null ? DateTimeZone.UTC : timeZone;
                DateMathParser dateMathParser2 = dateMathParser = parser == null ? new DateMathParser(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER) : parser;
                Long low = lowerTerm == null ? Long.MIN_VALUE : dateMathParser.parse(lowerTerm instanceof BytesRef ? ((BytesRef)lowerTerm).utf8ToString() : lowerTerm.toString(), context::nowInMillis, false, zone);
                Long high = upperTerm == null ? Long.MAX_VALUE : dateMathParser.parse(upperTerm instanceof BytesRef ? ((BytesRef)upperTerm).utf8ToString() : upperTerm.toString(), context::nowInMillis, false, zone);
                return super.rangeQuery(field, low, high, includeLower, includeUpper, relation, zone, dateMathParser, context);
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                return LONG.withinQuery(field, from, to, includeLower, includeUpper);
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                return LONG.containsQuery(field, from, to, includeLower, includeUpper);
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                return LONG.intersectsQuery(field, from, to, includeLower, includeUpper);
            }
        };
        public static final /* enum */ RangeType FLOAT = new RangeType("float_range", NumberFieldMapper.NumberType.FLOAT){

            @Override
            public Float minValue() {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }

            @Override
            public Float maxValue() {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }

            @Override
            public Float nextUp(Object value) {
                return Float.valueOf(Math.nextUp(((Number)value).floatValue()));
            }

            @Override
            public Float nextDown(Object value) {
                return Float.valueOf(Math.nextDown(((Number)value).floatValue()));
            }

            @Override
            public Field getRangeField(String name, Range r) {
                return new FloatRange(name, new float[]{((Number)r.from).floatValue()}, new float[]{((Number)r.to).floatValue()});
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return FloatRange.newWithinQuery(field, new float[]{includeFrom ? ((Float)from).floatValue() : Math.nextUp(((Float)from).floatValue())}, new float[]{includeTo ? ((Float)to).floatValue() : Math.nextDown(((Float)to).floatValue())});
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return FloatRange.newContainsQuery(field, new float[]{includeFrom ? ((Float)from).floatValue() : Math.nextUp(((Float)from).floatValue())}, new float[]{includeTo ? ((Float)to).floatValue() : Math.nextDown(((Float)to).floatValue())});
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return FloatRange.newIntersectsQuery(field, new float[]{includeFrom ? ((Float)from).floatValue() : Math.nextUp(((Float)from).floatValue())}, new float[]{includeTo ? ((Float)to).floatValue() : Math.nextDown(((Float)to).floatValue())});
            }
        };
        public static final /* enum */ RangeType DOUBLE = new RangeType("double_range", NumberFieldMapper.NumberType.DOUBLE){

            @Override
            public Double minValue() {
                return Double.NEGATIVE_INFINITY;
            }

            @Override
            public Double maxValue() {
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public Double nextUp(Object value) {
                return Math.nextUp(((Number)value).doubleValue());
            }

            @Override
            public Double nextDown(Object value) {
                return Math.nextDown(((Number)value).doubleValue());
            }

            @Override
            public Field getRangeField(String name, Range r) {
                return new DoubleRange(name, new double[]{((Number)r.from).doubleValue()}, new double[]{((Number)r.to).doubleValue()});
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return DoubleRange.newWithinQuery(field, new double[]{includeFrom ? (Double)from : Math.nextUp((Double)from)}, new double[]{includeTo ? (Double)to : Math.nextDown((Double)to)});
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return DoubleRange.newContainsQuery(field, new double[]{includeFrom ? (Double)from : Math.nextUp((Double)from)}, new double[]{includeTo ? (Double)to : Math.nextDown((Double)to)});
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return DoubleRange.newIntersectsQuery(field, new double[]{includeFrom ? (Double)from : Math.nextUp((Double)from)}, new double[]{includeTo ? (Double)to : Math.nextDown((Double)to)});
            }
        };
        public static final /* enum */ RangeType INTEGER = new RangeType("integer_range", NumberFieldMapper.NumberType.INTEGER){

            @Override
            public Integer minValue() {
                return Integer.MIN_VALUE;
            }

            @Override
            public Integer maxValue() {
                return Integer.MAX_VALUE;
            }

            @Override
            public Integer nextUp(Object value) {
                return ((Number)value).intValue() + 1;
            }

            @Override
            public Integer nextDown(Object value) {
                return ((Number)value).intValue() - 1;
            }

            @Override
            public Field getRangeField(String name, Range r) {
                return new IntRange(name, new int[]{((Number)r.from).intValue()}, new int[]{((Number)r.to).intValue()});
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return IntRange.newWithinQuery(field, new int[]{(Integer)from + (includeFrom ? 0 : 1)}, new int[]{(Integer)to - (includeTo ? 0 : 1)});
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return IntRange.newContainsQuery(field, new int[]{(Integer)from + (includeFrom ? 0 : 1)}, new int[]{(Integer)to - (includeTo ? 0 : 1)});
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return IntRange.newIntersectsQuery(field, new int[]{(Integer)from + (includeFrom ? 0 : 1)}, new int[]{(Integer)to - (includeTo ? 0 : 1)});
            }
        };
        public static final /* enum */ RangeType LONG = new RangeType("long_range", NumberFieldMapper.NumberType.LONG){

            @Override
            public Long minValue() {
                return Long.MIN_VALUE;
            }

            @Override
            public Long maxValue() {
                return Long.MAX_VALUE;
            }

            @Override
            public Long nextUp(Object value) {
                return ((Number)value).longValue() + 1L;
            }

            @Override
            public Long nextDown(Object value) {
                return ((Number)value).longValue() - 1L;
            }

            @Override
            public Field getRangeField(String name, Range r) {
                return new LongRange(name, new long[]{((Number)r.from).longValue()}, new long[]{((Number)r.to).longValue()});
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return LongRange.newWithinQuery(field, new long[]{(Long)from + (long)(includeFrom ? 0 : 1)}, new long[]{(Long)to - (long)(includeTo ? 0 : 1)});
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return LongRange.newContainsQuery(field, new long[]{(Long)from + (long)(includeFrom ? 0 : 1)}, new long[]{(Long)to - (long)(includeTo ? 0 : 1)});
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return LongRange.newIntersectsQuery(field, new long[]{(Long)from + (long)(includeFrom ? 0 : 1)}, new long[]{(Long)to - (long)(includeTo ? 0 : 1)});
            }
        };
        public final String name;
        private final NumberFieldMapper.NumberType numberType;
        private static final /* synthetic */ RangeType[] $VALUES;

        public static RangeType[] values() {
            return (RangeType[])$VALUES.clone();
        }

        public static RangeType valueOf(String name) {
            return Enum.valueOf(RangeType.class, name);
        }

        private RangeType(String name) {
            this.name = name;
            this.numberType = null;
        }

        private RangeType(String name, NumberFieldMapper.NumberType type) {
            this.name = name;
            this.numberType = type;
        }

        public final String typeName() {
            return this.name;
        }

        public abstract Field getRangeField(String var1, Range var2);

        public List<IndexableField> createFields(String name, Range range, boolean indexed, boolean docValued, boolean stored) {
            assert (range != null) : "range cannot be null when creating fields";
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            if (indexed) {
                fields.add(this.getRangeField(name, range));
            }
            if (stored) {
                fields.add(new StoredField(name, range.toString()));
            }
            return fields;
        }

        public Object parseFrom(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
            Number value = this.numberType.parse(parser, coerce);
            return included ? (Number)value : (Number)((Number)this.nextUp(value));
        }

        public Object parseTo(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
            Number value = this.numberType.parse(parser, coerce);
            return included ? (Number)value : (Number)((Number)this.nextDown(value));
        }

        public abstract Object minValue();

        public abstract Object maxValue();

        public abstract Object nextUp(Object var1);

        public abstract Object nextDown(Object var1);

        public abstract Query withinQuery(String var1, Object var2, Object var3, boolean var4, boolean var5);

        public abstract Query containsQuery(String var1, Object var2, Object var3, boolean var4, boolean var5);

        public abstract Query intersectsQuery(String var1, Object var2, Object var3, boolean var4, boolean var5);

        public Object parse(Object value, boolean coerce) {
            return this.numberType.parse(value, coerce);
        }

        public Query rangeQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo, ShapeRelation relation, @Nullable DateTimeZone timeZone, @Nullable DateMathParser dateMathParser, QueryShardContext context) {
            Object upper;
            Object lower = from == null ? this.minValue() : this.parse(from, false);
            Object object = upper = to == null ? this.maxValue() : this.parse(to, false);
            if (relation == ShapeRelation.WITHIN) {
                return this.withinQuery(field, lower, upper, includeFrom, includeTo);
            }
            if (relation == ShapeRelation.CONTAINS) {
                return this.containsQuery(field, lower, upper, includeFrom, includeTo);
            }
            return this.intersectsQuery(field, lower, upper, includeFrom, includeTo);
        }

        static {
            $VALUES = new RangeType[]{IP, DATE, FLOAT, DOUBLE, INTEGER, LONG};
        }
    }

    public static final class RangeFieldType
    extends MappedFieldType {
        protected RangeType rangeType;
        protected FormatDateTimeFormatter dateTimeFormatter;
        protected DateMathParser dateMathParser;

        public RangeFieldType(RangeType type) {
            this.rangeType = Objects.requireNonNull(type);
            this.setTokenized(false);
            this.setHasDocValues(false);
            this.setOmitNorms(true);
            if (this.rangeType == RangeType.DATE) {
                this.setDateTimeFormatter(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER);
            }
        }

        public RangeFieldType(RangeFieldType other) {
            super(other);
            this.rangeType = other.rangeType;
            if (other.dateTimeFormatter() != null) {
                this.setDateTimeFormatter(other.dateTimeFormatter);
            }
        }

        @Override
        public MappedFieldType clone() {
            return new RangeFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            RangeFieldType that = (RangeFieldType)o;
            return Objects.equals((Object)this.rangeType, (Object)that.rangeType) && this.rangeType == RangeType.DATE ? Objects.equals(this.dateTimeFormatter.format(), that.dateTimeFormatter.format()) && Objects.equals(this.dateTimeFormatter.locale(), that.dateTimeFormatter.locale()) : this.dateTimeFormatter == null && that.dateTimeFormatter == null;
        }

        @Override
        public int hashCode() {
            return this.dateTimeFormatter == null ? Objects.hash(new Object[]{super.hashCode(), this.rangeType}) : Objects.hash(new Object[]{super.hashCode(), this.rangeType, this.dateTimeFormatter.format(), this.dateTimeFormatter.locale()});
        }

        @Override
        public String typeName() {
            return this.rangeType.name;
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            if (strict) {
                RangeFieldType other = (RangeFieldType)fieldType;
                if (this.rangeType != other.rangeType) {
                    conflicts.add("mapper [" + this.name() + "] is attempting to update from type [" + this.rangeType.name + "] to incompatible type [" + other.rangeType.name + "].");
                }
                if (this.rangeType == RangeType.DATE) {
                    if (!Objects.equals(this.dateTimeFormatter().format(), other.dateTimeFormatter().format())) {
                        conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [format] across all types.");
                    }
                    if (!Objects.equals(this.dateTimeFormatter().locale(), other.dateTimeFormatter().locale())) {
                        conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [locale] across all types.");
                    }
                }
            }
        }

        public FormatDateTimeFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public void setDateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.checkIfFrozen();
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = new DateMathParser(dateTimeFormatter);
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            Query query = this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, QueryShardContext context) {
            this.failIfNotIndexed();
            return this.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, relation, null, this.dateMathParser, context);
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, DateTimeZone timeZone, DateMathParser parser, QueryShardContext context) {
            return this.rangeType.rangeQuery(this.name(), lowerTerm, upperTerm, includeLower, includeUpper, relation, timeZone, parser, context);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        final RangeType type;

        public TypeParser(RangeType type) {
            this.type = type;
        }

        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name, this.type);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    throw new MapperParsingException("Property [null_value] is not supported for [" + this.type.name + "] field types.");
                }
                if (propName.equals("coerce")) {
                    builder.coerce(TypeParsers.nodeBooleanValue(name, "coerce", propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("locale")) {
                    builder.locale(LocaleUtils.parse(propNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(propNode));
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, RangeFieldMapper> {
        private Boolean coerce;
        private Locale locale;

        public Builder(String name, RangeType type) {
            super(name, new RangeFieldType(type), new RangeFieldType(type));
            this.builder = this;
            this.locale = Locale.ROOT;
        }

        @Override
        public RangeFieldType fieldType() {
            return (RangeFieldType)this.fieldType;
        }

        @Override
        public Builder docValues(boolean docValues) {
            if (docValues) {
                throw new IllegalArgumentException("field [" + this.name + "] does not currently support " + "doc_values");
            }
            return (Builder)super.docValues(docValues);
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(COERCE_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.COERCE;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.fieldType().setDateTimeFormatter(dateTimeFormatter);
            return this;
        }

        @Override
        public Builder nullValue(Object nullValue) {
            throw new IllegalArgumentException("Field [" + this.name() + "] does not support null value.");
        }

        public void locale(Locale locale) {
            this.locale = locale;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            FormatDateTimeFormatter dateTimeFormatter = this.fieldType().dateTimeFormatter;
            if (this.fieldType().rangeType == RangeType.DATE) {
                if (!this.locale.equals(dateTimeFormatter.locale())) {
                    this.fieldType().setDateTimeFormatter(new FormatDateTimeFormatter(dateTimeFormatter.format(), dateTimeFormatter.parser(), dateTimeFormatter.printer(), this.locale));
                }
            } else if (dateTimeFormatter != null) {
                throw new IllegalArgumentException("field [" + this.name() + "] of type [" + (Object)((Object)this.fieldType().rangeType) + "] should not define a dateTimeFormatter unless it is a " + (Object)((Object)RangeType.DATE) + " type");
            }
        }

        @Override
        public RangeFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new RangeFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.coerce(context), this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(true, false);
    }
}

