/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.RandomAccessOrds;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.FieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public abstract class AbstractAtomicOrdinalsFieldData
implements AtomicOrdinalsFieldData {
    public static final Function<RandomAccessOrds, ScriptDocValues<?>> DEFAULT_SCRIPT_FUNCTION = ((Function<RandomAccessOrds, SortedBinaryDocValues>)FieldData::toString).andThen(ScriptDocValues.Strings::new);
    private final Function<RandomAccessOrds, ScriptDocValues<?>> scriptFunction;

    protected AbstractAtomicOrdinalsFieldData(Function<RandomAccessOrds, ScriptDocValues<?>> scriptFunction) {
        this.scriptFunction = scriptFunction;
    }

    @Override
    public final ScriptDocValues<?> getScriptValues() {
        return this.scriptFunction.apply(this.getOrdinalsValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getOrdinalsValues());
    }

    public static AtomicOrdinalsFieldData empty() {
        return new AbstractAtomicOrdinalsFieldData((Function)DEFAULT_SCRIPT_FUNCTION){

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }

            @Override
            public void close() {
            }

            @Override
            public RandomAccessOrds getOrdinalsValues() {
                return DocValues.emptySortedSet();
            }
        };
    }
}

