/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import java.util.regex.Pattern;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.pattern.PatternCaptureGroupTokenFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class PatternCaptureGroupTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Pattern[] patterns;
    private final boolean preserveOriginal;
    private static final String PATTERNS_KEY = "patterns";
    private static final String PRESERVE_ORIG_KEY = "preserve_original";

    public PatternCaptureGroupTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        String[] regexes = settings.getAsArray(PATTERNS_KEY, null, false);
        if (regexes == null) {
            throw new IllegalArgumentException("required setting 'patterns' is missing for token filter [" + name + "]");
        }
        this.patterns = new Pattern[regexes.length];
        for (int i = 0; i < regexes.length; ++i) {
            this.patterns[i] = Pattern.compile(regexes[i]);
        }
        this.preserveOriginal = settings.getAsBoolean(PRESERVE_ORIG_KEY, true);
    }

    @Override
    public TokenFilter create(TokenStream tokenStream) {
        return new PatternCaptureGroupTokenFilter(tokenStream, this.preserveOriginal, this.patterns);
    }
}

