/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Tokenizer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.CharMatcher;

public class NGramTokenizerFactory
extends AbstractTokenizerFactory {
    private final int minGram;
    private final int maxGram;
    private final CharMatcher matcher;
    static final Map<String, CharMatcher> MATCHERS;

    static CharMatcher parseTokenChars(String[] characterClasses) {
        if (characterClasses == null || characterClasses.length == 0) {
            return null;
        }
        CharMatcher.Builder builder = new CharMatcher.Builder();
        for (String characterClass : characterClasses) {
            CharMatcher matcher = MATCHERS.get(characterClass = characterClass.toLowerCase(Locale.ROOT).trim());
            if (matcher == null) {
                throw new IllegalArgumentException("Unknown token type: '" + characterClass + "', must be one of " + MATCHERS.keySet());
            }
            builder.or(matcher);
        }
        return builder.build();
    }

    public NGramTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.minGram = settings.getAsInt("min_gram", 1);
        this.maxGram = settings.getAsInt("max_gram", 2);
        this.matcher = NGramTokenizerFactory.parseTokenChars(settings.getAsArray("token_chars"));
    }

    @Override
    public Tokenizer create() {
        if (this.matcher == null) {
            return new NGramTokenizer(this.minGram, this.maxGram);
        }
        return new NGramTokenizer(this.minGram, this.maxGram){

            @Override
            protected boolean isTokenChar(int chr) {
                return NGramTokenizerFactory.this.matcher.isTokenChar(chr);
            }
        };
    }

    static {
        HashMap<String, CharMatcher> matchers = new HashMap<String, CharMatcher>();
        matchers.put("letter", CharMatcher.Basic.LETTER);
        matchers.put("digit", CharMatcher.Basic.DIGIT);
        matchers.put("whitespace", CharMatcher.Basic.WHITESPACE);
        matchers.put("punctuation", CharMatcher.Basic.PUNCTUATION);
        matchers.put("symbol", CharMatcher.Basic.SYMBOL);
        for (Field field : Character.class.getFields()) {
            if (field.getName().startsWith("DIRECTIONALITY") || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getType() != Byte.TYPE) continue;
            try {
                matchers.put(field.getName().toLowerCase(Locale.ROOT), CharMatcher.ByUnicodeCategory.of(field.getByte(null)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MATCHERS = Collections.unmodifiableMap(matchers);
    }
}

