/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class LimitTokenCountFilterFactory
extends AbstractTokenFilterFactory {
    public static final int DEFAULT_MAX_TOKEN_COUNT = 1;
    public static final boolean DEFAULT_CONSUME_ALL_TOKENS = false;
    final int maxTokenCount;
    final boolean consumeAllTokens;

    public LimitTokenCountFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.maxTokenCount = settings.getAsInt("max_token_count", 1);
        this.consumeAllTokens = settings.getAsBoolean("consume_all_tokens", false);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new LimitTokenCountFilter(tokenStream, this.maxTokenCount, this.consumeAllTokens);
    }
}

