/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class WeightFactorFunction
extends ScoreFunction {
    private static final ScoreFunction SCORE_ONE = new ScoreOne(CombineFunction.MULTIPLY);
    private final ScoreFunction scoreFunction;
    private float weight = 1.0f;

    public WeightFactorFunction(float weight, ScoreFunction scoreFunction) {
        super(CombineFunction.MULTIPLY);
        this.scoreFunction = scoreFunction == null ? SCORE_ONE : scoreFunction;
        this.weight = weight;
    }

    public WeightFactorFunction(float weight) {
        super(CombineFunction.MULTIPLY);
        this.scoreFunction = SCORE_ONE;
        this.weight = weight;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) throws IOException {
        final LeafScoreFunction leafFunction = this.scoreFunction.getLeafScoreFunction(ctx);
        return new LeafScoreFunction(){

            @Override
            public double score(int docId, float subQueryScore) {
                return leafFunction.score(docId, subQueryScore) * (double)WeightFactorFunction.this.getWeight();
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                Explanation functionExplanation = leafFunction.explainScore(docId, subQueryScore);
                return Explanation.match(functionExplanation.getValue() * WeightFactorFunction.this.getWeight(), "product of:", functionExplanation, WeightFactorFunction.this.explainWeight());
            }
        };
    }

    @Override
    public boolean needsScores() {
        return this.scoreFunction.needsScores();
    }

    public Explanation explainWeight() {
        return Explanation.match(this.getWeight(), "weight", new Explanation[0]);
    }

    public float getWeight() {
        return this.weight;
    }

    public ScoreFunction getScoreFunction() {
        return this.scoreFunction;
    }

    @Override
    protected boolean doEquals(ScoreFunction other) {
        WeightFactorFunction weightFactorFunction = (WeightFactorFunction)other;
        return this.weight == weightFactorFunction.weight && Objects.equals(this.scoreFunction, weightFactorFunction.scoreFunction);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(Float.valueOf(this.weight), this.scoreFunction);
    }

    private static class ScoreOne
    extends ScoreFunction {
        protected ScoreOne(CombineFunction scoreCombiner) {
            super(scoreCombiner);
        }

        @Override
        public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) {
            return new LeafScoreFunction(){

                @Override
                public double score(int docId, float subQueryScore) {
                    return 1.0;
                }

                @Override
                public Explanation explainScore(int docId, Explanation subQueryScore) {
                    return Explanation.match(1.0f, "constant score 1.0 - no function provided", new Explanation[0]);
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        protected boolean doEquals(ScoreFunction other) {
            return true;
        }

        @Override
        protected int doHashCode() {
            return 0;
        }
    }
}

