/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.XShapeCollection;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders.CoordinatesBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class MultiPolygonBuilder
extends ShapeBuilder {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.MULTIPOLYGON;
    private final List<PolygonBuilder> polygons = new ArrayList<PolygonBuilder>();
    private final ShapeBuilder.Orientation orientation;

    public MultiPolygonBuilder() {
        this(ShapeBuilder.Orientation.RIGHT);
    }

    public MultiPolygonBuilder(ShapeBuilder.Orientation orientation) {
        this.orientation = orientation;
    }

    public MultiPolygonBuilder(StreamInput in) throws IOException {
        this.orientation = ShapeBuilder.Orientation.readFrom(in);
        int holes = in.readVInt();
        for (int i = 0; i < holes; ++i) {
            this.polygon(new PolygonBuilder(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.orientation.writeTo(out);
        out.writeVInt(this.polygons.size());
        for (PolygonBuilder polygon : this.polygons) {
            polygon.writeTo(out);
        }
    }

    public ShapeBuilder.Orientation orientation() {
        return this.orientation;
    }

    public MultiPolygonBuilder polygon(PolygonBuilder polygon) {
        PolygonBuilder pb = new PolygonBuilder(new CoordinatesBuilder().coordinates(polygon.shell().coordinates(false)), this.orientation);
        for (LineStringBuilder hole : polygon.holes()) {
            pb.hole(hole);
        }
        this.polygons.add(pb);
        return this;
    }

    public List<PolygonBuilder> polygons() {
        return this.polygons;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE.shapeName());
        builder.field("orientation", this.orientation.name().toLowerCase(Locale.ROOT));
        builder.startArray("coordinates");
        for (PolygonBuilder polygon : this.polygons) {
            builder.startArray();
            polygon.coordinatesArray(builder, params);
            builder.endArray();
        }
        builder.endArray();
        return builder.endObject();
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }

    @Override
    public Shape build() {
        ArrayList<JtsGeometry> shapes = new ArrayList<JtsGeometry>(this.polygons.size());
        if (this.wrapdateline) {
            for (PolygonBuilder polygon : this.polygons) {
                for (Coordinate[][] part : polygon.coordinates()) {
                    shapes.add(this.jtsGeometry((Geometry)PolygonBuilder.polygon(FACTORY, part)));
                }
            }
        } else {
            for (PolygonBuilder polygon : this.polygons) {
                shapes.add(this.jtsGeometry((Geometry)polygon.toPolygon(FACTORY)));
            }
        }
        if (shapes.size() == 1) {
            return (Shape)shapes.get(0);
        }
        return new XShapeCollection(shapes, (SpatialContext)SPATIAL_CONTEXT);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.polygons, this.orientation});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiPolygonBuilder other = (MultiPolygonBuilder)obj;
        return Objects.equals(this.polygons, other.polygons) && Objects.equals((Object)this.orientation, (Object)other.orientation);
    }
}

