/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Collection;
import java.util.Collections;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.RoutingNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;

public class AllocationDeciders
extends AllocationDecider {
    private final Collection<AllocationDecider> allocations;

    public AllocationDeciders(Settings settings, Collection<AllocationDecider> allocations) {
        super(settings);
        this.allocations = Collections.unmodifiableCollection(allocations);
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRebalance(shardRouting, allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return Decision.NO;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(shardRouting, node, allocation);
            if (decision == Decision.NO) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Can not allocate [{}] on node [{}] due to [{}]", (Object)shardRouting, (Object)node.node(), (Object)allocationDecider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Shard [{}] should be ignored for node [{}]", (Object)shardRouting, (Object)node.nodeId());
            }
            return Decision.NO;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRemain(shardRouting, node, allocation);
            if (decision == Decision.NO) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Shard [{}] can not remain on node [{}] due to [{}]", (Object)shardRouting, (Object)node.nodeId(), (Object)allocationDecider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(IndexMetaData indexMetaData, RoutingNode node, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(indexMetaData, node, allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(shardRouting, allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(RoutingNode node, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(node, allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canRebalance(RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRebalance(allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard routing " + shardRouting;
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return Decision.NO;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider decider : this.allocations) {
            Decision decision = decider.canForceAllocatePrimary(shardRouting, node, allocation);
            if (decision == Decision.NO) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Shard [{}] can not be forcefully allocated to node [{}] due to [{}].", (Object)shardRouting.shardId(), (Object)node.nodeId(), (Object)decider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }
}

