/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchGenerationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.AbstractDiffable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.Diff;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesArray;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.compress.CompressedXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.set.Sets;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;

public class AliasMetaData
extends AbstractDiffable<AliasMetaData> {
    private final String alias;
    private final CompressedXContent filter;
    private final String indexRouting;
    private final String searchRouting;
    private final Set<String> searchRoutingValues;

    private AliasMetaData(String alias, CompressedXContent filter, String indexRouting, String searchRouting) {
        this.alias = alias;
        this.filter = filter;
        this.indexRouting = indexRouting;
        this.searchRouting = searchRouting;
        this.searchRoutingValues = searchRouting != null ? Collections.unmodifiableSet(Sets.newHashSet(Strings.splitStringByCommaToArray(searchRouting))) : Collections.emptySet();
    }

    private AliasMetaData(AliasMetaData aliasMetaData, String alias) {
        this(alias, aliasMetaData.filter(), aliasMetaData.indexRouting(), aliasMetaData.searchRouting());
    }

    public String alias() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias();
    }

    public CompressedXContent filter() {
        return this.filter;
    }

    public CompressedXContent getFilter() {
        return this.filter();
    }

    public boolean filteringRequired() {
        return this.filter != null;
    }

    public String getSearchRouting() {
        return this.searchRouting();
    }

    public String searchRouting() {
        return this.searchRouting;
    }

    public String getIndexRouting() {
        return this.indexRouting();
    }

    public String indexRouting() {
        return this.indexRouting;
    }

    public Set<String> searchRoutingValues() {
        return this.searchRoutingValues;
    }

    public static Builder builder(String alias) {
        return new Builder(alias);
    }

    public static Builder newAliasMetaDataBuilder(String alias) {
        return new Builder(alias);
    }

    public static AliasMetaData newAliasMetaData(AliasMetaData aliasMetaData, String newAlias) {
        return new AliasMetaData(aliasMetaData, newAlias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasMetaData that = (AliasMetaData)o;
        if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (this.indexRouting != null ? !this.indexRouting.equals(that.indexRouting) : that.indexRouting != null) {
            return false;
        }
        return !(this.searchRouting != null ? !this.searchRouting.equals(that.searchRouting) : that.searchRouting != null);
    }

    public int hashCode() {
        int result = this.alias != null ? this.alias.hashCode() : 0;
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.indexRouting != null ? this.indexRouting.hashCode() : 0);
        result = 31 * result + (this.searchRouting != null ? this.searchRouting.hashCode() : 0);
        return result;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.alias());
        if (this.filter() != null) {
            out.writeBoolean(true);
            this.filter.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.indexRouting() != null) {
            out.writeBoolean(true);
            out.writeString(this.indexRouting());
        } else {
            out.writeBoolean(false);
        }
        if (this.searchRouting() != null) {
            out.writeBoolean(true);
            out.writeString(this.searchRouting());
        } else {
            out.writeBoolean(false);
        }
    }

    public AliasMetaData(StreamInput in) throws IOException {
        this.alias = in.readString();
        this.filter = in.readBoolean() ? CompressedXContent.readCompressedString(in) : null;
        this.indexRouting = in.readBoolean() ? in.readString() : null;
        if (in.readBoolean()) {
            this.searchRouting = in.readString();
            this.searchRoutingValues = Collections.unmodifiableSet(Sets.newHashSet(Strings.splitStringByCommaToArray(this.searchRouting)));
        } else {
            this.searchRouting = null;
            this.searchRoutingValues = Collections.emptySet();
        }
    }

    public static Diff<AliasMetaData> readDiffFrom(StreamInput in) throws IOException {
        return AliasMetaData.readDiffFrom(AliasMetaData::new, in);
    }

    public static class Builder {
        private final String alias;
        private CompressedXContent filter;
        private String indexRouting;
        private String searchRouting;

        public Builder(String alias) {
            this.alias = alias;
        }

        public Builder(AliasMetaData aliasMetaData) {
            this(aliasMetaData.alias());
            this.filter = aliasMetaData.filter();
            this.indexRouting = aliasMetaData.indexRouting();
            this.searchRouting = aliasMetaData.searchRouting();
        }

        public String alias() {
            return this.alias;
        }

        public Builder filter(CompressedXContent filter) {
            this.filter = filter;
            return this;
        }

        public Builder filter(String filter) {
            if (!Strings.hasLength(filter)) {
                this.filter = null;
                return this;
            }
            return this.filter(XContentHelper.convertToMap(XContentFactory.xContent(filter), filter, true));
        }

        public Builder filter(Map<String, Object> filter) {
            if (filter == null || filter.isEmpty()) {
                this.filter = null;
                return this;
            }
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder().map(filter);
                this.filter = new CompressedXContent(builder.bytes());
                return this;
            }
            catch (IOException e) {
                throw new ElasticsearchGenerationException("Failed to build json for alias request", e);
            }
        }

        public Builder filter(XContentBuilder filterBuilder) {
            try {
                return this.filter(filterBuilder.string());
            }
            catch (IOException e) {
                throw new ElasticsearchGenerationException("Failed to build json for alias request", e);
            }
        }

        public Builder routing(String routing) {
            this.indexRouting = routing;
            this.searchRouting = routing;
            return this;
        }

        public Builder indexRouting(String indexRouting) {
            this.indexRouting = indexRouting;
            return this;
        }

        public Builder searchRouting(String searchRouting) {
            this.searchRouting = searchRouting;
            return this;
        }

        public AliasMetaData build() {
            return new AliasMetaData(this.alias, this.filter, this.indexRouting, this.searchRouting);
        }

        public static void toXContent(AliasMetaData aliasMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(aliasMetaData.alias());
            boolean binary = params.paramAsBoolean("binary", false);
            if (aliasMetaData.filter() != null) {
                if (binary) {
                    builder.field("filter", aliasMetaData.filter.compressed());
                } else {
                    builder.field("filter", XContentHelper.convertToMap(new BytesArray(aliasMetaData.filter().uncompressed()), true).v2());
                }
            }
            if (aliasMetaData.indexRouting() != null) {
                builder.field("index_routing", aliasMetaData.indexRouting());
            }
            if (aliasMetaData.searchRouting() != null) {
                builder.field("search_routing", aliasMetaData.searchRouting());
            }
            builder.endObject();
        }

        public static AliasMetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                return builder.build();
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (!"filter".equals(currentFieldName)) continue;
                    Map<String, Object> filter = parser.mapOrdered();
                    builder.filter(filter);
                    continue;
                }
                if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                    if (!"filter".equals(currentFieldName)) continue;
                    builder.filter(new CompressedXContent(parser.binaryValue()));
                    continue;
                }
                if (token != XContentParser.Token.VALUE_STRING) continue;
                if ("routing".equals(currentFieldName)) {
                    builder.routing(parser.text());
                    continue;
                }
                if ("index_routing".equals(currentFieldName) || "indexRouting".equals(currentFieldName)) {
                    builder.indexRouting(parser.text());
                    continue;
                }
                if (!"search_routing".equals(currentFieldName) && !"searchRouting".equals(currentFieldName)) continue;
                builder.searchRouting(parser.text());
            }
            return builder.build();
        }
    }
}

