/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster;

import java.util.function.Predicate;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;

public final class MasterNodeChangePredicate {
    private MasterNodeChangePredicate() {
    }

    public static Predicate<ClusterState> build(ClusterState currentState) {
        long currentVersion = currentState.version();
        DiscoveryNode masterNode = currentState.nodes().getMasterNode();
        String currentMasterId = masterNode == null ? null : masterNode.getEphemeralId();
        return newState -> {
            DiscoveryNode newMaster = newState.nodes().getMasterNode();
            boolean accept = newMaster == null ? false : (!newMaster.getEphemeralId().equals(currentMasterId) ? true : newState.version() > currentVersion);
            return accept;
        };
    }
}

