/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.nodes;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;

public abstract class BaseNodesRequest<Request extends BaseNodesRequest<Request>>
extends ActionRequest {
    private String[] nodesIds;
    private DiscoveryNode[] concreteNodes;
    private TimeValue timeout;

    protected BaseNodesRequest() {
    }

    protected BaseNodesRequest(String ... nodesIds) {
        this.nodesIds = nodesIds;
    }

    protected BaseNodesRequest(DiscoveryNode ... concreteNodes) {
        this.nodesIds = null;
        this.concreteNodes = concreteNodes;
    }

    public final String[] nodesIds() {
        return this.nodesIds;
    }

    public final Request nodesIds(String ... nodesIds) {
        this.nodesIds = nodesIds;
        return (Request)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final Request timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".timeout");
        return (Request)this;
    }

    public DiscoveryNode[] concreteNodes() {
        return this.concreteNodes;
    }

    public void setConcreteNodes(DiscoveryNode[] concreteNodes) {
        this.concreteNodes = concreteNodes;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodesIds = in.readStringArray();
        this.concreteNodes = in.readOptionalArray(DiscoveryNode::new, DiscoveryNode[]::new);
        this.timeout = in.readOptionalWriteable(TimeValue::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.nodesIds);
        out.writeOptionalArray(this.concreteNodes);
        out.writeOptionalWriteable(this.timeout);
    }
}

