/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest;

import java.util.ArrayList;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRunnable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.SimulateDocumentBaseResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.SimulateDocumentVerboseResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.SimulatePipelineResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.SimulateProcessorResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.TrackingResultProcessor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.CompoundProcessor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.IngestDocument;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.Pipeline;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;

class SimulateExecutionService {
    private static final String THREAD_POOL_NAME = "management";
    private final ThreadPool threadPool;

    SimulateExecutionService(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    SimulateDocumentResult executeDocument(Pipeline pipeline, IngestDocument ingestDocument, boolean verbose) {
        if (verbose) {
            ArrayList<SimulateProcessorResult> processorResultList = new ArrayList<SimulateProcessorResult>();
            CompoundProcessor verbosePipelineProcessor = TrackingResultProcessor.decorate(pipeline.getCompoundProcessor(), processorResultList);
            try {
                verbosePipelineProcessor.execute(ingestDocument);
                return new SimulateDocumentVerboseResult(processorResultList);
            }
            catch (Exception e) {
                return new SimulateDocumentVerboseResult(processorResultList);
            }
        }
        try {
            pipeline.execute(ingestDocument);
            return new SimulateDocumentBaseResult(ingestDocument);
        }
        catch (Exception e) {
            return new SimulateDocumentBaseResult(e);
        }
    }

    public void execute(final SimulatePipelineRequest.Parsed request, ActionListener<SimulatePipelineResponse> listener) {
        this.threadPool.executor(THREAD_POOL_NAME).execute(new ActionRunnable<SimulatePipelineResponse>(listener){

            @Override
            protected void doRun() throws Exception {
                ArrayList<SimulateDocumentResult> responses = new ArrayList<SimulateDocumentResult>();
                for (IngestDocument ingestDocument : request.getDocuments()) {
                    responses.add(SimulateExecutionService.this.executeDocument(request.getPipeline(), ingestDocument, request.isVerbose()));
                }
                this.listener.onResponse(new SimulatePipelineResponse(request.getPipeline().getId(), request.isVerbose(), responses));
            }
        });
    }
}

