/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.fieldstats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ValidateActions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.fieldstats.IndexConstraint;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;

public class FieldStatsRequest
extends BroadcastRequest<FieldStatsRequest> {
    public static final String DEFAULT_LEVEL = "cluster";
    private String[] fields = Strings.EMPTY_ARRAY;
    private String level = "cluster";
    private IndexConstraint[] indexConstraints = new IndexConstraint[0];
    private boolean useCache = true;

    public String[] getFields() {
        return this.fields;
    }

    public void setFields(String[] fields) {
        if (fields == null) {
            throw new NullPointerException("specified fields can't be null");
        }
        this.fields = fields;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean shouldUseCache() {
        return this.useCache;
    }

    public IndexConstraint[] getIndexConstraints() {
        return this.indexConstraints;
    }

    public void setIndexConstraints(IndexConstraint[] indexConstraints) {
        if (indexConstraints == null) {
            throw new NullPointerException("specified index_constraints can't be null");
        }
        this.indexConstraints = indexConstraints;
    }

    public void source(XContentParser parser) throws IOException {
        ArrayList<IndexConstraint> indexConstraints = new ArrayList<IndexConstraint>();
        ArrayList<String> fields = new ArrayList<String>();
        String fieldName = null;
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.START_OBJECT);
        token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    fieldName = parser.currentName();
                    break;
                }
                case START_OBJECT: {
                    if ("index_constraints".equals(fieldName)) {
                        FieldStatsRequest.parseIndexConstraints(indexConstraints, parser);
                        break;
                    }
                    throw new IllegalArgumentException("unknown field [" + fieldName + "]");
                }
                case START_ARRAY: {
                    if ("fields".equals(fieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token.isValue()) {
                                fields.add(parser.text());
                                continue;
                            }
                            throw new IllegalArgumentException("unexpected token [" + (Object)((Object)token) + "]");
                        }
                        break;
                    }
                    throw new IllegalArgumentException("unknown field [" + fieldName + "]");
                }
                default: {
                    throw new IllegalArgumentException("unexpected token [" + (Object)((Object)token) + "]");
                }
            }
            token = parser.nextToken();
        }
        this.fields = fields.toArray(new String[fields.size()]);
        this.indexConstraints = indexConstraints.toArray(new IndexConstraint[indexConstraints.size()]);
    }

    private static void parseIndexConstraints(List<IndexConstraint> indexConstraints, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        assert (token == XContentParser.Token.START_OBJECT);
        String field = null;
        String currentName = null;
        token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                field = currentName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                XContentParser.Token fieldToken = parser.nextToken();
                while (fieldToken != XContentParser.Token.END_OBJECT) {
                    if (fieldToken == XContentParser.Token.FIELD_NAME) {
                        currentName = parser.currentName();
                    } else if (fieldToken == XContentParser.Token.START_OBJECT) {
                        IndexConstraint.Property property = IndexConstraint.Property.parse(currentName);
                        String value = null;
                        String optionalFormat = null;
                        IndexConstraint.Comparison comparison = null;
                        XContentParser.Token propertyToken = parser.nextToken();
                        while (propertyToken != XContentParser.Token.END_OBJECT) {
                            if (propertyToken.isValue()) {
                                if ("format".equals(parser.currentName())) {
                                    optionalFormat = parser.text();
                                } else {
                                    comparison = IndexConstraint.Comparison.parse(parser.currentName());
                                    value = parser.text();
                                }
                            } else if (propertyToken != XContentParser.Token.FIELD_NAME) {
                                throw new IllegalArgumentException("unexpected token [" + (Object)((Object)propertyToken) + "]");
                            }
                            propertyToken = parser.nextToken();
                        }
                        indexConstraints.add(new IndexConstraint(field, property, comparison, value, optionalFormat));
                    } else {
                        throw new IllegalArgumentException("unexpected token [" + (Object)((Object)fieldToken) + "]");
                    }
                    fieldToken = parser.nextToken();
                }
            } else {
                throw new IllegalArgumentException("unexpected token [" + (Object)((Object)token) + "]");
            }
            token = parser.nextToken();
        }
    }

    public String level() {
        return this.level;
    }

    public void level(String level) {
        this.level = level;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (!DEFAULT_LEVEL.equals(this.level) && !"indices".equals(this.level)) {
            validationException = ValidateActions.addValidationError("invalid level option [" + this.level + "]", validationException);
        }
        if (this.fields == null || this.fields.length == 0) {
            validationException = ValidateActions.addValidationError("no fields specified", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.fields = in.readStringArray();
        int size = in.readVInt();
        this.indexConstraints = new IndexConstraint[size];
        for (int i = 0; i < size; ++i) {
            this.indexConstraints[i] = new IndexConstraint(in);
        }
        this.level = in.readString();
        this.useCache = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.fields);
        out.writeVInt(this.indexConstraints.length);
        for (IndexConstraint indexConstraint : this.indexConstraints) {
            out.writeString(indexConstraint.getField());
            out.writeByte(indexConstraint.getProperty().getId());
            out.writeByte(indexConstraint.getComparison().getId());
            out.writeString(indexConstraint.getValue());
            if (!out.getVersion().onOrAfter(Version.V_2_0_1)) continue;
            out.writeOptionalString(indexConstraint.getOptionalFormat());
        }
        out.writeString(this.level);
        out.writeBoolean(this.useCache);
    }
}

