/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.segments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.segments.ShardSegments;

public class IndexSegments
implements Iterable<IndexShardSegments> {
    private final String index;
    private final Map<Integer, IndexShardSegments> indexShards;

    IndexSegments(String index, ShardSegments[] shards) {
        this.index = index;
        HashMap<Integer, ArrayList<ShardSegments>> tmpIndexShards = new HashMap<Integer, ArrayList<ShardSegments>>();
        for (ShardSegments shard : shards) {
            ArrayList<ShardSegments> lst = (ArrayList<ShardSegments>)tmpIndexShards.get(shard.getShardRouting().id());
            if (lst == null) {
                lst = new ArrayList<ShardSegments>();
                tmpIndexShards.put(shard.getShardRouting().id(), lst);
            }
            lst.add(shard);
        }
        this.indexShards = new HashMap<Integer, IndexShardSegments>();
        for (Map.Entry entry : tmpIndexShards.entrySet()) {
            this.indexShards.put((Integer)entry.getKey(), new IndexShardSegments(((ShardSegments)((List)entry.getValue()).get(0)).getShardRouting().shardId(), ((List)entry.getValue()).toArray(new ShardSegments[((List)entry.getValue()).size()])));
        }
    }

    public String getIndex() {
        return this.index;
    }

    public Map<Integer, IndexShardSegments> getShards() {
        return this.indexShards;
    }

    @Override
    public Iterator<IndexShardSegments> iterator() {
        return this.indexShards.values().iterator();
    }
}

