/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PointValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.Geo3DDocValuesField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.Geo3DPoint;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.Geo3DUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoArea;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoAreaFactory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.GeoShape;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial3d.geom.XYZBounds;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.DocIdSetBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.NumericUtils;

class PointInShapeIntersectVisitor
implements PointValues.IntersectVisitor {
    private final DocIdSetBuilder hits;
    private final GeoShape shape;
    private final double minimumX;
    private final double maximumX;
    private final double minimumY;
    private final double maximumY;
    private final double minimumZ;
    private final double maximumZ;
    private DocIdSetBuilder.BulkAdder adder;

    public PointInShapeIntersectVisitor(DocIdSetBuilder hits, GeoShape shape, XYZBounds bounds) {
        this.hits = hits;
        this.shape = shape;
        this.minimumX = Geo3DDocValuesField.roundDownX(bounds.getMinimumX());
        this.maximumX = Geo3DDocValuesField.roundUpX(bounds.getMaximumX());
        this.minimumY = Geo3DDocValuesField.roundDownY(bounds.getMinimumY());
        this.maximumY = Geo3DDocValuesField.roundUpY(bounds.getMaximumY());
        this.minimumZ = Geo3DDocValuesField.roundDownZ(bounds.getMinimumZ());
        this.maximumZ = Geo3DDocValuesField.roundUpZ(bounds.getMaximumZ());
    }

    @Override
    public void grow(int count) {
        this.adder = this.hits.grow(count);
    }

    @Override
    public void visit(int docID) {
        this.adder.add(docID);
    }

    @Override
    public void visit(int docID, byte[] packedValue) {
        assert (packedValue.length == 12);
        double x = Geo3DPoint.decodeDimension(packedValue, 0);
        double y = Geo3DPoint.decodeDimension(packedValue, 4);
        double z = Geo3DPoint.decodeDimension(packedValue, 8);
        if (x >= this.minimumX && x <= this.maximumX && y >= this.minimumY && y <= this.maximumY && z >= this.minimumZ && z <= this.maximumZ && this.shape.isWithin(x, y, z)) {
            this.adder.add(docID);
        }
    }

    @Override
    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
        double xMin = Geo3DUtil.decodeValueFloor(NumericUtils.sortableBytesToInt(minPackedValue, 0));
        double xMax = Geo3DUtil.decodeValueCeil(NumericUtils.sortableBytesToInt(maxPackedValue, 0));
        double yMin = Geo3DUtil.decodeValueFloor(NumericUtils.sortableBytesToInt(minPackedValue, 4));
        double yMax = Geo3DUtil.decodeValueCeil(NumericUtils.sortableBytesToInt(maxPackedValue, 4));
        double zMin = Geo3DUtil.decodeValueFloor(NumericUtils.sortableBytesToInt(minPackedValue, 8));
        double zMax = Geo3DUtil.decodeValueCeil(NumericUtils.sortableBytesToInt(maxPackedValue, 8));
        assert (xMin <= xMax);
        assert (yMin <= yMax);
        assert (zMin <= zMax);
        if (this.minimumX >= xMin && this.maximumX <= xMax && this.minimumY >= yMin && this.maximumY <= yMax && this.minimumZ >= zMin && this.maximumZ <= zMax) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        GeoArea xyzSolid = GeoAreaFactory.makeGeoArea(PlanetModel.WGS84, xMin, xMax, yMin, yMax, zMin, zMax);
        switch (xyzSolid.getRelationship(this.shape)) {
            case 0: {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            case 2: {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            case 1: {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            case 3: {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        assert (false);
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }
}

